/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.entrydetail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.check.entrydetail.CheckTmplDetailModel;
import kd.fi.bcm.business.check.entrydetail.CheckTmplEntryDetail;
import kd.fi.bcm.business.check.helper.DiffModeFormulaHelper;
import kd.fi.bcm.business.check.model.key.CheckTmpl;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.ElimTypeEnum;

public class CheckTmplDetailBatchModel {
    private static final DBRoute BCM_DB_Router = DBRoute.of((String)"bcm");
    private Map<String, Map<String, CheckTmplSourceInfo>> checkTmplSourceInfoMap = new HashMap<String, Map<String, CheckTmplSourceInfo>>(16);
    private Map<String, Map<String, CheckTmpl>> checkTmplMap = new HashMap<String, Map<String, CheckTmpl>>(16);
    private Map<Long, String[]> entryIdToElimTypeMap = new HashMap<Long, String[]>(16);

    public static String createSQLParamPlaceHolderString(int size) {
        StringBuilder buf = new StringBuilder();
        boolean appendDelimiter = false;
        for (int i = 0; i < size; ++i) {
            if (appendDelimiter) {
                buf.append(", ?");
                continue;
            }
            buf.append('?');
            appendDelimiter = true;
        }
        return buf.toString();
    }

    protected <T> T addToMap(String elimType, String tmplNumber, Map<String, Map<String, T>> targetMap, T source) {
        Map<String, T> map = targetMap.get(elimType);
        if (map == null) {
            map = new HashMap<String, T>(16);
            targetMap.put(elimType, map);
        }
        map.put(tmplNumber, source);
        return source;
    }

    protected <T> T getMapElement(String elimType, String tmplNumber, Map<String, Map<String, T>> targetMap) {
        Map<String, T> map = targetMap.get(elimType);
        if (map != null) {
            return map.get(tmplNumber);
        }
        return null;
    }

    protected CheckTmpl addCheckImpl(String elimType, String tmplNumber, CheckTmpl checkImpl) {
        return this.addToMap(elimType, tmplNumber, this.checkTmplMap, checkImpl);
    }

    public CheckTmpl getCheckImpl(String elimType, String tmplNumber) {
        return (CheckTmpl)this.getMapElement(elimType, tmplNumber, this.checkTmplMap);
    }

    public CheckTmplSourceInfo getCheckTmplSourceInfo(String elimType, String tmplNumber) {
        return (CheckTmplSourceInfo)this.getMapElement(elimType, tmplNumber, this.checkTmplSourceInfoMap);
    }

    public boolean isEmpty() {
        return this.checkTmplSourceInfoMap.isEmpty();
    }

    public List<CheckTmplEntryDetail> getDetailByEntryAndDimKey(String elimType, String tmplNumber, Long entryId, String dimKey, boolean isElim) {
        CheckTmplSourceInfo tmplDetail = this.getCheckTmplSourceInfo(elimType, tmplNumber);
        List<Object> list = null;
        if (tmplDetail != null) {
            list = tmplDetail.getDetailByEntryAndDimKey(entryId, dimKey, isElim);
        }
        return list == null ? new ArrayList(0) : list;
    }

    public void addEntryInfo(String elimType, String tmplNumber, Collection<DynamicObject> sourceDynList) {
        String diffMethod;
        if (sourceDynList == null || sourceDynList.isEmpty()) {
            return;
        }
        Set<Long> sourceIdList = sourceDynList.stream().map(e -> e.getLong("tmplentryid")).collect(Collectors.toSet());
        Map<String, CheckTmplSourceInfo> tmplInfoMap = this.checkTmplSourceInfoMap.get(elimType);
        if (tmplInfoMap == null) {
            tmplInfoMap = new HashMap<String, CheckTmplSourceInfo>(16);
            this.checkTmplSourceInfoMap.put(elimType, tmplInfoMap);
        }
        String[] elimTypeInfo = new String[]{elimType, tmplNumber};
        for (Long sourceId : sourceIdList) {
            this.entryIdToElimTypeMap.put(sourceId, elimTypeInfo);
        }
        CheckTmplSourceInfo tmpInfo = tmplInfoMap.get(tmplNumber);
        if (tmpInfo == null) {
            tmpInfo = new CheckTmplSourceInfo(sourceIdList, sourceDynList);
            tmplInfoMap.put(tmplNumber, tmpInfo);
        }
        CheckTmpl checkImpl = this.addCheckImpl(elimType, tmplNumber, new CheckTmpl());
        DynamicObject srcDyn = tmpInfo.entryDynamicObjects.get(0);
        checkImpl.setId(srcDyn.getLong("id"));
        checkImpl.setNumber(tmplNumber);
        checkImpl.setName(srcDyn.getString("name"));
        checkImpl.setDiffMode(srcDyn.getInt("diffmode"));
        String string = diffMethod = srcDyn.getString("diffmethod") == null ? "" : srcDyn.getString("diffmethod");
        if (StringUtils.isEmpty((String)diffMethod.trim())) {
            checkImpl.setDiffMethod(0);
        } else {
            checkImpl.setDiffMethod(Integer.parseInt(diffMethod));
        }
        checkImpl.setCheckconfig(srcDyn.getString("checkconfig"));
        checkImpl.setElimType(ElimTypeEnum.getEnum((String)elimType).getValue());
        checkImpl.setTemplatecatalogId(srcDyn.getLong("templatecatalog.id"));
        checkImpl.setSingleDc(srcDyn.getBoolean("issingledc"));
        checkImpl.setLinkage(srcDyn.getInt("islinkage"));
        checkImpl.setGroupDC(srcDyn.getBoolean("balance"));
        checkImpl.setDiffModeFormula(srcDyn.getString("diffmodeformula"));
        checkImpl.setJournalType(StringUtils.isEmpty((String)srcDyn.getString("journaltype")) ? "1" : srcDyn.getString("journaltype"));
        checkImpl.setAdjustCatalogId(srcDyn.getLong("adjustcatalogid"));
        if (srcDyn.getInt("diffmode") == 4) {
            checkImpl.setResolvedFormula(DiffModeFormulaHelper.resolveFormulaForCheckCtx(srcDyn.getString("diffmodeformula")));
        }
        ArrayList<CheckTmpl.Entry> subEntryList = new ArrayList<CheckTmpl.Entry>(sourceDynList.size());
        HashMap<Long, CheckTmpl.Entry> dynMap = new HashMap<Long, CheckTmpl.Entry>(16);
        for (DynamicObject dyn : sourceDynList) {
            Long entryid = dyn.getLong("tmplentryid");
            CheckTmpl.Entry entry = (CheckTmpl.Entry)dynMap.get(entryid);
            if (entry != null) continue;
            entry = new CheckTmpl.Entry();
            dynMap.put(entryid, entry);
            entry.setAccounts(new HashSet<Long>(8));
            entry.setAccountNumbers(new HashSet<String>(8));
            entry.setElimAccounts(new HashSet<Long>(8));
            entry.setElimAccountNumbers(new HashSet<String>(8));
            entry.setChangetype(dyn.getLong("changetypeid"));
            entry.setChangetypeNumber(dyn.getString(PresetConstant.CHANGETYPE_DIM));
            entry.setElimChangetype(dyn.getLong("elimchangetypeid"));
            entry.setElimChangetypeNumber(dyn.getString("elim" + PresetConstant.CHANGETYPE_DIM));
            entry.setRule(dyn.getLong("multigaapid"));
            entry.setRuleNumber(dyn.getString(PresetConstant.RULE_DIM));
            entry.setDatasort(dyn.getLong("datasortid"));
            entry.setDatasortNumber(dyn.getString(PresetConstant.DATASORT_DIM));
            if (dyn.getBoolean("diffitem")) {
                entry.setMycompany(dyn.getLong("mycompanyid"));
                entry.setMycompanyNumber(dyn.getString(PresetConstant.MYCOMPANY_DIM));
            } else {
                entry.setMycompany(null);
                entry.setMycompanyNumber(null);
            }
            entry.setCompanyid(null);
            entry.setCompanyNumber(null);
            entry.setDiffitem(dyn.getBoolean("diffitem"));
            entry.setEntryId(dyn.getLong("tmplentryid"));
            entry.setSeq(dyn.getInt("seq"));
            entry.setMappingAccountId(dyn.getLong("mappingaccountid"));
            entry.setEntrygroup(StringUtils.isEmpty((String)dyn.getString("entrygroup")) ? "0" : dyn.getString("entrygroup"));
            entry.setEntrymyop(StringUtils.isEmpty((String)dyn.getString("entrymyop")) ? "0" : dyn.getString("entrymyop"));
            subEntryList.add(entry);
        }
        checkImpl.setEntries(subEntryList);
        checkImpl.setComMembEntries(new ArrayList<CheckTmpl.ComMembEntry>(10));
        checkImpl.setSpreadMembEntries(new ArrayList<CheckTmpl.SpreadMembEntry>(10));
    }

    public void initCheckTmplDetailModels() {
        StringBuilder querySQLTemplate = new StringBuilder();
        querySQLTemplate.append("SELECT '0' isElim, C.FDetailId id, C.fentryid entryId, C.fdimension dimension, C.fmemberid memberid, C.FSeq seq, C.fsign sign, C.fscope scope, P.FId pid ");
        querySQLTemplate.append("  FROM T_BCM_CHECKTMPL_DETAIL C LEFT JOIN T_BCM_DPROPERTYVALUE P ON C.fmemberid = P.FID ");
        querySQLTemplate.append(" WHERE C.fentryid in(%s) ");
        querySQLTemplate.append(" UNION ");
        querySQLTemplate.append("SELECT '1' isElim, C.FDetailId id, C.fentryid entryId, C.fdimension dimension, C.fmemberid memberid, C.FSeq seq, C.fsign sign, C.fscope scope, P.FId pid ");
        querySQLTemplate.append("  FROM T_BCM_CHECKTMPL_ELDETAIL C LEFT JOIN T_BCM_DPROPERTYVALUE P ON C.fmemberid = P.FID ");
        querySQLTemplate.append(" WHERE C.fentryid in(%s) ");
        ArrayList<Long> fetchIdList = new ArrayList<Long>(this.entryIdToElimTypeMap.keySet());
        ArrayList<Long> subList = new ArrayList<Long>(10);
        int batchSize = 1000;
        for (int posIndex = 0; fetchIdList.size() > posIndex; posIndex += batchSize) {
            int fetchSize = fetchIdList.size() - posIndex;
            fetchSize = fetchSize > batchSize ? batchSize : fetchSize;
            int toIndex = posIndex + fetchSize;
            subList.clear();
            subList.addAll(fetchIdList.subList(posIndex, toIndex));
            subList.addAll(fetchIdList.subList(posIndex, toIndex));
            if (subList.isEmpty()) continue;
            String paramStr = CheckTmplDetailBatchModel.createSQLParamPlaceHolderString(fetchSize);
            String querySQL = String.format(querySQLTemplate.toString(), paramStr, paramStr);
            this.doQuery(querySQL, subList);
        }
    }

    protected void doQuery(String querySQL, List<Long> paramIds) {
        try (DataSet dataset = DB.queryDataSet((String)"CheckTmplDetailBatchModel.doQuery", (DBRoute)BCM_DB_Router, (String)querySQL, (Object[])paramIds.toArray());){
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row dataRow = dataset.next();
                    boolean isElim = "1".equals(dataRow.getString("isElim"));
                    CheckTmplEntryDetail detail = new CheckTmplEntryDetail();
                    detail.setId(dataRow.getLong("id"));
                    detail.setEntryId(dataRow.getLong("entryid"));
                    detail.setDimensionId(dataRow.getLong("dimension"));
                    detail.setMemberTreeId(dataRow.getLong("memberid"));
                    detail.setSign(dataRow.getString("sign"));
                    detail.setScope(dataRow.getInteger("scope"));
                    detail.setSeq(dataRow.getInteger("seq"));
                    Long pid = dataRow.getLong("pid");
                    detail.setCust(pid != null && pid != 0L);
                    String[] typeInfo = this.entryIdToElimTypeMap.get(detail.getEntryId());
                    CheckTmplSourceInfo checkDetail = this.getCheckTmplSourceInfo(typeInfo[0], typeInfo[1]);
                    checkDetail.addCheckTmplEntryDetail(isElim, detail.getSign(), detail);
                }
            }
        }
    }

    public static class CheckTmplSourceInfo
    extends CheckTmplDetailModel {
        protected Set<Long> entryIds;
        protected List<DynamicObject> entryDynamicObjects;

        public String toString() {
            return "CheckTmplSourceInfo [entryIds=" + this.entryIds + ", entryDynamicObjects=" + this.entryDynamicObjects + "]";
        }

        public CheckTmplSourceInfo(Collection<Long> entryIds, Collection<DynamicObject> entryDynamicObjects) {
            this.entryIds = new HashSet<Long>(entryIds);
            this.entryDynamicObjects = new ArrayList<DynamicObject>(entryDynamicObjects);
            this.elimGroupByDetail = new HashMap(16);
            this.groupByDetail = new HashMap(16);
        }

        public void addCheckTmplEntryDetail(boolean isElim, String sign, CheckTmplEntryDetail entryDetail) {
            ArrayList<CheckTmplEntryDetail> detailList;
            if (entryDetail == null) {
                return;
            }
            Map map = isElim ? this.elimGroupByDetail : this.groupByDetail;
            HashMap<Long, ArrayList<CheckTmplEntryDetail>> detailMap = (HashMap<Long, ArrayList<CheckTmplEntryDetail>>)map.get(sign);
            if (detailMap == null) {
                detailMap = new HashMap<Long, ArrayList<CheckTmplEntryDetail>>(16);
                map.put(sign, detailMap);
            }
            if ((detailList = (ArrayList<CheckTmplEntryDetail>)detailMap.get(entryDetail.getEntryId())) == null) {
                detailList = new ArrayList<CheckTmplEntryDetail>(10);
                detailMap.put(entryDetail.getEntryId(), detailList);
            }
            detailList.add(entryDetail);
        }
    }
}

