/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.entrydetail;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.check.entrydetail.CheckTmplEntryDetail;
import kd.fi.bcm.common.util.QFBuilder;

public class CheckTmplDetailModel {
    protected Map<String, Map<Long, List<CheckTmplEntryDetail>>> groupByDetail;
    protected Map<String, Map<Long, List<CheckTmplEntryDetail>>> elimGroupByDetail;

    protected CheckTmplDetailModel() {
    }

    public CheckTmplDetailModel(Set<Long> entryIds) {
        this.groupByDetail = this.getGroupData("bcm_checktmpl", entryIds, false);
        this.elimGroupByDetail = this.getGroupData("bcm_checktmpl", entryIds, true);
    }

    public List<CheckTmplEntryDetail> getDetailByEntryAndDimKey(Long entryId, String dimKey, boolean isElim) {
        if (!isElim) {
            return this.groupByDetail.get(dimKey) != null ? this.groupByDetail.get(dimKey).get(entryId) : null;
        }
        return this.elimGroupByDetail.get(dimKey) != null ? this.elimGroupByDetail.get(dimKey).get(entryId) : null;
    }

    private Map<String, Map<Long, List<CheckTmplEntryDetail>>> getGroupData(String entity, Set<Long> entryIds, boolean isElim) {
        DynamicObjectCollection userDefines = this.loadDetailData(entity, entryIds, isElim);
        List<CheckTmplEntryDetail> details = this.transferToListFromDyCollection(userDefines, isElim);
        return details.stream().collect(Collectors.groupingBy(CheckTmplEntryDetail::getSign, Collectors.groupingBy(CheckTmplEntryDetail::getEntryId)));
    }

    private List<CheckTmplEntryDetail> transferToListFromDyCollection(DynamicObjectCollection collection, boolean isElim) {
        ArrayList<CheckTmplEntryDetail> list = new ArrayList<CheckTmplEntryDetail>(10);
        collection.forEach(e -> {
            CheckTmplEntryDetail detail = new CheckTmplEntryDetail();
            String preKey = "";
            if (isElim) {
                preKey = "elim";
            }
            detail.setId(e.getLong("id"));
            detail.setEntryId(e.getLong("entryid"));
            detail.setDimensionId(e.getLong(preKey + "dimension"));
            detail.setMemberTreeId(e.getLong(preKey + "memberid"));
            detail.setSign(e.getString(preKey + "sign"));
            detail.setScope(e.getInt(preKey + "scope"));
            detail.setSeq(e.getInt("seq"));
            list.add(detail);
        });
        return list;
    }

    public DynamicObjectCollection loadDetailData(String entity, Set<Long> entryIds, boolean isElim) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("entryentity.id", "in", entryIds));
        String preKey = "";
        if (isElim) {
            preKey = "elim";
        }
        String selectFields = String.format("entryentity.%sdetailscope.id as id,", preKey) + "entryentity.id as entryId," + String.format("entryentity.%s%s.%sdimension as %sdimension,", preKey, "detailscope", preKey, preKey) + String.format("entryentity.%s%s.%smemberid as %smemberid,", preKey, "detailscope", preKey, preKey) + String.format("entryentity.%s%s.seq as seq,", preKey, "detailscope") + String.format("entryentity.%s%s.%ssign as %ssign,", preKey, "detailscope", preKey, preKey) + String.format("entryentity.%s%s.%sscope as %sscope", preKey, "detailscope", preKey, preKey);
        return QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])qfBuilder.toArray());
    }
}

