/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.executor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.ICheckContext;
import kd.fi.bcm.business.check.diff.DiffHandler;
import kd.fi.bcm.business.check.executor.ICheckExecutor;
import kd.fi.bcm.business.check.helper.CheckRecordHelper;
import kd.fi.bcm.business.check.model.CheckRecord;
import kd.fi.bcm.business.check.model.ReportData;
import kd.fi.bcm.business.check.model.key.CheckTmpl;
import kd.fi.bcm.business.check.model.key.EntityKey;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.sql.IMDResultSet;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.enums.ElimTypeEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;

public abstract class AbstractCheckExecutor
implements ICheckExecutor {
    protected ICheckContext ctx;

    public AbstractCheckExecutor(ICheckContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public List<CheckRecord> check(List<CheckRecord> recs, Pair<DiffModeEnum, DiffMethodEnum> diffPair) {
        this.doDiff(recs, diffPair);
        this.doRemoveZero(recs);
        return recs;
    }

    @Override
    public List<CheckRecord> check(IMDResultSet rs) {
        List<CheckRecord> recs = this.doGroup((MDResultSet)rs);
        this.ctx.getCheckParam().stepCount();
        this.doDiff(recs, null);
        this.ctx.getCheckParam().stepCount();
        this.doRemoveZero(recs);
        this.ctx.getCheckParam().stepCount();
        return recs;
    }

    protected void doDiff(List<CheckRecord> recs, Pair<DiffModeEnum, DiffMethodEnum> diffPair) {
        if (recs == null || recs.size() == 0) {
            return;
        }
        recs.stream().forEach(e -> {
            int diffMode = e.getDiffMode();
            int diffMethod = e.getDiffMethod();
            if (diffPair != null) {
                diffMode = ((DiffModeEnum)diffPair.p1).getValue();
                diffMethod = ((DiffMethodEnum)diffPair.p2).getValue();
            }
            DiffHandler.balance(e, diffMode, diffMethod);
        });
        recs.forEach(r -> r.getEntries().forEach(e -> {
            if (e.isDi()) {
                e.setEntryorg(CheckUtil.getMembIdFromCache(this.ctx, PresetConstant.ENTITY_DIM, e.getEntryorgnumber()));
                if (this.ctx.isSpptMyCompany()) {
                    e.setEntrymycompany(CheckUtil.getMembIdFromCache(this.ctx, PresetConstant.MYCOMPANY_DIM, e.getEntrymycompanynumber()));
                }
                if ((e.getEntrycompany() == null || e.getEntrycompany() == 0L) && e.getEntrycompanynumber() != null) {
                    e.setEntrycompany(CheckUtil.getMembIdFromCache(this.ctx, PresetConstant.INTERNALCOMPANY_DIM, e.getEntrycompanynumber()));
                }
            }
        }));
        recs.parallelStream().forEach(r -> r.getEntries().sort(CheckRecord.Entry::compareTo));
        recs.forEach(r -> {
            int i = 0;
            for (CheckRecord.Entry e : r.getEntries()) {
                e.setSeq(i++);
            }
        });
    }

    protected void doRemoveZero(List<CheckRecord> recs) {
        if (recs == null || recs.size() == 0) {
            return;
        }
        ArrayList<CheckRecord> needRemoveRec = new ArrayList<CheckRecord>(10);
        for (CheckRecord rec : recs) {
            List<CheckRecord.Entry> entries = rec.getEntries();
            if (entries.size() > 0) {
                ArrayList<CheckRecord.Entry> needRemoveEntry = new ArrayList<CheckRecord.Entry>(10);
                for (CheckRecord.Entry entry : entries) {
                    if (entry.getValue().compareTo(BigDecimal.ZERO) != 0) continue;
                    needRemoveEntry.add(entry);
                }
                if (needRemoveEntry.size() > 0) {
                    entries.removeAll(needRemoveEntry);
                }
            }
            if (entries.size() != 0) continue;
            needRemoveRec.add(rec);
        }
        recs.removeAll(needRemoveRec);
    }

    protected List<CheckRecord> doGroup(MDResultSet rs) {
        List<CheckTmpl> tmpls = this.getTmplList(this.ctx);
        if (tmpls == null || tmpls.isEmpty()) {
            return null;
        }
        ArrayList<ReportData> datas = new ArrayList<ReportData>(rs.getFetchSize());
        rs.beforeFirst();
        HashMap<String, Row> ecDataMap = new HashMap<String, Row>();
        HashMap<String, Row> ocDataMap = new HashMap<String, Row>();
        while (rs.next()) {
            Row row = rs.getRow();
            if (!this.checkRow(row)) continue;
            String tc = CheckUtil.getTc(this.ctx, row);
            String ec = CheckUtil.getEc(this.ctx, row);
            String currency = row.getString(PresetConstant.CURRENCY_DIM);
            if (currency.equals(tc)) {
                datas.add(this.buildReportData(row, this.ctx.getFieldMapped()));
            }
            if (currency.equals(ec)) {
                ecDataMap.put(this.genDataKey(this.ctx, row), row);
            }
            if (!currency.equals("OC")) continue;
            ocDataMap.put(this.genDataKey(this.ctx, row), row);
        }
        boolean isChangeProcess = false;
        if (this.ctx.isIncludeADJ() && ConfigServiceHelper.getBoolParam((Long)this.ctx.getModel().p1, "isSupportCheckADJRule") && this.ctx.getProperty("rptdata") != null) {
            isChangeProcess = true;
            MDResultSet rptdata = (MDResultSet)this.ctx.getProperty("rptdata");
            rptdata.beforeFirst();
            while (rptdata.next()) {
                Row rptRow = rptdata.getRow();
                ecDataMap.put(this.genDataKey(this.ctx, rptRow), rptRow);
            }
        }
        for (ReportData data : datas) {
            Row ecRow;
            String tc = CheckUtil.getTc(this.ctx, data.getRow());
            String ec = CheckUtil.getEc(this.ctx, data.getRow());
            data.setEc(ec);
            data.setTc(tc);
            String entity = data.getRow().getString(PresetConstant.ENTITY_DIM);
            String tcKey = this.genDataKey(this.ctx, data.getRow());
            String ecKey = tcKey.replace("&" + PresetConstant.CURRENCY_DIM + tc + "&", "&" + PresetConstant.CURRENCY_DIM + ec + "&");
            if (isChangeProcess) {
                String realEntity = entity;
                ecKey = ecKey.replace("&" + PresetConstant.PROCESS_DIM + "TARPT" + "&", "&" + PresetConstant.PROCESS_DIM + "Rpt" + "&");
                if (entity.contains("_")) {
                    realEntity = entity.split("_")[1];
                }
                ecKey = ecKey.replace(PresetConstant.ENTITY_DIM + entity + "&", PresetConstant.ENTITY_DIM + realEntity + "&");
            }
            if ((ecRow = (Row)ecDataMap.get(ecKey)) != null) {
                data.setEcValue(ecRow.getBigDecimal(FacTabFieldDefEnum.FIELD_MONEY.getField()));
            } else {
                data.setEcValue(BigDecimal.ZERO);
            }
            String ocKey = this.genDataKey(this.ctx, data.getRow()).replace("&" + PresetConstant.CURRENCY_DIM + tc + "&", "&" + PresetConstant.CURRENCY_DIM + "OC" + "&");
            Row ocRow = (Row)ocDataMap.get(ocKey);
            if (ocRow != null) {
                data.setOcValue(ocRow.getBigDecimal(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                continue;
            }
            data.setOcValue(BigDecimal.ZERO);
        }
        if (datas.size() == 0) {
            return null;
        }
        Map rows = datas.parallelStream().collect(Collectors.groupingBy(ReportData::getCurrency, ConcurrentHashMap::new, Collectors.groupingBy(ReportData::genEntityKey, ConcurrentHashMap::new, Collectors.groupingBy(e -> e.genCheckTmplKey(tmpls), ConcurrentHashMap::new, Collectors.toList()))));
        return this.doConvert(rows);
    }

    protected ElimTypeEnum getElimType() {
        throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u7c7b\u5fc5\u987b\u91cd\u5199getElimType\u65b9\u6cd5", (String)"AbstractCheckExecutor_1", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    private List<CheckTmpl> getTmplList(ICheckContext ctx) {
        return ctx.getCheckTmplMap().get(this.getElimType().getNumber());
    }

    private ReportData buildReportData(Row row, Map<String, String> fieldMapped) {
        ReportData data = new ReportData(row, fieldMapped);
        BigDecimal scaleValue = this.dealScale(this.ctx.getModel(), data.getScenario(), data.getCurrency(), data.getAccount(), row.getBigDecimal(FacTabFieldDefEnum.FIELD_MONEY.getField()));
        data.setValue(scaleValue);
        return data;
    }

    protected BigDecimal dealScale(Pair<Long, String> model, String scenario, String currency, String account, BigDecimal value) {
        if (value == null) {
            return null;
        }
        Integer scale = CurrencyScaleHandler.getNewCurrencyScale((Long)model.p1, scenario, currency, account);
        return CurrencyScaleHandler.handleByScaleEnum(value, scale);
    }

    private boolean checkRow(Row row) {
        Pair<Long, String> parent;
        String entity = CheckUtil.convertToRealEntity(row.getString(PresetConstant.ENTITY_DIM));
        String iccompany = row.getString(PresetConstant.INTERNALCOMPANY_DIM);
        String mycompany = CheckUtil.convertToRealEntity(this.ctx.isSpptMyCompany() ? row.getString(PresetConstant.MYCOMPANY_DIM) : entity);
        try {
            BigDecimal value = row.getBigDecimal(FacTabFieldDefEnum.FIELD_MONEY.getField());
            if (BigDecimal.ZERO.compareTo(value) == 0) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        boolean isPass = true;
        if (this.ctx.isSpptMyCompany() && (parent = this.ctx.getParentMap().get(EntityKey.genKey(mycompany, iccompany))) != null && Objects.equals(parent.p2, entity)) {
            isPass = false;
        }
        if (this.ctx.isCompany()) {
            return isPass && (mycompany.equals(this.ctx.getCheckParam().getEntity().p2) || iccompany.equals(this.ctx.getCheckParam().getEntity().p2));
        }
        return isPass;
    }

    private List<CheckRecord> doConvert(Map<String, Map<EntityKey, Map<CheckTmpl, List<ReportData>>>> rows) {
        Map<EntityKey, Pair<Long, String>> parentMap = this.ctx.getParentMap();
        if (parentMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316\u4e24\u4e24\u516c\u53f8\u7684\u5171\u540c\u4e0a\u7ea7", (String)"AbstractCheckExecutor_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        ArrayList<CheckRecord> recList = new ArrayList<CheckRecord>(rows.size());
        rows.forEach((c, m1) -> m1.forEach((e, m2) -> {
            if (!"Entity".equals(((Pair)parentMap.get((Object)e)).p2) && !e.getMycompany().equals(e.getCompany())) {
                m2.forEach((t, d) -> {
                    if (t.getNumber() != null && t.getId() != 0L) {
                        ArrayList<Pair<ReportData, CheckTmpl.Entry>> dataPairs = new ArrayList<Pair<ReportData, CheckTmpl.Entry>>(16);
                        d.forEach(data -> {
                            Optional<CheckTmpl.Entry> opt = t.getEntries().stream().filter(te -> CheckRecordHelper.matchReportDataAndCheckTmplEntry(data, te)).findFirst();
                            if (opt.isPresent() && data.getValue() != null) {
                                dataPairs.add(Pair.onePair((Object)data, (Object)opt.get()));
                            }
                        });
                        if (dataPairs.size() > 0) {
                            CheckRecord rec1Myop;
                            boolean isContainsMyop = dataPairs.stream().anyMatch(p -> "0".equals(((CheckTmpl.Entry)p.p2).getEntrymyop()));
                            boolean isContainsMyOrOp = dataPairs.stream().anyMatch(p -> "1".equals(((CheckTmpl.Entry)p.p2).getEntrymyop()) || "2".equals(((CheckTmpl.Entry)p.p2).getEntrymyop()));
                            if (isContainsMyop && (rec1Myop = CheckRecordHelper.newCheckRecord(this.ctx, c, e, t, dataPairs, true, "0")) != null) {
                                recList.add(rec1Myop);
                            }
                            if (isContainsMyOrOp) {
                                CheckRecord rec1Op;
                                CheckRecord rec1My = CheckRecordHelper.newCheckRecord(this.ctx, c, e, t, dataPairs, true, "1");
                                if (rec1My != null) {
                                    recList.add(rec1My);
                                }
                                if ((rec1Op = CheckRecordHelper.newCheckRecord(this.ctx, c, e, t, dataPairs, true, "2")) != null) {
                                    recList.add(rec1Op);
                                }
                            }
                            if (!t.isGroupDC()) {
                                CheckRecord rec2Myop;
                                if (isContainsMyop && (rec2Myop = CheckRecordHelper.newCheckRecord(this.ctx, c, e, t, dataPairs, false, "0")) != null) {
                                    recList.add(rec2Myop);
                                }
                                if (isContainsMyOrOp) {
                                    CheckRecord rec2Op;
                                    CheckRecord rec2My = CheckRecordHelper.newCheckRecord(this.ctx, c, e, t, dataPairs, false, "1");
                                    if (rec2My != null) {
                                        recList.add(rec2My);
                                    }
                                    if ((rec2Op = CheckRecordHelper.newCheckRecord(this.ctx, c, e, t, dataPairs, false, "2")) != null) {
                                        recList.add(rec2Op);
                                    }
                                }
                            }
                        }
                    }
                });
            }
        }));
        return recList;
    }

    private String genDataKey(ICheckContext ctx, Row row) {
        StringBuilder sb = new StringBuilder();
        for (String dim : ctx.getAllDims()) {
            if (CheckConstant.PRESET_DIMFIELDS.contains(dim)) {
                dim = ctx.getFieldMapped().get(dim);
            }
            sb.append(dim);
            sb.append(row.getString(dim));
            sb.append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

