/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.executor;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.check.ICheckContext;
import kd.fi.bcm.business.check.executor.CashFlowCheckExecutor;
import kd.fi.bcm.business.check.executor.EJECheckExecutor;
import kd.fi.bcm.business.check.executor.ExchCheckExecutor;
import kd.fi.bcm.business.check.executor.ICheckExecutor;
import kd.fi.bcm.business.check.executor.InterCheckExecutor;
import kd.fi.bcm.business.check.executor.InvestCheckExecutor;
import kd.fi.bcm.common.enums.ElimTypeEnum;

public class CheckExecutorFactory {
    public static ICheckExecutor getExecutor(ICheckContext ctx, ElimTypeEnum elimType) {
        switch (elimType) {
            case EJE: {
                return new EJECheckExecutor(ctx);
            }
            case ECF: {
                return new CashFlowCheckExecutor(ctx);
            }
            case EIT: {
                return new ExchCheckExecutor(ctx);
            }
            case EICA: {
                return new InterCheckExecutor(ctx);
            }
            case EOE: {
                return new InvestCheckExecutor(ctx);
            }
            case EOTHER: {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u5176\u4ed6\u62b5\u9500\u7c7b\u578b\u7684\u5bf9\u8d26\u670d\u52a1", (String)"CheckExecutorFactory_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u62b5\u9500\u7c7b\u578b", (String)"CheckExecutorFactory_1", (String)"fi-bcm-business", (Object[])new Object[0]));
    }
}

