/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.check.AdjustBalanceCheckService;
import kd.fi.bcm.business.adjust.model.AdjustBalanceCheckModel;
import kd.fi.bcm.business.adjust.util.AdjustBusinessTypeUtil;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.ICheckContext;
import kd.fi.bcm.business.check.diff.IDiffEntry;
import kd.fi.bcm.business.check.entrydetail.CheckTmplDetailBatchModel;
import kd.fi.bcm.business.check.entrydetail.CheckTmplEntryDetail;
import kd.fi.bcm.business.check.model.CheckRecord;
import kd.fi.bcm.business.check.model.ReportData;
import kd.fi.bcm.business.check.model.key.CheckTmpl;
import kd.fi.bcm.business.check.model.key.EntityKey;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.adjust.AdjustOperationUtils;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.CheckCreateTypeEnum;
import kd.fi.bcm.common.enums.CheckRecordTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.ElimTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustDataSortRuleEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.enums.adjust.LinkAdjustMappingEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;

public class CheckRecordHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CheckTmpl newCheckTmpl(ICheckContext ctx, String elimType, String tmplNumber, CheckTmplDetailBatchModel checkTmplBatchModel) {
        if (elimType == null || tmplNumber == null || checkTmplBatchModel == null || checkTmplBatchModel.isEmpty()) {
            return null;
        }
        Map<String, String> fieldMapped = ctx.getFieldMapped();
        int userDefineSize = ctx.getUserDefineDims().size();
        long modelId = (Long)ctx.getModel().p1;
        CheckTmpl checkTmpl = checkTmplBatchModel.getCheckImpl(elimType, tmplNumber);
        for (CheckTmpl.Entry entry : checkTmpl.getEntries()) {
            Set<String> accountSet;
            List<CheckTmplEntryDetail> elimCompanyResult;
            List<CheckTmplEntryDetail> audittrailResult;
            Long entryId = entry.getEntryId();
            ArrayList<CheckTmpl.EntryDetailWithSign> dims = new ArrayList<CheckTmpl.EntryDetailWithSign>(10);
            ArrayList<CheckTmpl.EntryDetailWithSign> elims = new ArrayList<CheckTmpl.EntryDetailWithSign>(10);
            List<CheckTmplEntryDetail> companyResult = checkTmplBatchModel.getDetailByEntryAndDimKey(elimType, tmplNumber, entryId, "company", false);
            if (!companyResult.isEmpty()) {
                CheckRecordHelper.getMembersByRange(dims, PresetConstant.INTERNALCOMPANY_DIM, companyResult, modelId, ctx);
            }
            if (MemberReader.isExistAuditTrailDimension((long)modelId) && !(audittrailResult = checkTmplBatchModel.getDetailByEntryAndDimKey(elimType, tmplNumber, entryId, "audittrail", false)).isEmpty()) {
                CheckRecordHelper.getMembersByRange(dims, "audittrail", audittrailResult, modelId, ctx);
            }
            if (!(elimCompanyResult = checkTmplBatchModel.getDetailByEntryAndDimKey(elimType, tmplNumber, entryId, "elimcompany", true)).isEmpty()) {
                CheckRecordHelper.getMembersByRange(elims, "elimcompany", elimCompanyResult, modelId, ctx);
            }
            if (MemberReader.isExistAuditTrailDimension((long)modelId)) {
                List<CheckTmplEntryDetail> elimAudittrailResult = checkTmplBatchModel.getDetailByEntryAndDimKey(elimType, tmplNumber, entryId, "elimaudittrail", true);
                if (entry.isDiffitem()) {
                    checkTmpl.setDiffAuditTrail(elimAudittrailResult.get(0).getMemberTreeId());
                }
                if (!elimAudittrailResult.isEmpty()) {
                    CheckRecordHelper.getMembersByRange(elims, "elimaudittrail", elimAudittrailResult, modelId, ctx);
                }
            }
            HashSet accountUnleafSet = new HashSet(16);
            List<CheckTmplEntryDetail> accountResult = checkTmplBatchModel.getDetailByEntryAndDimKey(elimType, tmplNumber, entryId, "accounttree", false);
            if (!accountResult.isEmpty()) {
                accountSet = CheckRecordHelper.getMembersByRange(dims, PresetConstant.ACCOUNT_DIM, accountResult, modelId, ctx);
                accountSet.removeIf(e -> {
                    boolean isaccountoffset;
                    IDNumberTreeNode acct = MemberReader.findMemberByNumber((String)((String)ctx.getModel().p2), (String)PresetConstant.ACCOUNT_DIM, (String)e);
                    boolean bl = isaccountoffset = acct.getProperty("accountpart.isaccountoffset") == null ? true : (Boolean)acct.getProperty("accountpart.isaccountoffset");
                    if (!isaccountoffset) {
                        return true;
                    }
                    if (!acct.isLeaf()) {
                        accountUnleafSet.add(e);
                    }
                    return false;
                });
            } else {
                accountSet = new HashSet<String>();
            }
            entry.setAccountNumbers(accountSet);
            if (entry.isDiffitem() && CollectionUtils.isEmpty(accountSet)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f\u201c%s\u201d\u5dee\u989d\u9879\u7684\u79d1\u76ee\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u7684\u914d\u7f6e\u3002", (String)"CheckRecordHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), tmplNumber));
            }
            List<CheckTmplEntryDetail> elimAccountResult = checkTmplBatchModel.getDetailByEntryAndDimKey(elimType, tmplNumber, entryId, "elimaccounttree", true);
            if (elimAccountResult.size() == 1 && !elimAccountResult.get(0).isCust()) {
                IDNumberTreeNode acct = MemberReader.findMemberById((String)((String)ctx.getModel().p2), (String)DimEntityNumEnum.getEntieyNumByNumber((String)PresetConstant.ACCOUNT_DIM), (Long)elimAccountResult.get(0).getMemberTreeId());
                if (acct != IDNumberTreeNode.NotFoundTreeNode) {
                    acct = acct.getBaseTreeNode();
                }
                boolean isaccountoffset = acct.getProperty("accountpart.isaccountoffset") == null ? false : (Boolean)acct.getProperty("accountpart.isaccountoffset");
                HashSet<String> set = new HashSet<String>();
                entry.setElimAccountNumbers(set);
                if (!acct.isLeaf() || !isaccountoffset) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f%1$s\u7b2c%2$s\u884c\u62b5\u9500\u79d1\u76ee\u914d\u7f6e\u5e94\u540c\u65f6\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\uff1a\u62b5\u9500\u548c\u660e\u7ec6\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u62b5\u9500\u79d1\u76ee\u914d\u7f6e\u3002", (String)"CheckRecordHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), checkTmpl.getNumber(), entry.getSeq()));
                set.add(acct.getNumber());
            } else {
                if (accountUnleafSet.size() > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f%1$s\u7b2c%2$s\u884c\u62b5\u9500\u79d1\u76ee\u914d\u7f6e\u9700\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\uff1a\u62b5\u9500\u548c\u660e\u7ec6\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u62b5\u9500\u79d1\u76ee\u914d\u7f6e\u3002", (String)"CheckRecordHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), checkTmpl.getNumber(), entry.getSeq()));
                }
                entry.setElimAccountNumbers(accountSet);
            }
            if (entry.isDiffitem() && !CollectionUtils.isEmpty(entry.getElimAccountNumbers())) {
                String elimAcct = entry.getElimAccountNumbers().iterator().next();
                entry.setDc(DrCRDirectEnum.isDc((String)((String)MemberReader.findMemberByNumber((String)((String)ctx.getModel().p2), (String)PresetConstant.ACCOUNT_DIM, (String)elimAcct).getProperty("drcrdirect"))) ? 0 : 1);
            }
            if (userDefineSize > 0) {
                for (String currentDim : CheckConstant.PRESET_DIMFIELDS) {
                    String elimCurrentDim;
                    List<CheckTmplEntryDetail> elimResult;
                    if (!fieldMapped.containsKey(currentDim)) continue;
                    List<CheckTmplEntryDetail> result = checkTmplBatchModel.getDetailByEntryAndDimKey(elimType, tmplNumber, entryId, currentDim, false);
                    if (result != null) {
                        CheckRecordHelper.getMembersByRange(dims, currentDim, result, modelId, ctx);
                    }
                    if ((elimResult = checkTmplBatchModel.getDetailByEntryAndDimKey(elimType, tmplNumber, entryId, elimCurrentDim = "elim" + currentDim, true)) == null) continue;
                    CheckRecordHelper.getMembersByRange(elims, elimCurrentDim, elimResult, modelId, ctx);
                }
            }
            if (!dims.isEmpty()) {
                entry.setDims(dims);
            }
            if (elims.isEmpty()) continue;
            entry.setElimDims(elims);
        }
        return checkTmpl;
    }

    private static Set<String> getMembersByRange(List<CheckTmpl.EntryDetailWithSign> dims, String sign, List<CheckTmplEntryDetail> details, Long modelId, ICheckContext ctx) {
        boolean isInternalCompany = PresetConstant.INTERNALCOMPANY_DIM.equals(sign) || "elimcompany".equals(sign);
        boolean isElimDim = sign.startsWith("elim");
        if (details != null && !details.isEmpty()) {
            String cellCacheKey;
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            Set<Object> numberSet = new HashSet(16);
            Map<String, Pair<Boolean, Long>> numberIdMap = new HashMap(16);
            HashMap<String, Map<String, Pair<Boolean, Long>>> tmplCellMemberRangeMap = (HashMap<String, Map<String, Pair<Boolean, Long>>>)ctx.getProperty("TmplCellMemberRangeMap");
            if (tmplCellMemberRangeMap == null) {
                tmplCellMemberRangeMap = new HashMap<String, Map<String, Pair<Boolean, Long>>>(16);
                ctx.putProperty("TmplCellMemberRangeMap", tmplCellMemberRangeMap);
            }
            if (tmplCellMemberRangeMap.containsKey(cellCacheKey = CheckRecordHelper.getDetailsKey(details))) {
                numberIdMap = (Map)tmplCellMemberRangeMap.get(cellCacheKey);
                numberSet = numberIdMap.keySet();
            } else {
                HashMap tmplSingleMemberRangeMap = (HashMap)ctx.getProperty("TmplSingleMemberRangeMap");
                if (tmplSingleMemberRangeMap == null) {
                    tmplSingleMemberRangeMap = new HashMap(16);
                    ctx.putProperty("TmplSingleMemberRangeMap", tmplSingleMemberRangeMap);
                }
                for (CheckTmplEntryDetail detail : details) {
                    MembRangeItem membRangeItem = new MembRangeItem(CheckUtil.getEntityBySign(detail.getSign()), detail.getMemberTreeId(), detail.getNumber(), RangeEnum.getRangeByVal((int)detail.getScope()), detail.isCust(), (Object)modelId);
                    String cacheKey = membRangeItem.genKey(null);
                    if (tmplSingleMemberRangeMap.containsKey(cacheKey)) {
                        Map map = (Map)tmplSingleMemberRangeMap.get(cacheKey);
                        numberIdMap.putAll(map);
                        numberSet.addAll(map.keySet());
                        continue;
                    }
                    HashSet finalNumberSet = new HashSet(16);
                    HashMap finalNumberIdMap = new HashMap(16);
                    if (CheckRecordHelper.isNeedResolve(ctx, detail, details.size(), isInternalCompany)) {
                        membRangeItem.matchItems(e -> {
                            String number = e.getNumber();
                            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)ctx.getAllDimIdNumberMapped().get(detail.getDimensionId()), (String)number);
                            finalNumberSet.add(number);
                            finalNumberIdMap.put(number, Pair.onePair((Object)node.isLeaf(), e.getId()));
                        });
                    }
                    numberIdMap.putAll(finalNumberIdMap);
                    numberSet.addAll(finalNumberSet);
                    tmplSingleMemberRangeMap.put(cacheKey, finalNumberIdMap);
                }
                tmplCellMemberRangeMap.put(cellCacheKey, numberIdMap);
            }
            if (isElimDim && numberSet.size() > 1) {
                numberIdMap = new HashMap(16);
                numberSet = new HashSet(16);
            }
            CheckTmpl.EntryDetailWithSign detailWithSign = new CheckTmpl.EntryDetailWithSign(sign, details);
            detailWithSign.setNumberSet(numberSet);
            detailWithSign.setNumberIdMap(numberIdMap);
            dims.add(detailWithSign);
            return numberSet;
        }
        return new HashSet<String>(0);
    }

    private static boolean isNeedResolve(ICheckContext ctx, CheckTmplEntryDetail detail, int detailSize, boolean isInternalCompany) {
        Set internalCompanyIds = (Set)ctx.getProperty("InternalCompanyIds");
        return !isInternalCompany || detailSize != 1 || internalCompanyIds == null || !internalCompanyIds.contains(detail.getMemberTreeId()) || detail.getScope().intValue() != RangeEnum.VALUE_90.getValue();
    }

    private static String getDetailsKey(List<CheckTmplEntryDetail> details) {
        StringBuilder cacheKey = new StringBuilder();
        for (CheckTmplEntryDetail detail : details) {
            cacheKey.append(detail.getMemberTreeId()).append(detail.getScope()).append(detail.isCust());
        }
        return cacheKey.toString();
    }

    public static CheckRecord newCheckRecord(ICheckContext ctx, String number, String c, EntityKey e, CheckTmpl t, List<Pair<ReportData, CheckTmpl.Entry>> dataPairs, boolean isAbDc, String myop) {
        String interCom;
        if (c == null || e == null || t == null || dataPairs == null || dataPairs.size() == 0) {
            return null;
        }
        CheckRecord checkRecord = new CheckRecord();
        checkRecord.setOrgmap(new HashMap<String, String>(16));
        checkRecord.setRecordTypeEnumMap(new HashMap<String, CheckRecordTypeEnum>(16));
        checkRecord.setSingleDC(t.isSingleDc());
        checkRecord.setCheckconfig(t.getCheckconfig());
        checkRecord.setTmpl(t);
        checkRecord.setId(CheckRecordHelper.getCheckRecordId(ctx));
        checkRecord.setNumber(number);
        checkRecord.setElimType(t.getElimType());
        checkRecord.setDiffMode(t.getDiffMode());
        checkRecord.setDiffMethod(t.getDiffMethod());
        checkRecord.setStatus(1);
        checkRecord.setModelid((Long)ctx.getModel().p1);
        checkRecord.setSceneid((Long)ctx.getCheckParam().getScene().p1);
        checkRecord.setYearid((Long)ctx.getCheckParam().getYear().p1);
        checkRecord.setPeriodid((Long)ctx.getCheckParam().getPeriod().p1);
        checkRecord.setAudittrailid(t.getDiffAuditTrail());
        checkRecord.setCurrencyid(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.CURRENCY_DIM, c));
        String ProcessNum = ctx.getCheckParam().isIncludeAdj() ? "ARPT" : "Rpt";
        checkRecord.setProcessid(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.PROCESS_DIM, ProcessNum));
        Date nowTime = TimeServiceHelper.now();
        checkRecord.setMultigaapid(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.RULE_DIM, ((ReportData)dataPairs.get((int)0).p1).getMultigaap()));
        checkRecord.setDatasortid(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.DATASORT_DIM, ((ReportData)dataPairs.get((int)0).p1).getDatasort()));
        checkRecord.setCreatorid(Long.valueOf(RequestContext.get().getUserId()));
        checkRecord.setCreatetime(nowTime);
        checkRecord.setModifierid(Long.valueOf(RequestContext.get().getUserId()));
        checkRecord.setModifytime(nowTime);
        Pair<Long, String> entity = ctx.getCheckParam().getEntity();
        checkRecord.setEntityid(!ctx.isCompany() ? (Long)entity.p1 : CheckRecordHelper.getCommonParent(ctx, e));
        String myCom = (String)entity.p2;
        if (ctx.isCompany()) {
            interCom = ((String)entity.p2).equals(e.getMycompany()) ? e.getCompany() : e.getMycompany();
            checkRecord.setMyentityid((Long)entity.p1);
            checkRecord.setMyentityNum((String)entity.p2);
            checkRecord.setOpentityid(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.ENTITY_DIM, interCom));
            checkRecord.setOpentityNum(interCom);
        } else {
            interCom = "";
            if (e.getMycompany() != null && e.getCompany() != null && e.getMycompany().compareTo(e.getCompany()) < 0) {
                myCom = e.getMycompany();
                interCom = e.getCompany();
            } else {
                myCom = e.getCompany();
                interCom = e.getMycompany();
            }
            checkRecord.setMyentityid(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.ENTITY_DIM, myCom));
            checkRecord.setMyentityNum(myCom);
            checkRecord.setOpentityid(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.ENTITY_DIM, interCom));
            checkRecord.setOpentityNum(interCom);
        }
        ArrayList<CheckRecord.Entry> entries = new ArrayList<CheckRecord.Entry>(10);
        int seq = 0;
        for (Pair<ReportData, CheckTmpl.Entry> p : dataPairs) {
            boolean ab;
            boolean bl = ab = (ctx.isSpptMyCompany() ? ((ReportData)p.p1).getMycompany() : ((ReportData)p.p1).getEntity()).compareTo(((ReportData)p.p1).getInternalcompany()) < 0;
            if (t.isGroupDC()) {
                if (!CheckRecordHelper.filterEntryMyop(myop, ab, (CheckTmpl.Entry)p.p2)) continue;
                CheckRecord.Entry entry = CheckRecordHelper.newCheckRecordEntry(ctx, checkRecord, (CheckTmpl.Entry)p.p2, (ReportData)p.p1, seq++, myCom);
                entries.add(entry);
                continue;
            }
            boolean isDc = !CheckRecordHelper.isDc((Long)ctx.getModel().p1, CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.ACCOUNT_DIM, ((ReportData)p.p1).getAccount()));
            if (!(isAbDc ^ (ab ^ isDc)) || !CheckRecordHelper.filterEntryMyop(myop, ab, (CheckTmpl.Entry)p.p2)) continue;
            CheckRecord.Entry entry = CheckRecordHelper.newCheckRecordEntry(ctx, checkRecord, (CheckTmpl.Entry)p.p2, (ReportData)p.p1, seq++, myCom);
            entries.add(entry);
        }
        if (entries.isEmpty()) {
            return null;
        }
        checkRecord.setEntries(entries);
        entries.stream().map(IDiffEntry::getGroup).collect(Collectors.toSet()).forEach(k -> entries.add(CheckRecordHelper.newCheckRecordEntry(ctx, checkRecord, k)));
        return checkRecord;
    }

    private static Long getCheckRecordId(ICheckContext ctx) {
        Set checkRecordIds = (Set)ctx.getCheckParam().get("checkRecordIds");
        if (ctx.getCheckParam().get("actionDiffFlag") != null && !CollectionUtils.isEmpty((Collection)checkRecordIds)) {
            return (Long)new ArrayList(checkRecordIds).get(0);
        }
        return GlobalIdUtil.genGlobalLongId();
    }

    private static boolean filterEntryMyop(String myop, boolean isab, CheckTmpl.Entry tmplEntry) {
        switch (myop) {
            case "0": {
                return tmplEntry.getEntrymyop().equals(myop);
            }
            case "1": {
                return isab && "1".equals(tmplEntry.getEntrymyop()) || !isab && "2".equals(tmplEntry.getEntrymyop());
            }
            case "2": {
                return isab && "2".equals(tmplEntry.getEntrymyop()) || !isab && "1".equals(tmplEntry.getEntrymyop());
            }
        }
        return false;
    }

    public static CheckRecord newCheckRecord(ICheckContext ctx, String currency, EntityKey entityKey, CheckTmpl tmpl, List<Pair<ReportData, CheckTmpl.Entry>> dataPairs, boolean isAbDc, String myop) {
        return CheckRecordHelper.newCheckRecord(ctx, tmpl.getNumber(), currency, entityKey, tmpl, dataPairs, isAbDc, myop);
    }

    public static DynamicObject buildCheckDynamicObject(ICheckContext ctx, CheckRecord data, Map<Long, String> numbers) {
        DynamicObject checkRecord = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checkrecord");
        checkRecord.set("id", (Object)data.getId());
        checkRecord.set("number", (Object)(ctx.isBatchDiff() ? data.getNumber() : numbers.get(data.getId())));
        checkRecord.set("diffmode", (Object)data.getDiffMode());
        checkRecord.set("diffmethod", (Object)data.getDiffMethod());
        checkRecord.set("elimtype", (Object)data.getElimType());
        checkRecord.set("checktmpl", (Object)data.getTmpl().getId());
        checkRecord.set("status", (Object)data.getStatus());
        checkRecord.set("creator", (Object)data.getCreatorid());
        checkRecord.set("createtime", (Object)data.getCreatetime());
        checkRecord.set("modifier", (Object)data.getModifierid());
        checkRecord.set("modifytime", (Object)data.getModifytime());
        checkRecord.set("createorg", (Object)data.getCreatorid());
        checkRecord.set("model", (Object)data.getModelid());
        checkRecord.set("scene", (Object)data.getSceneid());
        checkRecord.set("year", (Object)data.getYearid());
        checkRecord.set("period", (Object)data.getPeriodid());
        checkRecord.set("currency", (Object)data.getCurrencyid());
        checkRecord.set("audittrail", (Object)data.getAudittrailid());
        checkRecord.set("process", (Object)data.getProcessid());
        checkRecord.set("multigaap", (Object)data.getMultigaapid());
        checkRecord.set("datasort", (Object)data.getDatasortid());
        checkRecord.set("entity", (Object)data.getEntityid());
        checkRecord.set("difference", (Object)data.getDifference());
        checkRecord.set("difference2", (Object)data.getDifference2());
        checkRecord.set("isautoelim", (Object)ctx.getCheckParam().getIsAutoElim());
        checkRecord.set("myentity", (Object)data.getMyentityid());
        checkRecord.set("oppositeentity", (Object)data.getOpentityid());
        checkRecord.set("myecmoney", (Object)data.getMyecmoney());
        checkRecord.set("opecmoney", (Object)data.getOpecmoney());
        checkRecord.set("mycvtpath", (Object)data.getMycvtpath());
        checkRecord.set("opcvtpath", (Object)data.getOpcvtpath());
        checkRecord.set("myrate", (Object)data.getMyrate());
        checkRecord.set("oprate", (Object)data.getOprate());
        checkRecord.set("mycvtmoney", (Object)data.getMycvtmoney());
        checkRecord.set("opcvtmoney", (Object)data.getOpcvtmoney());
        checkRecord.set("cvtdifmoney", (Object)data.getCvtdifmoney());
        checkRecord.set("createtype", (Object)(ctx.getCheckParam().getCreateTypeEnum() == null ? CheckCreateTypeEnum.CHECK_CREATE.value : ctx.getCheckParam().getCreateTypeEnum().value));
        checkRecord.set("recordtype", (Object)(data.getRecordTypeEnum() == null ? CheckRecordTypeEnum.NORMAL.value : data.getRecordTypeEnum().value));
        DynamicObjectCollection doc = checkRecord.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (CheckRecord.Entry entry : data.getEntries()) {
            DynamicObject dynaObj = new DynamicObject(doc.getDynamicObjectType());
            dynaObj.set("id", (Object)entry.getId());
            dynaObj.set("seq", (Object)seq++);
            dynaObj.set("entrymodel", (Object)entry.getEntrymodel());
            dynaObj.set("checktmplentry", (Object)entry.getTmplEntry().getEntryId());
            dynaObj.set("dc", (Object)entry.getDc());
            dynaObj.set("entryscene", (Object)entry.getEntryscene());
            dynaObj.set("entryyear", (Object)entry.getEntryyear());
            dynaObj.set("entryperiod", (Object)entry.getEntryperiod());
            dynaObj.set("entryprocess", (Object)entry.getEntryprocess());
            dynaObj.set("entryaudittrail", (Object)entry.getEntryaudittrail());
            dynaObj.set("entryorg", (Object)entry.getEntryorg());
            dynaObj.set("entrymycompany", (Object)entry.getEntrymycompany());
            dynaObj.set("entrycompany", (Object)entry.getEntrycompany());
            dynaObj.set("entrydebitaccout", (Object)entry.getEntrydebitaccout());
            dynaObj.set("entrycreditaccout", (Object)entry.getEntrycreditaccout());
            dynaObj.set("entrychangetype", (Object)entry.getEntrychangetype());
            dynaObj.set("entrymultigaap", (Object)entry.getEntrymultigaap());
            dynaObj.set("entrydatasort", (Object)entry.getEntrydatasort());
            dynaObj.set("entrycurrency", (Object)entry.getEntrycurrency());
            dynaObj.set("entrydim1", (Object)entry.getEntrydim1());
            dynaObj.set("entrydim2", (Object)entry.getEntrydim2());
            dynaObj.set("entrydim3", (Object)entry.getEntrydim3());
            dynaObj.set("entrydim4", (Object)entry.getEntrydim4());
            dynaObj.set("entrydim5", (Object)entry.getEntrydim5());
            dynaObj.set("entrydim6", (Object)entry.getEntrydim6());
            dynaObj.set("entrydebit", (Object)entry.getEntrydebit());
            dynaObj.set("entrycredit", (Object)entry.getEntrycredit());
            dynaObj.set("entrydebelimval", (Object)entry.getEntrydebelimvalue());
            dynaObj.set("entrycreelimval", (Object)entry.getEntrycreelimvalue());
            dynaObj.set("isdiffitem", (Object)(entry.isDi() ? "1" : "0"));
            dynaObj.set("entrymyecmoney", (Object)entry.getMyecmoney());
            dynaObj.set("entryopecmoney", (Object)entry.getOpecmoney());
            dynaObj.set("entrymycvtpath", (Object)entry.getMycvtpath());
            dynaObj.set("entryopcvtpath", (Object)entry.getOpcvtpath());
            dynaObj.set("entrymyrate", (Object)entry.getMyrate());
            dynaObj.set("entryoprate", (Object)entry.getOprate());
            dynaObj.set("entrymycvtmoney", (Object)entry.getMycvtmoney());
            dynaObj.set("entryopcvtmoney", (Object)entry.getOpcvtmoney());
            dynaObj.set("entrycvtdifmoney", (Object)entry.getCvtdifmoney());
            dynaObj.set("entrymyaccount", (Object)entry.getMyaccount());
            dynaObj.set("entryopaccount", (Object)entry.getOpaccount());
            dynaObj.set("merge", (Object)entry.isMerge());
            if (entry.getEntryDiffMode() == 5) {
                dynaObj.set("merge", (Object)true);
            }
            dynaObj.set("entryocmoney", (Object)entry.getOcmoney());
            dynaObj.set("entrydiffmode", (Object)entry.getEntryDiffMode());
            dynaObj.set("entrydiffmethod", (Object)entry.getEntryDiffMethod());
            dynaObj.set("difftype", (Object)entry.getDiffType());
            dynaObj.set("groupkey", (Object)(StringUtils.isEmpty((String)entry.getGroup()) ? " " : entry.getGroup()));
            doc.add((Object)dynaObj);
        }
        return checkRecord;
    }

    public static DynamicObject toCheckDynamicObject(DynamicObject head, DynamicObjectCollection rows) {
        DynamicObject checkRecord = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checkrecord");
        checkRecord.set("id", (Object)head.getLong("id"));
        checkRecord.set("diffmode", (Object)3);
        checkRecord.set("checktmpl", head.get("checktmpl"));
        checkRecord.set("status", (Object)2);
        checkRecord.set("creator", head.get("creator.id"));
        checkRecord.set("createtime", (Object)head.getDate("createtime"));
        checkRecord.set("modifier", (Object)RequestContext.get().getUserId());
        checkRecord.set("modifytime", (Object)TimeServiceHelper.now());
        checkRecord.set("createorg", head.get("createorg.id"));
        checkRecord.set("model", head.get("model.id"));
        checkRecord.set("scene", head.get("scene.id"));
        checkRecord.set("year", head.get("year.id"));
        checkRecord.set("period", head.get("period.id"));
        checkRecord.set("currency", head.get("currency.id"));
        checkRecord.set("audittrail", head.get("audittrail.id"));
        checkRecord.set("process", head.get("process.id"));
        checkRecord.set("multigaap", head.get("multigaap.id"));
        checkRecord.set("datasort", head.get("datasort.id"));
        checkRecord.set("entity", head.get("entity.id"));
        checkRecord.set("number", head.get("number"));
        checkRecord.set("elimtype", head.get("elimtype"));
        checkRecord.set("myentity", head.get("myentity"));
        checkRecord.set("oppositeentity", head.get("oppositeentity"));
        checkRecord.set("myecmoney", head.get("myecmoney"));
        checkRecord.set("opecmoney", head.get("opecmoney"));
        checkRecord.set("mycvtpath", head.get("mycvtpath"));
        checkRecord.set("opcvtpath", head.get("opcvtpath"));
        checkRecord.set("myrate", head.get("myrate"));
        checkRecord.set("oprate", head.get("oprate"));
        checkRecord.set("mycvtmoney", head.get("mycvtmoney"));
        checkRecord.set("opcvtmoney", head.get("opcvtmoney"));
        checkRecord.set("cvtdifmoney", head.get("cvtdifmoney"));
        checkRecord.set("recordtype", head.get("recordtype") == null ? "0" : head.get("recordtype"));
        checkRecord.set("mark", head.get("mark"));
        checkRecord.set("isautoelim", (Object)"0");
        checkRecord.set("createtype", (Object)CheckCreateTypeEnum.CHECKADJUST_CREATE.value);
        DynamicObjectCollection doc = checkRecord.getDynamicObjectCollection("entryentity");
        int seq = 0;
        BigDecimal difference = BigDecimal.ZERO;
        BigDecimal difference2 = BigDecimal.ZERO;
        DynamicObjectCollection checkRecordEntries = head.getDynamicObjectCollection("entryentity");
        DynamicObject checkRecordEntry = (DynamicObject)checkRecordEntries.get(0);
        for (DynamicObject row : rows) {
            DynamicObject account = row.getDynamicObject("entrydebitaccout") != null ? row.getDynamicObject("entrydebitaccout") : row.getDynamicObject("entrycreditaccout");
            boolean dc = CheckRecordHelper.getDC(account);
            DynamicObject dynaObj = new DynamicObject(doc.getDynamicObjectType());
            dynaObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dynaObj.set("seq", (Object)seq++);
            dynaObj.set("entrymodel", head.get("model.id"));
            dynaObj.set("dc", (Object)(dc ? 1 : 0));
            dynaObj.set("entryscene", head.get("scene.id"));
            dynaObj.set("entryyear", head.get("year.id"));
            dynaObj.set("entryperiod", head.get("period.id"));
            dynaObj.set("entryprocess", head.get("process.id"));
            dynaObj.set("entryaudittrail", row.get("entryaudittrail.id"));
            dynaObj.set("entrymultigaap", checkRecordEntry.get("entrymultigaap.id"));
            dynaObj.set("entrydatasort", checkRecordEntry.get("entrydatasort.id"));
            dynaObj.set("entrycurrency", head.get("currency.id"));
            dynaObj.set("entryorg", row.get("entryorg.id"));
            dynaObj.set("entrycompany", row.get("entrycompany.id"));
            dynaObj.set("entrymycompany", row.get("entrymycompany.id"));
            dynaObj.set("entrydebitaccout", row.get("entrydebitaccout.id"));
            dynaObj.set("entrycreditaccout", row.get("entrycreditaccout.id"));
            dynaObj.set("entrychangetype", row.get("entrychangetype.id"));
            for (String field : CheckConstant.PRESET_DIMFIELDS) {
                dynaObj.set("entry" + field, row.get("entry" + field + ".id"));
            }
            BigDecimal debit = row.getBigDecimal("entrydebit");
            BigDecimal credit = row.getBigDecimal("entrycredit");
            BigDecimal debitelim = row.getBigDecimal("entrydebelimval");
            BigDecimal creditelim = row.getBigDecimal("entrycreelimval");
            dynaObj.set("entrydebit", (Object)debit);
            dynaObj.set("entrycredit", (Object)credit);
            dynaObj.set("entrydebelimval", (Object)debitelim);
            dynaObj.set("entrycreelimval", (Object)creditelim);
            dynaObj.set("isdiffitem", (Object)(BigDecimal.ZERO.compareTo(debit) == 0 && BigDecimal.ZERO.compareTo(credit) == 0 ? "1" : "0"));
            DynamicObject entry0 = null;
            for (DynamicObject entry : checkRecordEntries) {
                if (entry.getLong("id") != row.getLong("id")) continue;
                entry0 = entry;
                break;
            }
            if (entry0 != null) {
                dynaObj.set("isdiffitem", entry0.get("isdiffitem"));
                dynaObj.set("entrymyecmoney", entry0.get("entrymyecmoney"));
                dynaObj.set("entryopecmoney", entry0.get("entryopecmoney"));
                dynaObj.set("entrymycvtpath", entry0.get("entrymycvtpath"));
                dynaObj.set("entryopcvtpath", entry0.get("entryopcvtpath"));
                dynaObj.set("entrymyrate", entry0.get("entrymyrate"));
                dynaObj.set("entryoprate", entry0.get("entryoprate"));
                dynaObj.set("entrymycvtmoney", entry0.get("entrymycvtmoney"));
                dynaObj.set("entryopcvtmoney", entry0.get("entryopcvtmoney"));
                dynaObj.set("entrycvtdifmoney", entry0.get("entrycvtdifmoney"));
                dynaObj.set("entrymyaccount", entry0.get("entrymyaccount"));
                dynaObj.set("entryopaccount", entry0.get("entryopaccount"));
                dynaObj.set("checktmplentry", entry0.get("checktmplentry"));
                dynaObj.set("groupkey", entry0.get("groupkey"));
                dynaObj.set("entryocmoney", (Object)(entry0.getBigDecimal("entryocmoney") == null ? BigDecimal.ZERO : entry0.getBigDecimal("entryocmoney")));
                dynaObj.set("difftype", (Object)entry0.getInt("difftype"));
            }
            doc.add((Object)dynaObj);
            difference = difference.add(debit.subtract(credit));
            difference2 = difference2.add(debitelim.subtract(creditelim));
        }
        checkRecord.set("difference", (Object)difference);
        checkRecord.set("difference2", (Object)difference2);
        return checkRecord;
    }

    public static boolean getDC(DynamicObject account) {
        String direct = account.getString("drcrdirect");
        return DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.getOIndex().equals(direct);
    }

    public static Map<Long, String> batchQueryCheckNumber(ICheckContext ctx, List<CheckRecord> recs) {
        HashMap<Long, String> result = new HashMap<Long, String>(recs.size());
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checkrecordsum");
        dy.set("createtime", (Object)TimeServiceHelper.now());
        String[] number = CodeRuleServiceHelper.getBatchNumber((String)"bcm_checkrecordsum", (DynamicObject)dy, null, (int)recs.size());
        if (number == null || number.length != recs.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7f16\u7801\u5931\u8d25\uff0c\u8bf7\u7ef4\u62a4\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"CheckRecordHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        for (int i = 0; i < recs.size(); ++i) {
            result.put(recs.get(i).getId(), number[i]);
        }
        return result;
    }

    public static DynamicObject buildElimDynamicObject(ICheckContext ctx, DynamicObject source) {
        Optional<CheckTmpl> tmplOptional = ctx.getCheckTmplMap().values().stream().flatMap(Collection::stream).filter(t -> Objects.equals(source.getLong("checktmpl.id"), t.getId())).findAny();
        IDNumberTreeNode yearNode = MemberReader.findMemberById((long)((Long)ctx.getModel().p1), (String)"bcm_fymembertree", (Long)((Long)ctx.getCheckParam().getYear().p1));
        IDNumberTreeNode periodNode = MemberReader.findMemberById((long)((Long)ctx.getModel().p1), (String)"bcm_periodmembertree", (Long)((Long)ctx.getCheckParam().getPeriod().p1));
        DynamicObject elimInfo = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
        elimInfo.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        elimInfo.set("model", (Object)source.getLong("model"));
        elimInfo.set("name", (Object)String.format("%s_%s_%s", source.get("checktmpl.name"), yearNode.getName(), periodNode.getName()));
        elimInfo.set("scenario", (Object)source.getLong("scene"));
        elimInfo.set("year", (Object)source.getLong("year"));
        elimInfo.set("period", (Object)source.getLong("period"));
        elimInfo.set("audittrail", (Object)source.getLong("audittrail"));
        elimInfo.set("modifier", (Object)RequestContext.get().getUserId());
        elimInfo.set("modifytime", (Object)TimeServiceHelper.now());
        elimInfo.set("creator", (Object)RequestContext.get().getUserId());
        elimInfo.set("createtime", (Object)TimeServiceHelper.now());
        elimInfo.set("spreadjson", null);
        elimInfo.set("data", null);
        elimInfo.set("iscontinuous", null);
        elimInfo.set("process", (Object)ElimTypeEnum.getEnum((Integer)source.getInt("elimtype")).getNumber());
        elimInfo.set("status", (Object)RptAdjustStatusEnum.SAVE.status());
        elimInfo.set("journaltype", StringUtils.isEmpty((String)source.getString("checktmpl.journaltype")) ? "1" : source.get("checktmpl.journaltype"));
        elimInfo.set("balancetype", (Object)BalanceTypeEnum.BALANCE.index);
        tmplOptional.ifPresent(t -> elimInfo.set("templatecatalog", (Object)t.getAdjustCatalogId()));
        if (source.getInt("checktmpl.islinkage") == 1) {
            elimInfo.set("linkcreatetype", (Object)AdjustLinkCreateEnum.AUTOCREATEADJUST.getStatus());
        } else if (source.getInt("checktmpl.islinkage") == 0) {
            elimInfo.set("linkcreatetype", (Object)AdjustLinkCreateEnum.MANUALCREATEADJUST.getStatus());
        } else {
            elimInfo.set("linkcreatetype", (Object)AdjustLinkCreateEnum.COMMONADJUST.getStatus());
        }
        elimInfo.set("description", (Object)String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u751f\u6210(%s)", (String)"CheckRecordHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), source.get("checktmpl.number")));
        elimInfo.set("entity", (Object)source.getLong("entity"));
        elimInfo.set("extend", null);
        elimInfo.set("checkrecord", (Object)source.getLong("id"));
        elimInfo.set("belongorg", (Object)source.getLong("entity"));
        elimInfo.set("bussnesstype", (Object)AdjustBusinessTypeUtil.getBusinessTypeByProcess(ElimTypeEnum.getEnum((Integer)source.getInt("elimtype")).getNumber()));
        elimInfo.set("entrysource", (Object)"0");
        elimInfo.set("linkagelinksource", (Object)0);
        elimInfo.set("multiplecurrency", (Object)"0");
        elimInfo.set("cvtbeforecurrency", (Object)0L);
        elimInfo.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.AUTO.getValue());
        elimInfo.set("submitter", (Object)RequestContext.get().getUserId());
        elimInfo.set("submittime", (Object)TimeServiceHelper.now());
        elimInfo.set("ratifier", (Object)RequestContext.get().getUserId());
        elimInfo.set("ratifytime", (Object)TimeServiceHelper.now());
        DynamicObjectCollection commembentry = elimInfo.getDynamicObjectCollection("commembentry");
        int seq = 0;
        DynamicObjectType type = commembentry.getDynamicObjectType();
        commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.FY_DIM), source.getLong("year"), seq++));
        commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.PERIOD_DIM), source.getLong("period"), seq++));
        commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.SCENE_DIM), source.getLong("scene"), seq++));
        commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.PROCESS_DIM), CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.PROCESS_DIM, ElimTypeEnum.getEnum((Integer)source.getInt("elimtype")).getNumber()), seq++));
        commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.CURRENCY_DIM), source.getLong("currency"), seq++));
        if (ctx.isSpptDataSort() && source.getLong("datasort") != 0L) {
            commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.DATASORT_DIM), source.getLong("datasort"), seq++));
        }
        DynamicObjectCollection spreadmembentry = elimInfo.getDynamicObjectCollection("spreadmembentry");
        DynamicObjectType typespread = spreadmembentry.getDynamicObjectType();
        List<String> commonDims = Arrays.asList(PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM, PresetConstant.PROCESS_DIM, PresetConstant.CURRENCY_DIM, PresetConstant.DATASORT_DIM);
        int seqspread = 0;
        for (String dim : ctx.getAllDims()) {
            if (commonDims.contains(dim)) continue;
            spreadmembentry.add((Object)CheckRecordHelper.getSpreadDimDynamicObject(typespread, ctx.getAllDimNumberIdMapped().get(dim), null, seqspread++));
        }
        String number = CodeRuleServiceHelper.getNumber((String)"bcm_rptadjust", (DynamicObject)elimInfo, null);
        elimInfo.set("number", (Object)number);
        return elimInfo;
    }

    public static DynamicObjectCollection buildElimDataDynamicObject(DynamicObject source, DynamicObject elim, EntrySourceEnum elimentrytype, ICheckContext ctx) {
        long elimid = elim.getLong("id");
        DynamicObject template = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjustdata");
        DynamicObjectCollection col = new DynamicObjectCollection(template.getDynamicObjectType(), null);
        HashMap<String, DynamicObject> sumDynaObj = new HashMap<String, DynamicObject>(16);
        for (DynamicObject entry : source.getDynamicObjectCollection("entryentity")) {
            BigDecimal debitLimVal = entry.getBigDecimal("entrydebelimval");
            BigDecimal creditLimVal = entry.getBigDecimal("entrycreelimval");
            if (debitLimVal.compareTo(BigDecimal.ZERO) == 0 && creditLimVal.compareTo(BigDecimal.ZERO) == 0) continue;
            String dimstr = CheckRecordHelper.getAllDimStr(entry);
            BigDecimal sumMoney = AdjustOperationUtils.handleSummoney((BigDecimal)debitLimVal, (BigDecimal)creditLimVal);
            DynamicObject obj = (DynamicObject)sumDynaObj.get(dimstr);
            if (null != obj) {
                BigDecimal creditValue = (BigDecimal)obj.get("credit");
                BigDecimal debitValue = (BigDecimal)obj.get("debit");
                obj.set("credit", (Object)creditValue.add(creditLimVal));
                obj.set("debit", (Object)debitValue.add(debitLimVal));
                obj.set("summoney", (Object)sumMoney.add(obj.getBigDecimal("summoney")));
                continue;
            }
            DynamicObject dynaObj = new DynamicObject(template.getDynamicObjectType(), null);
            if (elimid == 0L) {
                throw new KDBizException("Elimid is null, must have a parent entry!");
            }
            dynaObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dynaObj.set("adjust", (Object)elimid);
            dynaObj.set("model", (Object)source.getLong("model"));
            dynaObj.set("scenario", (Object)source.getLong("scene"));
            dynaObj.set("year", (Object)source.getLong("year"));
            dynaObj.set("period", (Object)source.getLong("period"));
            dynaObj.set("process", (Object)CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.PROCESS_DIM, ElimTypeEnum.getEnum((Integer)source.getInt("elimtype")).getNumber()));
            dynaObj.set("audittrail", (Object)CheckRecordHelper.getElimMember(ctx, entry, entry.getLong("entryaudittrail"), "elimaudittrail"));
            dynaObj.set("entity", (Object)entry.getLong("entryorg"));
            dynaObj.set("mycompany", (Object)entry.getLong("entrymycompany"));
            dynaObj.set("internalcompany", (Object)CheckRecordHelper.getElimMember(ctx, entry, entry.getLong("entrycompany"), "elimcompany"));
            long debitAccountId = entry.getLong("entrydebitaccout");
            long creditAccountId = entry.getLong("entrycreditaccout");
            Long account = debitAccountId != 0L ? debitAccountId : creditAccountId;
            dynaObj.set("account", (Object)CheckRecordHelper.getElimMember(ctx, entry, account, "elimaccounttree"));
            dynaObj.set("changetype", (Object)CheckRecordHelper.getElimMember(ctx, entry, entry.getLong("entrychangetype"), "elimchangetype"));
            dynaObj.set("currency", entry.get("entrycurrency"));
            dynaObj.set("multigaap", entry.get("entrymultigaap"));
            dynaObj.set("datasort", entry.get("entrydatasort"));
            for (String field : CheckConstant.PRESET_DIMFIELDS) {
                if (entry.get("entry" + field) != null) {
                    dynaObj.set(field, (Object)CheckRecordHelper.checkElimUserDefineMember(ctx, field, CheckRecordHelper.getElimMember(ctx, entry, entry.getLong("entry" + field), "elim" + field)));
                    continue;
                }
                dynaObj.set(field, null);
            }
            dynaObj.set("dseq", (Object)entry.getInt("seq"));
            dynaObj.set("description", source.get("checktmpl.name"));
            dynaObj.set("entrysource", (Object)elimentrytype.getValue());
            dynaObj.set("checkrecordentry", (Object)entry.getLong("id"));
            dynaObj.set("groupnum", source.get("number"));
            dynaObj.set("debit", (Object)entry.getBigDecimal("entrydebelimval"));
            dynaObj.set("credit", (Object)entry.getBigDecimal("entrycreelimval"));
            dynaObj.set("summoney", (Object)AdjustOperationUtils.handleSummoney((BigDecimal)dynaObj.getBigDecimal("debit"), (BigDecimal)dynaObj.getBigDecimal("credit")));
            dynaObj.set("differ", (Object)0.0);
            dynaObj.set("isdefaultcurrency", (Object)"1");
            sumDynaObj.put(dimstr, dynaObj);
        }
        List sortList = sumDynaObj.values().stream().filter(e -> e.getBigDecimal("credit").compareTo(BigDecimal.ZERO) != 0 || e.getBigDecimal("debit").compareTo(BigDecimal.ZERO) != 0).sorted(Comparator.comparing(e -> e.getInt("dseq"))).collect(Collectors.toList());
        int seq = 1;
        int size = String.valueOf(sortList.size()).length();
        for (DynamicObject d : sortList) {
            d.set("dseq", (Object)String.format("%0" + size + "d", seq++));
            d.set("merge", (Object)source.getLong("entity"));
            col.add((Object)d);
        }
        AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)elim, (Collection)col, (boolean)false);
        AdjustConvertUtil.setAdjustDataShowSeqByMoreAdjust((Collection<DynamicObject>)col, AdjustDataSortRuleEnum.SEQ_SORT);
        return col;
    }

    private static String getAllDimStr(DynamicObject entry) {
        if (entry.getBoolean("isdiffitem")) {
            return entry.getString("id");
        }
        ArrayList<String> dims = new ArrayList<String>(10);
        dims.add(entry.getString("entryorg"));
        dims.add(entry.getString("entrycompany"));
        dims.add(entry.getString("entrydebitaccout") == null ? "" : entry.getString("entrydebitaccout"));
        dims.add(entry.getString("entrycreditaccout") == null ? "" : entry.getString("entrycreditaccout"));
        dims.add(entry.getString("entrychangetype"));
        for (String dimNumber : CheckConstant.PRESET_DIMFIELDS) {
            if (entry.get("entry" + dimNumber) == null) continue;
            dims.add(entry.get("entry" + dimNumber).toString());
        }
        return String.join((CharSequence)String.valueOf('@'), dims);
    }

    public static DynamicObject buildElimDynamicObject(ICheckContext ctx, CheckRecord data, Long checkRecordId, String elimNumber) {
        IDNumberTreeNode yearNode = MemberReader.findMemberById((long)((Long)ctx.getModel().p1), (String)"bcm_fymembertree", (Long)((Long)ctx.getCheckParam().getYear().p1));
        IDNumberTreeNode periodNode = MemberReader.findMemberById((long)((Long)ctx.getModel().p1), (String)"bcm_periodmembertree", (Long)((Long)ctx.getCheckParam().getPeriod().p1));
        DynamicObject elimInfo = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
        elimInfo.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        elimInfo.set("name", (Object)String.format("%s_%s_%s", data.getTmpl().getName(), yearNode.getName(), periodNode.getName()));
        elimInfo.set("model", (Object)data.getModelid());
        elimInfo.set("scenario", (Object)data.getSceneid());
        elimInfo.set("year", (Object)data.getYearid());
        elimInfo.set("period", (Object)data.getPeriodid());
        elimInfo.set("audittrail", (Object)data.getAudittrailid());
        elimInfo.set("modifier", (Object)data.getModifierid());
        elimInfo.set("modifytime", (Object)data.getModifytime());
        elimInfo.set("creator", (Object)data.getCreatorid());
        elimInfo.set("createtime", (Object)data.getCreatetime());
        elimInfo.set("submitter", (Object)data.getCreatorid());
        elimInfo.set("submittime", (Object)data.getCreatetime());
        elimInfo.set("ratifier", (Object)data.getCreatorid());
        elimInfo.set("ratifytime", (Object)data.getCreatetime());
        elimInfo.set("reviewer", (Object)data.getCreatorid());
        elimInfo.set("reviewtime", (Object)data.getCreatetime());
        elimInfo.set("spreadjson", null);
        elimInfo.set("data", null);
        elimInfo.set("iscontinuous", null);
        elimInfo.set("process", (Object)ElimTypeEnum.getEnum((Integer)data.getElimType()).getNumber());
        elimInfo.set("status", (Object)RptAdjustStatusEnum.SAVE.status());
        elimInfo.set("journaltype", (Object)data.getTmpl().getJournalType());
        elimInfo.set("balancetype", (Object)BalanceTypeEnum.BALANCE.index);
        if (data.getTmpl().isLinkage() == 1) {
            elimInfo.set("linkcreatetype", (Object)AdjustLinkCreateEnum.AUTOCREATEADJUST.getStatus());
        } else if (data.getTmpl().isLinkage() == 0) {
            elimInfo.set("linkcreatetype", (Object)AdjustLinkCreateEnum.MANUALCREATEADJUST.getStatus());
        } else {
            elimInfo.set("linkcreatetype", (Object)AdjustLinkCreateEnum.COMMONADJUST.getStatus());
        }
        elimInfo.set("description", (Object)String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u751f\u6210(%s)", (String)"CheckRecordHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), data.getTmpl().getNumber()));
        elimInfo.set("entity", (Object)data.getEntityid());
        elimInfo.set("extend", null);
        elimInfo.set("checkrecord", (Object)checkRecordId);
        elimInfo.set("belongorg", (Object)data.getEntityid());
        elimInfo.set("bussnesstype", (Object)AdjustBusinessTypeUtil.getBusinessTypeByProcess(ElimTypeEnum.getEnum((Integer)data.getElimType()).getNumber()));
        elimInfo.set("templatecatalog", (Object)data.getTmpl().getAdjustCatalogId());
        elimInfo.set("checkstatus", (Object)"1");
        elimInfo.set("multiplecurrency", (Object)"0");
        elimInfo.set("cvtbeforecurrency", (Object)0L);
        elimInfo.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.AUTO.getValue());
        elimInfo.set("number", (Object)elimNumber);
        elimInfo.set("entrysource", (Object)"0");
        elimInfo.set("linkagelinksource", (Object)0);
        DynamicObjectCollection commembentry = elimInfo.getDynamicObjectCollection("commembentry");
        int seq = 0;
        DynamicObjectType type = commembentry.getDynamicObjectType();
        commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.FY_DIM), data.getYearid(), seq++));
        commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.PERIOD_DIM), data.getPeriodid(), seq++));
        commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.SCENE_DIM), data.getSceneid(), seq++));
        commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.PROCESS_DIM), CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.PROCESS_DIM, ElimTypeEnum.getEnum((Integer)data.getElimType()).getNumber()), seq++));
        commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.CURRENCY_DIM), data.getCurrencyid(), seq++));
        if (ctx.isSpptDataSort() && data.getDatasortid() != 0L) {
            commembentry.add((Object)CheckRecordHelper.getCommonDimDynamicObject(type, ctx.getAllDimNumberIdMapped().get(PresetConstant.DATASORT_DIM), data.getDatasortid(), seq++));
        }
        DynamicObjectCollection spreadmembentry = elimInfo.getDynamicObjectCollection("spreadmembentry");
        DynamicObjectType typespread = spreadmembentry.getDynamicObjectType();
        List<String> commonDims = Arrays.asList(PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM, PresetConstant.PROCESS_DIM, PresetConstant.CURRENCY_DIM, PresetConstant.DATASORT_DIM);
        int seqspread = 0;
        for (String dim : ctx.getAllDims()) {
            if (commonDims.contains(dim)) continue;
            spreadmembentry.add((Object)CheckRecordHelper.getSpreadDimDynamicObject(typespread, ctx.getAllDimNumberIdMapped().get(dim), null, seqspread++));
        }
        return elimInfo;
    }

    public static DynamicObjectCollection buildElimDataDynamicObject(ICheckContext ctx, CheckRecord data, DynamicObject elimInfo, String checkNumber, EntrySourceEnum elimentrytype, Map<String, Integer> countMap) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bcm_rptadjustdata");
        DynamicObjectCollection col = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        HashMap<String, DynamicObject> sumDynaObj = new HashMap<String, DynamicObject>(16);
        for (CheckRecord.Entry entry : data.getEntries()) {
            BigDecimal entrycreelimvalue;
            CheckTmpl.Entry tmplEntry = entry.getTmplEntry();
            String groupKey = CheckUtil.genElimDimKey(ctx, entry);
            Long accountId = entry.getMappingAccountId();
            if (LongUtil.toLong((Object)accountId) == 0L) {
                accountId = CheckRecordHelper.getElimAcctMemberIdOrDefault(ctx, tmplEntry, entry.getEntrycreditaccout() != 0L ? entry.getEntrycreditaccout() : entry.getEntrydebitaccout());
            }
            if (accountId == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f%1$s\u7b2c%2$s\u884c\u62b5\u9500\u79d1\u76ee\u914d\u7f6e\u5e94\u540c\u65f6\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\uff1a\u62b5\u9500\u548c\u660e\u7ec6\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u62b5\u9500\u79d1\u76ee\u914d\u7f6e\u3002", (String)"CheckRecordHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), data.getTmpl().getNumber(), tmplEntry.getSeq()));
            }
            BigDecimal entrydebelimvalue = entry.isMerge() ? entry.getEntrydebelimvalue() : entry.getEntrydebit();
            BigDecimal bigDecimal = entrycreelimvalue = entry.isMerge() ? entry.getEntrycreelimvalue() : entry.getEntrycredit();
            if (entrydebelimvalue.compareTo(BigDecimal.ZERO) == 0 && entrycreelimvalue.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal sumMoney = AdjustOperationUtils.handleSummoney((BigDecimal)entrydebelimvalue, (BigDecimal)entrycreelimvalue);
            DynamicObject obj = (DynamicObject)sumDynaObj.get(groupKey);
            if (null != obj) {
                BigDecimal creditValue = (BigDecimal)obj.get("credit");
                BigDecimal debitValue = (BigDecimal)obj.get("debit");
                obj.set("credit", (Object)creditValue.add(entrycreelimvalue));
                obj.set("debit", (Object)debitValue.add(entrydebelimvalue));
                obj.set("summoney", (Object)sumMoney.add(obj.getBigDecimal("summoney")));
                continue;
            }
            DynamicObject dyn = new DynamicObject((DynamicObjectType)entityType, null);
            if (elimInfo == null) {
                throw new KDBizException("Elimid is null, must have a parent entry!");
            }
            dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyn.set("dseq", (Object)entry.getSeq());
            dyn.set("adjust", (Object)elimInfo.getLong("id"));
            dyn.set("model", (Object)entry.getEntrymodel());
            dyn.set("scenario", (Object)entry.getEntryscene());
            dyn.set("year", (Object)entry.getEntryyear());
            dyn.set("period", (Object)entry.getEntryperiod());
            dyn.set("process", (Object)CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.PROCESS_DIM, ElimTypeEnum.getEnum((Integer)data.getElimType()).getNumber()));
            dyn.set("audittrail", (Object)CheckRecordHelper.getElimMemberOrDefault(tmplEntry, "elimaudittrail", entry.getEntryaudittrail()));
            dyn.set("entity", (Object)entry.getEntryorg());
            dyn.set("merge", (Object)data.getEntityid());
            dyn.set("mycompany", (Object)entry.getEntrymycompany());
            dyn.set("internalcompany", (Object)CheckRecordHelper.getInternalcompany(ctx, tmplEntry, entry.getEntrycompany()));
            dyn.set("account", (Object)accountId);
            dyn.set("changetype", (Object)tmplEntry.getElimChangetype());
            dyn.set("currency", (Object)entry.getEntrycurrency());
            dyn.set("multigaap", (Object)entry.getEntrymultigaap());
            dyn.set("datasort", (Object)entry.getEntrydatasort());
            dyn.set("dim1", (Object)CheckRecordHelper.checkElimUserDefineMember(ctx, (String)CheckConstant.PRESET_DIMFIELDS.get(0), CheckRecordHelper.getElimMemberOrDefault(tmplEntry, (String)CheckConstant.PRESET_ELIM_DIMFIELDS.get(0), entry.getEntrydim1())));
            dyn.set("dim2", (Object)CheckRecordHelper.checkElimUserDefineMember(ctx, (String)CheckConstant.PRESET_DIMFIELDS.get(1), CheckRecordHelper.getElimMemberOrDefault(tmplEntry, (String)CheckConstant.PRESET_ELIM_DIMFIELDS.get(1), entry.getEntrydim2())));
            dyn.set("dim3", (Object)CheckRecordHelper.checkElimUserDefineMember(ctx, (String)CheckConstant.PRESET_DIMFIELDS.get(2), CheckRecordHelper.getElimMemberOrDefault(tmplEntry, (String)CheckConstant.PRESET_ELIM_DIMFIELDS.get(2), entry.getEntrydim3())));
            dyn.set("dim4", (Object)CheckRecordHelper.checkElimUserDefineMember(ctx, (String)CheckConstant.PRESET_DIMFIELDS.get(3), CheckRecordHelper.getElimMemberOrDefault(tmplEntry, (String)CheckConstant.PRESET_ELIM_DIMFIELDS.get(3), entry.getEntrydim4())));
            dyn.set("dim5", (Object)CheckRecordHelper.checkElimUserDefineMember(ctx, (String)CheckConstant.PRESET_DIMFIELDS.get(4), CheckRecordHelper.getElimMemberOrDefault(tmplEntry, (String)CheckConstant.PRESET_ELIM_DIMFIELDS.get(4), entry.getEntrydim5())));
            dyn.set("dim6", (Object)CheckRecordHelper.checkElimUserDefineMember(ctx, (String)CheckConstant.PRESET_DIMFIELDS.get(5), CheckRecordHelper.getElimMemberOrDefault(tmplEntry, (String)CheckConstant.PRESET_ELIM_DIMFIELDS.get(5), entry.getEntrydim6())));
            dyn.set("description", (Object)data.getTmpl().getName());
            dyn.set("entrysource", (Object)elimentrytype.getValue());
            dyn.set("checkrecordentry", (Object)entry.getId());
            dyn.set("groupnum", (Object)checkNumber);
            dyn.set("debit", (Object)entrydebelimvalue);
            dyn.set("credit", (Object)entrycreelimvalue);
            dyn.set("summoney", (Object)sumMoney);
            dyn.set("differ", (Object)0.0);
            dyn.set("isdefaultcurrency", (Object)"1");
            dyn.set("linksource", (Object)0);
            sumDynaObj.put(groupKey, dyn);
        }
        sumDynaObj.values().forEach(e -> {
            if (e.getBigDecimal("credit").compareTo(BigDecimal.ZERO) != 0 || e.getBigDecimal("debit").compareTo(BigDecimal.ZERO) != 0) {
                col.add(e);
            }
        });
        col.sort(Comparator.comparing(e -> e.getInt("dseq")));
        int seq = 1;
        if (countMap.get(elimInfo.getString("number")) != null) {
            seq = countMap.get(elimInfo.getString("number"));
        }
        for (DynamicObject d : col) {
            d.set("dseq", (Object)seq++);
        }
        countMap.put(elimInfo.getString("number"), seq);
        AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)elimInfo, (Collection)col, (boolean)false);
        return col;
    }

    public static void saveAdjustMapping(List<DynamicObject> elimDataDynaObj) {
        ArrayList<DynamicObject> AdjustLingMapping = new ArrayList<DynamicObject>(16);
        for (DynamicObject elimData : elimDataDynaObj) {
            if (elimData.get("checkrecordentry") == null || elimData.getLong("checkrecordentry") == 0L) continue;
            DynamicObject rowDataMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_linkadjust_mapping");
            rowDataMapping.set("model", (Object)elimData.getLong("model"));
            rowDataMapping.set("linkid", (Object)elimData.getLong("checkrecordentry"));
            rowDataMapping.set("elim", (Object)elimData.getLong("adjust"));
            rowDataMapping.set("elimentry", (Object)elimData.getLong("id"));
            rowDataMapping.set("biztype", (Object)LinkAdjustMappingEnum.CHECK_RECORD.getBizType());
            AdjustLingMapping.add(rowDataMapping);
        }
        if (AdjustLingMapping.size() > 0) {
            DynamicObject mapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_linkadjust_mapping");
            SaveServiceHelper.save((IDataEntityType)mapping.getDynamicObjectType(), (Object[])AdjustLingMapping.toArray(new Object[0]));
        }
    }

    private static Long checkElimUserDefineMember(ICheckContext ctx, String field, Long memberId) {
        if (memberId == null) {
            return null;
        }
        IDNumberTreeNode member = MemberReader.findMemberById((String)((String)ctx.getModel().p2), (String)"bcm_userdefinedmembertree", (Long)memberId);
        if (member == null || IDNumberTreeNode.NotFoundTreeNode.getNumber().equals(member.getNumber()) || !member.isLeaf()) {
            return CheckRecordHelper.getUserDefineDimId(ctx, null, field);
        }
        return memberId;
    }

    private static Long getInternalcompany(ICheckContext ctx, CheckTmpl.Entry tmplEntry, Long defaultCompany) {
        Optional<CheckTmpl.EntryDetailWithSign> elimOpt = tmplEntry.getElimDims().stream().filter(e -> "elimcompany".equals(e.getSign())).findFirst();
        if (elimOpt.isPresent() && elimOpt.get().getNumberSet().size() == 1) {
            String number = elimOpt.get().getNumberSet().stream().findFirst().orElse(null);
            Pair<Boolean, Long> pair = elimOpt.get().getNumberIdMap().get(number);
            if (pair != null && ((Boolean)pair.p1).booleanValue()) {
                return (Long)pair.p2;
            }
        }
        return defaultCompany;
    }

    public static Long getMemberOrDefault(CheckTmpl.Entry tmplEntry, String sign, Long defaultId) {
        return CheckRecordHelper.getMemberOrDefault(tmplEntry, sign, defaultId, false);
    }

    private static Long getElimMemberOrDefault(CheckTmpl.Entry tmplEntry, String sign, Long defaultId) {
        return CheckRecordHelper.getMemberOrDefault(tmplEntry, sign, defaultId, true);
    }

    private static Long getElimAcctMemberIdOrDefault(ICheckContext ctx, CheckTmpl.Entry tmplEntry, Long defaultId) {
        IDNumberTreeNode treeNode;
        Long accountId = defaultId;
        Set<String> accounts = tmplEntry.getElimAccountNumbers();
        if (accounts.size() == 1) {
            accountId = CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.ACCOUNT_DIM, accounts.iterator().next());
        }
        if ((treeNode = MemberReader.findMemberById((long)((Long)ctx.getModel().p1), (String)"bcm_accountmembertree", (Long)accountId)).isLeaf() && (treeNode.getStorageType() == StorageTypeEnum.STORAGE || treeNode.getStorageType() == StorageTypeEnum.UNSHARE)) {
            return accountId;
        }
        return null;
    }

    private static Long getMemberOrDefault(CheckTmpl.Entry tmplEntry, String sign, Long defaultId, boolean isElim) {
        CheckTmpl.EntryDetailWithSign dimWithIndex;
        Optional<CheckTmpl.EntryDetailWithSign> opt;
        if (tmplEntry.getElimDims() != null && (opt = isElim ? tmplEntry.getElimDims().stream().filter(e -> sign.equals(e.getSign())).findFirst() : tmplEntry.getDims().stream().filter(e -> sign.equals(e.getSign())).findFirst()).isPresent() && (dimWithIndex = opt.get()) != null) {
            if (isElim && CheckConstant.PRESET_ELIM_DIMFIELDS.contains(sign)) {
                if (dimWithIndex.getNumberSet() != null && dimWithIndex.getNumberSet().size() == 1) {
                    String number = dimWithIndex.getNumberSet().stream().findFirst().orElse(null);
                    Pair<Boolean, Long> pair = dimWithIndex.getNumberIdMap().get(number);
                    if (pair != null && ((Boolean)pair.p1).booleanValue()) {
                        return (Long)pair.p2;
                    }
                }
            } else {
                List<CheckTmplEntryDetail> detail = dimWithIndex.getDetails();
                if (detail != null && detail.size() == 1 && detail.get(0).getScope().intValue() == RangeEnum.VALUE_10.getValue() && !detail.get(0).isCust()) {
                    return detail.get(0).getMemberTreeId();
                }
            }
        }
        return defaultId;
    }

    private static DynamicObject getCommonDimDynamicObject(DynamicObjectType objType, Long dimid, Long membid, int seq) {
        DynamicObject dynaObj = new DynamicObject(objType);
        dynaObj.set("comdimension", (Object)dimid);
        dynaObj.set("commembid", (Object)membid);
        dynaObj.set("seq", (Object)seq);
        return dynaObj;
    }

    private static DynamicObject getSpreadDimDynamicObject(DynamicObjectType objType, Long dimid, Long membid, int seq) {
        DynamicObject dynaObj = new DynamicObject(objType);
        dynaObj.set("spreaddimension", (Object)dimid);
        dynaObj.set("spreadmembid", (Object)membid);
        dynaObj.set("seq", (Object)seq);
        return dynaObj;
    }

    public static boolean matchReportDataAndCheckTmpl(ReportData data, CheckTmpl tmpl) {
        for (CheckTmpl.Entry entry : tmpl.getEntries()) {
            if (!CheckRecordHelper.matchReportDataAndCheckTmplEntry(data, entry)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchReportDataAndCheckTmplEntry(ReportData data, CheckTmpl.Entry entry) {
        if (!entry.getAccountNumbers().contains(data.getAccount())) {
            return false;
        }
        if (data.getChangetype() != null && !data.getChangetype().equals(entry.getChangetypeNumber())) {
            return false;
        }
        if (entry.isDiffitem()) {
            return false;
        }
        List<CheckTmpl.EntryDetailWithSign> dims = entry.getDims();
        if (dims != null && dims.size() > 0) {
            for (CheckTmpl.EntryDetailWithSign detailWithSign : dims) {
                String sign = detailWithSign.getSign();
                Set<String> dimSet = detailWithSign.getNumberSet();
                if (PresetConstant.INTERNALCOMPANY_DIM.equals(sign)) {
                    String interloping = data.getInternalcompany();
                    if (dimSet.isEmpty() || dimSet.contains(interloping)) continue;
                    return false;
                }
                if (PresetConstant.AUDITTRIAL_DIM.equalsIgnoreCase(sign)) {
                    String interloping = data.getAudittrail();
                    if (dimSet.contains(interloping)) continue;
                    return false;
                }
                for (int i = 0; i < CheckConstant.PRESET_DIMFIELDS.size(); ++i) {
                    String udValue;
                    if (!((String)CheckConstant.PRESET_DIMFIELDS.get(i)).equals(sign)) continue;
                    switch (i) {
                        case 0: {
                            udValue = data.getDim1();
                            break;
                        }
                        case 1: {
                            udValue = data.getDim2();
                            break;
                        }
                        case 2: {
                            udValue = data.getDim3();
                            break;
                        }
                        case 3: {
                            udValue = data.getDim4();
                            break;
                        }
                        case 4: {
                            udValue = data.getDim5();
                            break;
                        }
                        case 5: {
                            udValue = data.getDim6();
                            break;
                        }
                        default: {
                            udValue = data.getDim1();
                        }
                    }
                    if (dimSet.size() == 0 || dimSet.contains(udValue)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected static Long getCommonParent(ICheckContext ctx, EntityKey e) {
        Map<EntityKey, Pair<Long, String>> parentMap = ctx.getParentMap();
        if (parentMap == null) {
            return null;
        }
        return (Long)parentMap.get((Object)e).p1;
    }

    protected static Long getMembIdFromCache(ICheckContext ctx, String dimNumber, String membNumber) {
        return CheckUtil.getMembIdFromCache(ctx, dimNumber, membNumber);
    }

    protected static CheckRecord.Entry newCheckRecordEntry(ICheckContext ctx, CheckRecord checkRecord, CheckTmpl.Entry tmplEntry, ReportData data, int seq, String mycompany) {
        CheckRecord.Entry entry = checkRecord.new CheckRecord.Entry();
        entry.setTmplEntry(tmplEntry);
        entry.setId(GlobalIdUtil.genGlobalLongId());
        entry.setSeq(seq);
        entry.setEntrymodel((Long)ctx.getModel().p1);
        entry.setDi(false);
        entry.setAb((ctx.isSpptMyCompany() ? data.getMycompany() : data.getEntity()).compareTo(data.getInternalcompany()) < 0);
        entry.setEntryscene(checkRecord.getSceneid());
        entry.setEntryyear(checkRecord.getYearid());
        entry.setEntryperiod(checkRecord.getPeriodid());
        String processNum = "TARPT".equals(data.getProcess()) ? "ARPT" : ("TADJ".equals(data.getProcess()) ? "ADJ" : data.getProcess());
        entry.setEntryprocess(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.PROCESS_DIM, processNum));
        entry.setEntryaudittrail(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.AUDITTRIAL_DIM, data.getAudittrail()));
        entry.setEntryorg(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.ENTITY_DIM, data.getRow().getString(PresetConstant.ENTITY_DIM)));
        entry.setEntryorgnumber(data.getEntity());
        entry.setEntrymycompany(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.MYCOMPANY_DIM, data.getMycompany()));
        entry.setEntrycompany(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.INTERNALCOMPANY_DIM, data.getInternalcompany()));
        entry.setEntrymycompanynumber(data.getMycompany());
        entry.setEntrycompanynumber(data.getInternalcompany());
        Long accountId = CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.ACCOUNT_DIM, data.getAccount());
        boolean isDc = !CheckRecordHelper.isDc((Long)ctx.getModel().p1, accountId);
        entry.setEntrydebitaccout(isDc ? accountId : 0L);
        entry.setEntrycreditaccout(!isDc ? accountId : 0L);
        entry.setDc(isDc ? 1 : 0);
        entry.setEntrychangetype(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.CHANGETYPE_DIM, data.getChangetype()));
        entry.setEntrymultigaap(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.RULE_DIM, data.getMultigaap()));
        entry.setEntrydatasort(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.DATASORT_DIM, data.getDatasort()));
        entry.setEntrycurrency(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.CURRENCY_DIM, data.getCurrency()));
        entry.setEntrydim1(CheckRecordHelper.getMembIdFromCache(ctx, ctx.getFieldMapped().get("dim1"), data.getDim1()));
        entry.setEntrydim2(CheckRecordHelper.getMembIdFromCache(ctx, ctx.getFieldMapped().get("dim2"), data.getDim2()));
        entry.setEntrydim3(CheckRecordHelper.getMembIdFromCache(ctx, ctx.getFieldMapped().get("dim3"), data.getDim3()));
        entry.setEntrydim4(CheckRecordHelper.getMembIdFromCache(ctx, ctx.getFieldMapped().get("dim4"), data.getDim4()));
        entry.setEntrydim5(CheckRecordHelper.getMembIdFromCache(ctx, ctx.getFieldMapped().get("dim5"), data.getDim5()));
        entry.setEntrydim6(CheckRecordHelper.getMembIdFromCache(ctx, ctx.getFieldMapped().get("dim6"), data.getDim6()));
        entry.setEntrydebit(isDc ? data.getValue() : BigDecimal.ZERO);
        entry.setEntrycredit(!isDc ? data.getValue() : BigDecimal.ZERO);
        entry.setEntrydebelimvalue(BigDecimal.ZERO);
        entry.setEntrycreelimvalue(BigDecimal.ZERO);
        entry.setOcmoney(data.getOcValue());
        CheckRecordHelper.setEntry(ctx, checkRecord, data, entry, mycompany, accountId);
        if (ctx.isSpptMyCompany()) {
            checkRecord.getOrgmap().put(data.getMycompany() + '&' + data.getInternalcompany(), data.getEntity());
        } else {
            checkRecord.getOrgmap().put(data.getEntity() + '&' + data.getInternalcompany(), data.getEntity());
        }
        entry.setSortKey(entry.genSortKey());
        return entry;
    }

    protected static CheckRecord.Entry newCheckRecordEntry(ICheckContext ctx, CheckRecord checkRecord, String group) {
        String dimStr = group;
        if (group.contains(String.valueOf('@'))) {
            dimStr = group.split(String.valueOf('@'))[1];
        }
        String[] dims = dimStr.split(String.valueOf('&'));
        CheckRecord.Entry entry = checkRecord.new CheckRecord.Entry();
        entry.setGroup(group);
        entry.setTmplEntry(null);
        entry.setId(GlobalIdUtil.genGlobalLongId());
        entry.setSeq(0);
        entry.setEntrymodel((Long)ctx.getModel().p1);
        entry.setDc(-1);
        entry.setDi(true);
        entry.setAb(false);
        entry.setEntryscene(checkRecord.getSceneid());
        entry.setEntryyear(checkRecord.getYearid());
        entry.setEntryperiod(checkRecord.getPeriodid());
        entry.setEntryprocess(checkRecord.getProcessid());
        entry.setEntryorg(ctx.isSpptMyCompany() ? Long.valueOf(0L) : null);
        entry.setEntrymycompany(null);
        entry.setEntrycompany(CheckRecordHelper.getMembIdFromCache(ctx, PresetConstant.INTERNALCOMPANY_DIM, "ICNone"));
        entry.setEntryorgnumber(null);
        entry.setEntrymycompanynumber(null);
        entry.setEntrycompanynumber(null);
        entry.setEntrydebitaccout(null);
        entry.setEntrycreditaccout(null);
        entry.setEntrychangetype(null);
        entry.setEntrymultigaap(checkRecord.getMultigaapid());
        entry.setEntrydatasort(checkRecord.getDatasortid());
        entry.setEntrycurrency(checkRecord.getCurrencyid());
        entry.setEntrydim1(CheckRecordHelper.getUserDefineDimId(ctx, dims[0], (String)CheckConstant.PRESET_DIMFIELDS.get(0)));
        entry.setEntrydim2(CheckRecordHelper.getUserDefineDimId(ctx, dims[1], (String)CheckConstant.PRESET_DIMFIELDS.get(1)));
        entry.setEntrydim3(CheckRecordHelper.getUserDefineDimId(ctx, dims[2], (String)CheckConstant.PRESET_DIMFIELDS.get(2)));
        entry.setEntrydim4(CheckRecordHelper.getUserDefineDimId(ctx, dims[3], (String)CheckConstant.PRESET_DIMFIELDS.get(3)));
        entry.setEntrydim5(CheckRecordHelper.getUserDefineDimId(ctx, dims[4], (String)CheckConstant.PRESET_DIMFIELDS.get(4)));
        entry.setEntrydim6(CheckRecordHelper.getUserDefineDimId(ctx, dims[5], (String)CheckConstant.PRESET_DIMFIELDS.get(5)));
        entry.setEntryaudittrail(StringUtils.isEmpty((String)dims[6]) ? checkRecord.getAudittrailid() : Long.valueOf(dims[6]));
        entry.setEntrydebit(BigDecimal.ZERO);
        entry.setEntrycredit(BigDecimal.ZERO);
        entry.setEntrydebelimvalue(BigDecimal.ZERO);
        entry.setEntrycreelimvalue(BigDecimal.ZERO);
        entry.setSortKey(entry.genSortKey(group));
        entry.setOcmoney(BigDecimal.ZERO);
        return entry;
    }

    protected static Long getUserDefineDimId(ICheckContext ctx, String dimid, String field) {
        if (!StringUtils.isEmpty((String)dimid)) {
            return Long.valueOf(dimid);
        }
        String number = ctx.getFieldMapped().get(field);
        if (!StringUtils.isEmpty((String)number)) {
            return CheckRecordHelper.getMembIdFromCache(ctx, number, ctx.getUserDefineNumberMap().get(number) + "None");
        }
        return null;
    }

    private static void setEntry(ICheckContext ctx, CheckRecord checkRecord, ReportData data, CheckRecord.Entry entry, String company, Long accountId) {
        String tc;
        boolean isDc = CheckRecordHelper.isDc((Long)ctx.getModel().p1, accountId);
        String ec = data.getEc();
        String path = ec.equals(tc = data.getTc()) ? tc : ec + " -> " + tc;
        if (BigDecimal.ZERO.compareTo(data.getValue() == null ? BigDecimal.ZERO : data.getValue()) == 0 && BigDecimal.ZERO.compareTo(data.getEcValue() == null ? BigDecimal.ZERO : data.getEcValue()) == 0) {
            path = "";
        }
        if (!company.equals(data.getInternalcompany())) {
            entry.setMyrate(BigDecimal.ONE);
            entry.setMycvtmoney(data.getValue());
            entry.setMyecmoney(data.getEcValue());
            entry.setMycvtpath(path);
            entry.setMyaccount(accountId);
            if (isDc) {
                entry.setCvtdifmoney(CheckRecordHelper.add(entry.getMycvtmoney(), entry.getOpcvtmoney()));
                checkRecord.setMyecmoney(CheckRecordHelper.add(checkRecord.getMyecmoney(), entry.getMyecmoney()));
                checkRecord.setMycvtmoney(CheckRecordHelper.add(checkRecord.getMycvtmoney(), entry.getMycvtmoney()));
            } else {
                entry.setCvtdifmoney(CheckRecordHelper.subtract(entry.getMycvtmoney(), entry.getOpcvtmoney()));
                checkRecord.setMyecmoney(CheckRecordHelper.subtract(checkRecord.getMyecmoney(), entry.getMyecmoney()));
                checkRecord.setMycvtmoney(CheckRecordHelper.subtract(checkRecord.getMycvtmoney(), entry.getMycvtmoney()));
            }
            if (StringUtils.isEmpty((String)checkRecord.getMycvtpath())) {
                checkRecord.setMycvtpath(entry.getMycvtpath());
            }
            checkRecord.setMyrate(entry.getMyrate());
        } else {
            entry.setOprate(BigDecimal.ONE);
            entry.setOpcvtmoney(data.getValue());
            entry.setOpecmoney(data.getEcValue());
            entry.setOpcvtpath(path);
            entry.setOpaccount(accountId);
            if (isDc) {
                entry.setCvtdifmoney(CheckRecordHelper.add(entry.getMycvtmoney(), entry.getOpcvtmoney()));
                checkRecord.setOpecmoney(CheckRecordHelper.add(checkRecord.getOpecmoney(), entry.getOpecmoney()));
                checkRecord.setOpcvtmoney(CheckRecordHelper.add(checkRecord.getOpcvtmoney(), entry.getOpcvtmoney()));
            } else {
                entry.setCvtdifmoney(CheckRecordHelper.subtract(entry.getMycvtmoney(), entry.getOpcvtmoney()));
                checkRecord.setOpecmoney(CheckRecordHelper.subtract(checkRecord.getOpecmoney(), entry.getOpecmoney()));
                checkRecord.setOpcvtmoney(CheckRecordHelper.subtract(checkRecord.getOpcvtmoney(), entry.getOpcvtmoney()));
            }
            if (StringUtils.isEmpty((String)checkRecord.getOpcvtpath())) {
                checkRecord.setOpcvtpath(entry.getOpcvtpath());
            }
            checkRecord.setOprate(entry.getOprate());
        }
        checkRecord.setCvtdifmoney(CheckRecordHelper.add(checkRecord.getMycvtmoney(), checkRecord.getOpcvtmoney()));
    }

    public static boolean isDc(Long modelId, Long acctId) {
        Map acctDcMap = (Map)ThreadCache.get((Object)"acctDcMap", () -> new HashMap());
        Boolean isDc = (Boolean)acctDcMap.get(acctId);
        if (isDc == null) {
            isDc = DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.getOIndex().equals(MemberReader.findMemberById((long)modelId, (String)"bcm_accountmembertree", (Long)acctId).getProperty("drcrdirect"));
            acctDcMap.put(acctId, isDc);
        }
        return (Boolean)acctDcMap.get(acctId);
    }

    public static BigDecimal add(BigDecimal b1, BigDecimal b2) {
        if (b1 == null && b2 == null) {
            return null;
        }
        BigDecimal t1 = b1 == null ? BigDecimal.ZERO : b1;
        BigDecimal t2 = b2 == null ? BigDecimal.ZERO : b2;
        return t1.add(t2);
    }

    public static BigDecimal subtract(BigDecimal b1, BigDecimal b2) {
        if (b1 == null && b2 == null) {
            return null;
        }
        BigDecimal t1 = b1 == null ? BigDecimal.ZERO : b1;
        BigDecimal t2 = b2 == null ? BigDecimal.ZERO : b2;
        return t1.subtract(t2);
    }

    private static Long getElimMember(ICheckContext ctx, DynamicObject entry, Long defaultId, String elimsign) {
        CheckTmpl.Entry checktmplentry = null;
        CheckTmpl checkTmpl = null;
        block0: for (Map.Entry<String, List<CheckTmpl>> check : ctx.getCheckTmplMap().entrySet()) {
            for (CheckTmpl t : check.getValue()) {
                for (CheckTmpl.Entry e : t.getEntries()) {
                    if (!e.getEntryId().equals(entry.getLong("checktmplentry"))) continue;
                    checktmplentry = e;
                    checkTmpl = t;
                    break block0;
                }
            }
        }
        if (checktmplentry != null) {
            if ("elimchangetype".equals(elimsign)) {
                return checktmplentry.getElimChangetype();
            }
            if ("elimaccounttree".equals(elimsign)) {
                Long accountId = CheckRecordHelper.getElimAcctMemberIdOrDefault(ctx, checktmplentry, defaultId);
                if (accountId == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f%1$s\u7b2c%2$s\u884c\u62b5\u9500\u79d1\u76ee\u914d\u7f6e\u5e94\u540c\u65f6\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\uff1a\u62b5\u9500\u548c\u660e\u7ec6\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u62b5\u9500\u79d1\u76ee\u914d\u7f6e\u3002", (String)"CheckRecordHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), checkTmpl.getNumber(), checktmplentry.getSeq()));
                }
                return accountId;
            }
            if ("elimcompany".equals(elimsign)) {
                return CheckRecordHelper.getInternalcompany(ctx, checktmplentry, defaultId);
            }
            return CheckRecordHelper.getElimMemberOrDefault(checktmplentry, elimsign, defaultId);
        }
        return defaultId;
    }

    public static void resetAdjustBalance(Long modelId, Collection<DynamicObject> elimDynaObj, Collection<DynamicObject> elimDataDynaObj) {
        AdjustBalanceCheckService adjustBalanceCheckService = new AdjustBalanceCheckService(modelId);
        Map<Long, List<DynamicObject>> entryMap = elimDataDynaObj.stream().collect(Collectors.groupingBy(e -> e.getLong("adjust")));
        block0: for (DynamicObject head : elimDynaObj) {
            List<DynamicObject> entries = entryMap.get(head.getLong("id"));
            if (entries == null || entries.size() <= 0) continue;
            Map<String, AdjustBalanceCheckModel> balanceCheckModelMap = adjustBalanceCheckService.checkAdjustBalance(head, entries);
            for (AdjustBalanceCheckModel checkModel : balanceCheckModelMap.values()) {
                if (checkModel.isDataBalance(adjustBalanceCheckService.getConfigBalance())) continue;
                head.set("balancetype", (Object)BalanceTypeEnum.UNBALANCE.index);
                continue block0;
            }
        }
    }
}

