/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.serviceHelper.ExpressionServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.formula.EncoderService;

public class DiffModeFormulaHelper {
    public static Map<String, String> calculateDiffModeByFormal(BigDecimal diffValue, String resolvedFormula, BigDecimal myoc, BigDecimal opoc, BigDecimal absum, BigDecimal basum) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("default_diffmode", "1");
        map.put("default_diffmethod", DiffMethodEnum.DIFFITEM.getValue() + "");
        if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)resolvedFormula)) {
            if (resolvedFormula.contains("&&")) {
                String[] split = resolvedFormula.split("&&");
                resolvedFormula = split[0];
                String s = split[1];
                if ((s = s.replace("(", "").replace(")", "")).contains("!")) {
                    map.put("diffaccount", s);
                } else if ("101".equals(s) || "102".equals(s)) {
                    map.put("dc", s);
                } else if (DiffModeFormulaHelper.checkNumber(s)) {
                    try {
                        int i;
                        int j;
                        String[] splits = s.split("\\.");
                        if (splits.length == 2 && DiffMethodEnum.getEnum((int)(j = Integer.parseInt(splits[1]))) != null) {
                            map.put("diffmethod", j + "");
                        }
                        if (DiffModeEnum.getEnum((int)(i = Integer.parseInt(splits[0]))) != null) {
                            map.put("diffmode", i + "");
                        }
                    }
                    catch (Exception splits) {
                        // empty catch block
                    }
                }
            }
            CalContext ctx = new CalContext("", "", "", "", "", "");
            resolvedFormula = resolvedFormula.replaceAll("diff", diffValue.toString());
            resolvedFormula = resolvedFormula.replaceAll("myoc", myoc.toString());
            resolvedFormula = resolvedFormula.replaceAll("opoc", opoc.toString());
            resolvedFormula = resolvedFormula.replaceAll("absum", absum.toString());
            CalculateService service = new CalculateService(ctx);
            Object result = service.singleCalculate(resolvedFormula = resolvedFormula.replaceAll("basum", basum.toString()));
            if (result != null) {
                if ("1001".equals(result.toString()) || "1002".equals(result.toString())) {
                    map.put("diffitem", result.toString());
                } else if ("101".equals(result.toString()) || "102".equals(result.toString())) {
                    map.put("dc", result.toString());
                } else if (DiffModeFormulaHelper.checkNumber(result.toString())) {
                    try {
                        int i;
                        int j;
                        String[] splits = result.toString().split("\\.");
                        if (splits.length == 2 && DiffMethodEnum.getEnum((int)(j = Integer.parseInt(splits[1]))) != null) {
                            map.put("diffmethod", j + "");
                        }
                        if (DiffModeEnum.getEnum((int)(i = Integer.parseInt(splits[0]))) != null) {
                            map.put("diffmode", i + "");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return map;
    }

    public static String resolveFormulaForCheckCtx(String formula) {
        StringBuilder result = new StringBuilder(16);
        String formula2 = "";
        if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)formula)) {
            if (formula.contains("&&")) {
                String[] split = formula.split("&&");
                formula = split[0];
                formula2 = DiffModeFormulaHelper.resolveDiffModeFormula(split[1]);
            }
            result.append(DiffModeFormulaHelper.resolveDiffModeFormula(formula));
            if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)formula2)) {
                result.append("&&").append(formula2);
            }
        }
        return result.toString();
    }

    private static String resolveDiffModeFormula(String formula) {
        StringBuilder sb = new StringBuilder();
        String tempData = DiffModeFormulaHelper.buildJudgeFormulaDisplay(formula, sb);
        while (tempData.length() > 0) {
            tempData = DiffModeFormulaHelper.buildJudgeFormulaDisplay(tempData, sb);
        }
        return sb.toString();
    }

    private static String buildJudgeFormulaDisplay(String data, StringBuilder sb) {
        int beginPosition = data.indexOf("CVT(");
        if (beginPosition > 0) {
            sb.append(data.substring(0, beginPosition));
            return data.substring(beginPosition);
        }
        if (beginPosition == -1) {
            sb.append(data);
            return "";
        }
        try {
            String item = data.substring(beginPosition, data.indexOf(")") + 1);
            sb.append(DiffModeFormulaHelper.analyFullFormula(item));
            return data.substring(data.indexOf(41) + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String analyFullFormula(String formula) {
        ExpressParser parser = new ExpressParser();
        EncoderService encoder = new EncoderService();
        StringBuilder sb = new StringBuilder();
        try {
            Pair<String, List<IFormula>> pair = parser.parse(formula, encoder);
            int flag = 0;
            for (int i = 0; i < ((String)pair.p1).length(); ++i) {
                if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                    if (!ExpressionServiceHelper.checkFactorComplete(i, (String)pair.p1)) continue;
                    IFormula iFormula = (IFormula)((List)pair.p2).get(flag);
                    if ("CVT".equals(iFormula.getName())) {
                        String[] number = ((ParamItem)iFormula.getParamList().get(0)).toString().split("@");
                        if (number[0].equals("check")) {
                            if ("diff".equals(number[1]) || "myoc".equals(number[1]) || "opoc".equals(number[1]) || "absum".equals(number[1]) || "basum".equals(number[1])) {
                                return number[1];
                            }
                            if ("diffitem1".equals(number[1])) {
                                return "1001";
                            }
                            if ("diffitem2".equals(number[1])) {
                                return "1002";
                            }
                        } else {
                            if (number[0].equals("diffmodetype")) {
                                return number[1];
                            }
                            if (number[0].equals("dc0")) {
                                return "101";
                            }
                            if (number[0].equals("dc1")) {
                                return "102";
                            }
                        }
                    }
                    ++flag;
                    continue;
                }
                String oper = String.valueOf(((String)pair.p1).charAt(i));
                sb.append(oper);
            }
        }
        catch (Exception e1) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e1));
        }
        return sb.toString();
    }

    private static boolean checkNumber(String str) {
        int dotCount = 0;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            char c = str.charAt(i);
            if (i == 0 && c == '-') {
                return true;
            }
            if (!(c == '.' ? ++dotCount >= 2 : !Character.isDigit(c))) continue;
            return false;
        }
        return true;
    }
}

