/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.check.ICheckContext;
import kd.fi.bcm.business.check.model.key.EntityKey;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class EntityServiceHelper {
    public static Long getBaseEntityId(DynamicObject dynaObj) {
        Long copyfrom = dynaObj.getLong("copyfrom.id");
        if (copyfrom != null && copyfrom != 0L) {
            return copyfrom;
        }
        return dynaObj.getLong("id");
    }

    public static Map<EntityKey, Pair<Long, String>> batchQueryCommonParent(ICheckContext ctx, Set<EntityKey> abSet) {
        Set<String> noMergeNumbers = ctx.getNoMerge();
        HashMap<EntityKey, Pair<Long, String>> resultMap = new HashMap<EntityKey, Pair<Long, String>>(16);
        HashMap<String, Pair> parentCache = new HashMap<String, Pair>(16);
        String modelNumber = MemberReader.findModelNumberById((Object)ctx.getModel().p1);
        for (EntityKey key : abSet) {
            String commonParentLongNumber;
            Pair<Long, String> myPair = ctx.getSortedOrgByChangeType().get(key.getMycompany());
            Pair<Long, String> opPair = ctx.getSortedOrgByChangeType().get(key.getCompany());
            if (myPair == null || !StringUtils.isNotEmpty((String)((String)myPair.p2)) || opPair == null || !StringUtils.isNotEmpty((String)((String)opPair.p2)) || !StringUtils.isNotEmpty((String)(commonParentLongNumber = EntityServiceHelper.getCommonParentLongNumber(noMergeNumbers, (String)myPair.p2, (String)opPair.p2)))) continue;
            boolean pass = true;
            if (!ctx.isCompany()) {
                pass = commonParentLongNumber.equals(ctx.getEntity().p3);
            }
            if (!pass) continue;
            Pair parentPair = (Pair)parentCache.get(commonParentLongNumber);
            if (parentPair == null) {
                IDNumberTreeNode comParentNode = EntityServiceHelper.findEntityByLongNumber(modelNumber, commonParentLongNumber);
                parentPair = Pair.onePair((Object)comParentNode.getId(), (Object)comParentNode.getNumber());
                parentCache.put(commonParentLongNumber, parentPair);
            }
            if (!pass || (Long)parentPair.p1 == -1L) continue;
            resultMap.put(key, (Pair<Long, String>)parentPair);
        }
        return resultMap;
    }

    private static String getCommonParentLongNumber(Set<String> noMergeNumbers, String longNum1, String longNum2) {
        int i;
        String[] split1 = longNum1.split("!");
        String[] split2 = longNum2.split("!");
        int length = Math.min(split2.length, split1.length);
        ArrayList<String> comParent = new ArrayList<String>(length - 1);
        for (int i2 = 0; i2 < length && split1[i2].equals(split2[i2]); ++i2) {
            comParent.add(split1[i2]);
        }
        int start = comParent.size();
        if (length == start && start > 1) {
            comParent.remove(comParent.size() - 1);
        }
        String parent = String.join((CharSequence)"!", comParent);
        for (i = comParent.size(); i < split1.length; ++i) {
            if (!noMergeNumbers.contains(split1[i - 1] + "!" + split1[i])) continue;
            return null;
        }
        for (i = comParent.size(); i < split2.length - 1; ++i) {
            if (!noMergeNumbers.contains(split2[i - 1] + "!" + split2[i])) continue;
            return null;
        }
        return parent;
    }

    public static String getSecondLongNumber(String longnumber) {
        String[] arr = longnumber.split("!");
        if (arr.length >= 2) {
            return arr[0] + "!" + arr[1];
        }
        return "Entity";
    }

    public static Set<String> getParentLongNumber(String longnumber) {
        HashSet<String> result = new HashSet<String>(16);
        String[] arr = longnumber.split("!");
        if (arr.length >= 2) {
            ArrayList<String> entity = new ArrayList<String>(16);
            for (int i = 0; i < arr.length - 1; ++i) {
                entity.add(arr[i]);
                result.add(String.join((CharSequence)"!", entity));
            }
        } else {
            result.add("Entity");
        }
        return result;
    }

    public static String getMergeDirectLongNumber(String mergeLongNumber, String longnumber) {
        String[] mergeArr;
        if (mergeLongNumber == null || longnumber == null) {
            return "";
        }
        String[] arr = longnumber.split("!");
        if (arr.length - (mergeArr = mergeLongNumber.split("!")).length >= 1) {
            ArrayList<String> entity = new ArrayList<String>(16);
            for (int i = 0; i < mergeArr.length + 1; ++i) {
                entity.add(arr[i]);
            }
            return String.join((CharSequence)"!", entity);
        }
        return "Entity";
    }

    public static Set<String> trans2WithParentEntity(ICheckContext ctx, Set<String> entities) {
        HashSet<String> relaEntities = new HashSet<String>(16);
        entities.forEach(num -> {
            String[] arr;
            int length;
            Pair<Long, String> pair = ctx.getSortedOrgByChangeType().get(num);
            if (pair != null && StringUtils.isNotEmpty((String)((String)pair.p2)) && (length = (arr = ((String)pair.p2).split("!")).length) >= 2) {
                relaEntities.add(arr[length - 2] + "_" + arr[length - 1]);
            }
        });
        return relaEntities;
    }

    public static IDNumberTreeNode findEntityByLongNumber(String modelNum, String longNumber) {
        if (StringUtils.isBlank((String)longNumber)) {
            return IDNumberTreeNode.NotFoundTreeNode;
        }
        String[] splits = longNumber.split("!");
        String number = splits[splits.length - 1];
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)PresetConstant.ENTITY_DIM, (String)number);
        if (longNumber.equals(node.getLongNumber())) {
            return node;
        }
        for (IDNumberTreeNode shareNode : node.getShareNodes()) {
            if (!longNumber.equals(shareNode.getLongNumber())) continue;
            return shareNode;
        }
        return IDNumberTreeNode.NotFoundTreeNode;
    }
}

