/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.check.diff.DiffHandler;
import kd.fi.bcm.business.check.diff.IDiff;
import kd.fi.bcm.business.check.diff.IDiffEntry;
import kd.fi.bcm.business.check.helper.CheckRecordHelper;
import kd.fi.bcm.business.check.model.key.CheckTmpl;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CheckRecordTypeEnum;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ToStringHelper;

public class CheckRecord
implements IDiff {
    private CheckTmpl tmpl;
    private Long id;
    private String number;
    private int elimType;
    private int diffMode;
    private int diffMethod;
    private int status;
    private Long modelid;
    private Long sceneid;
    private Long yearid;
    private Long periodid;
    private Long audittrailid;
    private Long currencyid;
    private Long processid;
    private Long multigaapid;
    private Long datasortid;
    private Long creatorid;
    private Date createtime;
    private Long modifierid;
    private Date modifytime;
    private Long entityid;
    private BigDecimal difference;
    private BigDecimal difference2;
    private Map<String, String> orgmap;
    private String checkconfig;
    private List<Entry> entries;
    private Long myentityid;
    private String myentityNum;
    private Long opentityid;
    private String opentityNum;
    private BigDecimal myecmoney;
    private BigDecimal opecmoney;
    private String mycvtpath;
    private String opcvtpath;
    private BigDecimal myrate;
    private BigDecimal oprate;
    private BigDecimal mycvtmoney;
    private BigDecimal opcvtmoney;
    private BigDecimal cvtdifmoney;
    private Map<String, CheckRecordTypeEnum> recordTypeEnumMap;
    private CheckRecordTypeEnum recordTypeEnum;
    private Map<String, Integer> groupDiffMap;
    private Map<String, Map<String, String>> paramMap = new HashMap<String, Map<String, String>>(16);
    private boolean isSingleDC;

    @Override
    public boolean isSingleDC() {
        return this.isSingleDC;
    }

    @Override
    public void setSingleDC(boolean isSingleDC) {
        this.isSingleDC = isSingleDC;
    }

    public Long getMyentityid() {
        return this.myentityid;
    }

    public void setMyentityid(Long myentityid) {
        this.myentityid = myentityid;
    }

    public String getMyentityNum() {
        return this.myentityNum;
    }

    public void setMyentityNum(String myentityNum) {
        this.myentityNum = myentityNum;
    }

    public Long getOpentityid() {
        return this.opentityid;
    }

    public void setOpentityid(Long opentityid) {
        this.opentityid = opentityid;
    }

    public String getOpentityNum() {
        return this.opentityNum;
    }

    public void setOpentityNum(String opentityNum) {
        this.opentityNum = opentityNum;
    }

    public BigDecimal getMyecmoney() {
        return this.myecmoney;
    }

    public void setMyecmoney(BigDecimal myecmoney) {
        this.myecmoney = myecmoney;
    }

    public BigDecimal getOpecmoney() {
        return this.opecmoney;
    }

    public void setOpecmoney(BigDecimal opecmoney) {
        this.opecmoney = opecmoney;
    }

    public String getMycvtpath() {
        return this.mycvtpath;
    }

    public void setMycvtpath(String mycvtpath) {
        this.mycvtpath = mycvtpath;
    }

    public String getOpcvtpath() {
        return this.opcvtpath;
    }

    public void setOpcvtpath(String opcvtpath) {
        this.opcvtpath = opcvtpath;
    }

    public BigDecimal getMyrate() {
        return this.myrate;
    }

    public void setMyrate(BigDecimal myrate) {
        this.myrate = myrate;
    }

    public BigDecimal getOprate() {
        return this.oprate;
    }

    public void setOprate(BigDecimal oprate) {
        this.oprate = oprate;
    }

    public BigDecimal getMycvtmoney() {
        return this.mycvtmoney;
    }

    public void setMycvtmoney(BigDecimal mycvtmoney) {
        this.mycvtmoney = mycvtmoney;
    }

    public BigDecimal getOpcvtmoney() {
        return this.opcvtmoney;
    }

    public void setOpcvtmoney(BigDecimal opcvtmoney) {
        this.opcvtmoney = opcvtmoney;
    }

    public BigDecimal getCvtdifmoney() {
        return this.cvtdifmoney;
    }

    public void setCvtdifmoney(BigDecimal cvtdifmoney) {
        this.cvtdifmoney = cvtdifmoney;
    }

    @Override
    public CheckTmpl getTmpl() {
        return this.tmpl;
    }

    public void setTmpl(CheckTmpl tmpl) {
        this.tmpl = tmpl;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public int getElimType() {
        return this.elimType;
    }

    public void setElimType(int elimType) {
        this.elimType = elimType;
    }

    public int getDiffMode() {
        return this.diffMode;
    }

    @Override
    public void setDiffMode(int diffMode) {
        this.diffMode = diffMode;
    }

    public int getDiffMethod() {
        return this.diffMethod;
    }

    public void setDiffMethod(int diffMethod) {
        this.diffMethod = diffMethod;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public Long getModelid() {
        return this.modelid;
    }

    public void setModelid(Long modelid) {
        this.modelid = modelid;
    }

    public Long getSceneid() {
        return this.sceneid;
    }

    public void setSceneid(Long sceneid) {
        this.sceneid = sceneid;
    }

    public Long getYearid() {
        return this.yearid;
    }

    public void setYearid(Long yearid) {
        this.yearid = yearid;
    }

    public Long getPeriodid() {
        return this.periodid;
    }

    public void setPeriodid(Long periodid) {
        this.periodid = periodid;
    }

    public Long getAudittrailid() {
        return this.audittrailid;
    }

    public void setAudittrailid(Long audittrailid) {
        this.audittrailid = audittrailid;
    }

    public Long getCurrencyid() {
        return this.currencyid;
    }

    public void setCurrencyid(Long currencyid) {
        this.currencyid = currencyid;
    }

    public Long getProcessid() {
        return this.processid;
    }

    public void setProcessid(Long processid) {
        this.processid = processid;
    }

    public Long getMultigaapid() {
        return this.multigaapid;
    }

    public void setMultigaapid(Long multigaapid) {
        this.multigaapid = multigaapid;
    }

    public Long getCreatorid() {
        return this.creatorid;
    }

    public void setCreatorid(Long creatorid) {
        this.creatorid = creatorid;
    }

    public Date getCreatetime() {
        return this.createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    public Long getModifierid() {
        return this.modifierid;
    }

    public void setModifierid(Long modifierid) {
        this.modifierid = modifierid;
    }

    public Date getModifytime() {
        return this.modifytime;
    }

    public void setModifytime(Date modifytime) {
        this.modifytime = modifytime;
    }

    public Long getEntityid() {
        return this.entityid;
    }

    public void setEntityid(Long entityid) {
        this.entityid = entityid;
    }

    public Long getDatasortid() {
        return this.datasortid;
    }

    public void setDatasortid(Long datasortid) {
        this.datasortid = datasortid;
    }

    @Override
    public BigDecimal getDifference() {
        return this.difference;
    }

    @Override
    public void setDifference(BigDecimal difference) {
        this.difference = difference;
    }

    @Override
    public BigDecimal getDifference2() {
        return this.difference2;
    }

    @Override
    public void setDifference2(BigDecimal difference2) {
        this.difference2 = difference2;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public Map<String, String> getOrgmap() {
        return this.orgmap;
    }

    public void setOrgmap(Map<String, String> orgmap) {
        this.orgmap = orgmap;
    }

    public String getCheckconfig() {
        return this.checkconfig;
    }

    public void setCheckconfig(String checkconfig) {
        this.checkconfig = checkconfig;
    }

    public Map<String, CheckRecordTypeEnum> getRecordTypeEnumMap() {
        return this.recordTypeEnumMap;
    }

    public void setRecordTypeEnumMap(Map<String, CheckRecordTypeEnum> recordTypeEnumMap) {
        this.recordTypeEnumMap = recordTypeEnumMap;
    }

    public CheckRecordTypeEnum getRecordTypeEnum() {
        return this.recordTypeEnum;
    }

    public Map<String, Integer> getGroupDiffMap() {
        return this.groupDiffMap;
    }

    @Override
    public void setGroupDiffMap(Map<String, Integer> groupDiffMap) {
        this.groupDiffMap = groupDiffMap;
    }

    @Override
    public void setParamMap(Map<String, Map<String, String>> paramMap) {
        this.paramMap = paramMap;
    }

    @Override
    public void dealRecordTypeEnum() {
        HashSet<CheckRecordTypeEnum> groupRecordType;
        this.recordTypeEnum = this.recordTypeEnumMap != null ? ((groupRecordType = new HashSet<CheckRecordTypeEnum>(this.recordTypeEnumMap.values())).size() == 1 ? (CheckRecordTypeEnum)groupRecordType.iterator().next() : CheckRecordTypeEnum.MULTIPLE_TYPE) : CheckRecordTypeEnum.NORMAL;
    }

    public String toString() {
        return ToStringHelper.reflectionToString((Object)this);
    }

    @Override
    public void diffProcess(String groupKey, BigDecimal abSum, BigDecimal baSum, int diffMode, int diffMethod) {
        this.dealEntryRecordType(groupKey, abSum, baSum);
        Map<String, String> param = new HashMap(16);
        this.setEntryDiffMode(groupKey, diffMode, diffMethod, abSum.compareTo(baSum) == 0 ? "3" : "2");
        if (diffMode == 4) {
            BigDecimal opocMoney;
            param = this.paramMap.getOrDefault(groupKey, new HashMap(16));
            diffMode = this.getGroupDiffMap().getOrDefault(groupKey, 3);
            String d = param.get(param.containsKey("diffmethod") ? "diffmethod" : "default_diffmethod");
            diffMethod = StringUtils.isEmpty((String)d) ? DiffMethodEnum.DIFFITEM.getValue() : Integer.parseInt(d);
            Map<Boolean, BigDecimal> ocValueMap = this.calculateOcValue(groupKey);
            BigDecimal myocMoney = ocValueMap.get(Boolean.TRUE);
            this.setEntryDiffMode(groupKey, diffMode, diffMethod, myocMoney.compareTo((opocMoney = ocValueMap.get(Boolean.FALSE)).negate()) != 0 ? "1" : (abSum.compareTo(baSum) == 0 ? "3" : "2"));
        }
        if (abSum.compareTo(baSum) == 0 && (diffMode != 2 || diffMethod != DiffMethodEnum.MAXLINE.getValue() && diffMethod != DiffMethodEnum.ORDERLINE.getValue()) || diffMode == 5 || diffMode == 3 || diffMode == 8) {
            if (diffMode == 5 || diffMode == 3 || diffMode == 8) {
                this.setEntryDiffMode(groupKey, diffMode, diffMethod, null);
            }
            if (diffMode == 5) {
                List<Entry> groupEntrties = this.getEntries().stream().filter(e -> groupKey.equals(e.getGroup())).collect(Collectors.toList());
                groupEntrties.forEach(e -> e.setMerge(true));
            }
            return;
        }
        if (diffMethod == DiffMethodEnum.DIFFITEM.getValue()) {
            this.diffProcessDiffItem(groupKey, abSum, baSum, diffMode, param);
        } else if (diffMethod == DiffMethodEnum.MAXMAPPING.getValue()) {
            this.diffProcessMaxMapping(groupKey, abSum, baSum, diffMode, param);
        } else if (diffMode == 1 || diffMode == 2) {
            this.diffProcessAbsBigOrAbsSmall(groupKey, abSum, baSum, diffMode, diffMethod, param);
        } else {
            this.diffProcessDebitOrCredit(groupKey, abSum, baSum, diffMode, diffMethod, param);
        }
    }

    private void dealEntryRecordType(String groupKey, BigDecimal abSum, BigDecimal baSum) {
        baSum = this.isSingleDC() ? baSum : baSum.negate();
        Map<Boolean, List<Entry>> groupEntries = this.getEntries().stream().filter(e -> !e.isDi() && groupKey.equals(e.getGroup())).collect(Collectors.groupingBy(e -> e.isAb()));
        List<Object> abEntries = groupEntries.get(Boolean.TRUE) == null ? new ArrayList(1) : groupEntries.get(Boolean.TRUE);
        List<Object> baEntries = groupEntries.get(Boolean.FALSE) == null ? new ArrayList(1) : groupEntries.get(Boolean.FALSE);
        abEntries = abEntries.stream().sorted(Comparator.comparingInt(e -> e.getTmplEntry().getSeq())).collect(Collectors.toList());
        baEntries = baEntries.stream().sorted(Comparator.comparingInt(e -> e.getTmplEntry().getSeq())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(abEntries) ^ CollectionUtils.isEmpty(baEntries)) {
            this.getRecordTypeEnumMap().put(groupKey, CheckRecordTypeEnum.SINGLE_DATA);
            return;
        }
        Set abDc = abEntries.stream().map(Entry::getDc).collect(Collectors.toSet());
        Set baDc = baEntries.stream().map(Entry::getDc).collect(Collectors.toSet());
        if (abDc.size() == 1 && baDc.size() == 1 && abDc.containsAll(baDc)) {
            this.getRecordTypeEnumMap().put(groupKey, CheckRecordTypeEnum.SAME_ACCOUNT_DC);
            return;
        }
        if (abSum.signum() == baSum.signum()) {
            this.getRecordTypeEnumMap().put(groupKey, CheckRecordTypeEnum.SAME_AMOUNT_SIGN);
            return;
        }
        Iterator<Object> abIterator = abEntries.iterator();
        block0: while (abIterator.hasNext()) {
            Entry abNext = (Entry)abIterator.next();
            Iterator<Object> baIterator = baEntries.iterator();
            while (baIterator.hasNext()) {
                Entry baNext = (Entry)baIterator.next();
                if (abNext.getValue().compareTo(baNext.getValue().negate()) != 0) continue;
                abIterator.remove();
                baIterator.remove();
                continue block0;
            }
        }
        if (CollectionUtils.isEmpty(abEntries) ^ CollectionUtils.isEmpty(baEntries)) {
            this.getRecordTypeEnumMap().put(groupKey, CheckRecordTypeEnum.AFTER_SINGLE_DATA);
            return;
        }
        this.getRecordTypeEnumMap().put(groupKey, CheckRecordTypeEnum.NORMAL);
    }

    private Map<Boolean, BigDecimal> calculateOcValue(String groupKey) {
        List<IDiffEntry> groupEntrties = this.getEntries().stream().filter(e -> groupKey.equals(e.getGroup())).collect(Collectors.toList());
        return DiffHandler.calculateOcValue(groupEntrties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void diffProcessMaxMapping(String groupKey, BigDecimal abSum, BigDecimal baSum, int diffMode, Map<String, String> param) {
        Optional<Entry> maxEntry;
        BigDecimal value;
        Optional<Entry> recEntries;
        String diffGroup = "1";
        if (groupKey.contains(String.valueOf('@'))) {
            diffGroup = groupKey.split(String.valueOf('@'))[0];
        }
        if (!(recEntries = this.getEntries().stream().filter(e -> e.getDc() == -1 && e.isDi() && groupKey.equals(e.getGroup())).findFirst()).isPresent()) return;
        String finalDiffGroup = diffGroup;
        List tmplList = this.getTmpl().getEntries().stream().filter(CheckTmpl.Entry::isDiffitem).filter(e -> finalDiffGroup.equals(e.getEntrygroup())).collect(Collectors.toList());
        if (tmplList.isEmpty()) {
            tmplList = this.getTmpl().getEntries().stream().filter(CheckTmpl.Entry::isDiffitem).filter(e -> "0".equals(e.getEntrygroup())).collect(Collectors.toList());
        }
        if (tmplList.isEmpty()) {
            return;
        }
        boolean isAb = false;
        boolean isDc = false;
        BigDecimal bigDecimal = value = this.isSingleDC() ? abSum.add(baSum) : abSum.subtract(baSum);
        if (diffMode == 1 || diffMode == 2) {
            Pair<Boolean, Boolean> abAndDc = this.getGroupDataAbAndDc(abSum, baSum, diffMode, null);
            boolean finalIsAb = isAb = ((Boolean)abAndDc.p1).booleanValue();
            maxEntry = this.getEntries().stream().filter(e -> !e.isDi() && groupKey.equals(e.getGroup())).filter(e -> e.isAb() ^ finalIsAb).sorted(Comparator.comparingInt(e -> e.getTmplEntry().getSeq())).max(Comparator.comparing(e -> e.getValue().abs()));
        } else {
            boolean isDcType = diffMode == 9;
            Map<Boolean, List<Entry>> entryMap = this.getEntries().stream().filter(e -> !e.isDi() && groupKey.equals(e.getGroup())).collect(Collectors.groupingBy(e -> e.getDc() == 1));
            List<Entry> entries = entryMap.get(isDcType);
            if (entries == null) {
                param.put("forceIsDC", Boolean.valueOf(isDcType).toString());
                this.diffProcessDiffItem(groupKey, abSum, baSum, 1, param);
                return;
            }
            if (entryMap.get(!isDcType) == null) {
                Set<Entry> groupEntries = this.getEntries().stream().filter(e -> !e.isDi() && groupKey.equals(e.getGroup())).collect(Collectors.toSet());
                groupEntries.forEach(e -> {
                    e.setEntrydebelimvalue(BigDecimal.ZERO);
                    e.setEntrycreelimvalue(BigDecimal.ZERO);
                    e.setMerge(true);
                });
                return;
            }
            maxEntry = entries.stream().max(Comparator.comparing(e -> e.getValue() == null ? BigDecimal.ZERO : e.getValue().abs()));
        }
        if (maxEntry.isPresent()) {
            boolean isAccountOffset;
            if (diffMode == 10 || diffMode == 9) {
                isAb = maxEntry.get().ab;
            }
            Long mappingAccountId = maxEntry.get().getTmplEntry().getMappingAccountId();
            IDNumberTreeNode mappingAccountNode = MemberReader.findMemberById((long)this.getModelid(), (String)"bcm_accountmembertree", (Long)mappingAccountId);
            boolean bl = isAccountOffset = mappingAccountNode.getProperty("accountpart.isaccountoffset") == null ? Boolean.FALSE.booleanValue() : ((Boolean)mappingAccountNode.getProperty("accountpart.isaccountoffset")).booleanValue();
            if (mappingAccountNode != IDNumberTreeNode.NotFoundTreeNode && mappingAccountNode.isLeaf() && isAccountOffset && StorageTypeEnum.getRealStorageEnumIndexs().contains(mappingAccountNode.getStorageType().index)) {
                CheckTmpl.Entry tmplEntry;
                boolean finalIsDc = isDc = !DrCRDirectEnum.isDc((String)((String)mappingAccountNode.getProperty("drcrdirect")));
                int entryDc = -1;
                if (tmplList.size() == 1) {
                    tmplEntry = (CheckTmpl.Entry)tmplList.get(0);
                } else {
                    if (tmplList.size() != 2) return;
                    Optional<CheckTmpl.Entry> entryOptional = tmplList.stream().filter(e -> e.getDc() == 1 == finalIsDc).findFirst();
                    if (entryOptional.isPresent()) {
                        tmplEntry = entryOptional.get();
                    } else {
                        Optional<CheckTmpl.Entry> entryOptional2 = tmplList.stream().filter(e -> e.getDc() == 1 == !finalIsDc).findFirst();
                        if (!entryOptional2.isPresent()) return;
                        tmplEntry = entryOptional2.get();
                    }
                }
                int n = entryDc = isDc ? 1 : 0;
                if (!this.isSingleDC()) {
                    BigDecimal bigDecimal2 = value = isDc ? value.negate() : value;
                    if (value.doubleValue() < 0.0 && diffMode == 11) {
                        entryDc = 1 - entryDc;
                        value = value.negate();
                    }
                }
                Entry entry = recEntries.get();
                entry.setTmplEntry(tmplEntry);
                entry.setSeq(0);
                entry.setDc(entryDc);
                if (diffMode == 9 || diffMode == 10) {
                    entry.setAb(maxEntry.get().ab);
                } else {
                    entry.setAb(isAb);
                }
                entry.setEntryscene(this.getSceneid());
                entry.setEntryyear(this.getYearid());
                entry.setEntryperiod(this.getPeriodid());
                entry.setEntryprocess(this.getProcessid());
                String small = null;
                String big = null;
                if (this.orgmap != null && this.orgmap.size() > 0) {
                    String pair = this.orgmap.keySet().iterator().next();
                    String[] ps = pair.split(String.valueOf('&'));
                    if (ps[0].compareTo(ps[1]) < 0) {
                        small = ps[0];
                        big = ps[1];
                    } else {
                        big = ps[0];
                        small = ps[1];
                    }
                }
                entry.setEntryorg(0L);
                entry.setEntrymycompany(0L);
                entry.setEntrycompany(this.getUserDefineDimId(tmplEntry, PresetConstant.INTERNALCOMPANY_DIM, 0L));
                String mycompany = isAb ? small : big;
                String company = !isAb ? small : big;
                String entity = this.orgmap.get(mycompany + '&' + company);
                entry.setEntryorgnumber(entity == null ? mycompany : entity);
                if (tmplEntry.getMycompany() != null && tmplEntry.getMycompany() != 0L) {
                    entry.setEntrymycompany(tmplEntry.getMycompany());
                    entry.setEntrymycompanynumber(tmplEntry.getMycompanyNumber());
                } else {
                    entry.setEntrymycompanynumber(mycompany);
                }
                entry.setEntrycompanynumber(company);
                this.setICCompanyByElimTmpl(tmplEntry, entry);
                entry.setEntrydebitaccout(isDc ? mappingAccountId : 0L);
                entry.setEntrycreditaccout(!isDc ? mappingAccountId : 0L);
                entry.setMappingAccountId(mappingAccountId);
                entry.setEntrychangetype(tmplEntry.getChangetype());
                entry.setEntrymultigaap(tmplEntry.getRule());
                entry.setEntrydatasort(tmplEntry.getDatasort());
                entry.setEntrycurrency(this.getCurrencyid());
                entry.setEntrydim1(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(0), entry.getEntrydim1()));
                entry.setEntrydim2(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(1), entry.getEntrydim2()));
                entry.setEntrydim3(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(2), entry.getEntrydim3()));
                entry.setEntrydim4(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(3), entry.getEntrydim4()));
                entry.setEntrydim5(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(4), entry.getEntrydim5()));
                entry.setEntrydim6(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(5), entry.getEntrydim6()));
                entry.setEntryaudittrail(this.getUserDefineDimId(tmplEntry, "audittrail", entry.getEntryaudittrail()));
                entry.setEntrydebit(entryDc == 1 ? value : BigDecimal.ZERO);
                entry.setEntrycredit(entryDc != 1 ? value : BigDecimal.ZERO);
                entry.setEntrydebelimvalue(BigDecimal.ZERO);
                entry.setEntrycreelimvalue(BigDecimal.ZERO);
                return;
            } else {
                this.diffProcessDiffItem(groupKey, abSum, baSum, 1, param);
            }
            return;
        } else {
            this.diffProcessDiffItem(groupKey, abSum, baSum, 1, param);
        }
    }

    private void diffProcessDebitOrCredit(String groupKey, BigDecimal abSum, BigDecimal baSum, int diffMode, int diffMethod, Map<String, String> param) {
        Optional<Entry> maxEntry;
        BigDecimal value = this.isSingleDC() ? abSum.add(baSum) : abSum.subtract(baSum);
        boolean isDc = diffMode == 9;
        value = isDc ? value.negate() : value;
        Map<Boolean, List<Entry>> entryMap = this.getEntries().stream().filter(e -> !e.isDi() && groupKey.equals(e.getGroup())).collect(Collectors.groupingBy(e -> e.getDc() == 1));
        List<Entry> entries = entryMap.get(isDc);
        if (entries == null) {
            param.put("forceIsDC", Boolean.valueOf(isDc).toString());
            this.diffProcessDiffItem(groupKey, abSum, baSum, 1, param);
            return;
        }
        if (entryMap.get(!isDc) == null) {
            Set<Entry> groupEntries = this.getEntries().stream().filter(e -> !e.isDi() && groupKey.equals(e.getGroup())).collect(Collectors.toSet());
            groupEntries.forEach(e -> {
                e.setEntrydebelimvalue(BigDecimal.ZERO);
                e.setEntrycreelimvalue(BigDecimal.ZERO);
                e.setMerge(true);
            });
            return;
        }
        if (diffMethod == DiffMethodEnum.ORDERLINE.getValue()) {
            List orderEntries = entries.stream().sorted(Comparator.comparingInt(e -> e.getTmplEntry().getSeq()).reversed()).collect(Collectors.toList());
            for (int i = 0; i < orderEntries.size(); ++i) {
                boolean isLast;
                Entry e2 = (Entry)orderEntries.get(i);
                boolean bl = isLast = i == orderEntries.size() - 1;
                if (value.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal entryValue = e2.getDc() == 1 ? e2.getEntrydebit() : e2.getEntrycredit();
                    BigDecimal elimValue = entryValue.add(value);
                    if (!isLast && entryValue.signum() + elimValue.signum() == 0) {
                        e2.setElimValue(BigDecimal.ZERO);
                        value = value.subtract(entryValue.negate());
                    } else {
                        e2.setElimValue(elimValue);
                        value = BigDecimal.ZERO;
                    }
                } else {
                    e2.setEntrydebelimvalue(e2.getEntrydebit());
                    e2.setEntrycreelimvalue(e2.getEntrycredit());
                }
                e2.setMerge(true);
            }
        } else if (diffMethod == DiffMethodEnum.MAXLINE.getValue() && (maxEntry = entries.stream().max(Comparator.comparing(e -> e.getValue() == null ? BigDecimal.ZERO : e.getValue().abs()))).isPresent()) {
            Entry entry = maxEntry.get();
            BigDecimal entryValue = entry.getDc() == 1 ? entry.getEntrydebit() : entry.getEntrycredit();
            BigDecimal elimValue = entryValue.add(value);
            entry.setElimValue(elimValue);
            entry.setMerge(true);
            Long entryId = entry.getId();
            entryMap.values().forEach(l -> l.forEach(e -> {
                if (!e.getId().equals(entryId)) {
                    e.setEntrydebelimvalue(e.getEntrydebit());
                    e.setEntrycreelimvalue(e.getEntrycredit());
                    e.setMerge(true);
                }
            }));
        }
    }

    private void diffProcessAbsBigOrAbsSmall(String groupKey, BigDecimal abSum, BigDecimal baSum, int diffMode, int diffMethod, Map<String, String> param) {
        Map<Boolean, List<Entry>> groupEntries = this.getEntries().stream().filter(e -> !e.isDi() && groupKey.equals(e.getGroup())).collect(Collectors.groupingBy(Entry::isAb));
        List<Object> abEntries = groupEntries.get(Boolean.TRUE) == null ? new ArrayList(1) : groupEntries.get(Boolean.TRUE);
        List<Object> baEntries = groupEntries.get(Boolean.FALSE) == null ? new ArrayList(1) : groupEntries.get(Boolean.FALSE);
        abEntries = abEntries.stream().sorted(Comparator.comparingInt(e -> e.getTmplEntry().getSeq())).collect(Collectors.toList());
        baEntries = baEntries.stream().sorted(Comparator.comparingInt(e -> e.getTmplEntry().getSeq())).collect(Collectors.toList());
        if (!(diffMode != 2 || diffMethod != DiffMethodEnum.MAXLINE.getValue() && diffMethod != DiffMethodEnum.ORDERLINE.getValue() || abSum.compareTo(BigDecimal.ZERO) != 0 && baSum.compareTo(BigDecimal.ZERO) != 0)) {
            groupEntries.values().forEach(l -> l.forEach(e -> {
                e.setEntrydebelimvalue(BigDecimal.ZERO);
                e.setEntrycreelimvalue(BigDecimal.ZERO);
                e.setMerge(true);
            }));
            return;
        }
        if (!CollectionUtils.isEmpty(abEntries) && !CollectionUtils.isEmpty(baEntries)) {
            Iterator<Object> abIterator = abEntries.iterator();
            block0: while (abIterator.hasNext()) {
                Entry abNext = (Entry)abIterator.next();
                Iterator<Object> baIterator = baEntries.iterator();
                while (baIterator.hasNext()) {
                    Entry baNext = (Entry)baIterator.next();
                    if (abNext.getValue().compareTo(baNext.getValue().negate()) != 0) continue;
                    abIterator.remove();
                    baIterator.remove();
                    continue block0;
                }
            }
        }
        BigDecimal value = this.isSingleDC() ? abSum.add(baSum) : abSum.subtract(baSum);
        Optional<Entry> abmax = abEntries.stream().max(Comparator.comparing(e -> e.getValue() == null ? BigDecimal.ZERO : e.getValue().abs()));
        Optional<Entry> bamax = baEntries.stream().max(Comparator.comparing(e -> e.getValue() == null ? BigDecimal.ZERO : e.getValue().abs()));
        Pair<Boolean, Boolean> abAndDc = this.getGroupDataAbAndDc(abSum, baSum, diffMode);
        boolean isAb = (Boolean)abAndDc.p1;
        boolean isDc = (Boolean)abAndDc.p2;
        value = isDc ? value.negate() : value;
        Entry entry = null;
        if (isAb && abmax.isPresent()) {
            entry = abmax.get();
        }
        if (!isAb && bamax.isPresent()) {
            entry = bamax.get();
        }
        if (diffMode == 1) {
            if (entry == null) {
                this.diffProcessDiffItem(groupKey, abSum, baSum, 1, param);
                return;
            }
            if (isAb && abEntries.size() == 1 && baEntries.isEmpty() || !isAb && baEntries.size() == 1 && abEntries.isEmpty()) {
                Entry copyEntity = entry.copyEntity(groupKey);
                copyEntity.setDi(true);
                if (isDc == (copyEntity.getDc() == 1)) {
                    copyEntity.setElimValue(value);
                    copyEntity.setValue(value);
                } else {
                    copyEntity.setElimValue(value.negate());
                    copyEntity.setValue(value.negate());
                }
                this.getEntries().add(copyEntity);
                return;
            }
        }
        if (diffMode == 2 && (CollectionUtils.isEmpty(abEntries) || CollectionUtils.isEmpty(baEntries))) {
            if (isAb && !CollectionUtils.isEmpty(abEntries) || !isAb && !CollectionUtils.isEmpty(baEntries)) {
                abEntries.forEach(e -> {
                    e.setEntrydebelimvalue(BigDecimal.ZERO);
                    e.setEntrycreelimvalue(BigDecimal.ZERO);
                    e.setMerge(true);
                });
                baEntries.forEach(e -> {
                    e.setEntrydebelimvalue(BigDecimal.ZERO);
                    e.setEntrycreelimvalue(BigDecimal.ZERO);
                    e.setMerge(true);
                });
                return;
            }
            this.diffProcessDiffItem(groupKey, abSum, baSum, 2, param);
            return;
        }
        if (diffMethod == DiffMethodEnum.ORDERLINE.getValue()) {
            List orderEntries = isAb ? abEntries.stream().sorted(Comparator.comparingInt(e -> e.getTmplEntry().getSeq()).reversed()).collect(Collectors.toList()) : baEntries.stream().sorted(Comparator.comparingInt(e -> e.getTmplEntry().getSeq()).reversed()).collect(Collectors.toList());
            for (int i = 0; i < orderEntries.size(); ++i) {
                boolean isLast;
                Entry e2 = (Entry)orderEntries.get(i);
                boolean bl = isLast = i == orderEntries.size() - 1;
                if (value.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal elimValue;
                    BigDecimal entryValue = e2.getDc() == 1 ? e2.getEntrydebit() : e2.getEntrycredit();
                    if (isDc == (e2.getDc() == 1)) {
                        elimValue = entryValue.add(value);
                        if (!isLast && entryValue.signum() + elimValue.signum() == 0) {
                            e2.setElimValue(BigDecimal.ZERO);
                            value = value.subtract(entryValue.negate());
                        } else {
                            e2.setElimValue(elimValue);
                            value = BigDecimal.ZERO;
                        }
                    } else {
                        elimValue = entryValue.subtract(value);
                        if (!isLast && entryValue.signum() + elimValue.signum() == 0) {
                            e2.setElimValue(BigDecimal.ZERO);
                            value = value.subtract(entryValue);
                        } else {
                            e2.setElimValue(elimValue);
                            value = BigDecimal.ZERO;
                        }
                    }
                } else {
                    e2.setEntrydebelimvalue(e2.getEntrydebit());
                    e2.setEntrycreelimvalue(e2.getEntrycredit());
                }
                e2.setMerge(true);
            }
        } else if (diffMethod == DiffMethodEnum.MAXLINE.getValue() && entry != null) {
            BigDecimal elimValue;
            BigDecimal entryValue = entry.getDc() == 1 ? entry.getEntrydebit() : entry.getEntrycredit();
            if (isDc == (entry.getDc() == 1)) {
                elimValue = entryValue.add(value);
                entry.setElimValue(elimValue);
            } else {
                elimValue = entryValue.subtract(value);
                entry.setElimValue(elimValue);
            }
            entry.setMerge(true);
            Long entryId = entry.getId();
            groupEntries.values().forEach(l -> l.forEach(e -> {
                if (!e.getId().equals(entryId)) {
                    e.setEntrydebelimvalue(e.getEntrydebit());
                    e.setEntrycreelimvalue(e.getEntrycredit());
                    e.setMerge(true);
                }
            }));
        }
    }

    private Pair<Boolean, Boolean> getGroupDataAbAndDc(BigDecimal abSum, BigDecimal baSum, int diffMode) {
        return this.getGroupDataAbAndDc(abSum, baSum, diffMode, null);
    }

    private Pair<Boolean, Boolean> getGroupDataAbAndDc(BigDecimal abSum, BigDecimal baSum, int diffMode, Boolean forceIsDc) {
        boolean isDc;
        boolean isAb;
        BigDecimal value = this.isSingleDC() ? abSum.add(baSum) : abSum.subtract(baSum);
        int i = abSum.abs().compareTo(baSum.abs());
        if (diffMode == 1 || diffMode == 6 || diffMode == 11) {
            boolean bl = isAb = i < 0;
            isDc = this.isSingleDC() ? false : value.compareTo(BigDecimal.ZERO) < 0;
        } else {
            boolean bl = isAb = i > 0;
            if (this.isSingleDC()) {
                isDc = false;
            } else {
                boolean bl2 = isDc = value.compareTo(BigDecimal.ZERO) > 0;
            }
        }
        if (forceIsDc != null) {
            isDc = forceIsDc;
        }
        return Pair.onePair((Object)isAb, (Object)isDc);
    }

    private void setEntryDiffMode(String groupKey, int diffMode, int diffMethod, String diffType) {
        List<Entry> groupEntrties = this.getEntries().stream().filter(e -> groupKey.equals(e.getGroup())).collect(Collectors.toList());
        groupEntrties.forEach(e -> e.setEntryDiffMode(diffMode));
        groupEntrties.forEach(e -> e.setEntryDiffMethod(diffMethod));
        if (StringUtils.isNotEmpty((String)diffType)) {
            groupEntrties.forEach(e -> e.setDiffType(Integer.parseInt(diffType)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void diffProcessDiffItem(String groupKey, BigDecimal abSum, BigDecimal baSum, int diffMode, Map<String, String> param) {
        Optional<CheckTmpl.Entry> entryOptional2;
        Optional<CheckTmpl.Entry> entryOptional;
        CheckTmpl.Entry tmplEntry;
        String diffGroup = "1";
        if (groupKey.contains(String.valueOf('@'))) {
            diffGroup = groupKey.split(String.valueOf('@'))[0];
        }
        String diffItem = param.get("diffitem");
        String dc = param.get("dc");
        Boolean forceIsDc = param.get("forceIsDC") == null ? null : Boolean.valueOf(param.get("forceIsDC"));
        Optional<Entry> recEntries = this.getEntries().stream().filter(e -> e.getDc() == -1 && e.isDi() && groupKey.equals(e.getGroup())).findFirst();
        if (!recEntries.isPresent()) return;
        String finalDiffGroup = diffGroup;
        List tmplList = this.getTmpl().getEntries().stream().filter(CheckTmpl.Entry::isDiffitem).filter(e -> finalDiffGroup.equals(e.getEntrygroup())).collect(Collectors.toList());
        if (tmplList.isEmpty()) {
            tmplList = this.getTmpl().getEntries().stream().filter(CheckTmpl.Entry::isDiffitem).filter(e -> "0".equals(e.getEntrygroup())).collect(Collectors.toList());
        }
        if (tmplList.isEmpty()) {
            return;
        }
        tmplList.sort(Comparator.comparing(CheckTmpl.Entry::getSeq));
        boolean isAb = false;
        boolean isDc = false;
        if (diffMode == 9 || diffMode == 10) {
            isDc = diffMode == 9;
            Map<Boolean, List<Entry>> entryMap = this.getEntries().stream().filter(e -> !e.isDi() && groupKey.equals(e.getGroup())).collect(Collectors.groupingBy(e -> e.getDc() == 1));
            List<Entry> entries = entryMap.get(isDc);
            if (entries == null) {
                param.put("forceIsDC", Boolean.valueOf(isDc).toString());
                this.diffProcessDiffItem(groupKey, abSum, baSum, 1, param);
                return;
            }
            Optional<Entry> maxEntry = entries.stream().max(Comparator.comparing(e -> e.getValue() == null ? BigDecimal.ZERO : e.getValue().abs()));
            if (maxEntry.isPresent()) {
                isAb = maxEntry.get().ab;
            }
        } else {
            Pair<Boolean, Boolean> abAndDc = this.getGroupDataAbAndDc(abSum, baSum, diffMode, forceIsDc);
            isAb = (Boolean)abAndDc.p1;
            isDc = (Boolean)abAndDc.p2;
        }
        BigDecimal value = this.isSingleDC() ? abSum.add(baSum) : abSum.subtract(baSum);
        boolean finalIsDc = isDc;
        int entryDc = -1;
        if (!this.isSingleDC()) {
            BigDecimal bigDecimal = value = isDc ? value.negate() : value;
            if (tmplList.size() == 1) {
                tmplEntry = (CheckTmpl.Entry)tmplList.get(0);
                value = tmplEntry.getDc() == 1 == isDc ? value : value.negate();
            } else {
                if (tmplList.size() != 2) return;
                if (StringUtils.isNotEmpty((String)diffItem)) {
                    tmplEntry = "1001".equals(diffItem) ? (CheckTmpl.Entry)tmplList.get(0) : (CheckTmpl.Entry)tmplList.get(1);
                    if (tmplEntry.getDc() == 1 == !isDc) {
                        value = value.negate();
                    }
                } else {
                    entryOptional = tmplList.stream().filter(e -> e.getDc() == 1 == finalIsDc).findFirst();
                    if (entryOptional.isPresent()) {
                        tmplEntry = entryOptional.get();
                    } else {
                        value = value.negate();
                        entryOptional2 = tmplList.stream().filter(e -> e.getDc() == 1 == !finalIsDc).findFirst();
                        if (!entryOptional2.isPresent()) return;
                        tmplEntry = entryOptional2.get();
                    }
                }
            }
            if ((tmplList.size() == 1 || tmplList.size() == 2) && value.doubleValue() < 0.0 && diffMode == 1) {
                entryDc = 1 - tmplEntry.getDc();
                value = value.negate();
            } else if ((tmplList.size() == 1 || tmplList.size() == 2) && value.doubleValue() > 0.0 && diffMode == 2) {
                entryDc = 1 - tmplEntry.getDc();
                value = value.negate();
            } else if (diffMode == 3 && value.doubleValue() < 0.0) {
                entryDc = 1 - tmplEntry.getDc();
                value = value.negate();
            } else {
                entryDc = tmplEntry.getDc();
            }
        } else {
            if (tmplList.size() == 1) {
                tmplEntry = (CheckTmpl.Entry)tmplList.get(0);
            } else {
                if (tmplList.size() != 2) return;
                if (StringUtils.isNotEmpty((String)diffItem)) {
                    tmplEntry = "1001".equals(diffItem) ? (CheckTmpl.Entry)tmplList.get(0) : (CheckTmpl.Entry)tmplList.get(1);
                } else {
                    entryOptional = tmplList.stream().filter(e -> e.getDc() == 1 == finalIsDc).findFirst();
                    if (entryOptional.isPresent()) {
                        tmplEntry = entryOptional.get();
                    } else {
                        value = value.negate();
                        entryOptional2 = tmplList.stream().filter(e -> e.getDc() == 1 == !finalIsDc).findFirst();
                        if (!entryOptional2.isPresent()) return;
                        tmplEntry = entryOptional2.get();
                    }
                }
            }
            entryDc = tmplEntry.getDc();
            if (entryDc == 1 && !isDc) {
                value = value.negate();
            }
        }
        if ("101".equals(dc)) {
            if (entryDc == 1) {
                entryDc = 1 - entryDc;
                value = value.negate();
            }
        } else if ("102".equals(dc) && entryDc == 0) {
            entryDc = 1 - entryDc;
            value = value.negate();
        }
        Entry entry = recEntries.get();
        entry.setTmplEntry(tmplEntry);
        entry.setSeq(0);
        entry.setDc(entryDc);
        entry.setAb(isAb);
        entry.setEntryscene(this.getSceneid());
        entry.setEntryyear(this.getYearid());
        entry.setEntryperiod(this.getPeriodid());
        entry.setEntryprocess(this.getProcessid());
        String small = null;
        String big = null;
        if (this.orgmap != null && !this.orgmap.isEmpty()) {
            String pair = this.orgmap.keySet().iterator().next();
            String[] ps = pair.split(String.valueOf('&'));
            if (ps[0].compareTo(ps[1]) < 0) {
                small = ps[0];
                big = ps[1];
            } else {
                big = ps[0];
                small = ps[1];
            }
        }
        entry.setEntryorg(0L);
        entry.setEntrymycompany(0L);
        entry.setEntrycompany(this.getUserDefineDimId(tmplEntry, PresetConstant.INTERNALCOMPANY_DIM, 0L));
        String mycompany = isAb ? small : big;
        String company = !isAb ? small : big;
        String entity = this.orgmap.get(mycompany + '&' + company);
        entry.setEntryorgnumber(entity == null ? mycompany : entity);
        if (tmplEntry.getMycompany() != null && tmplEntry.getMycompany() != 0L) {
            entry.setEntrymycompany(tmplEntry.getMycompany());
            entry.setEntrymycompanynumber(tmplEntry.getMycompanyNumber());
        } else {
            entry.setEntrymycompanynumber(mycompany);
        }
        entry.setEntrycompanynumber(company);
        this.setICCompanyByElimTmpl(tmplEntry, entry);
        Long acctId = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.modelid), (String)PresetConstant.ACCOUNT_DIM, (String)tmplEntry.getAccountNumbers().iterator().next()).getId();
        entry.setEntrydebitaccout(tmplEntry.getDc() == 1 ? acctId : 0L);
        entry.setEntrycreditaccout(tmplEntry.getDc() == 0 ? acctId : 0L);
        entry.setEntrychangetype(tmplEntry.getChangetype());
        entry.setEntrymultigaap(tmplEntry.getRule());
        entry.setEntrydatasort(tmplEntry.getDatasort());
        entry.setEntrycurrency(this.getCurrencyid());
        entry.setEntrydim1(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(0), entry.getEntrydim1()));
        entry.setEntrydim2(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(1), entry.getEntrydim2()));
        entry.setEntrydim3(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(2), entry.getEntrydim3()));
        entry.setEntrydim4(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(3), entry.getEntrydim4()));
        entry.setEntrydim5(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(4), entry.getEntrydim5()));
        entry.setEntrydim6(this.getUserDefineDimId(tmplEntry, (String)CheckConstant.PRESET_DIMFIELDS.get(5), entry.getEntrydim6()));
        entry.setEntryaudittrail(this.getUserDefineDimId(tmplEntry, "audittrail", entry.getEntryaudittrail()));
        entry.setEntrydebit(entryDc == 1 ? value : BigDecimal.ZERO);
        entry.setEntrycredit(entryDc != 1 ? value : BigDecimal.ZERO);
        entry.setEntrydebelimvalue(BigDecimal.ZERO);
        entry.setEntrycreelimvalue(BigDecimal.ZERO);
    }

    private void setICCompanyByElimTmpl(CheckTmpl.Entry tmplEntry, Entry entry) {
        Optional<CheckTmpl.EntryDetailWithSign> elimOpt = tmplEntry.getElimDims().stream().filter(e -> "elimcompany".equals(e.getSign())).findFirst();
        if (elimOpt.isPresent() && elimOpt.get().getNumberSet().size() == 1) {
            Optional firstIcNum = elimOpt.get().getNumberSet().stream().findFirst();
            firstIcNum.ifPresent(number -> {
                Pair<Boolean, Long> pair = ((CheckTmpl.EntryDetailWithSign)elimOpt.get()).getNumberIdMap().get(number);
                if (pair != null && ((Boolean)pair.p1).booleanValue()) {
                    entry.setEntrycompanynumber((String)number);
                    entry.setEntrycompany((Long)pair.p2);
                }
            });
        }
    }

    private Long getUserDefineDimId(CheckTmpl.Entry tmplEntry, String sign, Long orginal) {
        return CheckRecordHelper.getMemberOrDefault(tmplEntry, sign, orginal);
    }

    public class Entry
    implements IDiffEntry,
    Comparable<Entry> {
        private CheckTmpl.Entry tmplEntry;
        private Long id;
        private int seq;
        private Long entrymodel;
        private int dc;
        private boolean di;
        private boolean ab;
        private Long entryscene;
        private Long entryyear;
        private Long entryperiod;
        private Long entryprocess;
        private Long entryaudittrail;
        private Long entryorg;
        private Long entrymycompany;
        private Long entrycompany;
        private String entryorgnumber;
        private String entrymycompanynumber;
        private String entrycompanynumber;
        private Long entrydebitaccout;
        private Long entrycreditaccout;
        private Long entrychangetype;
        private Long entrymultigaap;
        private Long entrydatasort;
        private Long entrycurrency;
        private Long entrydim1;
        private Long entrydim2;
        private Long entrydim3;
        private Long entrydim4;
        private Long entrydim5;
        private Long entrydim6;
        private BigDecimal entrydebit;
        private BigDecimal entrycredit;
        private BigDecimal entrydebelimval;
        private BigDecimal entrycreelimval;
        private String sortKey;
        private BigDecimal myecmoney;
        private BigDecimal opecmoney;
        private String mycvtpath;
        private String opcvtpath;
        private BigDecimal myrate;
        private BigDecimal oprate;
        private BigDecimal mycvtmoney;
        private BigDecimal opcvtmoney;
        private BigDecimal cvtdifmoney;
        private Long myaccount;
        private Long opaccount;
        private boolean merge;
        private int entryDiffMode;
        private int entryDiffMethod;
        private int diffType;
        private BigDecimal ocmoney;
        private String group;
        private Long MappingAccountId;

        public BigDecimal getEntrydebelimval() {
            return this.entrydebelimval;
        }

        public void setEntrydebelimval(BigDecimal entrydebelimval) {
            this.entrydebelimval = entrydebelimval;
        }

        public BigDecimal getEntrycreelimval() {
            return this.entrycreelimval;
        }

        public void setEntrycreelimval(BigDecimal entrycreelimval) {
            this.entrycreelimval = entrycreelimval;
        }

        public BigDecimal getMyecmoney() {
            return this.myecmoney;
        }

        public void setMyecmoney(BigDecimal myecmoney) {
            this.myecmoney = myecmoney;
        }

        public BigDecimal getOpecmoney() {
            return this.opecmoney;
        }

        public void setOpecmoney(BigDecimal opecmoney) {
            this.opecmoney = opecmoney;
        }

        public String getMycvtpath() {
            return this.mycvtpath;
        }

        public void setMycvtpath(String mycvtpath) {
            this.mycvtpath = mycvtpath;
        }

        public String getOpcvtpath() {
            return this.opcvtpath;
        }

        public void setOpcvtpath(String opcvtpath) {
            this.opcvtpath = opcvtpath;
        }

        public BigDecimal getMyrate() {
            return this.myrate;
        }

        public void setMyrate(BigDecimal myrate) {
            this.myrate = myrate;
        }

        public BigDecimal getOprate() {
            return this.oprate;
        }

        public void setOprate(BigDecimal oprate) {
            this.oprate = oprate;
        }

        public BigDecimal getMycvtmoney() {
            return this.mycvtmoney;
        }

        public void setMycvtmoney(BigDecimal mycvtmoney) {
            this.mycvtmoney = mycvtmoney;
        }

        public BigDecimal getOpcvtmoney() {
            return this.opcvtmoney;
        }

        public void setOpcvtmoney(BigDecimal opcvtmoney) {
            this.opcvtmoney = opcvtmoney;
        }

        public BigDecimal getCvtdifmoney() {
            return this.cvtdifmoney;
        }

        public void setCvtdifmoney(BigDecimal cvtdifmoney) {
            this.cvtdifmoney = cvtdifmoney;
        }

        public Long getMyaccount() {
            return this.myaccount;
        }

        public void setMyaccount(Long myaccount) {
            this.myaccount = myaccount;
        }

        public Long getOpaccount() {
            return this.opaccount;
        }

        public void setOpaccount(Long opaccount) {
            this.opaccount = opaccount;
        }

        public CheckTmpl.Entry getTmplEntry() {
            return this.tmplEntry;
        }

        public void setTmplEntry(CheckTmpl.Entry tmplEntry) {
            this.tmplEntry = tmplEntry;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int seq) {
            this.seq = seq;
        }

        public Long getEntrymodel() {
            return this.entrymodel;
        }

        public void setEntrymodel(Long entrymodel) {
            this.entrymodel = entrymodel;
        }

        public int getDc() {
            return this.dc;
        }

        public Long getEntryscene() {
            return this.entryscene;
        }

        public void setEntryscene(Long entryscene) {
            this.entryscene = entryscene;
        }

        public Long getEntryyear() {
            return this.entryyear;
        }

        public void setEntryyear(Long entryyear) {
            this.entryyear = entryyear;
        }

        public Long getEntryperiod() {
            return this.entryperiod;
        }

        public void setEntryperiod(Long entryperiod) {
            this.entryperiod = entryperiod;
        }

        public Long getEntryprocess() {
            return this.entryprocess;
        }

        public void setEntryprocess(Long entryprocess) {
            this.entryprocess = entryprocess;
        }

        public Long getEntryaudittrail() {
            return this.entryaudittrail;
        }

        public void setEntryaudittrail(Long entryaudittrail) {
            this.entryaudittrail = entryaudittrail;
        }

        public Long getEntryorg() {
            return this.entryorg;
        }

        public void setEntryorg(Long entryorg) {
            this.entryorg = entryorg;
        }

        public Long getEntrycompany() {
            return this.entrycompany;
        }

        public void setEntrycompany(Long entrycompany) {
            this.entrycompany = entrycompany;
        }

        public Long getEntrydebitaccout() {
            return this.entrydebitaccout;
        }

        public void setEntrydebitaccout(Long entrydebitaccout) {
            this.entrydebitaccout = entrydebitaccout;
        }

        public Long getEntrycreditaccout() {
            return this.entrycreditaccout;
        }

        public void setEntrycreditaccout(Long entrycreditaccout) {
            this.entrycreditaccout = entrycreditaccout;
        }

        public Long getEntrychangetype() {
            return this.entrychangetype;
        }

        public void setEntrychangetype(Long entrychangetype) {
            this.entrychangetype = entrychangetype;
        }

        public Long getEntrymultigaap() {
            return this.entrymultigaap;
        }

        public void setEntrymultigaap(Long entrymultigaap) {
            this.entrymultigaap = entrymultigaap;
        }

        public Long getEntrycurrency() {
            return this.entrycurrency;
        }

        public void setEntrycurrency(Long entrycurrency) {
            this.entrycurrency = entrycurrency;
        }

        public Long getEntrydim1() {
            return this.entrydim1;
        }

        public void setEntrydim1(Long entrydim1) {
            this.entrydim1 = entrydim1;
        }

        public Long getEntrydim2() {
            return this.entrydim2;
        }

        public void setEntrydim2(Long entrydim2) {
            this.entrydim2 = entrydim2;
        }

        public Long getEntrydim3() {
            return this.entrydim3;
        }

        public void setEntrydim3(Long entrydim3) {
            this.entrydim3 = entrydim3;
        }

        public Long getEntrydim4() {
            return this.entrydim4;
        }

        public void setEntrydim4(Long entrydim4) {
            this.entrydim4 = entrydim4;
        }

        public Long getEntrydim5() {
            return this.entrydim5;
        }

        public void setEntrydim5(Long entrydim5) {
            this.entrydim5 = entrydim5;
        }

        public Long getEntrydim6() {
            return this.entrydim6;
        }

        public void setEntrydim6(Long entrydim6) {
            this.entrydim6 = entrydim6;
        }

        public BigDecimal getEntrydebit() {
            return this.entrydebit;
        }

        public void setEntrydebit(BigDecimal entrydebit) {
            this.entrydebit = entrydebit;
        }

        public BigDecimal getEntrycredit() {
            return this.entrycredit;
        }

        public void setEntrycredit(BigDecimal entrycredit) {
            this.entrycredit = entrycredit;
        }

        public BigDecimal getEntrydebelimvalue() {
            return this.entrydebelimval;
        }

        public void setEntrydebelimvalue(BigDecimal entrydebelimval) {
            this.entrydebelimval = entrydebelimval;
        }

        public BigDecimal getEntrycreelimvalue() {
            return this.entrycreelimval;
        }

        public void setEntrycreelimvalue(BigDecimal entrycreelimval) {
            this.entrycreelimval = entrycreelimval;
        }

        public Long getEntrymycompany() {
            return this.entrymycompany;
        }

        public void setEntrymycompany(Long entrymycompany) {
            this.entrymycompany = entrymycompany;
        }

        public String getEntryorgnumber() {
            return this.entryorgnumber;
        }

        public void setEntryorgnumber(String entryorgnumber) {
            this.entryorgnumber = entryorgnumber;
        }

        public String getEntrymycompanynumber() {
            return this.entrymycompanynumber;
        }

        public void setEntrymycompanynumber(String entrymycompanynumber) {
            this.entrymycompanynumber = entrymycompanynumber;
        }

        public String getEntrycompanynumber() {
            return this.entrycompanynumber;
        }

        public void setEntrycompanynumber(String entrycompanynumber) {
            this.entrycompanynumber = entrycompanynumber;
        }

        public Long getEntrydatasort() {
            return this.entrydatasort;
        }

        public void setEntrydatasort(Long entrydatasort) {
            this.entrydatasort = entrydatasort;
        }

        public boolean isMerge() {
            return this.merge;
        }

        public void setMerge(boolean merge) {
            this.merge = merge;
        }

        public int getEntryDiffMode() {
            return this.entryDiffMode;
        }

        @Override
        public void setEntryDiffMode(int entryDiffMode) {
            this.entryDiffMode = entryDiffMode;
        }

        public int getEntryDiffMethod() {
            return this.entryDiffMethod;
        }

        @Override
        public void setEntryDiffMethod(int entryDiffMethod) {
            this.entryDiffMethod = entryDiffMethod;
        }

        public int getDiffType() {
            return this.diffType;
        }

        @Override
        public void setDiffType(int diffType) {
            this.diffType = diffType;
        }

        public BigDecimal getOcmoney() {
            return this.ocmoney;
        }

        public void setOcmoney(BigDecimal ocmoney) {
            this.ocmoney = ocmoney;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("seq=").append(this.seq).append(',');
            sb.append("entrymodel=").append(this.entrymodel).append(',');
            sb.append("dc=").append(this.dc).append(',');
            sb.append("entryscene=").append(this.entryscene).append(',');
            sb.append("entryyear=").append(this.entryyear).append(',');
            sb.append("entryperiod=").append(this.entryperiod).append(',');
            sb.append("entryprocess=").append(this.entryprocess).append(',');
            sb.append("entryaudittrail=").append(this.entryaudittrail).append(',');
            sb.append("entryorg=").append(this.entryorg).append(',');
            sb.append("entrymycompany=").append(this.entrymycompany).append(',');
            sb.append("entrycompany=").append(this.entrycompany).append(',');
            sb.append("entrydebitaccout=").append(this.entrydebitaccout).append(',');
            sb.append("entrycreditaccout=").append(this.entrycreditaccout).append(',');
            sb.append("entrychangetype=").append(this.entrychangetype).append(',');
            sb.append("entrymultigaap=").append(this.entrymultigaap).append(',');
            sb.append("entrycurrency=").append(this.entrycurrency).append(',');
            sb.append("entrydim1=").append(this.entrydim1).append(',');
            sb.append("entrydim2=").append(this.entrydim2).append(',');
            sb.append("entrydim3=").append(this.entrydim3).append(',');
            sb.append("entrydim4=").append(this.entrydim4).append(',');
            sb.append("entrydim5=").append(this.entrydim5).append(',');
            sb.append("entrydim6=").append(this.entrydim6).append(',');
            sb.append("entrydebit=").append(this.entrydebit).append(',');
            sb.append("entrycredit=").append(this.entrycredit).append(',');
            sb.append("entrydebelimval=").append(this.entrydebelimval).append(',');
            sb.append("entrycreelimval=").append(this.entrycreelimval);
            return sb.toString();
        }

        @Override
        public BigDecimal getValue() {
            return this.dc == 1 ? this.entrydebit : this.entrycredit.negate();
        }

        @Override
        public BigDecimal getOCValue() {
            return this.dc == 1 ? this.ocmoney : this.ocmoney.negate();
        }

        @Override
        public void setValue(BigDecimal v) {
            if (this.dc == 1) {
                this.setEntrydebit(v);
            } else {
                this.setEntrycredit(v);
            }
        }

        public void setElimValue(BigDecimal v) {
            if (this.dc == 1) {
                this.setEntrydebelimvalue(v);
                this.setEntrycreelimvalue(BigDecimal.ZERO);
            } else {
                this.setEntrydebelimvalue(BigDecimal.ZERO);
                this.setEntrycreelimvalue(v);
            }
        }

        @Override
        public boolean isAb() {
            return this.ab;
        }

        public void setAb(boolean ab) {
            this.ab = ab;
        }

        @Override
        public boolean isDi() {
            return this.di;
        }

        public void setDi(boolean di) {
            this.di = di;
        }

        public boolean isAbDc() {
            return this.isAb() ^ this.isDc();
        }

        @Override
        public String getGroup() {
            if (StringUtils.isNotEmpty((String)this.group)) {
                return this.group;
            }
            String checkConfig = CheckRecord.this.getCheckconfig();
            Set<Object> dimSets = null;
            dimSets = !StringUtils.isEmpty((String)checkConfig) ? Stream.of(checkConfig.split(",")).collect(Collectors.toSet()) : new HashSet(16);
            StringBuilder sb = new StringBuilder();
            if (this.tmplEntry != null) {
                sb.append(StringUtils.isEmpty((String)this.tmplEntry.getEntrygroup()) ? "1" : this.tmplEntry.getEntrygroup());
                sb.append('@');
            }
            sb.append(this.getEntrydim1() != null && dimSets.contains("1") ? this.getEntrydim1().toString() : " ");
            sb.append('&');
            sb.append(this.getEntrydim2() != null && dimSets.contains("2") ? this.getEntrydim2().toString() : " ");
            sb.append('&');
            sb.append(this.getEntrydim3() != null && dimSets.contains("3") ? this.getEntrydim3().toString() : " ");
            sb.append('&');
            sb.append(this.getEntrydim4() != null && dimSets.contains("4") ? this.getEntrydim4().toString() : " ");
            sb.append('&');
            sb.append(this.getEntrydim5() != null && dimSets.contains("5") ? this.getEntrydim5().toString() : " ");
            sb.append('&');
            sb.append(this.getEntrydim6() != null && dimSets.contains("6") ? this.getEntrydim6().toString() : " ");
            sb.append('&');
            sb.append(this.getEntryaudittrail() != null && dimSets.contains("7") ? this.getEntryaudittrail().toString() : " ");
            this.group = sb.toString();
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        @Override
        public boolean isDc() {
            return this.dc == 1;
        }

        public void setDc(int dc) {
            this.dc = dc;
        }

        @Override
        public int compareTo(Entry o) {
            return this.getSortKey().compareTo(o.getSortKey());
        }

        public String getSortKey() {
            return this.sortKey;
        }

        public void setSortKey(String sortKey) {
            this.sortKey = sortKey;
        }

        public String genSortKey() {
            return this.genSortKey(this.getGroup());
        }

        public Long getMappingAccountId() {
            return this.MappingAccountId;
        }

        public void setMappingAccountId(Long mappingAccountId) {
            this.MappingAccountId = mappingAccountId;
        }

        public String genSortKey(String group) {
            String tmplEntrySeq;
            String string = tmplEntrySeq = this.tmplEntry == null ? "" : String.format("%05d", this.tmplEntry.getSeq());
            char seq = this.isDi() ? (char)'3' : (this.isDc() ? (char)'1' : '2');
            return group + seq + tmplEntrySeq;
        }

        public Entry copyEntity(String groupKey) {
            Entry entry = new Entry();
            entry.setEntrydebelimval(BigDecimal.ZERO);
            entry.setEntrycreelimval(BigDecimal.ZERO);
            entry.setMyecmoney(BigDecimal.ZERO);
            entry.setOpecmoney(BigDecimal.ZERO);
            entry.setMycvtpath("");
            entry.setOpcvtpath("");
            entry.setMyrate(BigDecimal.ZERO);
            entry.setOprate(this.oprate);
            entry.setMycvtmoney(BigDecimal.ZERO);
            entry.setOpcvtmoney(BigDecimal.ZERO);
            entry.setCvtdifmoney(BigDecimal.ZERO);
            entry.setMyaccount(this.myaccount);
            entry.setOpaccount(this.opaccount);
            entry.setTmplEntry(this.tmplEntry);
            entry.setId(GlobalIdUtil.genGlobalLongId());
            entry.setSeq(0);
            entry.setEntrymodel(this.entrymodel);
            entry.setEntryscene(this.entryscene);
            entry.setEntryyear(this.entryyear);
            entry.setEntryperiod(this.entryperiod);
            entry.setEntryprocess(this.entryprocess);
            entry.setEntryaudittrail(this.entryaudittrail);
            entry.setEntryorg(this.entryorg);
            entry.setEntrycompany(this.entrycompany);
            entry.setEntrydebitaccout(this.entrydebitaccout);
            entry.setEntrycreditaccout(this.entrycreditaccout);
            entry.setEntrychangetype(this.entrychangetype);
            entry.setEntrymultigaap(this.entrymultigaap);
            entry.setEntrycurrency(this.entrycurrency);
            entry.setEntrydim1(this.entrydim1);
            entry.setEntrydim2(this.entrydim2);
            entry.setEntrydim3(this.entrydim3);
            entry.setEntrydim4(this.entrydim4);
            entry.setEntrydim5(this.entrydim5);
            entry.setEntrydim6(this.entrydim6);
            entry.setEntrydebit(this.entrydebit);
            entry.setEntrycredit(this.entrycredit);
            entry.setEntrydebelimvalue(this.entrydebelimval);
            entry.setEntrycreelimvalue(this.entrycreelimval);
            entry.setEntrymycompany(this.entrymycompany);
            entry.setEntryorgnumber(this.entryorgnumber);
            entry.setEntrymycompanynumber(this.entrymycompanynumber);
            entry.setEntrycompanynumber(this.entrycompanynumber);
            entry.setEntrydatasort(this.entrydatasort);
            entry.setMerge(false);
            entry.setValue(BigDecimal.ZERO);
            entry.setElimValue(BigDecimal.ZERO);
            entry.setAb(this.ab);
            entry.setDi(this.di);
            entry.setDc(this.dc);
            entry.setGroup(this.group);
            entry.setSortKey(entry.genSortKey(groupKey));
            entry.setEntryDiffMode(this.entryDiffMode);
            entry.setEntryDiffMethod(this.entryDiffMethod);
            entry.setDiffType(this.diffType);
            entry.setOcmoney(this.ocmoney);
            return entry;
        }
    }
}

