/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.check.entrydetail.CheckTmplDetailModel;
import kd.fi.bcm.business.check.entrydetail.CheckTmplEntryDetail;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.ElimTypeEnum;

public class CheckTmplModel {
    private static final String key_dim = "dim";
    private static final String key_elimdim = "elimdim";
    private String number;
    private Long id;
    private String name;
    private BigDecimal diffLimit;
    private int diffMode;
    private int elimType;
    private List<Map<String, Object>> entries;

    public CheckTmplModel() {
    }

    public CheckTmplModel(List<String> userDefineDims, List<DynamicObject> dos, Map<String, String> fieldMapped) {
        if (dos != null && dos.size() > 0) {
            this.initHead(dos.get(0));
            this.initEntries(userDefineDims, dos, fieldMapped);
        }
    }

    private void initHead(DynamicObject dynaObj) {
        this.id = dynaObj.getLong("template.id");
        this.diffMode = dynaObj.getInt("template.diffmode");
        this.elimType = dynaObj.get("template.elimtype") != null && !StringUtils.isEmpty((String)dynaObj.get("template.elimtype").toString()) ? dynaObj.getInt("template.elimtype") : ElimTypeEnum.EICA.getValue();
        this.number = dynaObj.getString("template.number");
        this.name = dynaObj.getString("template.name");
    }

    private void initEntries(List<String> userDefineDims, List<DynamicObject> dynaObjs, Map<String, String> fieldMapped) {
        this.entries = new ArrayList<Map<String, Object>>(dynaObjs.size());
        CheckTmplDetailModel checkTmplDetailModel = null;
        if (fieldMapped.size() > 0) {
            Set<Long> entryIds = dynaObjs.stream().map(e -> e.getLong("tmplentryid")).collect(Collectors.toSet());
            checkTmplDetailModel = new CheckTmplDetailModel(entryIds);
        }
        int diCount = 0;
        int dc = 0;
        for (DynamicObject dynamicObject : dynaObjs) {
            HashMap<String, Object> entry = new HashMap<String, Object>(16);
            this.setExistValue2Map(entry, dynamicObject, "accountid");
            this.setExistValue2Map(entry, dynamicObject, PresetConstant.ACCOUNT_DIM);
            this.setExistValue2Map(entry, dynamicObject, "companyid");
            this.setExistValue2Map(entry, dynamicObject, PresetConstant.INTERNALCOMPANY_DIM);
            this.setExistValue2Map(entry, dynamicObject, "changetypeid");
            this.setExistValue2Map(entry, dynamicObject, PresetConstant.CHANGETYPE_DIM);
            this.setExistValue2Map(entry, dynamicObject, "multigaapid");
            this.setExistValue2Map(entry, dynamicObject, PresetConstant.RULE_DIM);
            this.setExistValue2Map(entry, dynamicObject, "datasortid");
            this.setExistValue2Map(entry, dynamicObject, PresetConstant.DATASORT_DIM);
            this.setExistValue2Map(entry, dynamicObject, "diffitem");
            this.setExistValue2Map(entry, dynamicObject, "dc");
            if (fieldMapped.size() > 0) {
                for (String field : CheckConstant.PRESET_DIMFIELDS) {
                    String fieldValue = fieldMapped.get(field);
                    if (null == fieldValue) continue;
                    Long entryId = dynamicObject.getLong("tmplentryid");
                    List<CheckTmplEntryDetail> result = null;
                    if (checkTmplDetailModel != null) {
                        result = checkTmplDetailModel.getDetailByEntryAndDimKey(entryId, field, false);
                    }
                    if (result != null) {
                        entry.put(fieldValue, result);
                    }
                    if (checkTmplDetailModel == null) continue;
                    List<CheckTmplEntryDetail> elimResult = checkTmplDetailModel.getDetailByEntryAndDimKey(entryId, "elim" + field, true);
                    if (result == null) continue;
                    entry.put("elim" + fieldValue, elimResult);
                }
            }
            if (dynamicObject.getBoolean("diffitem")) {
                entry.put("di", "1");
                ++diCount;
                dc = dynamicObject.getInt("dc");
            } else {
                entry.put("di", "0");
            }
            entry.put(key_dim, this.getDim(entry, userDefineDims));
            entry.put(key_elimdim, this.getElimDim(entry, userDefineDims));
            this.entries.add(entry);
        }
        if (diCount == 1) {
            for (Map map : this.entries) {
                if (Integer.parseInt(map.get("dc").toString()) == dc || Integer.parseInt(map.get("di").toString()) != 0) continue;
                map.put("di", 1);
                break;
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getDiffLimit() {
        return this.diffLimit;
    }

    public void setDiffLimit(BigDecimal diffLimit) {
        this.diffLimit = diffLimit;
    }

    public int getDiffMode() {
        return this.diffMode;
    }

    public String getNumber() {
        return this.number;
    }

    public List<Map<String, Object>> getEntries() {
        return this.entries;
    }

    public String getName() {
        return this.name;
    }

    public void setDiffMode(int diffMode) {
        this.diffMode = diffMode;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEntries(List<Map<String, Object>> entries) {
        this.entries = entries;
    }

    public String toString() {
        return "elimType:" + this.elimType + ",id:" + this.id + ",number:" + this.number + ",name:" + this.name + ",diffMode:" + this.diffMode + "entries:" + this.entries;
    }

    private void setExistValue2Map(Map<String, Object> entry, DynamicObject e, String key) {
        Object o = e.get(key);
        if (o != null) {
            entry.put(key, o);
        }
    }

    private String getDim(Map<String, Object> entry, List<String> userDefineDims) {
        StringBuilder dimStr = new StringBuilder();
        dimStr.append(entry.get(PresetConstant.ACCOUNT_DIM));
        dimStr.append('@');
        dimStr.append(entry.get(PresetConstant.CHANGETYPE_DIM));
        for (String dim : userDefineDims) {
            dimStr.append('@');
            dimStr.append(entry.get(dim));
        }
        return dimStr.toString();
    }

    private Object getElimDim(Map<String, Object> entry, List<String> userDefineDims) {
        StringBuilder dimStr = new StringBuilder();
        dimStr.append(entry.get(PresetConstant.ACCOUNT_DIM));
        dimStr.append('@');
        dimStr.append(entry.get(PresetConstant.CHANGETYPE_DIM));
        for (String dim : userDefineDims) {
            dimStr.append('@');
            dimStr.append(entry.get("elim" + dim));
        }
        return dimStr.toString();
    }
}

