/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.helper.CheckRecordHelper;
import kd.fi.bcm.business.check.model.key.CheckTmpl;
import kd.fi.bcm.business.check.model.key.EntityKey;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.PresetConstant;

public class ReportData {
    private Row row;
    private Map<String, String> fieldMapped;
    private BigDecimal ecValue;
    private BigDecimal value;
    private BigDecimal ocValue;
    private String ec;
    private String tc;

    public ReportData(Row row, Map<String, String> fieldMapped) {
        this.row = row;
        this.fieldMapped = fieldMapped;
    }

    public void setEcValue(BigDecimal ecValue) {
        this.ecValue = ecValue;
    }

    public void setEc(String ec) {
        this.ec = ec;
    }

    public void setTc(String tc) {
        this.tc = tc;
    }

    public BigDecimal getEcValue() {
        return this.ecValue;
    }

    public String getEc() {
        return this.ec;
    }

    public String getTc() {
        return this.tc;
    }

    public Row getRow() {
        return this.row;
    }

    public String getEntity() {
        return CheckUtil.convertToRealEntity(this.row.getString(PresetConstant.ENTITY_DIM));
    }

    public String getAccount() {
        return this.row.getString(PresetConstant.ACCOUNT_DIM);
    }

    public String getYear() {
        return this.row.getString(PresetConstant.FY_DIM);
    }

    public String getPeriod() {
        return this.row.getString(PresetConstant.PERIOD_DIM);
    }

    public String getScenario() {
        return this.row.getString(PresetConstant.SCENE_DIM);
    }

    public String getProcess() {
        return this.row.getString(PresetConstant.PROCESS_DIM);
    }

    public String getCurrency() {
        return this.row.getString(PresetConstant.CURRENCY_DIM);
    }

    public String getAudittrail() {
        return this.row.getString(PresetConstant.AUDITTRIAL_DIM);
    }

    public String getChangetype() {
        return this.row.getString(PresetConstant.CHANGETYPE_DIM);
    }

    public String getInternalcompany() {
        return this.row.getString(PresetConstant.INTERNALCOMPANY_DIM);
    }

    public String getMultigaap() {
        return this.row.getString(PresetConstant.RULE_DIM);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public String getMycompany() {
        return CheckUtil.convertToRealEntity(this.row.getString(PresetConstant.MYCOMPANY_DIM));
    }

    public String getDatasort() {
        return this.row.getString(PresetConstant.DATASORT_DIM);
    }

    public String getDim1() {
        return this.row.getString(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(0)));
    }

    public String getDim2() {
        return this.row.getString(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(1)));
    }

    public String getDim3() {
        return this.row.getString(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(2)));
    }

    public String getDim4() {
        return this.row.getString(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(3)));
    }

    public String getDim5() {
        return this.row.getString(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(4)));
    }

    public String getDim6() {
        return this.row.getString(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(5)));
    }

    public BigDecimal getOcValue() {
        return this.ocValue;
    }

    public void setOcValue(BigDecimal ocValue) {
        this.ocValue = ocValue;
    }

    public EntityKey genEntityKey() {
        return EntityKey.genKey(StringUtils.isEmpty((String)this.getMycompany()) ? this.getEntity() : this.getMycompany(), this.getInternalcompany());
    }

    public CheckTmpl genCheckTmplKey(List<CheckTmpl> tmpls) {
        if (tmpls == null) {
            return null;
        }
        for (CheckTmpl tmpl : tmpls) {
            if (!CheckRecordHelper.matchReportDataAndCheckTmpl(this, tmpl)) continue;
            return tmpl;
        }
        return new CheckTmpl();
    }

    public String toString() {
        return Objects.toString(this.row);
    }
}

