/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.sum;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.check.model.key.EntityKey;
import kd.fi.bcm.common.Tuple;

public class CheckEntryData
extends HashMap<String, Object> {
    public CheckEntryData(DynamicObject header, DynamicObject entry) {
        this.transferDynaObj2Data(header, entry);
    }

    private void transferDynaObj2Data(DynamicObject header, DynamicObject entry) {
        String headerOpNumber = header.getString("oppositeentity.number");
        this.put("headerId", header.get("id"));
        this.put("mergeLongNumber", header.getString("entity.longnumber"));
        this.put("status", header.getString("status"));
        this.put("isautoelim", header.getString("isautoelim"));
        this.put("checkTmplId", header.getLong("checktmpl.id"));
        this.put("entryId", entry.getLong("entryid"));
        this.put("isdiffitem", entry.getBoolean("isdiffitem"));
        this.put("checkTmplEntryId", entry.getLong("checktmplentry"));
        if (Objects.equals(headerOpNumber, entry.get("entrycompany.number"))) {
            this.put("myOrgId", header.getLong("myentity.id"));
            this.put("myOrgNumber", header.getString("myentity.number"));
            this.put("myOrgLongNumber", header.getString("myentity.longnumber"));
            this.put("opOrgId", header.getLong("oppositeentity.id"));
            this.put("opOrgNumber", header.getString("oppositeentity.number"));
            this.put("opOrgLongNumber", header.getString("oppositeentity.longnumber"));
        } else {
            this.put("opOrgId", header.getLong("myentity.id"));
            this.put("opOrgNumber", header.getString("myentity.number"));
            this.put("opOrgLongNumber", header.getString("myentity.longnumber"));
            this.put("myOrgId", header.getLong("oppositeentity.id"));
            this.put("myOrgNumber", header.getString("oppositeentity.number"));
            this.put("myOrgLongNumber", header.getString("oppositeentity.longnumber"));
        }
        BigDecimal entrydebit = entry.getBigDecimal("entrydebit") == null ? BigDecimal.ZERO : entry.getBigDecimal("entrydebit");
        BigDecimal entrycredit = entry.getBigDecimal("entrycredit") == null ? BigDecimal.ZERO : entry.getBigDecimal("entrycredit");
        BigDecimal entrydebelimval = entry.getBigDecimal("entrydebelimval") == null ? BigDecimal.ZERO : entry.getBigDecimal("entrydebelimval");
        BigDecimal entrycreelimval = entry.getBigDecimal("entrycreelimval") == null ? BigDecimal.ZERO : entry.getBigDecimal("entrycreelimval");
        this.put("entryCvtMoney", entrycredit.subtract(entrydebit));
        this.put("entryElimMoney", entrydebelimval.subtract(entrycreelimval));
    }

    public Long getCheckTmplId() {
        return (Long)this.get("checkTmplId");
    }

    public String getMergeLongNumber() {
        return (String)this.get("mergeLongNumber");
    }

    public Long getHeaderId() {
        return (Long)this.get("headerId");
    }

    public Long getEntryId() {
        return (Long)this.get("entryId");
    }

    public String isautoelim() {
        return (String)this.get("isautoelim");
    }

    public String getStatus() {
        return (String)this.get("status");
    }

    public Long getCheckTmplEntryId() {
        return (Long)this.get("checkTmplEntryId");
    }

    public Boolean isdiffitem() {
        return (Boolean)this.get("isdiffitem");
    }

    public EntityKey genDirectEntityKey() {
        return EntityKey.genKey((String)this.getDirectMyOrg().p2, (String)this.getDirectOpOrg().p2);
    }

    public Boolean isAbByDirectEntity() {
        return ((String)this.getDirectMyOrg().p2).compareTo((String)this.getDirectOpOrg().p2) < 0;
    }

    public BigDecimal getEntryCvtMoney() {
        return this.get("entryCvtMoney", BigDecimal.ZERO);
    }

    public BigDecimal getEntryElimMoney() {
        return this.get("entryElimMoney", BigDecimal.ZERO);
    }

    public Tuple<Long, String, String> getMyOrg() {
        return Tuple.create(this.get("myOrgId"), this.get("myOrgNumber"), this.get("myOrgLongNumber"));
    }

    public Tuple<Long, String, String> getOpOrg() {
        return Tuple.create(this.get("opOrgId"), this.get("opOrgNumber"), this.get("opOrgLongNumber"));
    }

    public Tuple<Long, String, String> getDirectMyOrg() {
        return (Tuple)this.get("directMyOrgTuple");
    }

    public void setDirectMyOrg(Tuple<Long, String, String> directMyOrg) {
        this.put("directMyOrgTuple", directMyOrg);
    }

    public Tuple<Long, String, String> getDirectOpOrg() {
        return (Tuple)this.get("directOpOrgTuple");
    }

    public void setDirectOpOrg(Tuple<Long, String, String> directOpOrg) {
        this.put("directOpOrgTuple", directOpOrg);
    }

    public <T> T get(String key) {
        return (T)super.get(key);
    }

    public <T> T get(String key, T defaultVal) {
        return this.get(key) == null ? defaultVal : this.get(key);
    }

    public boolean containsKey(String key) {
        return super.containsKey(key.toLowerCase(Locale.ENGLISH));
    }

    public <T> T remove(String key) {
        return (T)super.remove(key.toLowerCase(Locale.ENGLISH));
    }
}

