/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.sum;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.allinone.util.AllInOneUtils;
import kd.fi.bcm.business.check.CheckContext;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.CheckResult;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.helper.CheckServiceHelper;
import kd.fi.bcm.business.check.model.key.EntityKey;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;

public class CheckSumHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(CheckSumHelper.class);
    public static final int PAGE_SIZE = 10000;
    private static final String key_orgreadonly = "key_orgreadonly";
    private static final String key_orgstatus = "key_orgstatus";
    private static final String key_tmplcheckfail = "key_tmplcheckfail";
    private static final String key_periodentrystatus = "key_periodentrystatus";
    private static final String key_sumrecordstatus = "key_sumrecordstatus";
    private static final String key_checkrecordstatus = "key_checkrecordstatus";
    private static final String key_checkrecorddeleted = "key_checkrecorddeleted";
    private static final String key_executecheckdirecterror = "key_executecheckdirecterror";
    private static final String key_executeunAuditerror = "key_executeunAuditerror";
    private static final String key_executeunAuditLock = "key_executeunAuditLock";
    private static final String key_adjustunautolock = "key_adjustunautolock";
    private static final String key_adjustsharelock = "key_adjustsharelock";
    private static final String key_quoteLocked = "key_quoteLocked";
    public static final String RECORD_SELECT_FIELDS = "id,number,model.id,checktmpl.id,entity.id,entity.number,entity.longnumber,myentity.id,myentity.number,myentity.longnumber, oppositeentity.id,oppositeentity.number,oppositeentity.longnumber,currency.number,cvtdifmoney,diffmode, status, isautoelim";
    public static final String ENTRY_SELECT_FIELDS = "id,entryentity.id as entryid,entryentity.checktmplentry as checktmplentry, entryentity.isdiffitem as isdiffitem,entryentity.entrydebit as entrydebit,entryentity.entrycredit as entrycredit,entryentity.entrydebelimval as entrydebelimval,entryentity.entrycreelimval as entrycreelimval,entryentity.entrycompany.id as entrycompany.id,entryentity.entrycompany.number as entrycompany.number,entryentity.entrymycompany.id as entrymycompany.id,entryentity.entryorg.id as entryorg.id,entryentity.entrydiffmode as entrydiffmode,entryentity.entrymycvtmoney as entrymycvtmoney,entryentity.entryopcvtmoney as entryopcvtmoney,entryentity.difftype as difftype,entryentity.seq as seq,entryentity.groupkey as groupkey";

    public static Map<String, String> getOrgCurrencyMap(CheckParam checkParam) {
        HashMap<String, String> currencyMap = new HashMap<String, String>(checkParam.getMergeEntityIds().size());
        QFilter modelQf = new QFilter("model", "=", checkParam.getModel().p1);
        QFilter idQf = new QFilter("id", "in", checkParam.getMergeEntityIds());
        DynamicObjectCollection orgs = OrgCurrencyServiceHelper.getOrgsCurrency(new QFilter[]{modelQf, idQf}, (Long)checkParam.getYear().p1, (Long)checkParam.getPeriod().p1);
        orgs.forEach(dy -> currencyMap.put(dy.getString("number"), dy.getString("currency.number")));
        return currencyMap;
    }

    public static Pair<Long, Long> getMyOpEntityIdByEntityKey(EntityKey key, Map<String, Long> orgNum2IdMap) {
        if (key.getMycompany().compareTo(key.getCompany()) < 0) {
            return Pair.onePair((Object)orgNum2IdMap.get(key.getMycompany()), (Object)orgNum2IdMap.get(key.getCompany()));
        }
        return Pair.onePair((Object)orgNum2IdMap.get(key.getCompany()), (Object)orgNum2IdMap.get(key.getMycompany()));
    }

    public static void batchDealRecordSumNumber(List<DynamicObject> checkRecordSumList, Map<String, String> checkRecordSumNums) {
        ArrayList needGetCodeRuleNums = new ArrayList(16);
        checkRecordSumList.forEach(e -> {
            String num = (String)checkRecordSumNums.get(CheckSumHelper.genCacheKey(e));
            if (StringUtils.isEmpty((Object)num)) {
                needGetCodeRuleNums.add(e);
            } else {
                e.set("number", (Object)num);
            }
        });
        if (needGetCodeRuleNums.size() > 0) {
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checkrecordsum");
            dy.set("createtime", (Object)TimeServiceHelper.now());
            String[] number = CodeRuleServiceHelper.getBatchNumber((String)"bcm_checkrecordsum", (DynamicObject)dy, null, (int)needGetCodeRuleNums.size());
            if (number == null || number.length != needGetCodeRuleNums.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7f16\u7801\u5931\u8d25\uff0c\u8bf7\u7ef4\u62a4\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"CheckRecordHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            for (int i = 0; i < needGetCodeRuleNums.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)needGetCodeRuleNums.get(i);
                dynamicObject.set("number", (Object)number[i]);
            }
        }
    }

    public static void cachecheckRecordSumNums(DynamicObjectCollection collection, Map<String, String> checkRecordSumNums) {
        collection.forEach(e -> checkRecordSumNums.put(CheckSumHelper.genCacheKey(e), e.getString("number")));
    }

    private static String genCacheKey(DynamicObject e) {
        IDNumberTreeNode mergeOrgNode = MemberReader.findMemberById((long)e.getLong("model"), (String)"bcm_entitymembertree", (Long)e.getLong("entity"));
        return mergeOrgNode.getNumber() + "." + e.getString("checktmpl") + "." + e.getString("myentity") + "." + e.getString("oppositeentity") + "." + e.getString("status") + "." + e.getString("isautoelim") + "." + e.getString("createtype") + ".";
    }

    public static CheckResult doAudit(Set<Long> sumIds, CheckParam checkParam, Pair<DiffModeEnum, DiffMethodEnum> diffPair) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checkrecordsum", (String)"id,number,checktmpl.id,checktmpl.number,status,isautoelim,entity.id,entity.number", (QFilter[])new QFilter[]{new QFilter("model", "=", checkParam.getModel().p1), new QFilter("id", "in", sumIds)});
        if (dynamicObjects.size() != sumIds.size()) {
            return CheckResult.fail(ResManager.loadKDString((String)"\u5bf9\u8d26\u6c47\u603b\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckSumHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Map<Long, DynamicObject> sumRecordMap = dynamicObjects.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
        Pair<Set<Long>, Map<String, List<String>>> validateData = CheckSumHelper.validateDataBeforeAudit(dynamicObjects, checkParam, true);
        Set needDealSumIds = (Set)validateData.p1;
        Map errorNumbers = (Map)validateData.p2;
        if (needDealSumIds.size() > 0) {
            DynamicObjectCollection sumRecordLinkCollection = QueryServiceHelper.query((String)"bcm_checkrecord_link", (String)"checkrecordsum.id,checkrecord", (QFilter[])new QFilter[]{new QFilter("model", "=", checkParam.getModel().p1), new QFilter("checkrecordsum", "in", (Object)needDealSumIds)});
            DynamicObjectCollection recordCollection = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id, number, status, diffmode, isautoelim,entity.id,entity.number,entity.name,myentity.name,checktmpl.id,checktmpl.number,checktmpl.name,checktmpl.isenable", (QFilter[])new QFilter[]{new QFilter("id", "in", sumRecordLinkCollection.stream().map(e -> e.getLong("checkrecord")).collect(Collectors.toSet()))});
            Map<Long, List<DynamicObject>> groupLinkMap = sumRecordLinkCollection.stream().collect(Collectors.groupingBy(e -> e.getLong("checkrecordsum.id")));
            for (Long sumId : needDealSumIds) {
                List<DynamicObject> groupLinks = groupLinkMap.get(sumId);
                if (CollectionUtils.isEmpty(groupLinks)) continue;
                Set checkRecordIds = groupLinks.stream().map(e -> e.getLong("checkrecord")).collect(Collectors.toSet());
                List dos = recordCollection.stream().filter(e -> checkRecordIds.contains(e.getLong("id"))).collect(Collectors.toList());
                if (dos.size() == groupLinks.size()) {
                    HashSet<Long> needDealCheckRecords = new HashSet<Long>(16);
                    HashSet<Long> needReSumMergeEntity = new HashSet<Long>(16);
                    HashSet<Long> needReSumTmpl = new HashSet<Long>(16);
                    boolean isPass = true;
                    for (DynamicObject e2 : dos) {
                        if (e2.getInt("status") == 1) {
                            needDealCheckRecords.add(e2.getLong("id"));
                            needReSumMergeEntity.add(e2.getLong("entity.id"));
                            needReSumTmpl.add(e2.getLong("checktmpl.id"));
                            continue;
                        }
                        if (diffPair.p1 != DiffModeEnum.DIRECT) continue;
                        ((List)errorNumbers.get(key_checkrecordstatus)).add(sumRecordMap.get(sumId).getString("number"));
                        isPass = false;
                        break;
                    }
                    if (needDealCheckRecords.size() <= 0 || !isPass) continue;
                    checkParam.put("checkRecordIds", needDealCheckRecords);
                    checkParam.setIsAutoElim("2");
                    Pair entityPair = Pair.onePair((Object)((DynamicObject)dos.get(0)).getLong("entity.id"), (Object)((DynamicObject)dos.get(0)).getString("entity.number"));
                    checkParam.setEntity((Pair<Long, String>)entityPair);
                    CheckResult checkResult = CheckServiceHelper.check(new CheckContext(checkParam), diffPair);
                    if (checkResult == null || checkResult.getSuccess()) {
                        Map re;
                        if (checkResult != null && checkResult.getData() != null && checkResult.getData() instanceof Map && (re = (Map)checkResult.getData()).containsKey("lockAdjustInfo")) {
                            ((List)errorNumbers.get(key_executeunAuditLock)).add(sumRecordMap.get(sumId).getString("number"));
                        }
                        checkParam.setMergeEntityIds(Lists.newArrayList(needReSumMergeEntity));
                        checkParam.setCheckTmpl((Pair<Long[], String>)Pair.onePair((Object)needReSumTmpl.toArray(new Long[0]), null));
                        CheckServiceHelper.sumCheckRecord(checkParam);
                        logger.info(String.format("CheckSumHelper.doAudit  reSumCheckRecord  mergeOrg number: %1$s  checktmpl number: %2$s", sumRecordMap.get(sumId).getString("entity.number"), sumRecordMap.get(sumId).getString("checktmpl.number")));
                        continue;
                    }
                    ((List)errorNumbers.get(key_executecheckdirecterror)).add(String.format(ResManager.loadKDString((String)"%1$s\u6267\u884c\u5931\u8d25:%2$s", (String)"CheckSumHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), sumRecordMap.get(sumId).getString("number"), checkResult.getMessage()));
                    continue;
                }
                ((List)errorNumbers.get(key_checkrecorddeleted)).add(sumRecordMap.get(sumId).getString("number"));
            }
        }
        return CheckResult.success(CheckSumHelper.getAuditMessage(errorNumbers));
    }

    public static CheckResult unAudit(Set<Long> sumIds, CheckParam checkParam) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checkrecordsum", (String)"id,number,checktmpl.id,checktmpl.number,status,isautoelim,entity.id,entity.number", (QFilter[])new QFilter[]{new QFilter("model", "=", checkParam.getModel().p1), new QFilter("id", "in", sumIds)});
        if (dynamicObjects.size() != sumIds.size()) {
            return CheckResult.fail(ResManager.loadKDString((String)"\u5bf9\u8d26\u6c47\u603b\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckSumHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Map<Long, DynamicObject> sumRecordMap = dynamicObjects.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
        Pair<Set<Long>, Map<String, List<String>>> validateData = CheckSumHelper.validateDataBeforeAudit(dynamicObjects, checkParam, false);
        Set needDealSumIds = (Set)validateData.p1;
        Map errorNumbers = (Map)validateData.p2;
        if (needDealSumIds.size() > 0) {
            DynamicObjectCollection sumRecordLinkCollection = QueryServiceHelper.query((String)"bcm_checkrecord_link", (String)"checkrecordsum.id,checkrecord", (QFilter[])new QFilter[]{new QFilter("model", "=", checkParam.getModel().p1), new QFilter("checkrecordsum", "in", (Object)needDealSumIds)});
            DynamicObjectCollection recordCollection = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id, number, status, diffmode, isautoelim,entity.id,entity.number,entity.name,myentity.name,checktmpl.id,checktmpl.number,checktmpl.name,checktmpl.isenable", (QFilter[])new QFilter[]{new QFilter("id", "in", sumRecordLinkCollection.stream().map(e -> e.getLong("checkrecord")).collect(Collectors.toSet()))});
            Map<Long, List<DynamicObject>> groupLinkMap = sumRecordLinkCollection.stream().collect(Collectors.groupingBy(e -> e.getLong("checkrecordsum.id")));
            for (Long sumId : needDealSumIds) {
                List<DynamicObject> groupLinks = groupLinkMap.get(sumId);
                if (CollectionUtils.isEmpty(groupLinks)) continue;
                Set checkRecordIds = groupLinks.stream().map(e -> e.getLong("checkrecord")).collect(Collectors.toSet());
                List dos = recordCollection.stream().filter(e -> checkRecordIds.contains(e.getLong("id"))).collect(Collectors.toList());
                HashSet<Long> needDealCheckRecords = new HashSet<Long>(16);
                boolean isContine = true;
                for (DynamicObject e2 : dos) {
                    if (!"2".equals(e2.getString("isautoelim")) || e2.getInt("status") != 2) continue;
                    needDealCheckRecords.add(e2.getLong("id"));
                }
                if (needDealCheckRecords.size() > 0) {
                    try {
                        Map<String, Pair<Set<Long>, String>> unAuditBatch = CheckUtil.unAuditBatch(Lists.newArrayList(needDealCheckRecords), "bcm_checkrecordsum", checkParam);
                        if (!unAuditBatch.isEmpty()) {
                            if (unAuditBatch.containsKey("adjuststagelock")) {
                                ((List)errorNumbers.get(key_executeunAuditLock)).add(sumRecordMap.get(sumId).getString("number"));
                            }
                            if (unAuditBatch.containsKey("adjustsharelock")) {
                                ((List)errorNumbers.get(key_adjustsharelock)).add(sumRecordMap.get(sumId).getString("number"));
                            }
                            if (unAuditBatch.containsKey("adjustunautolock")) {
                                ((List)errorNumbers.get(key_adjustunautolock)).add(sumRecordMap.get(sumId).getString("number"));
                            }
                        }
                    }
                    catch (Exception t) {
                        isContine = false;
                        logger.error("--kd.fi.bcm.business.check.sum.CheckSumHelper.unAudit--:" + ThrowableHelper.toString((Exception)t));
                        ((List)errorNumbers.get(key_executeunAuditerror)).add(String.format(ResManager.loadKDString((String)"%1$s\u6267\u884c\u5931\u8d25:%2$s", (String)"CheckSumHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), sumRecordMap.get(sumId).getString("number"), t.getMessage()));
                    }
                }
                if (!isContine) continue;
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_checkrecordsum"), (Object[])new Long[]{sumId});
                DeleteServiceHelper.delete((String)"bcm_checkrecord_link", (QFilter[])new QFilter[]{new QFilter("model", "=", checkParam.getModel().p1), new QFilter("checkrecordsum", "=", (Object)sumId)});
                checkParam.setMergeEntityIds(Lists.newArrayList((Object[])new Long[]{sumRecordMap.get(sumId).getLong("entity.id")}));
                checkParam.setCheckTmpl((Pair<Long[], String>)Pair.onePair((Object)new Long[]{sumRecordMap.get(sumId).getLong("checktmpl.id")}, null));
                CheckServiceHelper.sumCheckRecord(checkParam);
                logger.info(String.format("CheckSumHelper.unAudit reSumCheckRecord  mergeOrg number: %1$s  checktmpl number: %2$s", sumRecordMap.get(sumId).getString("entity.number"), sumRecordMap.get(sumId).getString("checktmpl.number")));
            }
        }
        return CheckResult.success(CheckSumHelper.getAuditMessage(errorNumbers));
    }

    private static String getAuditMessage(Map<String, List<String>> errorNumbers) {
        StringBuilder msg = new StringBuilder();
        if (errorNumbers.get(key_orgreadonly).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u5982\u4e0b\u8bb0\u5f55\u5408\u5e76\u8282\u70b9\u53ea\u8bfb\uff1a%s", (String)"CheckSumHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_orgreadonly)))).append("\n");
        } else if (errorNumbers.get(key_orgstatus).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u8bb0\u5f55\u5408\u5e76\u8282\u70b9\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u72b6\u6001\u5df2\u63d0\u4ea4\uff1a%s", (String)"CheckSumHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_orgstatus)))).append("\n");
        } else if (errorNumbers.get(key_tmplcheckfail).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u8bb0\u5f55\u7684\u5bf9\u8d26\u6a21\u677f\u4e0d\u53ef\u7528\uff1a%s", (String)"CheckSumHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_tmplcheckfail)))).append("\n");
        } else if (errorNumbers.get(key_periodentrystatus).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u8bb0\u5f55\u5408\u5e76\u8282\u70b9\u6570\u636e\u671f\u95f4\u6216\u8c03\u6574\u5206\u5f55\u671f\u95f4\u672a\u5f00\u542f\uff1a%s", (String)"CheckSumHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_periodentrystatus)))).append("\n");
        } else if (errorNumbers.get(key_sumrecordstatus).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u8bb0\u5f55\u4e0d\u7b26\u5408\u6267\u884c\u6761\u4ef6\uff1a%s", (String)"CheckSumHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_sumrecordstatus)))).append("\n");
        } else if (errorNumbers.get(key_checkrecordstatus).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u8bb0\u5f55\u7684\u660e\u7ec6\u5bf9\u8d26\u8bb0\u5f55\u4e0d\u7b26\u5408\u6267\u884c\u6761\u4ef6\uff1a%s", (String)"CheckSumHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_checkrecordstatus)))).append("\n");
        } else if (errorNumbers.get(key_checkrecorddeleted).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u8bb0\u5f55\u7684\u660e\u7ec6\u5bf9\u8d26\u8bb0\u5f55\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u6c47\u603b\u6570\u636e\uff1a%s", (String)"CheckSumHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_checkrecorddeleted)))).append("\n");
        } else if (errorNumbers.get(key_quoteLocked).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5982\u4e0b\u8bb0\u5f55\u7684\u5408\u5e76\u8282\u70b9\u5728\u65b0\u60c5\u666f\u4e0b\u672a\u5f00\u542f\u7ec4\u7ec7\u7248\u672c\u5316\uff1a%s", (String)"CheckSumHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_quoteLocked)))).append("\n");
        } else if (errorNumbers.get(key_executeunAuditLock).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u8bb0\u5f55\u6240\u5bf9\u5e94\u7684\u5206\u5f55\u7ef4\u5ea6\u7ec4\u5408\u88ab\u5206\u9636\u6bb5\u9501\u5b9a\uff1a%s", (String)"CheckSumHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_executeunAuditLock)))).append("\n");
        } else if (errorNumbers.get(key_adjustunautolock).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u8bb0\u5f55\u6240\u5bf9\u5e94\u7684\u5206\u5f55\u5b58\u5728\u624b\u5de5\u4fee\u6539\uff1a%s", (String)"CheckSumHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_adjustunautolock)))).append("\n");
        } else if (errorNumbers.get(key_adjustsharelock).size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u8bb0\u5f55\u6240\u5bf9\u5e94\u7684\u5206\u5f55\u5b58\u5728\u5171\u4eab\u5206\u5f55\uff1a%s", (String)"CheckSumHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable<? extends CharSequence>)errorNumbers.get(key_adjustsharelock)))).append("\n");
        } else if (errorNumbers.get(key_executecheckdirecterror).size() > 0) {
            errorNumbers.get(key_executecheckdirecterror).forEach(s -> msg.append((String)s).append("\n"));
        } else if (errorNumbers.get(key_executeunAuditerror).size() > 0) {
            errorNumbers.get(key_executeunAuditerror).forEach(s -> msg.append((String)s).append("\n"));
        }
        if (msg.length() == 0) {
            msg.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"CheckSumHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    private static Pair<Set<Long>, Map<String, List<String>>> validateDataBeforeAudit(DynamicObjectCollection dynamicObjects, CheckParam checkParam, boolean isAudit) {
        Set<String> mergeOrgs = dynamicObjects.stream().map(e -> e.getString("entity.number")).collect(Collectors.toSet());
        HashMap errorNumbers = new HashMap(16);
        errorNumbers.put(key_orgreadonly, new ArrayList(16));
        errorNumbers.put(key_orgstatus, new ArrayList(16));
        errorNumbers.put(key_tmplcheckfail, new ArrayList(16));
        errorNumbers.put(key_periodentrystatus, new ArrayList(16));
        errorNumbers.put(key_sumrecordstatus, new ArrayList(16));
        errorNumbers.put(key_checkrecordstatus, new ArrayList(16));
        errorNumbers.put(key_checkrecorddeleted, new ArrayList(16));
        errorNumbers.put(key_executecheckdirecterror, new ArrayList(16));
        errorNumbers.put(key_executeunAuditerror, new ArrayList(16));
        errorNumbers.put(key_quoteLocked, new ArrayList(16));
        errorNumbers.put(key_executeunAuditLock, new ArrayList(16));
        errorNumbers.put(key_adjustsharelock, new ArrayList(16));
        errorNumbers.put(key_adjustunautolock, new ArrayList(16));
        Map<String, Boolean> orgStatus = AllInOneUtils.isSubmittedBatch((Long)checkParam.getModel().p1, mergeOrgs, checkParam.getScene().p1, checkParam.getYear().p1, checkParam.getPeriod().p1);
        Map<String, Boolean> periodAndEntryStatus = CheckSumHelper.batchGetPeriodAndEntryStatus(checkParam, mergeOrgs);
        boolean isRoot = MemberPermHelper.getLimitedModelListByUser().contains(checkParam.getModel().p1);
        HashMap orgTmplEnableMap = new HashMap(16);
        Map orgNumberTmplMap = dynamicObjects.stream().collect(Collectors.groupingBy(e -> e.getString("entity.number"), Collectors.mapping(e -> e.getLong("checktmpl.id"), Collectors.toSet())));
        orgNumberTmplMap.forEach((orgNum, tmpls) -> {
            Set<Long> orgDispensedTmpls = CheckUtil.queryDispensedTmpls((Long)checkParam.getModel().p1, (Long)checkParam.getScene().p1, tmpls, null, Sets.newHashSet((Object[])new String[]{orgNum}));
            Set<Long> tmplIdSet = CheckUtil.queryEffectiveTmpls((Long)checkParam.getModel().p1, (Long)checkParam.getYear().p1, (Long)checkParam.getPeriod().p1, orgDispensedTmpls);
            orgTmplEnableMap.put(orgNum, tmplIdSet);
        });
        HashSet needDealSumIds = new HashSet(16);
        Long entityId = MemberReader.getDimensionIdByNum((long)((Long)checkParam.getModel().p1), (String)"Entity");
        PermissionService permService = PermissionServiceImpl.getInstance((Long)checkParam.getModel().p1);
        dynamicObjects.forEach(e -> {
            boolean statusPass;
            boolean bl = statusPass = isAudit && 1 == e.getInt("status") && "1".equals(e.getString("isautoelim")) || !isAudit && 2 == e.getInt("status") && "2".equals(e.getString("isautoelim"));
            if (statusPass) {
                if (((Boolean)orgStatus.get(e.getString("entity.number"))).booleanValue()) {
                    ((List)errorNumbers.get(key_orgstatus)).add(e.getString("number"));
                } else if (((Boolean)periodAndEntryStatus.get(e.getString("entity.number"))).booleanValue()) {
                    if (!isRoot && permService.isAllReadPerm(entityId, "bcm_entitymembertree", Sets.newHashSet((Object[])new Long[]{e.getLong("entity.id")}))) {
                        ((List)errorNumbers.get(key_orgreadonly)).add(e.getString("number"));
                    } else if (orgTmplEnableMap.get(e.getString("entity.number")) != null && ((Set)orgTmplEnableMap.get(e.getString("entity.number"))).contains(e.getLong("checktmpl.id"))) {
                        if (MergeControlHelper.isQuoteLocked((Long)checkParam.getModel().p1, (Long)checkParam.getScene().p1, (Long)checkParam.getYear().p1, (Long)checkParam.getPeriod().p1, (Long)checkParam.getEntity().p1)) {
                            ((List)errorNumbers.get(key_quoteLocked)).add(e.getString("number"));
                        } else {
                            needDealSumIds.add(e.getLong("id"));
                        }
                    } else {
                        ((List)errorNumbers.get(key_tmplcheckfail)).add(e.getString("number"));
                    }
                } else {
                    ((List)errorNumbers.get(key_periodentrystatus)).add(e.getString("number"));
                }
            } else {
                ((List)errorNumbers.get(key_sumrecordstatus)).add(e.getString("number"));
            }
        });
        return Pair.onePair(needDealSumIds, errorNumbers);
    }

    private static Map<String, Boolean> batchGetPeriodAndEntryStatus(CheckParam checkParam, Set<String> orgNumSet) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(orgNumSet.size());
        boolean periodManage = ConfigServiceHelper.getBoolParam((Long)checkParam.getModel().p1, "CM012");
        if (periodManage) {
            Set<String> periodStatusOpen = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)checkParam.getModel().p1, orgNumSet, (Long)checkParam.getScene().p1, (Long)checkParam.getYear().p1, (Long)checkParam.getPeriod().p1, "datastatus");
            Set<String> entryStatusOpen = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)checkParam.getModel().p1, periodStatusOpen, (Long)checkParam.getScene().p1, (Long)checkParam.getYear().p1, (Long)checkParam.getPeriod().p1, "entrystatus");
            orgNumSet.forEach(n -> result.put((String)n, periodStatusOpen.contains(n) && entryStatusOpen.contains(n)));
        } else {
            orgNumSet.forEach(n -> result.put((String)n, Boolean.TRUE));
        }
        return result;
    }
}

