/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.sum;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.CheckResult;
import kd.fi.bcm.business.check.ICheckService;
import kd.fi.bcm.business.check.helper.EntityServiceHelper;
import kd.fi.bcm.business.check.model.key.EntityKey;
import kd.fi.bcm.business.check.sum.CheckEntryData;
import kd.fi.bcm.business.check.sum.CheckSumHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CheckCreateTypeEnum;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.StringUtils;

public class CheckSumService
implements ICheckService {
    private WatchLogger log;
    private CheckParam checkParam;
    private Map<String, List<CheckEntryData>> rs = new HashMap<String, List<CheckEntryData>>(16);
    private List<DynamicObject> checkRecordSumList = new ArrayList<DynamicObject>(16);
    private List<DynamicObject> checkRecordLinkList = new ArrayList<DynamicObject>(16);
    private Map<String, String> checkRecordSumNums = new HashMap<String, String>(16);
    private static final String KEY_ORGCURRENCYMAP = "orgCurrencyMap";
    private static final String KEY_ORGNUM2IDMAP = "orgNum2IdMap";

    public CheckSumService(CheckParam checkParam) {
        this.log = BcmLogFactory.getWatchLogInstance(this.getClass());
        this.checkParam = checkParam;
    }

    @Override
    public void execute() {
        this.log.startWatch();
        this.beforeExecute();
        this.log.info(String.format("[\u5bf9\u8d26\u6570\u636e\u6c47\u603b]%s\u4e2a\u5408\u5e76\u8282\u70b9\u51c6\u5907\u660e\u7ec6\u6570\u636e%s\u6761", this.checkParam.getMergeEntityIds().size(), this.rs.values().stream().map(List::size).reduce(Integer::sum)));
        this.doExecute();
        this.log.info(String.format("[\u5bf9\u8d26\u6570\u636e\u6c47\u603b]\u751f\u6210\u6c47\u603b\u6570\u636e%s\u6761\uff0c\u6c47\u603b\u5173\u8054\u5173\u7cfb\u6570\u636e%s\u6761", this.checkRecordSumList.size(), this.checkRecordLinkList.size()));
        this.afterExecute();
        this.log.info("[\u5bf9\u8d26\u6570\u636e\u6c47\u603b]\u6267\u884c\u4fdd\u5b58\u6570\u636e\u7ed3\u675f");
        this.log.infoEnd("[\u5bf9\u8d26\u6570\u636e\u6c47\u603b]\u6267\u884c\u7ed3\u675f\uff0cCheckSumService.execute()\u65b9\u6cd5\u5171\u8017\u65f6\u3002");
    }

    @Override
    public void beforeExecute() {
        Set MergeNums = MemberReader.change2MemberNumsById((long)((Long)this.checkParam.getModel().p1), (String)"bcm_entitymembertree", this.checkParam.getMergeEntityIds());
        Map<String, String> currencyMap = CheckSumHelper.getOrgCurrencyMap(this.checkParam);
        this.checkParam.put(KEY_ORGCURRENCYMAP, currencyMap);
        QFBuilder qfBuilder = new QFBuilder("model", "=", this.checkParam.getModel().p1);
        qfBuilder.add("scene", "=", this.checkParam.getScene().p1);
        qfBuilder.add("year", "=", this.checkParam.getYear().p1);
        qfBuilder.add("period", "=", this.checkParam.getPeriod().p1);
        qfBuilder.add("process.number", "=", (Object)"ARPT");
        qfBuilder.add("currency.number", "in", currencyMap.values());
        qfBuilder.add("createtype", "=", (Object)CheckCreateTypeEnum.CHECKADJUST_CREATE.value);
        qfBuilder.add("entity.number", "in", (Object)MergeNums);
        qfBuilder.add("entity.cslscheme", "=", (Object)this.checkParam.getCslschemeId());
        qfBuilder.add("checktmpl", "in", this.checkParam.getCheckTmpl().p1);
        DynamicObjectCollection allCheckRecords = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,number,model.id,checktmpl.id,entity.id,entity.number,entity.longnumber,myentity.id,myentity.number,myentity.longnumber, oppositeentity.id,oppositeentity.number,oppositeentity.longnumber,currency.number,cvtdifmoney,diffmode, status, isautoelim", (QFilter[])qfBuilder.toArray());
        Map<String, List<DynamicObject>> recordMap = allCheckRecords.stream().collect(Collectors.groupingBy(e -> e.getString("entity.number") + e.getString("currency.number")));
        qfBuilder.add("isautoelim", "=", (Object)"2");
        DynamicObjectCollection allSumCheckRecords = QueryServiceHelper.query((String)"bcm_checkrecordsum", (String)"id,entity.number,currency.number", (QFilter[])qfBuilder.toArray());
        Map<String, List<DynamicObject>> sumRecordMap = allSumCheckRecords.stream().collect(Collectors.groupingBy(e -> e.getString("entity.number") + e.getString("currency.number")));
        for (String mergeNum : MergeNums) {
            List checkRecords;
            if (currencyMap.get(mergeNum) == null || (checkRecords = (List)recordMap.getOrDefault(mergeNum + currencyMap.get(mergeNum), new ArrayList(16))).size() == 0) continue;
            List sumCheckRecords = sumRecordMap.getOrDefault(mergeNum + currencyMap.get(mergeNum), new ArrayList(16));
            if (sumCheckRecords.size() > 0) {
                DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)"bcm_checkrecord_link", (String)"checkrecord", (QFilter[])new QFilter[]{new QFilter("model", "=", this.checkParam.getModel().p1), new QFilter("checkrecordsum", "in", sumCheckRecords.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()))});
                Set noNeedCheckRecordId = objectCollection.stream().map(e -> e.getLong("checkrecord")).collect(Collectors.toSet());
                checkRecords.removeIf(e -> noNeedCheckRecordId.contains(e.getLong("id")));
            }
            if (checkRecords.size() == 0) continue;
            ArrayList recordEntryDatas = new ArrayList(16);
            BatchProcessHelper.batchConsume((List)checkRecords, (int)10000, subRecords -> {
                Set subIds = subRecords.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                HashMap<Long, DynamicObjectCollection> allEntryMap = new HashMap<Long, DynamicObjectCollection>(subIds.size());
                DynamicObjectCollection allEntry = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,entryentity.id as entryid,entryentity.checktmplentry as checktmplentry, entryentity.isdiffitem as isdiffitem,entryentity.entrydebit as entrydebit,entryentity.entrycredit as entrycredit,entryentity.entrydebelimval as entrydebelimval,entryentity.entrycreelimval as entrycreelimval,entryentity.entrycompany.id as entrycompany.id,entryentity.entrycompany.number as entrycompany.number,entryentity.entrymycompany.id as entrymycompany.id,entryentity.entryorg.id as entryorg.id,entryentity.entrydiffmode as entrydiffmode,entryentity.entrymycvtmoney as entrymycvtmoney,entryentity.entryopcvtmoney as entryopcvtmoney,entryentity.difftype as difftype,entryentity.seq as seq,entryentity.groupkey as groupkey", (QFilter[])new QFilter[]{new QFilter("id", "in", subIds)});
                for (DynamicObject dyn : allEntry) {
                    DynamicObjectCollection entryDoc = (DynamicObjectCollection)allEntryMap.get(dyn.getLong("id"));
                    if (entryDoc == null) {
                        entryDoc = new DynamicObjectCollection();
                        allEntryMap.put(dyn.getLong("id"), entryDoc);
                    }
                    entryDoc.add((Object)dyn);
                }
                for (DynamicObject header : subRecords) {
                    if (StringUtils.isEmpty((CharSequence)header.getString("myentity.longnumber")) || StringUtils.isEmpty((CharSequence)header.getString("oppositeentity.longnumber")) || StringUtils.isEmpty((CharSequence)header.getString("entity.longnumber"))) continue;
                    DynamicObjectCollection entries = (DynamicObjectCollection)allEntryMap.get(header.getLong("id"));
                    entries.forEach(entry -> recordEntryDatas.add(new CheckEntryData(header, (DynamicObject)entry)));
                }
            });
            this.rs.put(mergeNum, recordEntryDatas);
        }
    }

    private void doExecute() {
        this.rs.forEach((mergeOrgNum, entryDatas) -> {
            this.beforeGroupData((List<CheckEntryData>)entryDatas, this.checkParam);
            Map<Long, Map<EntityKey, Map<String, Map<String, Map<Long, List<CheckEntryData>>>>>> rows = entryDatas.parallelStream().collect(Collectors.groupingBy(CheckEntryData::getCheckTmplId, Collectors.groupingBy(CheckEntryData::genDirectEntityKey, Collectors.groupingBy(CheckEntryData::getStatus, Collectors.groupingBy(CheckEntryData::isautoelim, Collectors.groupingBy(CheckEntryData::getCheckTmplEntryId))))));
            this.buildCheckRecordSum((String)mergeOrgNum, rows);
        });
    }

    @Override
    public void afterExecute() {
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject mapping;
                this.doDelete();
                if (this.checkRecordSumList.size() > 0) {
                    CheckSumHelper.batchDealRecordSumNumber(this.checkRecordSumList, this.checkRecordSumNums);
                    mapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checkrecordsum");
                    SaveServiceHelper.save((IDataEntityType)mapping.getDynamicObjectType(), (Object[])this.checkRecordSumList.toArray(new Object[0]));
                }
                if (this.checkRecordLinkList.size() > 0) {
                    mapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checkrecord_link");
                    SaveServiceHelper.save((IDataEntityType)mapping.getDynamicObjectType(), (Object[])this.checkRecordLinkList.toArray(new Object[0]));
                }
            }
            catch (Throwable t) {
                tx.markRollback();
                this.log.error("--CheckSumService.afterExecute--:\n" + ThrowableHelper.toString((Throwable)t));
                String errMsg = t instanceof KDBizException ? t.getMessage() : ThrowableHelper.toString((Throwable)t);
                throw new KDBizException(t, new ErrorCode("", errMsg), new Object[0]);
            }
        }
        this.checkParam.put("CheckResult", CheckResult.success(null));
    }

    private void doDelete() {
        Map currencyMap = (Map)this.checkParam.get(KEY_ORGCURRENCYMAP);
        Set mergeNums = MemberReader.change2MemberNumsById((long)((Long)this.checkParam.getModel().p1), (String)"bcm_entitymembertree", this.checkParam.getMergeEntityIds());
        QFBuilder qfBuilder = new QFBuilder("model", "=", this.checkParam.getModel().p1);
        qfBuilder.add("scene", "=", this.checkParam.getScene().p1);
        qfBuilder.add("year", "=", this.checkParam.getYear().p1);
        qfBuilder.add("period", "=", this.checkParam.getPeriod().p1);
        qfBuilder.add("process.number", "=", (Object)"ARPT");
        qfBuilder.add("currency.number", "in", currencyMap.values());
        qfBuilder.add("createtype", "=", (Object)CheckCreateTypeEnum.CHECKADJUST_CREATE.value);
        qfBuilder.add("entity.number", "in", (Object)mergeNums);
        qfBuilder.add("entity.cslscheme", "=", (Object)this.checkParam.getCslschemeId());
        qfBuilder.add("checktmpl", "in", this.checkParam.getCheckTmpl().p1);
        qfBuilder.add("isautoelim", "in", (Object)new String[]{"0", "1"});
        DynamicObjectCollection allSumRecords = QueryServiceHelper.query((String)"bcm_checkrecordsum", (String)"id,number,model,entity,entity.number,myentity,oppositeentity,checktmpl,scene,year,period,currency,currency.number,process,status,isautoelim,createtype", (QFilter[])qfBuilder.toArray());
        Map<String, List<DynamicObject>> sumRecordMap = allSumRecords.stream().collect(Collectors.groupingBy(e -> e.getString("entity.number") + e.getString("currency.number")));
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        mergeNums.forEach(mergeNum -> dynamicObjectCollection.addAll((Collection)sumRecordMap.getOrDefault(mergeNum + (String)currencyMap.get(mergeNum), new ArrayList(16))));
        if (dynamicObjectCollection.size() > 0) {
            CheckSumHelper.cachecheckRecordSumNums(dynamicObjectCollection, this.checkRecordSumNums);
            Set checkRecordSumIds = dynamicObjectCollection.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_checkrecordsum"), (Object[])checkRecordSumIds.toArray());
            DeleteServiceHelper.delete((String)"bcm_checkrecord_link", (QFilter[])new QFilter[]{new QFilter("model", "=", this.checkParam.getModel().p1), new QFilter("checkrecordsum", "in", checkRecordSumIds)});
        }
    }

    private void beforeGroupData(List<CheckEntryData> entryDatas, CheckParam checkParam) {
        HashMap orgNum2IdMap = new HashMap(16);
        String modelNumber = MemberReader.findModelNumberById((Object)checkParam.getModel().p1);
        entryDatas.forEach(e -> {
            String myMergeDirectOrg = EntityServiceHelper.getMergeDirectLongNumber(e.getMergeLongNumber(), (String)e.getMyOrg().p3);
            IDNumberTreeNode myMergeDirectOrgTreeNode = EntityServiceHelper.findEntityByLongNumber(modelNumber, myMergeDirectOrg);
            e.setDirectMyOrg((Tuple<Long, String, String>)Tuple.create((Object)myMergeDirectOrgTreeNode.getId(), (Object)myMergeDirectOrgTreeNode.getNumber(), (Object)myMergeDirectOrg));
            orgNum2IdMap.putIfAbsent(myMergeDirectOrgTreeNode.getNumber(), myMergeDirectOrgTreeNode.getId());
            String opMergeDirectOrg = EntityServiceHelper.getMergeDirectLongNumber(e.getMergeLongNumber(), (String)e.getOpOrg().p3);
            IDNumberTreeNode opMergeDirectOrgTreeNode = EntityServiceHelper.findEntityByLongNumber(modelNumber, opMergeDirectOrg);
            e.setDirectOpOrg((Tuple<Long, String, String>)Tuple.create((Object)opMergeDirectOrgTreeNode.getId(), (Object)opMergeDirectOrgTreeNode.getNumber(), (Object)opMergeDirectOrg));
            orgNum2IdMap.putIfAbsent(opMergeDirectOrgTreeNode.getNumber(), opMergeDirectOrgTreeNode.getId());
        });
        checkParam.put(KEY_ORGNUM2IDMAP, orgNum2IdMap);
    }

    private void buildCheckRecordSum(String mergeOrgNum, Map<Long, Map<EntityKey, Map<String, Map<String, Map<Long, List<CheckEntryData>>>>>> rows) {
        String modelNumber = MemberReader.findModelNumberById((Object)this.checkParam.getModel().p1);
        String processNum = this.checkParam.isIncludeAdj() ? "ARPT" : "Rpt";
        IDNumberTreeNode processTreeNode = MemberReader.findProcessMemberByNum((String)modelNumber, (String)processNum);
        Map currencyMap = (Map)this.checkParam.get(KEY_ORGCURRENCYMAP);
        IDNumberTreeNode currencyTreeNode = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)((String)currencyMap.get(mergeOrgNum)));
        IDNumberTreeNode mergeTreeNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)mergeOrgNum);
        if (!this.checkParam.getMergeEntityIds().contains(mergeTreeNode.getId())) {
            for (IDNumberTreeNode shareNode : mergeTreeNode.getShareNodes()) {
                if (!this.checkParam.getMergeEntityIds().contains(shareNode.getId())) continue;
                mergeTreeNode = shareNode;
                break;
            }
        }
        Map orgNum2IdMap = (Map)this.checkParam.get(KEY_ORGNUM2IDMAP);
        Date nowTime = TimeServiceHelper.now();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        IDNumberTreeNode sumRecordMergeNode = mergeTreeNode;
        rows.forEach((t, m1) -> m1.forEach((e, m2) -> m2.forEach((s, m3) -> m3.forEach((i, m4) -> {
            DynamicObject recordsum = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checkrecordsum");
            recordsum.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            recordsum.set("creator", (Object)userId);
            recordsum.set("createtime", (Object)nowTime);
            recordsum.set("modifier", (Object)userId);
            recordsum.set("modifytime", (Object)nowTime);
            recordsum.set("model", this.checkParam.getModel().p1);
            recordsum.set("scene", this.checkParam.getScene().p1);
            recordsum.set("year", this.checkParam.getYear().p1);
            recordsum.set("period", this.checkParam.getPeriod().p1);
            recordsum.set("process", (Object)processTreeNode.getId());
            recordsum.set("currency", (Object)currencyTreeNode.getId());
            recordsum.set("status", s);
            recordsum.set("checktmpl", t);
            recordsum.set("entity", (Object)sumRecordMergeNode.getId());
            Pair<Long, Long> myOpEntityPair = CheckSumHelper.getMyOpEntityIdByEntityKey(e, orgNum2IdMap);
            recordsum.set("myentity", myOpEntityPair.p1);
            recordsum.set("oppositeentity", myOpEntityPair.p2);
            recordsum.set("createtype", (Object)this.checkParam.getCreateTypeEnum().getValue());
            recordsum.set("isautoelim", i);
            DynamicObjectCollection doc = recordsum.getDynamicObjectCollection("entryentity");
            AtomicInteger seq = new AtomicInteger();
            ArrayList myCvtMoneyList = new ArrayList(16);
            ArrayList opCvtMoneyList = new ArrayList(16);
            ArrayList myElimMoneyList = new ArrayList(16);
            ArrayList opElimMoneyList = new ArrayList(16);
            HashSet<Long> checkRecordIds = new HashSet<Long>(16);
            m4.forEach((tmplEntryId, l) -> {
                Map<Boolean, List<CheckEntryData>> map = l.stream().collect(Collectors.groupingBy(CheckEntryData::isAbByDirectEntity));
                map.forEach((ismy, datas) -> {
                    if (!CollectionUtils.isEmpty((Collection)datas)) {
                        DynamicObject entry = new DynamicObject(doc.getDynamicObjectType());
                        entry.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                        entry.set("seq", (Object)seq.getAndIncrement());
                        entry.set("ismydata", (Object)(ismy != false ? "1" : "0"));
                        entry.set("checktmplentry", tmplEntryId);
                        BigDecimal cvtMoney = datas.stream().map(CheckEntryData::getEntryCvtMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal elimMoney = datas.stream().map(CheckEntryData::getEntryElimMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                        entry.set("entrycvtmoney", (Object)cvtMoney);
                        entry.set("entryelimmoney", (Object)elimMoney);
                        boolean isdiffitem = tmplEntryId == 0L || ((CheckEntryData)datas.get(0)).isdiffitem() != false;
                        entry.set("isdiffitem", (Object)(isdiffitem ? "1" : "0"));
                        if (ismy.booleanValue()) {
                            myCvtMoneyList.add(cvtMoney);
                            myElimMoneyList.add(elimMoney);
                        } else {
                            opCvtMoneyList.add(cvtMoney);
                            opElimMoneyList.add(elimMoney);
                        }
                        checkRecordIds.addAll(datas.stream().map(CheckEntryData::getHeaderId).collect(Collectors.toSet()));
                        doc.add((Object)entry);
                    }
                });
            });
            BigDecimal myCvtMoney = myCvtMoneyList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal opCvtMoney = opCvtMoneyList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal myElimMoney = myElimMoneyList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal opElimMoney = opElimMoneyList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal cvtDifMoney = myCvtMoney.add(opCvtMoney);
            recordsum.set("mycvtmoney", (Object)myCvtMoney);
            recordsum.set("opcvtmoney", (Object)opCvtMoney);
            recordsum.set("myelimmoney", (Object)myElimMoney);
            recordsum.set("opelimmoney", (Object)opElimMoney);
            recordsum.set("cvtdifmoney", (Object)cvtDifMoney);
            this.checkRecordSumList.add(recordsum);
            this.checkRecordLinkList.addAll(this.generateCheckRecordLink(recordsum, checkRecordIds));
        }))));
    }

    private List<DynamicObject> generateCheckRecordLink(DynamicObject header, Set<Long> checkRecordIds) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        checkRecordIds.forEach(checkRecordId -> {
            DynamicObject link = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checkrecord_link");
            link.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            link.set("model", this.checkParam.getModel().p1);
            link.set("checkrecordsum", (Object)header);
            link.set("checkrecord", checkRecordId);
            result.add(link);
        });
        return result;
    }

    @Override
    public void check(Pair<DiffModeEnum, DiffMethodEnum> mode) {
        throw new UnsupportedOperationException("kd.fi.bcm.business.check.sum.CheckSumService.check is Unsupported");
    }
}

