/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.task;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kd.fi.bcm.business.check.CheckContext;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.CheckResult;
import kd.fi.bcm.business.check.helper.CheckServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;

public class ActionCheck {
    private CheckParam checkParam;
    private List<Tuple<Long, String, String>> entities;
    private Consumer<Integer> outerTaskCallback;
    private int totalStep = 0;
    private AtomicInteger stepCount = new AtomicInteger(0);
    private HashMultimap<Pair<Long, String>, Long> mulMap;

    public ActionCheck(CheckParam checkParam, List<Tuple<Long, String, String>> entities, Consumer<Integer> outerTaskCallback) {
        this.checkParam = checkParam;
        this.entities = entities;
        this.totalStep = entities.size() * 10;
        this.outerTaskCallback = outerTaskCallback;
    }

    public ActionCheck(CheckParam checkParam, HashMultimap<Pair<Long, String>, Long> mulMap, Consumer<Integer> outerTaskCallback) {
        this.checkParam = checkParam;
        this.mulMap = mulMap;
        this.totalStep = mulMap.asMap().size() * 10;
        this.outerTaskCallback = outerTaskCallback;
    }

    public Map<String, Object> executeCheck() {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        for (int i = 0; i < this.entities.size(); ++i) {
            Tuple<Long, String, String> entity = this.entities.get(i);
            CheckParam param = new CheckParam(this.checkParam.getModel(), this.checkParam.getScene(), this.checkParam.getYear(), this.checkParam.getPeriod(), (Pair<Long, String>)Pair.onePair((Object)entity.p1, (Object)entity.p2), this.checkParam.getCurrency(), this.checkParam.isIncludeAdj(), this.checkParam.isGenerateElim(), this.checkParam.getIcNumbers(), this.checkParam.getElimType(), this.checkParam.getCheckTmpl(), this.checkParam.getCreateTypeEnum());
            int currentIndex = i;
            param.setTaskCallback(isComplete -> {
                int ps = 0;
                if (!isComplete.booleanValue()) {
                    ps = 100 * this.stepCount.incrementAndGet() / this.totalStep;
                } else {
                    this.stepCount.set((currentIndex + 1) * 10);
                    ps = 100 * this.stepCount.get() / this.totalStep;
                }
                this.outerTaskCallback.accept(ps);
            });
            CheckResult checkResult = CheckServiceHelper.check(param);
            param.getTaskCallback().accept(true);
            if (checkResult == null) continue;
            if ("fail".equals(checkResult.getErrorCode())) {
                result.put("errorInfo", checkResult.getMessage());
                return result;
            }
            if (!(checkResult.getData() instanceof Map)) continue;
            result.putAll((Map)checkResult.getData());
        }
        return result;
    }

    public Map<String, Object> executeBatchDiffProcess() {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        AtomicInteger i = new AtomicInteger();
        this.mulMap.asMap().forEach((entityPair, ids) -> {
            CheckParam param = new CheckParam(this.checkParam.getModel(), this.checkParam.getScene(), this.checkParam.getYear(), this.checkParam.getPeriod(), (Pair<Long, String>)Pair.onePair((Object)entityPair.p1, (Object)entityPair.p2), this.checkParam.getCurrency(), this.checkParam.isIncludeAdj(), this.checkParam.isGenerateElim(), this.checkParam.getIcNumbers(), this.checkParam.getElimType(), this.checkParam.getCheckTmpl(), this.checkParam.getCreateTypeEnum());
            param.put("checkRecordIds", Sets.newHashSet((Iterable)ids));
            param.setIsAutoElim("0");
            int currentIndex = i.get();
            param.setTaskCallback(isComplete -> {
                int ps = 0;
                if (!isComplete.booleanValue()) {
                    ps = 100 * this.stepCount.incrementAndGet() / this.totalStep;
                } else {
                    this.stepCount.set((currentIndex + 1) * 10);
                    ps = 100 * this.stepCount.get() / this.totalStep;
                }
                this.outerTaskCallback.accept(ps);
            });
            CheckResult checkResult = CheckServiceHelper.check(new CheckContext(param), this.checkParam.getDiffPair());
            param.getTaskCallback().accept(true);
            if (checkResult != null && "fail".equals(checkResult.getErrorCode())) {
                result.put("errorInfo", checkResult.getMessage());
                return;
            }
            if (checkResult != null && checkResult.getData() instanceof Map) {
                result.putAll((Map)checkResult.getData());
            }
            i.getAndIncrement();
        });
        return result;
    }
}

