/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.task.ActionCheck;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class ActionCheckTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ActionCheckTask.class);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        OperationContext context = OperationContext.get();
        if (context != null) {
            context.setFormId("bcm_checkmainpage");
        }
        String message = ResManager.loadKDString((String)"\u6b63\u5728\u5bf9\u8d26\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"ActionCheckTask_01", (String)"fi-bcm-business", (Object[])new Object[0]);
        this.feedbackProgress(0, message, null);
        if (this.isStop()) {
            this.stop();
        }
        Boolean success = Boolean.TRUE;
        String errorMessage = "";
        Long modelId = 0L;
        Map<Object, Object> executeCheckRes = new HashMap(16);
        try {
            if (this.isStop()) {
                this.stop();
            }
            CheckUtil.requestContextWrapper(requestContext, params);
            CheckParam checkParam = (CheckParam)ObjectSerialUtil.deSerializedBytes((String)((String)params.get("checkParam")));
            modelId = (Long)checkParam.getModel().p1;
            List entities = (List)ObjectSerialUtil.deSerializedBytes((String)((String)params.get("entities")));
            ActionCheck actionCheck = new ActionCheck(checkParam, entities, i -> this.feedbackProgress((int)i, message, null));
            executeCheckRes = actionCheck.executeCheck();
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            success = Boolean.FALSE;
            log.error((Throwable)e);
        }
        finally {
            this.feedbackProgress(100, errorMessage, null);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("success", success);
        result.put("modelId", modelId);
        result.put("message", errorMessage);
        result.put("unOpenPeriodOrg", params.get("unOpenPeriodOrg"));
        result.put("permInfo", params.get("permInfo"));
        result.put("taskType", params.get("taskType"));
        result.put("executeCheckRes", ObjectSerialUtil.toByteSerialized(executeCheckRes));
        this.feedbackCustomdata(result);
    }
}

