/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.business.chkcheck.model.ChkMember;
import kd.fi.bcm.business.chkcheck.model.MemberRangeEntry;
import kd.fi.bcm.business.chkcheck.model.MultiTemplateModel;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkMemberRangeLimitTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ChkFormulaModel
extends DynaEntityObject {
    private static final long serialVersionUID = 1L;
    private List<MultiTemplateModel> multitemplate;
    private boolean umtemp = true;
    private boolean isEdit = false;
    private boolean isdistcslscheme = false;
    private DynamicObjectCollection mulCslScheme;
    private DynamicObjectCollection effectivePeriod;
    private String chineseformula;
    private boolean isPureXdmFormula = false;
    private Object multiLangName;

    public ChkFormulaModel() {
        this.put("memberrange", (Object)new ArrayList(10));
        this.setStatus(CHKFormulaStatusEnum.enable.getIndex());
        this.setDataEntityNumber("bcm_chkformulasetting");
    }

    public void setEdit(boolean edit) {
        this.isEdit = edit;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public boolean isPureXdmFormula() {
        return this.isPureXdmFormula;
    }

    public void setPureXdmFormula(boolean pureXdmFormula) {
        this.isPureXdmFormula = pureXdmFormula;
    }

    public List<MemberRangeEntry> getMemberRangeEntries() {
        return (List)this.get("memberrange");
    }

    public void addMemberRangeEntries(MemberRangeEntry e) {
        this.getMemberRangeEntries().add(e);
    }

    public void loadDynaObj2Model(DynamicObject dyna) {
        DynamicObject[] array = new DynamicObject[]{dyna};
        Map<String, Map<Long, DynamicObject>> memberMap = ChkCheckServiceHelper.getMemberData(array);
        this.loadDynaObj2Model(dyna, memberMap, true);
    }

    public void loadDynaObj2Model(DynamicObject dyna, Map<String, Map<Long, DynamicObject>> memberMap, boolean findLatestTmp) {
        this.loadDynaObj2ModelEx(dyna, memberMap);
        ArrayList<MultiTemplateModel> multi = new ArrayList<MultiTemplateModel>(10);
        for (DynamicObject obj : dyna.getDynamicObjectCollection("multitemplate")) {
            Map<Long, Long> groupId2LastTempIdMap;
            DynamicObject tpl = obj.getDynamicObject("fbasedataid");
            if (tpl == null) continue;
            long lastTplId = tpl.getLong("id");
            if (findLatestTmp && !(groupId2LastTempIdMap = TemplateServiceHelper.getGroupId2LastTempIdMap(this.getModelId())).isEmpty() && groupId2LastTempIdMap.get(tpl.getLong("group")) != null) {
                lastTplId = groupId2LastTempIdMap.get(tpl.getLong("group"));
            }
            MultiTemplateModel mt = new MultiTemplateModel(tpl.getLong("id"), lastTplId, tpl.getString("number"));
            mt.setType(obj.getDynamicObjectType());
            mt.setBasetype(tpl.getDynamicObjectType());
            multi.add(mt);
        }
        this.setMultiTemplate(multi);
    }

    public void loadDynaObj2ModelEx(DynamicObject dyna, Map<String, Map<Long, DynamicObject>> memberMap) {
        Predicate<Object> p = t -> t == null;
        this.setId(dyna.getLong("id"));
        this.setName(dyna.getString("name"));
        this.setNumber(dyna.getString("number"));
        this.setModelId(this.defaultIfNull(p, dyna.getDynamicObject("model"), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setOrg(this.defaultIfNull(p, dyna.getDynamicObject("org"), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setTemplate(this.defaultIfNull(p, dyna.getDynamicObject("template"), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setCreatorId(this.defaultIfNull(p, dyna.getDynamicObject("creator"), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setModifierId(this.defaultIfNull(p, dyna.getDynamicObject("modifier"), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setCreateTime(dyna.getDate("createTime"));
        this.setModifyTime(dyna.getDate("modifytime"));
        String leftFormula = dyna.getString("leftformula");
        this.setLeftformula(leftFormula);
        this.setLformulatemp(dyna.getString("lformulatemp"));
        String rightFormula = dyna.getString("rightformula");
        this.setRightformula(rightFormula);
        this.setRformulatemp(dyna.getString("rformulatemp"));
        this.setComparetype(dyna.getString("comparetype"));
        this.setChkeffecttype(dyna.getString("chkeffecttype"));
        this.setStatus(dyna.getString("status"));
        this.setDescription(dyna.getString("description"));
        this.setAllowamount(Double.parseDouble(dyna.getString("allowamount")));
        this.setPeriodTxt(dyna.getString("periodtxt"));
        this.setVRangeTxt(dyna.getString("vrangetxt"));
        this.setVFixDimTxt(dyna.getString("vfixdimtxt"));
        this.setChineseformula(dyna.getString("chineseformula"));
        DynamicObjectCollection entries = dyna.getDynamicObjectCollection("memberrange");
        this.getMemberRangeEntries().addAll(new MemberRangeEntry(this).loadDynaObject(entries, () -> this, memberMap));
        DynamicObjectCollection mulcslschemes = dyna.getDynamicObjectCollection("mulcslscheme");
        this.setMulCslscheme(mulcslschemes);
        if (CollectionUtils.isNotEmpty((Collection)mulcslschemes)) {
            this.isdistcslscheme = true;
        }
        DynamicObjectCollection effective = dyna.getDynamicObjectCollection("effective");
        this.setEffectivePeriod(effective);
        this.isEdit = true;
        if (StringUtils.isNotEmpty((CharSequence)leftFormula)) {
            this.isPureXdmFormula = !leftFormula.contains("V(") && (!StringUtils.isNotEmpty((CharSequence)rightFormula) || !rightFormula.contains("V("));
        }
    }

    public boolean getUmtemp() {
        return this.umtemp;
    }

    public void setUmtemp(boolean umtemp) {
        this.umtemp = umtemp;
    }

    private <R> R defaultIfNull(Predicate<Object> p, Object v, R defaultValue, Function<Object, R> f) {
        if (p.test(v)) {
            return defaultValue;
        }
        return f.apply(v);
    }

    @Override
    public boolean isIncludeField(Object key) {
        return super.isIncludeField(key);
    }

    public void setModelId(long modelId) {
        this.put("model", (Object)modelId);
    }

    public long getModelId() {
        return (Long)this.get("model");
    }

    @Override
    public void setNumber(String number) {
        this.put("number", (Object)number);
    }

    @Override
    public String getNumber() {
        return (String)this.get("number");
    }

    @Override
    public void setName(String name) {
        this.put("name", (Object)name);
    }

    @Override
    public String getName() {
        return (String)this.get("name");
    }

    public void setLeftformula(String leftformula) {
        this.put("leftformula", (Object)leftformula);
    }

    public String getLeftformula() {
        return (String)this.get("leftformula");
    }

    public void setLformulatemp(String lformulatemp) {
        this.put("lformulatemp", (Object)lformulatemp);
    }

    public String getLformulatemp() {
        return (String)this.get("lformulatemp");
    }

    public void setRightformula(String rightformula) {
        this.put("rightformula", (Object)rightformula);
    }

    public String getRightformula() {
        return (String)this.get("rightformula");
    }

    public void setRformulatemp(String rformulatemp) {
        this.put("rformulatemp", (Object)rformulatemp);
    }

    public String getRformulatemp() {
        return (String)this.get("rformulatemp");
    }

    public void setComparetype(String comparetype) {
        this.put("comparetype", (Object)comparetype);
    }

    public String getComparetype() {
        return (String)this.get("comparetype");
    }

    public void setAllowamount(double allowamount) {
        this.put("allowamount", (Object)allowamount);
    }

    public double getAllowamount() {
        return (Double)this.get("allowamount");
    }

    public void setChkeffecttype(String chkeffecttype) {
        this.put("chkeffecttype", (Object)chkeffecttype);
    }

    public String getChkeffecttype() {
        return (String)this.get("chkeffecttype");
    }

    public void setOrg(long org) {
        this.put("org", (Object)org);
    }

    public long getOrg() {
        return (Long)this.get("org");
    }

    public void setTemplate(long template) {
        this.put("template", (Object)template);
    }

    public void setMultiTemplate(List<MultiTemplateModel> templates) {
        this.multitemplate = templates;
    }

    public void setMultiTemplate(DynamicObjectCollection templates) {
        this.put("multitemplate", (Object)templates);
    }

    public long getTemplate() {
        return this.get("template") == null ? 0L : (Long)this.get("template");
    }

    public List<MultiTemplateModel> getMultiTemplate() {
        return this.multitemplate;
    }

    public void setCreateTime(Date createTime) {
        this.put("createTime", (Object)createTime);
    }

    public Date getCreateTime() {
        return (Date)this.get("createTime");
    }

    public void setModifyTime(Date modifyTime) {
        this.put("modifytime", (Object)modifyTime);
    }

    public Date getModifyTime() {
        return (Date)this.get("modifytime");
    }

    public void setCreatorId(long creatorId) {
        this.put("creator", (Object)creatorId);
    }

    public long getCreatorId() {
        return (Long)this.get("creator");
    }

    public void setModifierId(long modifierId) {
        this.put("modifier", (Object)modifierId);
    }

    public long getModifierId() {
        return (Long)this.get("modifier");
    }

    public final void setStatus(String status) {
        this.put("status", (Object)status);
    }

    public String getStatus() {
        return (String)this.get("status");
    }

    public void setDescription(String description) {
        this.put("description", (Object)description);
    }

    public String getDescription() {
        return (String)this.get("description");
    }

    public void setRangeTxt(String rangeTxt) {
        this.put("rangetxt", (Object)rangeTxt);
    }

    public String getRangeTxt() {
        return (String)this.get("rangetxt");
    }

    public void setVRangeTxt(String vrangeTxt) {
        this.put("vrangetxt", (Object)vrangeTxt);
    }

    public String getVRangeTxt() {
        return (String)this.get("vrangetxt");
    }

    public void setMRangeTxt(String mrangeTxt) {
        this.put("mrangetxt", (Object)mrangeTxt);
    }

    public String getMRangeTxt() {
        return (String)this.get("mrangetxt");
    }

    public void setPeriodTxt(String periodTxt) {
        this.put("periodtxt", (Object)periodTxt);
    }

    public String getPeriodTxt() {
        return (String)this.get("periodtxt");
    }

    public void setFixDimTxt(String fixDimTxt) {
        this.put("fixdimtxt", (Object)fixDimTxt);
    }

    public String getFixDimTxt() {
        return (String)this.get("fixdimtxt");
    }

    public void setVFixDimTxt(String vfixDimTxt) {
        this.put("vfixdimtxt", (Object)vfixDimTxt);
    }

    public String getVFixDimTxt() {
        return (String)this.get("vfixdimtxt");
    }

    public void setMFixDimTxt(String mfixDimTxt) {
        this.put("mfixdimtxt", (Object)mfixDimTxt);
    }

    public String getMFixDimTxt() {
        return (String)this.get("mfixdimtxt");
    }

    public List<MemberRangeEntry> getScope() {
        return this.getMemberRangeEntriesByType(ChkMemberRangeLimitTypeEnum.INBOUND.getLimitType());
    }

    public List<MemberRangeEntry> getUnScope() {
        return this.getMemberRangeEntriesByType(ChkMemberRangeLimitTypeEnum.OUTBOUND.getLimitType());
    }

    public void setTempMatchRule(String tempmatchrule) {
        this.put("tempmatchrule", (Object)tempmatchrule);
    }

    public String getTempMatchRule() {
        return (String)this.get("tempmatchrule");
    }

    public List<MemberRangeEntry> getMapdim() {
        return this.getMemberRangeEntriesByType(ChkMemberRangeLimitTypeEnum.COMMON.getLimitType());
    }

    private List<MemberRangeEntry> getMemberRangeEntriesByType(String limittype) {
        ArrayList<MemberRangeEntry> mbrs = new ArrayList<MemberRangeEntry>(10);
        block0: for (MemberRangeEntry mbr : this.getMemberRangeEntries()) {
            for (ChkMember cm : mbr.getAllMembProperties()) {
                if (!limittype.equals(cm.getLimittype())) continue;
                mbrs.add(mbr);
                continue block0;
            }
        }
        return mbrs;
    }

    public boolean isDistcslscheme() {
        return this.isdistcslscheme;
    }

    public void setIsdistcslscheme(boolean isdistcslscheme) {
        this.isdistcslscheme = isdistcslscheme;
    }

    public DynamicObjectCollection getMulCslscheme() {
        return this.mulCslScheme;
    }

    public void setMulCslscheme(DynamicObjectCollection mulCslscheme) {
        this.mulCslScheme = mulCslscheme;
    }

    public DynamicObjectCollection getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public void setEffectivePeriod(DynamicObjectCollection effectivePeriod) {
        this.effectivePeriod = effectivePeriod;
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this.getClass().getSimpleName(), ToStringStyle.NO_CLASS_NAME_STYLE);
        this.forEach((k, v) -> {
            if (v != null) {
                builder.append(k, v);
            }
        });
        builder.append((Object)("multitemplate=" + this.multitemplate + ", umtemp=" + this.umtemp + ", isEdit=" + this.isEdit + ", isdistcslscheme=" + this.isdistcslscheme + ", mulCslScheme=" + this.mulCslScheme));
        return builder.toString();
    }

    public void setChineseformula(String chineseformula) {
        this.chineseformula = chineseformula;
    }

    public String getChineseformula() {
        return this.chineseformula;
    }

    public Object getMultiLangName() {
        return this.multiLangName == null ? this.getName() : this.multiLangName;
    }

    public void setMultiLangName(Object multiLangName) {
        this.multiLangName = multiLangName;
    }
}

