/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.model;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.ParseException;

@SDKMark
public class ChkResultMapFormulaModel
extends HashMap<String, String> {
    private static final Log log = LogFactory.getLog(ChkResultMapFormulaModel.class);
    private static final long serialVersionUID = 1L;
    private String concreteFormula;
    private String result;
    private String abstractFormula;
    private String formulaExpression;
    private String resultMap;

    public final void init() {
        this.anlysis2AbstractFormula();
        try {
            this.analysisResult();
        }
        catch (Exception e) {
            log.error("analysis error!", (Throwable)e);
        }
    }

    public ChkResultMapFormulaModel(String concreteFormula, String result) {
        this.concreteFormula = concreteFormula;
        this.result = result;
        this.init();
    }

    public final void anlysis2AbstractFormula() {
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        try {
            Pair<String, List<IFormula>> pair = parser.parse(this.concreteFormula, coder);
            Pair<String, List<IFormula>> pair1 = parser.parse(this.result, coder);
            this.abstractFormula = (String)pair.p1;
            this.result = (String)pair1.p1;
        }
        catch (ParseException e) {
            this.abstractFormula = "A";
        }
        catch (Exception e) {
            log.error("analysis error!", (Throwable)e);
        }
    }

    public final void analysisResult() {
        if (this.result.contains("kd.fi.bcm.business.formula.calculate.exception.InvalidParamException: ")) {
            return;
        }
        if (this.isJudgeFormula(this.concreteFormula)) {
            this.formulaExpression = this.result;
            this.put("A", this.result);
            return;
        }
        int length = this.abstractFormula.length();
        int startIndex = this.abstractFormula.indexOf(65);
        char[] results = this.result.toCharArray();
        char[] formulas = this.abstractFormula.toCharArray();
        StringBuilder formulaExpressinSb = new StringBuilder();
        if (startIndex >= 0) {
            formulaExpressinSb.append(this.abstractFormula, 0, startIndex);
        } else {
            formulaExpressinSb.append(this.abstractFormula);
        }
        if (startIndex >= 0) {
            StringBuilder sb = new StringBuilder();
            int currentIndex = startIndex;
            int difference = 0;
            StringBuilder absF = new StringBuilder();
            for (int i = startIndex; i < length; ++i) {
                if (!Character.isUpperCase(formulas[i]) && !Character.isLowerCase(formulas[i])) {
                    if (this.result.equalsIgnoreCase("false") || this.result.equalsIgnoreCase("true")) continue;
                    formulaExpressinSb.append(formulas[i]);
                    ++difference;
                    continue;
                }
                if (currentIndex + difference < results.length) {
                    boolean isNumber = false;
                    while (Character.isDigit(results[currentIndex + difference]) || '.' == results[currentIndex + difference] || ',' == results[currentIndex + difference] || !isNumber && '-' == results[currentIndex + difference]) {
                        difference = 0;
                        sb.append(results[currentIndex += difference]);
                        isNumber = true;
                        if (++currentIndex <= results.length - 1) continue;
                        currentIndex = results.length - 1;
                        break;
                    }
                }
                absF.append(formulas[i]);
                while (i + 1 < length && (Character.isLowerCase(formulas[i + 1]) || Character.isUpperCase(formulas[i + 1]))) {
                    absF.append(formulas[i + 1]);
                    ++i;
                }
                if (this.result.equalsIgnoreCase("false") || this.result.equalsIgnoreCase("true")) {
                    this.put(String.valueOf(formulas[i]), this.result);
                } else {
                    this.put(String.valueOf(absF), sb.toString());
                }
                try {
                    if (Double.valueOf(sb.toString()).compareTo(0.0) < 0) {
                        formulaExpressinSb.append('(');
                        formulaExpressinSb.append("#{");
                        formulaExpressinSb.append((CharSequence)absF);
                        formulaExpressinSb.append('}');
                        formulaExpressinSb.append(')');
                    } else {
                        formulaExpressinSb.append("#{");
                        formulaExpressinSb.append((CharSequence)absF);
                        formulaExpressinSb.append('}');
                    }
                }
                catch (NumberFormatException e) {
                    formulaExpressinSb.append("#{");
                    formulaExpressinSb.append((CharSequence)absF);
                    formulaExpressinSb.append('}');
                }
                sb.setLength(0);
                absF.setLength(0);
            }
        }
        this.formulaExpression = formulaExpressinSb.toString();
    }

    public static void main(String[] args) {
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        Pair<String, List<IFormula>> pair = Pair.onePair(null, null);
        try {
            pair = parser.parse("(11+7*(9+10))*8", coder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getConcreteFormula() {
        return this.concreteFormula;
    }

    public String getResult() {
        return this.result;
    }

    public String getAbstractFormula() {
        return this.abstractFormula;
    }

    public String getFormulaExpression() {
        return this.formulaExpression;
    }

    public void setResultMap(String resultMap) {
        this.resultMap = resultMap;
    }

    public String getResultMap() {
        return this.resultMap;
    }

    private boolean isJudgeFormula(String formula) {
        boolean isJudge = false;
        if ((formula = formula.toUpperCase(Locale.ENGLISH)).contains("IF(") || formula.contains("AND(") || formula.contains("OR(") || formula.contains("ROUND(") || formula.contains("ABS(") || formula.contains("LEN(")) {
            isJudge = true;
        }
        return isJudge;
    }
}

