/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.model;

import java.math.BigDecimal;
import java.util.Locale;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.chkcheck.CHKCheckEffectEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CheckResultenum;
import kd.fi.bcm.fel.common.StringUtils;

public class ChkResultModel {
    private ExpressStatus leftstatus;
    private ExpressStatus rightstatus;
    private BigDecimal leftresult;
    private BigDecimal rightresult;
    private long setid;
    private long tmpid;
    private String leftformla;
    private String rightformula;
    private String leftformlatemp;
    private String rightformulatemp;
    private CHKCheckEffectEnum checkEffect;
    private CHKTypeEnum opera;
    private double allowamount;
    private ChkFormulaModel ckm;
    private String lefttext;
    private String righttext;
    private boolean isText;
    private boolean forcePass;
    private String leftFormulaErr;
    private String rightFormulaErr;
    private String process;
    private String currency;
    private String fulllformula;
    private String fullrformula;
    private String expandLFormula;
    private String expandRFormula;
    private boolean judge;

    public ChkResultModel(ExpressStatus leftstatus, String leftformlatemp, String leftformla, long setid) {
        this.leftstatus = leftstatus;
        this.leftformlatemp = leftformlatemp;
        this.leftformla = leftformla;
        this.setid = setid;
    }

    public ChkResultModel(ExpressStatus leftstatus, ExpressStatus rightstatus, String leftformlatemp, String rightformulatemp, String leftformla, String rightformula, int opera, long setid) {
        this(leftstatus, leftformlatemp, leftformla, setid);
        this.rightstatus = rightstatus;
        this.rightformulatemp = rightformulatemp;
        this.rightformula = rightformula;
        this.opera = CHKTypeEnum.getCHKTypeEnumByIndex((int)opera);
    }

    public CHKCheckEffectEnum getCheckEffect() {
        return this.checkEffect;
    }

    public void setCheckEffect(CHKCheckEffectEnum checkEffect) {
        this.checkEffect = checkEffect;
    }

    public String getLeftformlatemp() {
        return this.leftformlatemp;
    }

    public String getRightformulatemp() {
        return this.rightformulatemp;
    }

    public String getBalance() {
        if (StringUtils.isNotEmpty((CharSequence)this.leftFormulaErr)) {
            return this.leftFormulaErr.length() > 200 ? this.leftFormulaErr.substring(0, 200) : this.leftFormulaErr;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.rightFormulaErr)) {
            return this.rightFormulaErr.length() > 200 ? this.rightFormulaErr.substring(0, 200) : this.rightFormulaErr;
        }
        if (this.isText) {
            return null;
        }
        BigDecimal re = this.leftresult.subtract(this.rightresult);
        return re.toPlainString();
    }

    public CheckResultenum getResult() {
        if (CHKCheckEffectEnum.TipAndNotReport == this.getCheckEffect()) {
            if (this.isPass()) {
                return CheckResultenum.SUCCESS;
            }
            return CheckResultenum.FAIL;
        }
        if (CHKCheckEffectEnum.TipAndReport == this.getCheckEffect()) {
            if (this.isPass()) {
                return CheckResultenum.SUCCESS;
            }
            return CheckResultenum.REMIND;
        }
        if (CHKCheckEffectEnum.NoteAndReport == this.getCheckEffect()) {
            if (this.isPass()) {
                return CheckResultenum.SUCCESS;
            }
            return CheckResultenum.FAIL;
        }
        return null;
    }

    public void setForcePass(boolean forcePass) {
        this.forcePass = forcePass;
    }

    public boolean isForcePass() {
        return this.forcePass;
    }

    public boolean isPass() {
        if (this.forcePass) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.leftFormulaErr) || StringUtils.isNotEmpty((CharSequence)this.rightFormulaErr)) {
            return false;
        }
        if (this.isText) {
            if (this.judge) {
                return this.lefttext != null && StringUtils.equals((CharSequence)Boolean.TRUE.toString(), (CharSequence)this.lefttext.toLowerCase(Locale.ENGLISH));
            }
            return this.isTextPass();
        }
        BigDecimal re = this.leftresult.subtract(this.rightresult);
        switch (this.opera) {
            case EQUAL: {
                return re.compareTo(BigDecimal.ZERO) == 0 || BigDecimal.valueOf(this.getAllowamount()).abs().compareTo(re.abs()) >= 0;
            }
            case LARGE_THAN: {
                return re.compareTo(BigDecimal.ZERO) > 0;
            }
            case LARGE_EQUALS: {
                return re.compareTo(BigDecimal.ZERO) >= 0 || BigDecimal.valueOf(this.getAllowamount()).abs().compareTo(re.abs()) >= 0;
            }
            case LESS_THAN: {
                return re.compareTo(BigDecimal.ZERO) < 0;
            }
            case LESS_EQUALS: {
                return re.compareTo(BigDecimal.ZERO) <= 0 || BigDecimal.valueOf(this.getAllowamount()).abs().compareTo(re.abs()) >= 0;
            }
            case NOT_EQUALS: {
                return re.compareTo(BigDecimal.ZERO) != 0;
            }
        }
        return false;
    }

    private boolean isTextPass() {
        if (this.lefttext != null && this.righttext != null) {
            if (this.lefttext.equals(this.righttext)) {
                return !this.lefttext.contains("kd.fi.bcm.business.formula.calculate.exception.InvalidParamException: ") && this.getResultByOpera();
            }
            return this.opera == CHKTypeEnum.NOT_EQUALS;
        }
        if (this.isEmptyStringAndZero(this.lefttext, this.rightresult) || this.isEmptyStringAndZero(this.righttext, this.leftresult)) {
            return this.getResultByOpera();
        }
        return this.opera == CHKTypeEnum.NOT_EQUALS;
    }

    private boolean getResultByOpera() {
        switch (this.opera) {
            case EQUAL: 
            case LARGE_EQUALS: 
            case LESS_EQUALS: {
                return true;
            }
        }
        return false;
    }

    private boolean isEmptyStringAndZero(String text, BigDecimal number) {
        return "".equals(text) && (number == null || number == BCMConstant.Zero);
    }

    public long getSetid() {
        return this.setid;
    }

    public CHKTypeEnum getOpera() {
        return this.opera;
    }

    public boolean setRightresult(CalculateService service) {
        boolean is = true;
        Object express = null;
        try {
            express = service.evalExpress(this.rightstatus);
            if (express instanceof Exception) {
                this.rightFormulaErr = ((Exception)express).getMessage();
                return false;
            }
            if (express instanceof String) {
                this.isText = true;
                this.righttext = String.valueOf(express);
            } else {
                this.rightresult = express instanceof BigDecimal ? (BigDecimal)express : new BigDecimal(express.toString());
            }
        }
        catch (NumberFormatException e) {
            this.isText = true;
            this.righttext = String.valueOf(express);
        }
        catch (ArithmeticException e) {
            if (e.getMessage().contains("Division")) {
                is = false;
            }
        }
        catch (NullPointerException e) {
            this.rightresult = BigDecimal.ZERO;
        }
        return is;
    }

    public void setRightresult(BigDecimal rightresult) {
        this.rightresult = rightresult;
    }

    public boolean setLeftresult(CalculateService service) {
        boolean is = true;
        Object express = null;
        try {
            express = service.evalExpress(this.leftstatus);
            if (express instanceof Exception) {
                this.leftFormulaErr = ((Exception)express).getMessage();
                return false;
            }
            if (express instanceof String) {
                this.isText = true;
                this.lefttext = String.valueOf(express);
            } else {
                this.leftresult = express instanceof BigDecimal ? (BigDecimal)express : new BigDecimal(express.toString());
            }
        }
        catch (NumberFormatException e) {
            this.isText = true;
            this.lefttext = String.valueOf(express);
        }
        catch (ArithmeticException e) {
            if (e.getMessage().contains("Division")) {
                is = false;
            }
        }
        catch (NullPointerException e) {
            this.leftresult = BigDecimal.ZERO;
        }
        return is;
    }

    public void setLeftresult(BigDecimal leftresult) {
        this.leftresult = leftresult;
    }

    public BigDecimal getLeftresult() {
        return this.leftresult;
    }

    public BigDecimal getRightresult() {
        return this.rightresult;
    }

    public ExpressStatus getLeftstatus() {
        return this.leftstatus;
    }

    public ExpressStatus getRightstatus() {
        return this.rightstatus;
    }

    public String getLeftformla() {
        return this.leftformla;
    }

    public String getRightformula() {
        return this.rightformula;
    }

    public void setAllowamount(double allowamount) {
        this.allowamount = allowamount;
    }

    public double getAllowamount() {
        return this.allowamount;
    }

    public long getTmpid() {
        return this.tmpid;
    }

    public void setTmpid(long tmpid) {
        this.tmpid = tmpid;
    }

    public ChkFormulaModel getCkm() {
        return this.ckm;
    }

    public void setCkm(ChkFormulaModel ckm) {
        this.ckm = ckm;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public String getProcess() {
        return this.process;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getFulllformula() {
        return this.fulllformula;
    }

    public void setFulllformula(String fulllformula) {
        this.fulllformula = fulllformula;
    }

    public String getFullrformula() {
        return this.fullrformula;
    }

    public void setFullrformula(String fullrformula) {
        this.fullrformula = fullrformula;
    }

    public boolean getJudge() {
        return this.judge;
    }

    public void setJudge(boolean judge) {
        this.judge = judge;
    }

    public boolean isText() {
        return this.isText;
    }

    public String getExpandLFormula() {
        return this.expandLFormula;
    }

    public void setExpandLFormula(String expandLFormula) {
        this.expandLFormula = expandLFormula;
    }

    public String getExpandRFormula() {
        return this.expandRFormula;
    }

    public void setExpandRFormula(String expandRFormula) {
        this.expandRFormula = expandRFormula;
    }
}

