/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.model.MultiTemplateModel;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.dimension.data.MemberMsgCache;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.CommonSqlMsgUtil;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkSourceEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkStatusGenEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class ChkStatusBuilder {
    private ICalContext ctx;
    private Map<Long, Table<String, String, Boolean>> status;
    private boolean needCollect;
    private long ecId;
    private long pcId;
    private Set<Long> erptIds = new HashSet<Long>(3);
    private Set<Long> rptIds = new HashSet<Long>(3);
    private List<DynamicObject> oldChkReports;
    private static final Log LOG = LogFactory.getLog(ChkStatusBuilder.class);

    public ChkStatusBuilder(ICalContext ctx, boolean syncStatus) {
        if (syncStatus) {
            this.ctx = ctx;
            String modelNum = MemberReader.findModelNumberById((Object)ctx.getModelId());
            this.ecId = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)((String)ctx.getProperty("ecCurrency"))).getId();
            this.pcId = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)((String)ctx.getProperty("pcCurrency"))).getId();
            ParamConstant.ERptProcess.forEach(process -> this.erptIds.add(MemberReader.findProcessMemberByNum((String)modelNum, (String)process).getId()));
            ParamConstant.RptProcess.forEach(process -> this.rptIds.add(MemberReader.findProcessMemberByNum((String)modelNum, (String)process).getId()));
        }
    }

    public ChkStatusBuilder(ICalContext ctx) {
        this.ctx = ctx;
        this.status = new HashMap<Long, Table<String, String, Boolean>>();
        this.needCollect = true;
        this.ecId = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)ctx.getModelId()), (String)((String)ctx.getProperty("ecCurrency"))).getId();
        this.pcId = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)ctx.getModelId()), (String)((String)ctx.getProperty("pcCurrency"))).getId();
        Map<String, Long> bpNumber2Id = ctx.getBpNumber2Id();
        ParamConstant.ERptProcess.forEach(d -> {
            if (bpNumber2Id.containsKey(d)) {
                this.erptIds.add((Long)bpNumber2Id.get(d));
            }
        });
        ParamConstant.RptProcess.forEach(d -> {
            if (bpNumber2Id.containsKey(d)) {
                this.rptIds.add((Long)bpNumber2Id.get(d));
            }
        });
        this.oldChkReports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"chkformula.id,chkformula.multitemplate.fbasedataid.id,chkformula.status,process.number", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)ctx.getOrgId()), new QFilter("period", "=", (Object)ctx.getPeriodId()), new QFilter("year", "=", (Object)ctx.getYearId()), new QFilter("model", "=", (Object)ctx.getModelId()), new QFilter("scenario", "=", (Object)ctx.getScenarioId()), new QFilter("chkresulttype", "=", (Object)String.valueOf(ChkResultTypeEnum.UNPASS.getIndex()))});
    }

    public boolean isNeedCollect() {
        return this.needCollect;
    }

    public void collectStatus(ChkFormulaModel ckm, String bp, boolean pass) {
        if (!this.isNeedCollect()) {
            return;
        }
        if (!ParamConstant.ERptProcess.contains(bp) && !ParamConstant.RptProcess.contains(bp)) {
            return;
        }
        String at = "ATTotal";
        if (ckm != null && !ckm.getMultiTemplate().isEmpty()) {
            Map formulaId2Process = (Map)this.ctx.getProperty("report_process");
            for (MultiTemplateModel multitemplate : ckm.getMultiTemplate()) {
                long tmpId = multitemplate.getTempId();
                if (!this.status.containsKey(tmpId)) {
                    HashBasedTable table = HashBasedTable.create();
                    this.status.put(tmpId, (Table<String, String, Boolean>)table);
                }
                if (this.status.get(tmpId).get((Object)bp, (Object)at) != null && !((Boolean)this.status.get(tmpId).get((Object)bp, (Object)at)).booleanValue()) continue;
                try {
                    this.status.get(tmpId).put((Object)bp, (Object)at, (Object)pass);
                    for (DynamicObject report : this.oldChkReports) {
                        if (report.getLong("chkformula.multitemplate.fbasedataid.id") != tmpId || formulaId2Process.containsKey(report.getLong("chkformula.id")) || !bp.equals(report.getString("process.number")) || !CHKFormulaStatusEnum.enable.getIndex().equals(report.getString("chkformula.status"))) continue;
                        this.status.get(tmpId).put((Object)bp, (Object)at, (Object)false);
                    }
                }
                catch (Exception e) {
                    LOG.error(String.format("collectStatus error!formula:[%s]", ckm.getNumber()), (Throwable)e);
                }
            }
        }
    }

    public List<DynamicObject> getStatusObj() {
        return this.getCollectStatusAndDeleteOld();
    }

    private List<DynamicObject> getCollectStatusAndDeleteOld() {
        Set set;
        boolean existAuditTrail = MemberReader.isExistAuditTrailDimension((String)this.ctx.getCubeNumber());
        QFilter qf = QFilter.of((String)"model=? and org=? and scenario=? and year=? and period=?", (Object[])new Object[]{this.ctx.getModelId(), this.ctx.getOrgId(), this.ctx.getScenarioId(), this.ctx.getYearId(), this.ctx.getPeriodId()});
        HashSet processIds = new HashSet(10);
        Map formulaId2Process = (Map)this.ctx.getProperty("report_process");
        Map<String, Long> bp_Number2Id = this.ctx.getBpNumber2Id();
        if (this.isNeedBatchDealProcess()) {
            processIds.addAll((Collection)this.ctx.getProperty("processIds"));
        } else {
            formulaId2Process.forEach((key, value) -> value.forEach(v -> {
                if (bp_Number2Id.containsKey(v)) {
                    processIds.add(bp_Number2Id.get(v));
                }
            }));
        }
        if (processIds.isEmpty()) {
            processIds.addAll((Collection)this.ctx.getProperty("processIds"));
            this.ctx.getProcessList().forEach(p -> {
                if (bp_Number2Id.containsKey(p)) {
                    processIds.add(bp_Number2Id.get(p));
                }
            });
        }
        qf.and(new QFilter("process", "in", processIds));
        qf.and(new QFilter("cslscheme", "in", Arrays.asList((Long)this.ctx.getProperty("cslSchemeId"), 0L)));
        DynamicObjectCollection old = QueryServiceHelper.query((String)"bcm_status", (String)"id,tmp.id,process.id,audittrail.id,checkedstatus,modifier,modifytime,process.storagetype", (QFilter[])new QFilter[]{qf});
        HashMultimap oldMap = HashMultimap.create();
        for (DynamicObject obj : old) {
            String key2 = obj.getString("tmp.id") + obj.getString("process.id") + obj.getString("audittrail.id");
            oldMap.put((Object)key2, (Object)obj.getLong("id"));
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        MemberMsgCache members = new MemberMsgCache(this.ctx.getModelId());
        members.setCustomKey("number");
        members.setSelectfiled(DimTypesEnum.PROCESS.getNumber(), "id,number");
        members.setSelectfiled(DimTypesEnum.AUDITTRIAL.getNumber(), "id,number");
        HashSet bps = new HashSet();
        HashSet ats = new HashSet();
        for (Table<String, String, Boolean> table : this.status.values()) {
            bps.addAll(table.rowKeySet());
            ats.addAll(table.columnKeySet().stream().filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
        }
        members.addCustomFilter(DimTypesEnum.PROCESS.getNumber(), new QFilter("number", "in", bps).and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index));
        if (existAuditTrail) {
            members.addCustomFilter(DimTypesEnum.AUDITTRIAL.getNumber(), new QFilter("number", "in", ats));
        }
        HashSet deleteSet = new HashSet();
        for (Map.Entry<Long, Table<String, String, Boolean>> entry : this.status.entrySet()) {
            for (String bp : entry.getValue().rowKeySet()) {
                for (String at : entry.getValue().row((Object)bp).keySet()) {
                    long bpid = (Long)members.getMsg(DimTypesEnum.PROCESS.getNumber(), bp, "id");
                    DynamicObject obj = this.getStatus(entry.getKey(), bpid, (Boolean)entry.getValue().get((Object)bp, (Object)at));
                    list.add(obj);
                    if (this.isNeedBatchDealProcess() && processIds.contains(bpid)) {
                        processIds.forEach(id -> {
                            String key = this.generateKey(obj, (long)id);
                            if (oldMap.get((Object)key) != null) {
                                deleteSet.addAll(oldMap.get((Object)key));
                            }
                        });
                        continue;
                    }
                    String key3 = this.generateKey(obj, obj.getLong("process"));
                    if (oldMap.get((Object)key3) == null) continue;
                    deleteSet.addAll(oldMap.get((Object)key3));
                }
            }
        }
        if (this.status.isEmpty() && (set = (Set)this.ctx.getProperty("tmpIds")) != null) {
            set.forEach(tmpId -> processIds.forEach(p -> {
                String key = String.valueOf(tmpId) + p + "0";
                if (oldMap.get((Object)key) != null) {
                    DynamicObject obj = this.getStatus((long)tmpId, (long)p, true);
                    list.add(obj);
                    deleteSet.addAll(oldMap.get((Object)key));
                }
            }));
        }
        DeleteServiceHelper.delete((String)"bcm_status", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteSet)});
        return list;
    }

    private String generateKey(DynamicObject status, long bpId) {
        return status.getString("tmp") + bpId + status.getString("audittrail");
    }

    private boolean isNeedBatchDealProcess() {
        return !CollectionUtils.isEmpty(this.ctx.getProcessList());
    }

    private DynamicObject getStatus(long tmpId, long bpid, boolean pass) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_status");
        obj.set("model", (Object)this.ctx.getModelId());
        obj.set("tmp", (Object)tmpId);
        obj.set("org", (Object)this.ctx.getOrgId());
        obj.set("scenario", (Object)this.ctx.getScenarioId());
        obj.set("year", (Object)this.ctx.getYearId());
        obj.set("period", (Object)this.ctx.getPeriodId());
        long ccyId = this.ctx.getCurrencyId() == null ? (this.erptIds.contains(bpid) ? this.ecId : this.pcId) : this.ctx.getCurrencyId();
        obj.set("currency", (Object)ccyId);
        obj.set("process", (Object)bpid);
        obj.set("isnewgenerate", (Object)ChkStatusGenEnum.NEW.getGenerateType());
        obj.set("cslscheme", this.ctx.getProperty("cslSchemeId"));
        if (pass) {
            obj.set("checkedstatus", (Object)ChkStatusEnum.PASS.getStatus());
            obj.set("chkresult", (Object)ChkStatusEnum.PASS.getStatus());
        } else {
            obj.set("checkedstatus", (Object)ChkStatusEnum.UNPASS.getStatus());
            obj.set("chkresult", (Object)ChkStatusEnum.UNPASS.getStatus());
        }
        if (this.ctx.getProperty("noFormula") != null && ((Boolean)this.ctx.getProperty("noFormula")).booleanValue()) {
            obj.set("chkresult", (Object)ChkStatusEnum.NOFORMULA.getStatus());
        }
        obj.set("audittrail", (Object)0);
        CommonSqlMsgUtil.modifi(obj);
        return obj;
    }

    public void save(boolean isSync) {
        this.syncStatus(isSync);
    }

    public void save() {
        this.save(ConfigServiceHelper.getBoolParam(this.ctx.getModelId(), "isChkStatusSyncUpdate"));
    }

    public Map<String, Pair<Integer, Integer>> syncStatus(boolean isSync) {
        if (isSync) {
            return this.run();
        }
        ThreadPoolService.runInSyncThread(this::run);
        return new HashMap<String, Pair<Integer, Integer>>();
    }

    private Map<String, Pair<Integer, Integer>> sync() {
        Set<Object> checkedTemplateId;
        boolean isMerge = this.ctx.getProperty("chksourcetype") == ChkSourceEnum.MERGE;
        boolean isOnlySaveFailChk = ConfigServiceHelper.getGlobalBoolParam("isOnlySaveFailChk");
        List<String> mergeProcess = isMerge && !CollectionUtils.isEqualCollection(this.ctx.getProcessList(), (Collection)ParamConstant.MergeEcProcess) ? this.ctx.getProcessList() : ParamConstant.MergeProcess;
        HashMap bpNumber2Id = new HashMap(mergeProcess.size());
        ArrayList erptAndRptProcessIds = new ArrayList(ParamConstant.ERptProcess.size() + ParamConstant.RptProcess.size());
        ArrayList mergeStatusProcessIds = new ArrayList(ParamConstant.MERGE_STATUS_PROCESS.size());
        String modelNum = this.ctx.getCubeNumber();
        mergeProcess.forEach(p -> {
            Long id = MemberReader.findProcessMemberByNum((String)modelNum, (String)p).getId();
            bpNumber2Id.put(p, id);
            if (ParamConstant.ERptProcess.contains(p) || ParamConstant.RptProcess.contains(p)) {
                erptAndRptProcessIds.add(id);
            }
            if (ParamConstant.MERGE_STATUS_PROCESS.contains(p)) {
                mergeStatusProcessIds.add(id);
            }
        });
        QFilter commonFilter = new QFilter("scenario", "=", (Object)this.ctx.getScenarioId()).and("year", "=", (Object)this.ctx.getYearId()).and("period", "=", (Object)this.ctx.getPeriodId()).and("org", "in", Arrays.asList(this.ctx.getOrgId(), ChkCheckServiceHelper.getRealOrgId(this.ctx)));
        if (this.ctx.getCurrencyId() != null) {
            commonFilter.and("currency", "=", (Object)this.ctx.getCurrencyId());
        } else {
            commonFilter.and("currency", "in", Arrays.asList(this.ecId, this.pcId));
        }
        QFilter tempStsDeleteFilter = new QFilter("process", "in", bpNumber2Id.values()).and("tmp", "!=", (Object)0L);
        QFilter templateFilter = new QFilter("process", "in", erptAndRptProcessIds).and("tmp", "!=", (Object)0L);
        DynamicObjectCollection chkStatus = QueryServiceHelper.query((String)"bcm_status", (String)"id,process", (QFilter[])new QFilter[]{commonFilter, templateFilter});
        List pkIds = chkStatus.stream().map(status -> status.getLong("id")).collect(Collectors.toList());
        DynamicObject[] templateOldChkStatus = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_status").getDynamicObjectType());
        Map<Long, List<DynamicObject>> tmpId2ChkStatus = Arrays.stream(templateOldChkStatus).collect(Collectors.groupingBy(d -> d.getLong("tmp.id")));
        if (isMerge || this.ctx.getProperty("chksourcetype") == ChkSourceEnum.INTELLIGENT_SCHEDULE) {
            DynamicObject[] disTemplateIds = TemplateDistributionOrgUtil.getDisTemplateByOrg(this.ctx.getModelId(), this.ctx.getOrgId());
            QFilter modelFilter = new QFilter("model", "=", (Object)this.ctx.getModelId());
            Set disTemplateNums = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number", (QFilter[])new QFilter[]{modelFilter, new QFilter("id", "in", (Object)disTemplateIds)}).stream().map(d -> d.getString("number")).collect(Collectors.toSet());
            checkedTemplateId = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{modelFilter, new QFilter("number", "in", disTemplateNums), new QFilter("versionnumber", "=", (Object)1)}).stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        } else {
            checkedTemplateId = new HashSet<Long>(templateOldChkStatus.length);
            for (DynamicObject dy2 : templateOldChkStatus) {
                checkedTemplateId.add(dy2.getLong("tmp.id"));
            }
        }
        QFilter mergeProcessFilter = new QFilter("process", "in", bpNumber2Id.values());
        DynamicObjectCollection chkReports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"chkformula.id,process.id,currency.id,chkresulttype", (QFilter[])new QFilter[]{commonFilter, mergeProcessFilter, new QFilter("chkformula.status", "=", (Object)CHKFormulaStatusEnum.enable.getIndex())});
        List<DynamicObject> erptAndRptChkReports = chkReports.stream().filter(report -> erptAndRptProcessIds.contains(report.getLong("process.id"))).collect(Collectors.toList());
        HashMap chkSetting2BPIds = new HashMap();
        erptAndRptChkReports.forEach(dy -> chkSetting2BPIds.computeIfAbsent(dy.getLong("chkformula.id"), k -> new HashSet()).add(dy.getLong("process.id")));
        Set templateIds = (Set)this.ctx.getProperty("tmpIds");
        HashSet<Object> orgCslSchemeIds = new HashSet<Object>();
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)this.ctx.getCubeNumber(), (String)this.ctx.getOrg());
        orgCslSchemeIds.add(entityNode.getProperty("cslscheme.id"));
        entityNode.getShareNodes().forEach(node -> orgCslSchemeIds.add(node.getProperty("cslscheme.id")));
        HashMap<Long, TemplateStatusVO> noFormulaTemplate2Status = new HashMap<Long, TemplateStatusVO>();
        ArrayList<DynamicObject> unPassedTemplate = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> passedTemplate = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> noFormulaTemplateNew = new ArrayList<DynamicObject>();
        HashSet settingIds = new HashSet(chkSetting2BPIds.keySet());
        if (isOnlySaveFailChk) {
            List<Long> allSettingIds = ChkCheckServiceHelper.getAllFormulaIdsByCTX(this.ctx, CHKFormulaStatusEnum.enable.getIndex(), false);
            List<DynamicObject> allSetting = ChkCheckServiceHelper.doFilter(this.ctx, BusinessDataServiceHelper.load((Object[])allSettingIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkformulasetting").getDynamicObjectType()));
            settingIds.addAll(allSetting.stream().map(f -> f.getLong("id")).collect(Collectors.toSet()));
        }
        DynamicObjectCollection queryAllSetting = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,multitemplate.fbasedataid.id,mulcslscheme.fbasedataid.id", (QFilter[])new QFBuilder("id", "in", settingIds).and("status", "=", (Object)CHKFormulaStatusEnum.enable.getIndex()).and("multitemplate.fbasedataid.id", "!=", null).toArray());
        List<DynamicObject> loadAllSetting = Arrays.asList(BusinessDataServiceHelper.load((Object[])settingIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkformulasetting").getDynamicObjectType()));
        HashSet isNotNoFormulaTemps = new HashSet(10);
        Long BpDimId = MemberReader.getDimensionIdByNum((long)this.ctx.getModelId(), (String)DimTypesEnum.PROCESS.getNumber());
        loadAllSetting.forEach(f -> {
            if (CollectionUtils.isNotEmpty((Collection)f.getDynamicObjectCollection("multitemplate"))) {
                DynamicObjectCollection memberRange = f.getDynamicObjectCollection("memberrange");
                Set fixBPs = memberRange.stream().filter(m -> m.getLong("dimension.id") == BpDimId.longValue()).map(m -> m.getLong("memberid")).collect(Collectors.toSet());
                if (this.ctx.getProperty("processIds") != null) {
                    fixBPs.retainAll((Collection)this.ctx.getProperty("processIds"));
                }
                if (!fixBPs.isEmpty()) {
                    isNotNoFormulaTemps.addAll(f.getDynamicObjectCollection("multitemplate").stream().map(t -> t.getLong("fbasedataid.id")).collect(Collectors.toSet()));
                }
                chkSetting2BPIds.putIfAbsent(f.getLong("id"), fixBPs);
            }
        });
        HashMap<Long, TemplateStatusVO> passedTemplate2Status = new HashMap<Long, TemplateStatusVO>();
        if (CollectionUtils.isNotEmpty(erptAndRptChkReports)) {
            List unPassedChkReports = erptAndRptChkReports.stream().filter(dy -> String.valueOf(ChkResultTypeEnum.UNPASS.getIndex()).equals(dy.getString("chkresulttype"))).collect(Collectors.toList());
            Set unPassedChkSettingIds = unPassedChkReports.stream().map(dy -> dy.getLong("chkformula.id")).collect(Collectors.toSet());
            HashMap<Long, TemplateStatusVO> unPassedTemplate2Status = new HashMap<Long, TemplateStatusVO>();
            queryAllSetting.forEach(dy -> {
                if (unPassedChkSettingIds.contains(dy.getLong("id"))) {
                    this.collectTemplate2Status(this.ctx.getCubeNumber(), (Map<Long, TemplateStatusVO>)unPassedTemplate2Status, (DynamicObject)dy, chkSetting2BPIds, (Set<Long>)orgCslSchemeIds, false);
                } else if (!isOnlySaveFailChk) {
                    this.collectTemplate2Status(this.ctx.getCubeNumber(), (Map<Long, TemplateStatusVO>)passedTemplate2Status, (DynamicObject)dy, chkSetting2BPIds, (Set<Long>)orgCslSchemeIds, true);
                } else {
                    long tempId = dy.getLong("multitemplate.fbasedataid.id");
                    if (isNotNoFormulaTemps.contains(tempId) && (checkedTemplateId.contains(tempId) || templateIds.contains(tempId))) {
                        this.collectTemplate2Status(this.ctx.getCubeNumber(), (Map<Long, TemplateStatusVO>)passedTemplate2Status, (DynamicObject)dy, chkSetting2BPIds, (Set<Long>)orgCslSchemeIds, true);
                    }
                }
            });
            passedTemplate2Status.forEach((tempId, templateStatusVO) -> {
                if (unPassedTemplate2Status.containsKey(tempId)) {
                    TemplateStatusVO unPassVO = (TemplateStatusVO)unPassedTemplate2Status.get(tempId);
                    templateStatusVO.getProcessIds().forEach(p -> {
                        if (unPassVO.getProcessIds().contains(p)) {
                            templateStatusVO.getCslSchemeIds().removeIf(cslSchemeId -> unPassVO.getCslSchemeIds().contains(cslSchemeId));
                        }
                    });
                }
            });
            checkedTemplateId.forEach(id -> {
                if (!unPassedTemplate2Status.containsKey(id) && !passedTemplate2Status.containsKey(id)) {
                    this.collectNoFormulaTemplateStatus((long)id, (Set<Long>)orgCslSchemeIds, (Map<Long, TemplateStatusVO>)noFormulaTemplate2Status, bpNumber2Id, tmpId2ChkStatus, isNotNoFormulaTemps);
                }
            });
            if (templateIds != null && !templateIds.isEmpty()) {
                templateIds.forEach(templateId -> {
                    if (!(unPassedTemplate2Status.containsKey(templateId) || passedTemplate2Status.containsKey(templateId) || checkedTemplateId.contains(templateId))) {
                        this.collectNoFormulaTemplateStatus((long)templateId, (Set<Long>)orgCslSchemeIds, (Map<Long, TemplateStatusVO>)noFormulaTemplate2Status, bpNumber2Id, tmpId2ChkStatus, isNotNoFormulaTemps);
                    }
                });
            }
            this.createTemplateStatus(unPassedTemplate2Status, unPassedTemplate);
        } else {
            if (isOnlySaveFailChk && !isNotNoFormulaTemps.isEmpty()) {
                DynamicObjectCollection chkSetting = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,multitemplate.fbasedataid.id,mulcslscheme.fbasedataid.id", (QFilter[])new QFBuilder("id", "in", chkSetting2BPIds.keySet()).and("status", "=", (Object)CHKFormulaStatusEnum.enable.getIndex()).and("multitemplate.fbasedataid.id", "!=", null).toArray());
                chkSetting.forEach(dy -> this.collectTemplate2Status(this.ctx.getCubeNumber(), (Map<Long, TemplateStatusVO>)passedTemplate2Status, (DynamicObject)dy, chkSetting2BPIds, (Set<Long>)orgCslSchemeIds, true));
            }
            checkedTemplateId.forEach(id -> this.collectNoFormulaTemplateStatus((long)id, (Set<Long>)orgCslSchemeIds, (Map<Long, TemplateStatusVO>)noFormulaTemplate2Status, bpNumber2Id, tmpId2ChkStatus, isNotNoFormulaTemps));
            if (templateIds != null && !templateIds.isEmpty()) {
                templateIds.forEach(templateId -> {
                    if (!checkedTemplateId.contains(templateId)) {
                        this.collectNoFormulaTemplateStatus((long)templateId, (Set<Long>)orgCslSchemeIds, (Map<Long, TemplateStatusVO>)noFormulaTemplate2Status, bpNumber2Id, tmpId2ChkStatus, isNotNoFormulaTemps);
                    }
                });
            }
        }
        this.createTemplateStatus(passedTemplate2Status, passedTemplate);
        this.createTemplateStatus(noFormulaTemplate2Status, noFormulaTemplateNew);
        IDNumberTreeNode realEntityNode = MemberReader.findEntityMemberById((String)modelNum, (Long)ChkCheckServiceHelper.getRealOrgId(this.ctx));
        HashMap<Long, Boolean> process2ChkResult = new HashMap<Long, Boolean>();
        mergeStatusProcessIds.forEach(processId -> process2ChkResult.put((Long)processId, true));
        chkReports.forEach(report -> {
            long totalProcess = ChkCheckServiceHelper.findTotalProcess(this.ctx.getCubeNumber(), report.getLong("process.id"));
            process2ChkResult.compute(totalProcess, (processId, chkresult) -> {
                if (ChkResultTypeEnum.UNPASS.getIndex() == report.getInt("chkresulttype")) {
                    return false;
                }
                return chkresult;
            });
        });
        ArrayList<DynamicObject> orgStatus = new ArrayList<DynamicObject>();
        process2ChkResult.forEach((k, v) -> {
            DynamicObject status1 = this.getStatus(0L, (long)k, (boolean)v);
            if (!erptAndRptProcessIds.contains(k)) {
                status1.set("org", (Object)realEntityNode.getId());
            }
            status1.set("cslscheme", (Object)0L);
            orgStatus.add(status1);
        });
        QFilter mergeStatusFilter = mergeProcessFilter.and("tmp", "=", (Object)0L);
        return this.saveTemplateStatus(unPassedTemplate, passedTemplate, noFormulaTemplateNew, orgStatus, commonFilter, new QFilter[]{tempStsDeleteFilter, mergeStatusFilter});
    }

    private void updateMergeChkStatus(ICalContext ctx) {
        if (ctx.getProperty("chksourcetype") == ChkSourceEnum.MERGE) {
            return;
        }
        String currency = ctx.getCurrency();
        if (ctx.getProperty("chksourcetype") == ChkSourceEnum.REPORT) {
            List processList = (List)ctx.getProperty("processIds");
            if (currency == null || !CollectionUtils.containsAny((Collection)processList, this.erptIds) && !CollectionUtils.containsAny((Collection)processList, this.rptIds)) {
                return;
            }
            this.updateMergeChkStsByCurrency(ctx, currency);
        } else {
            HashMap bpNum2Id = (HashMap)ctx.getProperty("bp_Number2Id");
            HashSet processSet = (HashSet)ctx.getProperty("report_process_list");
            List processList = processSet.stream().map(bpNum2Id::get).collect(Collectors.toList());
            if (CollectionUtils.containsAny(processList, this.erptIds)) {
                currency = (String)ctx.getProperty("ecCurrency");
                this.updateMergeChkStsByCurrency(ctx, currency);
            }
            if (CollectionUtils.containsAny(processList, this.rptIds)) {
                currency = (String)ctx.getProperty("pcCurrency");
                this.updateMergeChkStsByCurrency(ctx, currency);
            }
        }
    }

    private void updateMergeChkStsByCurrency(ICalContext ctx, String currency) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)ChkCheckServiceHelper.getRealOrgId(ctx));
        long baseOrgId = orgNode.isShare() ? orgNode.getCopyfromId() : orgNode.getId();
        McStatus mcStatus = MergeStatusHelper.getMcStatusByCurrencyNumber(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, currency);
        if (!"B".equals(mcStatus.getChkStatus().getStatus())) {
            QFilter qFilter = new QFilter("model", "=", (Object)ctx.getModelId());
            qFilter.and(new QFilter("org", "=", (Object)baseOrgId));
            qFilter.and(new QFilter("scenario", "=", (Object)ctx.getScenarioId()));
            qFilter.and(new QFilter("year", "=", (Object)ctx.getYearId()));
            qFilter.and(new QFilter("period", "=", (Object)ctx.getPeriodId()));
            qFilter.and(new QFilter("currency", "=", (Object)MemberReader.findCurrencyMemberByNum((String)ctx.getCubeNumber(), (String)currency).getId()));
            if (currency.equals(ctx.getProperty("ecCurrency"))) {
                qFilter.and(new QFilter("process", "=", (Object)MemberReader.findProcessMemberByNum((String)ctx.getCubeNumber(), (String)"ERpt").getId()));
            } else {
                qFilter.and(new QFilter("process", "=", (Object)MemberReader.findProcessMemberByNum((String)ctx.getCubeNumber(), (String)"Rpt").getId()));
            }
            qFilter.and(new QFilter("tmp", "=", (Object)0L));
            DynamicObject status = QueryServiceHelper.queryOne((String)"bcm_status", (String)"process.number,currency,checkedstatus", (QFilter[])qFilter.toArray());
            if (status == null) {
                MergeStatusHelper.updateChkStatusNeedChk(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, currency);
            } else if (ChkStatusEnum.PASS.getStatus() == status.getInt("checkedstatus")) {
                MergeStatusHelper.updateChkStatusSuccess(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, currency);
            } else if (ChkStatusEnum.UNPASS.getStatus() == status.getInt("checkedstatus")) {
                MergeStatusHelper.updateChkStatusFail(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, currency);
            }
        }
    }

    private void collectNoFormulaTemplateStatus(long templateId, Set<Long> orgCslSchemeIds, Map<Long, TemplateStatusVO> noFormulaTemplate2Status, Map<String, Long> bpNumber2Id, Map<Long, List<DynamicObject>> tmpId2ChkStatus, Set<Long> isNoFormulaTemps) {
        if (templateId == 0L || isNoFormulaTemps.contains(templateId)) {
            return;
        }
        TemplateStatusVO templateStatusVO = new TemplateStatusVO(templateId);
        templateStatusVO.setCslSchemeIds(orgCslSchemeIds);
        List processIds = (List)this.ctx.getProperty("processIds");
        if (CollectionUtils.isNotEmpty((Collection)processIds)) {
            bpNumber2Id.forEach((number, id) -> {
                if (processIds.contains(id)) {
                    if (ParamConstant.CHILD_PROCESS_2_PARENT.containsKey(number) && bpNumber2Id.containsKey(ParamConstant.CHILD_PROCESS_2_PARENT.get(number))) {
                        templateStatusVO.addProcess(this.ctx.getCubeNumber(), (Long)bpNumber2Id.get(ParamConstant.CHILD_PROCESS_2_PARENT.get(number)));
                    } else if (ParamConstant.REPORT_LIST_STATUS_PROCESS.contains(number)) {
                        templateStatusVO.addProcess(this.ctx.getCubeNumber(), (Long)bpNumber2Id.get(number));
                    }
                }
            });
        } else if (this.ctx.getProperty("report_process_list") != null) {
            Set process = (Set)this.ctx.getProperty("report_process_list");
            bpNumber2Id.forEach((number, id) -> {
                if (process.contains(number)) {
                    if (ParamConstant.CHILD_PROCESS_2_PARENT.containsKey(number) && bpNumber2Id.containsKey(ParamConstant.CHILD_PROCESS_2_PARENT.get(number))) {
                        templateStatusVO.addProcess(this.ctx.getCubeNumber(), (Long)bpNumber2Id.get(ParamConstant.CHILD_PROCESS_2_PARENT.get(number)));
                    } else if (ParamConstant.REPORT_LIST_STATUS_PROCESS.contains(number)) {
                        templateStatusVO.addProcess(this.ctx.getCubeNumber(), (Long)bpNumber2Id.get(number));
                    }
                }
            });
        } else {
            bpNumber2Id.forEach((number, id) -> {
                if (ParamConstant.CHILD_PROCESS_2_PARENT.containsKey(number) && bpNumber2Id.containsKey(ParamConstant.CHILD_PROCESS_2_PARENT.get(number))) {
                    templateStatusVO.addProcess(this.ctx.getCubeNumber(), (Long)bpNumber2Id.get(ParamConstant.CHILD_PROCESS_2_PARENT.get(number)));
                } else if (ParamConstant.REPORT_LIST_STATUS_PROCESS.contains(number)) {
                    templateStatusVO.addProcess(this.ctx.getCubeNumber(), (Long)bpNumber2Id.get(number));
                }
            });
        }
        this.compensateOldProcess4Sts(templateStatusVO, tmpId2ChkStatus.get(templateId));
        noFormulaTemplate2Status.put(templateId, templateStatusVO);
    }

    private void compensateOldProcess4Sts(TemplateStatusVO templateStatusVO, List<DynamicObject> dyns) {
        if (CollectionUtils.isNotEmpty(dyns)) {
            Set<Long> newProcess = templateStatusVO.getProcessIds();
            dyns.forEach(dy -> {
                if (!newProcess.contains(dy.getLong("process.id")) && ParamConstant.REPORT_LIST_STATUS_PROCESS.contains(dy.getString("process.number"))) {
                    templateStatusVO.addProcess(this.ctx.getCubeNumber(), dy.getLong("process.id"));
                }
            });
        }
    }

    private static boolean isErptOrRpt(Map<String, Long> bpNumber2Id, String number) {
        String parentNumber = (String)ParamConstant.CHILD_PROCESS_2_PARENT.get(number);
        return ParamConstant.CHILD_PROCESS_2_PARENT.containsKey(number) && bpNumber2Id.containsKey(parentNumber) && ("ERpt".equals(parentNumber) || "Rpt".equals(parentNumber));
    }

    private void createTemplateStatus(Map<Long, TemplateStatusVO> template2Status, List<DynamicObject> templateStatus) {
        template2Status.forEach((tempId, templateStatusVO) -> {
            Set clsSchemeProcess = Sets.cartesianProduct((Set[])new Set[]{templateStatusVO.getCslSchemeIds(), templateStatusVO.getProcessIds()});
            clsSchemeProcess.forEach(cp -> {
                DynamicObject templateChkStatus = this.getStatus(templateStatusVO.getTemplateId(), (Long)cp.get(1), templateStatusVO.isPass());
                templateChkStatus.set("cslscheme", cp.get(0));
                templateStatus.add(templateChkStatus);
            });
        });
    }

    private Map<String, Pair<Integer, Integer>> saveTemplateStatus(List<DynamicObject> unPassedTemplate, List<DynamicObject> passedTemplate, List<DynamicObject> noFormulaTemplateNew, List<DynamicObject> orgStatus, QFilter commonFilter, QFilter[] qFilters) {
        HashMap<String, Pair<Integer, Integer>> checkTempStatus = new HashMap<String, Pair<Integer, Integer>>();
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"bcm_status", (QFilter[])new QFilter[]{commonFilter, qFilters[0]});
                DeleteServiceHelper.delete((String)"bcm_status", (QFilter[])new QFilter[]{commonFilter, qFilters[1]});
                Set templateIds = this.ctx.getProperty("tmpIds") == null ? new HashSet(1) : (Set)this.ctx.getProperty("tmpIds");
                ArrayList processIds = new ArrayList();
                if (this.ctx.getProperty("processIds") != null) {
                    processIds.addAll((Collection)this.ctx.getProperty("processIds"));
                }
                noFormulaTemplateNew.forEach(dy -> {
                    dy.set("checkedstatus", (Object)ChkStatusEnum.PASS.getStatus());
                    dy.set("chkresult", (Object)ChkStatusEnum.NOFORMULA.getStatus());
                    if (ChkStatusBuilder.isCheckTemplate(templateIds, processIds, dy)) {
                        checkTempStatus.put(ChkStatusBuilder.templateKey(dy.getLong("tmp")), Pair.onePair((Object)ChkStatusEnum.PASS.getStatus(), (Object)ChkStatusEnum.NOFORMULA.getStatus()));
                    }
                });
                passedTemplate.forEach(dy -> {
                    dy.set("checkedstatus", (Object)ChkStatusEnum.PASS.getStatus());
                    dy.set("chkresult", (Object)ChkStatusEnum.PASS.getStatus());
                    if (ChkStatusBuilder.isCheckTemplate(templateIds, processIds, dy)) {
                        checkTempStatus.put(ChkStatusBuilder.templateKey(dy.getLong("tmp")), Pair.onePair((Object)ChkStatusEnum.PASS.getStatus(), (Object)ChkStatusEnum.PASS.getStatus()));
                    }
                });
                unPassedTemplate.forEach(dy -> {
                    dy.set("checkedstatus", (Object)ChkStatusEnum.UNPASS.getStatus());
                    dy.set("chkresult", (Object)ChkStatusEnum.UNPASS.getStatus());
                    if (ChkStatusBuilder.isCheckTemplate(templateIds, processIds, dy)) {
                        checkTempStatus.put(ChkStatusBuilder.templateKey(dy.getLong("tmp")), Pair.onePair((Object)ChkStatusEnum.UNPASS.getStatus(), (Object)ChkStatusEnum.UNPASS.getStatus()));
                    }
                });
                SaveServiceHelper.save((DynamicObject[])noFormulaTemplateNew.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])passedTemplate.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])unPassedTemplate.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])orgStatus.toArray(new DynamicObject[0]));
                this.updateMergeChkStatus(this.ctx);
            }
            catch (Exception e) {
                tx.markRollback();
                LOG.error("save status error!", (Throwable)e);
            }
        }
        return checkTempStatus;
    }

    private static String templateKey(Long templateId) {
        return "" + templateId;
    }

    private static boolean isCheckTemplate(Set<Long> templateIds, List<Long> processIds, DynamicObject dy) {
        return templateIds.contains(dy.getLong("tmp")) && processIds.contains(dy.getLong("process"));
    }

    private void collectTemplate2Status(String modelNum, Map<Long, TemplateStatusVO> template2Status, DynamicObject dy, Map<Long, Set<Long>> allChkSettingIds, Set<Long> orgCslSchemeIds, boolean pass) {
        long templateId = dy.getLong("multitemplate.fbasedataid.id");
        long cslSchemeId = dy.getLong("mulcslscheme.fbasedataid.id");
        template2Status.putIfAbsent(templateId, new TemplateStatusVO(templateId));
        TemplateStatusVO templateStatusVO = template2Status.get(templateId);
        if (cslSchemeId == 0L) {
            templateStatusVO.setCslSchemeIds(new HashSet<Long>(orgCslSchemeIds));
        } else {
            templateStatusVO.addCslScheme(cslSchemeId);
        }
        templateStatusVO.setPass(pass);
        allChkSettingIds.get(dy.getLong("id")).forEach(processId -> {
            long totalProcessId = ChkCheckServiceHelper.findTotalProcess(modelNum, processId);
            if (totalProcessId != IDNumberTreeNode.NotFoundTreeNode.getId()) {
                templateStatusVO.addProcess(this.ctx.getCubeNumber(), totalProcessId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Map<String, Pair<Integer, Integer>> run() {
        lockKey = String.format("%s|%s|%s|%s|%s", new Object[]{this.ctx.getCubeNumber(), this.ctx.getOrg(), this.ctx.getScenario(), this.ctx.getYear(), this.ctx.getPeriod()});
        lock = DLock.create((String)lockKey).fastMode();
        var3_3 = null;
        try {
            block20: {
                locked = lock.tryLock(3000L);
                if (!locked) break block20;
                try {
                    var5_6 = this.sync();
                    return var5_6;
                }
                catch (Exception e) {
                    ChkStatusBuilder.LOG.error("sync chkCheckStatus failed...", (Throwable)e);
                    ** break block21
                }
                finally {
                    lock.unlock();
                }
            }
            ChkStatusBuilder.LOG.error("get lock failed!lockKey=" + lockKey);
lbl-1000:
            // 2 sources

            {
                var5_8 = new HashMap<String, Pair<Integer, Integer>>();
            }
            return var5_8;
        }
        catch (Throwable var4_5) {
            var3_3 = var4_5;
            throw var4_5;
        }
        finally {
            if (lock != null) {
                if (var3_3 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable var6_9) {
                        var3_3.addSuppressed(var6_9);
                    }
                } else {
                    lock.close();
                }
            }
        }
    }

    static class TemplateStatusVO {
        private long templateId;
        private Set<Long> processIds = new HashSet<Long>(10);
        private Set<Long> cslSchemeIds = new HashSet<Long>(10);
        private long currencyId;
        private boolean pass;
        private long orgId;

        public TemplateStatusVO(long templateId) {
            this.templateId = templateId;
        }

        public TemplateStatusVO(long templateId, long orgId) {
            this.templateId = templateId;
            this.orgId = orgId;
        }

        public long getTemplateId() {
            return this.templateId;
        }

        public void setTemplateId(long templateId) {
            this.templateId = templateId;
        }

        public Set<Long> getProcessIds() {
            return this.processIds;
        }

        public void setProcessIds(Set<Long> processIds) {
            this.processIds = processIds;
        }

        public Set<Long> getCslSchemeIds() {
            return this.cslSchemeIds;
        }

        public void setCslSchemeIds(Set<Long> cslSchemeIds) {
            this.cslSchemeIds = cslSchemeIds;
        }

        public long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(long currencyId) {
            this.currencyId = currencyId;
        }

        public boolean isPass() {
            return this.pass;
        }

        public void setPass(boolean pass) {
            this.pass = pass;
        }

        public void addCslScheme(long cslSchemeId) {
            this.cslSchemeIds.add(cslSchemeId);
        }

        public void addProcess(String modelNum, long processId) {
            if (this.templateId != 0L) {
                IDNumberTreeNode process = BcmThreadCache.findNodeById((String)modelNum, (String)DimTypesEnum.PROCESS.getNumber(), (long)processId);
                if (process != IDNumberTreeNode.NotFoundTreeNode && ParamConstant.REPORT_LIST_STATUS_PROCESS.contains(process.getNumber())) {
                    this.processIds.add(processId);
                }
            } else {
                this.processIds.add(processId);
            }
        }

        public long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(long orgId) {
            this.orgId = orgId;
        }
    }
}

