/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.model.ChkMember;
import kd.fi.bcm.business.template.model.CustomProperty;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.template.model.DynaEntryObject;
import kd.fi.bcm.business.template.model.ILoader;

public class MemberRangeEntry
extends DynaEntryObject
implements ILoader<DynamicObjectCollection, List<MemberRangeEntry>, ChkFormulaModel> {
    private static final long serialVersionUID = 1L;

    public MemberRangeEntry(ChkFormulaModel chkFormula) {
        this.put("chkformula", (Object)chkFormula);
        this.put("properties", (Object)new ArrayList());
        this.put("customproperties", (Object)new ArrayList());
        this.setDataEntityNumber("bcm_chkformulasetting.memberrange");
    }

    public void setDimension(Dimension dim) {
        this.put("dimension", (Object)dim);
    }

    public Dimension getDimension() {
        return (Dimension)this.get("dimension");
    }

    public ChkFormulaModel getChkFormula() {
        return (ChkFormulaModel)this.get("chkformula");
    }

    public List<ChkMember> getAllMembProperties() {
        return (List)this.get("properties");
    }

    public void addMembProperty(ChkMember m) {
        this.getAllMembProperties().add(m);
    }

    @Override
    public List<MemberRangeEntry> loadDynaObject(DynamicObjectCollection t, Supplier<ChkFormulaModel> s) {
        return this.loadDynaObject(t, s, new HashMap<String, Map<Long, DynamicObject>>());
    }

    public List<MemberRangeEntry> loadDynaObject(DynamicObjectCollection t, Supplier<ChkFormulaModel> s, Map<String, Map<Long, DynamicObject>> memberMap) {
        LinkedHashMap<String, MemberRangeEntry> entriesCacheBuf = new LinkedHashMap<String, MemberRangeEntry>();
        for (DynamicObject o : t) {
            DynamicObject dyna;
            Dimension d;
            String memRangeEntryKey = o.getDynamicObject("dimension").getLong("id") + o.getString("limittype");
            MemberRangeEntry entry = (MemberRangeEntry)entriesCacheBuf.get(memRangeEntryKey);
            if (entry == null) {
                entry = new MemberRangeEntry(s.get());
                entry.setId(o.getLong("id"));
                entry.setSeq(o.getInt("seq"));
                d = new Dimension();
                dyna = o.getDynamicObject("dimension");
                this.loadSimpleDynamicObject(d, dyna);
                d.setDataEntityNumber(dyna.getDataEntityType().getName());
                d.setMemberEntityNumber(dyna.getString("membermodel"));
                entry.setDimension(d);
                entriesCacheBuf.put(memRangeEntryKey, entry);
            }
            d = entry.getDimension();
            ChkMember m = new ChkMember();
            if ("2".equals(o.getString("membboundtype"))) {
                Map<Long, DynamicObject> dynamicObjectMap = memberMap.get("bcm_definedpropertyvalue");
                dyna = null != dynamicObjectMap ? dynamicObjectMap.get(o.getLong("memberid")) : null;
                CustomProperty p = new CustomProperty();
                if (o.get("propertyid") instanceof DynamicObject) {
                    p.setId(o.getLong("propertyid.id"));
                } else {
                    p.setId(o.getLong("propertyid"));
                }
                m.setCustomProperty(p);
            } else {
                DynamicObject dynamicObject = dyna = memberMap.containsKey(d.getMemberEntityNumber()) ? memberMap.get(d.getMemberEntityNumber()).get(o.getLong("memberid")) : null;
            }
            if (dyna == null) continue;
            this.loadSimpleDynamicObject(m, dyna);
            m.setDimension(d);
            m.setDataEntityNumber(d.getMemberEntityNumber());
            m.setMembboundtype(o.getString("membboundtype"));
            m.setLimittype(o.getString("limittype"));
            m.setScope(o.getInt("membbound"));
            entry.addMembProperty(m);
        }
        return new ArrayList<MemberRangeEntry>(entriesCacheBuf.values());
    }

    @Override
    protected DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObject dyna = this.convert2SimpleDynamicObject();
        DynamicObjectCollection coll = new DynamicObjectCollection(dyna.getDynamicObjectType(), (Object)parent);
        int i = 1;
        for (ChkMember p : this.getAllMembProperties()) {
            dyna = this.newSimpleDynamicObject();
            dyna.set("dimension", (Object)this.getDimension().getId());
            if (p.getCustomProperty() != null) {
                dyna.set("propertyid", (Object)p.getCustomProperty().getId());
            }
            dyna.set("memberid", (Object)p.getId());
            dyna.set("seq", (Object)i++);
            dyna.set("membbound", (Object)p.getScope());
            dyna.set("membboundtype", (Object)p.getMembboundtype());
            dyna.set("limittype", (Object)p.getLimittype());
            coll.add((Object)dyna);
        }
        return coll;
    }

    protected void loadSimpleDynamicObject(DynaEntityObject ba, DynamicObject d) {
        ba.setId(d.getLong("id"));
        ba.setName(d.getString("name"));
        ba.setNumber(d.getString("number"));
        ba.setDataEntityNumber(d.getDataEntityType().getName());
    }
}

