/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.spread.formula.EncoderService;

public class VTFormula {
    private Pair<String, List<IFormula>> pair;
    private Map<String, FormulaWithTempMemStr> formulaToMemStr = new HashMap<String, FormulaWithTempMemStr>(16);

    public VTFormula() {
    }

    public VTFormula(String express) throws Exception {
        ExpressParser parser = new ExpressParser();
        EncoderService encoder = new EncoderService();
        this.pair = parser.parse(express, encoder);
        for (IFormula formula : (List)this.pair.p2) {
            String formulaStr = formula.toString();
            this.formulaToMemStr.put(formulaStr, new FormulaWithTempMemStr(formulaStr));
        }
    }

    public Pair<String, List<IFormula>> getPair() {
        return this.pair;
    }

    public Map<String, FormulaWithTempMemStr> getFormulaToMemStr() {
        return this.formulaToMemStr;
    }

    public FormulaWithTempMemStr getFormulaToMemStr(String formula) {
        return this.formulaToMemStr.get(formula);
    }

    public static class FormulaWithTempMemStr {
        private boolean appointCell = false;
        private String formula;
        private Map<String, String> dimToMem_Num = new HashMap<String, String>();
        private long templateId;
        private String tempNum;

        public FormulaWithTempMemStr(String formula) {
            this.formula = formula;
            int start = 0;
            int end = 0;
            if (ChkFormulaServiceHelper.isXdmFormula(formula)) {
                return;
            }
            if (formula.contains("@TMP")) {
                this.appointCell = true;
                start = formula.indexOf("@TMP");
                end = formula.indexOf("\",");
                this.tempNum = formula.substring(start + 5, end);
                start = end + 2;
                end = formula.indexOf(41);
            } else {
                start = formula.indexOf("\",") + 2;
                end = formula.indexOf(41);
            }
            this.parserExpressToMap(formula.substring(start, end));
        }

        public boolean isAppointCell() {
            return this.appointCell;
        }

        public String getFormula() {
            return this.formula;
        }

        public String getTempNum() {
            return this.tempNum;
        }

        public Map<String, String> getDimToMem_Num() {
            return this.dimToMem_Num;
        }

        public long getTemplateId() {
            return this.templateId;
        }

        public final void parserExpressToMap(String dimMemExpress) {
            String[] dimMems;
            dimMemExpress = ChkFormulaServiceHelper.replaceSpace(dimMemExpress);
            for (String dimMem : dimMems = dimMemExpress.split(",")) {
                int index = dimMem.indexOf(".");
                if (index < 0) continue;
                this.dimToMem_Num.put(dimMem.substring(1, index), dimMem.substring(index + 1, dimMem.length() - 1));
            }
        }
    }
}

