/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.serviceHelper;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListColumnContext;
import kd.bos.list.TemplateTextListColumn;
import kd.bos.list.column.ListTemplateTextColumnDesc;
import kd.bos.list.column.TemplateTextItem;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.model.ChkResultMapFormulaModel;
import kd.fi.bcm.business.chkcheck.model.VTFormula;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckStatusHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.chkcheck.util.FormulaAnalyseUtil;
import kd.fi.bcm.business.chkcheck.util.NumberQuantileValueUtil;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.chkcheck.CHKCheckEffectEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class ChkCheckReportListHelper {
    private static final Log LOG = LogFactory.getLog(ChkCheckReportListHelper.class);
    private static final String BATCH_NOTE_IDS = "batchNoteIds";
    private static final String COMMA = "\uff0c";

    public static void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListTemplateTextColumnDesc) {
            TemplateTextItem templateTextItem = new TemplateTextItem();
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(10);
            String fieldKey = ((ListTemplateTextColumnDesc)e.getSource()).getFieldKey();
            String result = FormulaAnalyseUtil.getResult(e, fieldKey);
            String formula = FormulaAnalyseUtil.getFullFormula(e, fieldKey);
            if (StringUtils.isEmpty((String)formula)) {
                templateTextItem.setTem("");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("key", "r");
                map.put("id", "rid");
                map.put("text", "");
                data.add(map);
            } else if (result.contains("kd.fi.bcm.business.formula.calculate.exception.InvalidParamException: ")) {
                templateTextItem.setTem(result.replace("kd.fi.bcm.business.formula.calculate.exception.InvalidParamException: ", ""));
            } else if (!ChkFormulaServiceHelper.isJudgeFormula(formula.toUpperCase(Locale.ENGLISH)) && !ChkFormulaServiceHelper.hasXdmFormula(formula) && StringUtils.isNotEmpty((String)e.getRowData().getString("resultmap"))) {
                String resultMap = e.getRowData().getString("resultmap");
                Set<String> noTempFormulas = ChkCheckReportListHelper.parseNoTempFormulas(formula);
                FormulaAnalyseUtil.packageFormulaResult(e, data, result, resultMap, fieldKey, templateTextItem, noTempFormulas);
            } else {
                ChkResultMapFormulaModel mapFormulaModel = new ChkResultMapFormulaModel(formula, result);
                templateTextItem.setTem(mapFormulaModel.getFormulaExpression());
                for (Map.Entry entry : mapFormulaModel.entrySet()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("key", entry.getKey());
                    map.put("id", e.getRowData().getLong("id"));
                    if (StringUtils.isEmpty((String)((String)entry.getValue()))) {
                        map.put("text", result);
                    } else {
                        map.put("text", NumberQuantileValueUtil.change2QuantileValue((String)entry.getValue()));
                    }
                    data.add(map);
                }
            }
            templateTextItem.setData(data);
            e.setFormatValue((Object)templateTextItem);
        }
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String chineseFormula;
            String value;
            String key = ((ColumnDesc)e.getSource()).getKey();
            if ("chkformula.allowamount".equals(key)) {
                value = NumberQuantileValueUtil.change2QuantileValueNoEndZero(e.getRowData().get(key).toString());
                e.setFormatValue((Object)value);
            }
            if ("calcresultexpr".equals(key)) {
                value = NumberQuantileValueUtil.change2QuantileValueDefault2Zero(e.getRowData().get(key).toString());
                e.setFormatValue((Object)value);
            }
            if ("fulllformula".equals(key) || "fullrformula".equals(key)) {
                value = ChkCheckServiceHelper.transferXFromula(e.getRowData().get(key).toString());
                e.setFormatValue((Object)value);
            }
            if ("note".equals(key) && StringUtils.isEmpty((String)e.getFormatValue().toString())) {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u65e0", (String)"ChkCheckReportListHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if ("chkformula.chineseformula".equals(key) && StringUtils.isNotEmpty((String)(chineseFormula = e.getRowData().getString("chineseformula")))) {
                e.setFormatValue((Object)chineseFormula);
            }
        }
    }

    private static Set<String> parseNoTempFormulas(String formula) {
        try {
            VTFormula vtFormula = new VTFormula(formula);
            return ((List)vtFormula.getPair().p2).stream().filter(f -> "V".equals(f.getName()) && !f.toString().contains("@TMP.")).map(IFormula::getUUID).collect(Collectors.toSet());
        }
        catch (Exception e) {
            LOG.error("parseNoTempFormulas:", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public static void createListColumns(BeforeCreateListColumnsArgs e) {
        Tips tips = new Tips("text", "0");
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u975e\u62a5\u8868\u5355\u5143\u683c\u8bbe\u7f6e\u7684\u52fe\u7a3d\uff0c\u4e0d\u5141\u8bb8\u901a\u8fc7\u91d1\u989d\u7ed3\u679c\u8df3\u8f6c\u3002", (String)"ChkCheckReportListHelper_10", (String)"fi-bcm-business", (Object[])new Object[0])));
        TemplateTextListColumn leftResultColumn = new TemplateTextListColumn();
        leftResultColumn.setListFieldKey("leftresultcol");
        leftResultColumn.setKey("leftresultcol");
        leftResultColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5de6\u7b49\u5f0f\u7ed3\u679c", (String)"ChkCheckReportListHelper_2", (String)"fi-bcm-business", (Object[])new Object[0])));
        leftResultColumn.setContext(new ListColumnContext(null, false));
        leftResultColumn.setCtlTips(tips);
        TemplateTextListColumn rightResultColumn = new TemplateTextListColumn();
        rightResultColumn.setListFieldKey("rightresultcol");
        rightResultColumn.setKey("rightresultcol");
        rightResultColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53f3\u7b49\u5f0f\u7ed3\u679c", (String)"ChkCheckReportListHelper_3", (String)"fi-bcm-business", (Object[])new Object[0])));
        rightResultColumn.setContext(new ListColumnContext(null, false));
        rightResultColumn.setCtlTips(tips);
        e.getListColumns().add(4, leftResultColumn);
        e.getListColumns().add(5, rightResultColumn);
    }

    public static void openBatchNoteView(IFormPlugin plugin, IFormView view, Object[] ids) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_chkforcepassnote");
        showParameter.setCaption(ResManager.loadKDString((String)"\u6279\u91cf\u6279\u6ce8", (String)"ChkCheckReportListHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "btn_batchnote"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.getPageCache().put(BATCH_NOTE_IDS, ObjectSerialUtil.toByteSerialized((Object)ids));
        view.showForm(showParameter);
    }

    public static void batchNoteReports(IFormView view, Object[] ids, String note, long modelId, long cslschemeId) {
        if (ids != null && ids.length > 0) {
            DynamicObject[] reports = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_chkreport"));
            if (reports == null || reports.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u62a5\u544a\u5df2\u7ecf\u5237\u65b0\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\u3002", (String)"CheckUpChkReportPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            boolean isNeedDealChkSts = false;
            long senceId = 0L;
            long yearId = 0L;
            long periodId = 0L;
            ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(10);
            for (DynamicObject r : reports) {
                r.set("note", (Object)ChkCheckReportListHelper.appendNote(r.getString("note"), note, false));
                CHKCheckEffectEnum ce = CHKCheckEffectEnum.getCHKCheckEffectByIndex((String)r.getString("chkformula.chkeffecttype"));
                if (CHKCheckEffectEnum.NoteAndReport != ce) continue;
                r.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
                isNeedDealChkSts = true;
                senceId = r.getLong("scenario.id");
                yearId = r.getLong("year.id");
                periodId = r.getLong("period.id");
                dyns.add(r);
            }
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            try (TXHandle txHandle = TX.required();){
                try {
                    if (isNeedDealChkSts) {
                        ChkCheckStatusHelper.dealChkStsAfterChangeReport(modelId, senceId, yearId, periodId, cslschemeId, dyns.toArray(new DynamicObject[0]));
                    }
                    SaveServiceHelper.save((DynamicObject[])reports);
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u6279\u6ce8\u64cd\u4f5c\u6210\u529f\u3002", (String)"ChkCheckReportListHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    LOG.error("-->\u6279\u91cf\u6279\u6ce8\u64cd\u4f5c\u5931\u8d25:", (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u6279\u91cf\u6279\u6ce8\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ChkCheckReportListHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                view.getPageCache().remove(BATCH_NOTE_IDS);
                for (DynamicObject r : reports) {
                    AppLogInfo logInfo = OperationLogUtil.buildLogInfo(new OpNameMultiLangEnumBridge("\u6279\u91cf\u6279\u6ce8", "ChkCheckReportListHelper_4", "fi-bcm-business", "Batch annotation"), new OPDescMultiLangEnumBridge("%1$s  %2$s\uff0c\u6279\u91cf\u6279\u6ce8\u64cd\u4f5c\u6210\u529f\u3002", "ChkCheckReportListHelper_7", "fi-bcm-business", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{r.getString("chkformula.number"), r.getString("chkformula.name")})), (Long)modelId, view.getModel().getDataEntityType().getName());
                    logService.addLog(logInfo);
                }
            }
        }
    }

    public static String appendNote(String note, String newNote, boolean isOverwrite) {
        DateTimeFormatter dtFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formatTime = LocalDateTime.now().format(dtFormat);
        String finalNote = null;
        if (isOverwrite) {
            finalNote = StringUtils.isEmpty((String)newNote) ? "" : newNote + COMMA + RequestContext.get().getUserName() + COMMA + formatTime + System.lineSeparator();
        } else {
            String string = finalNote = StringUtils.isEmpty((String)newNote) ? note : note + newNote + COMMA + RequestContext.get().getUserName() + COMMA + formatTime + System.lineSeparator();
        }
        if (finalNote.length() > 2000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6279\u6ce8\u957f\u5ea6\u8d85\u957f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChkCheckReportListHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return finalNote;
    }

    public static void checkTemplateDistributionOrg(long modelId, long sceneId, long fyId, long periodId, long orgId, long ccyId, long tempId) {
        Set<Long> disTemplateByOrg = TemplateDistributionOrgUtil.getDisTemplateByOrg(modelId, orgId);
        if (disTemplateByOrg.contains(tempId)) {
            return;
        }
        DynamicObjectCollection reportCols = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,template.id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("entity", "=", (Object)orgId), new QFilter("scene", "=", (Object)sceneId), new QFilter("fyear", "=", (Object)fyId), new QFilter("period", "=", (Object)periodId), new QFilter("currency", "=", (Object)ccyId), new QFilter("template", "=", (Object)tempId)}, null);
        boolean noDistribution = reportCols.stream().noneMatch(r -> r.getLong("template.id") == tempId);
        if (noDistribution) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u62a5\u8868\u6a21\u677f\u672a\u5206\u914d\u5230\u5f53\u524d\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u8df3\u8f6c\u3002", (String)"ChkCheckReportListHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public static long convert2EffectiveOrg(long orgId, long modelId, long scenarioId, long yearId, long periodId, long cslschemeId) {
        IDNumberTreeNode orgNode;
        QFilter qf;
        Set<Long> orgIds;
        FilterOrgStructParam filterParam;
        Map<Long, String> effectiveOrg;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (cslschemeId != 0L) {
            qFilter.and(new QFilter("cslscheme", "=", (Object)cslschemeId));
        }
        if (!(effectiveOrg = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(filterParam = new FilterOrgStructParam(modelId, scenarioId, yearId, periodId), orgIds = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{qFilter, qf = (orgNode = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)orgId)).isShare() ? new QFilter("id", "=", (Object)orgNode.getCopyfromId()).or(new QFilter("copyfrom", "=", (Object)orgNode.getCopyfromId())) : new QFilter("id", "=", (Object)orgNode.getId()).or(new QFilter("copyfrom", "=", (Object)orgNode.getId()))}).stream().map(d -> d.getLong("id")).collect(Collectors.toSet()))).isEmpty()) {
            return effectiveOrg.keySet().toArray(new Long[0])[0];
        }
        return orgNode.isShare() ? orgNode.getCopyfromId() : orgNode.getId();
    }
}

