/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.serviceHelper;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.model.ChkMember;
import kd.fi.bcm.business.chkcheck.model.ChkResultModel;
import kd.fi.bcm.business.chkcheck.model.ChkStatusBuilder;
import kd.fi.bcm.business.chkcheck.model.MemberRangeEntry;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.ChkCheckBatchReportService;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.ChkCheckMergeService;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.ChkCheckReportListNoReportService;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.ChkCheckReportListService;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.ChkCheckReportRecheckService;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.ChkCheckReportService;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.ChkCheckScheduleService;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.dimension.data.MemberMsgCache;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.model.FormulaPoolManager;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.script.CommonFormulaModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ExpressionServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.common.ChkCtxConstant;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKCheckEffectEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKReportType;
import kd.fi.bcm.common.enums.chkcheck.CheckResultenum;
import kd.fi.bcm.common.enums.chkcheck.ChkCheckReportModeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkMemberRangeLimitTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkMemberTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkSourceEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkStatusEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CartesianUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MemberRangeUtil;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;

public class ChkCheckServiceHelper {
    public static final Log LOG = LogFactory.getLog(ChkCheckServiceHelper.class);
    public static final WatchLogger WATCH_LOG = BcmLogFactory.getWatchLogInstance((boolean)true, ChkCheckServiceHelper.class);
    private static final Pattern PATTERN_CONTAIN_CONSTANT = Pattern.compile("(?<=\\))\\s*[+\\-*/><=]\\d+(\\.\\d+)?|^\\d+(\\.\\d+)?[+\\-*/><=]|[+\\-*/><=]\".*\"|\".*\"[+\\-*/><=]");
    private static final String[] BATCH_COPY_PROPERTY = new String[]{"year", "period", "scenario", "currency", "bp_Number2Id", "reporttype", "cslSchemeId", "alltemplate", "memberData"};
    private static final DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    private ChkCheckServiceHelper() {
    }

    public static List<ChkFormulaModel> getAllFormulaModel(ICalContext ctx, String status) {
        DynamicObject[] formulaList = ChkCheckServiceHelper.getAllFormulaListByCTX(ctx, status);
        ArrayList<ChkFormulaModel> chkModelList = new ArrayList<ChkFormulaModel>(formulaList.length);
        Map<String, Map<Long, DynamicObject>> memberMap = ChkCheckServiceHelper.batchGetMemberDataForLoadDynaObj2Model(Arrays.asList(formulaList));
        for (DynamicObject formula : formulaList) {
            ChkFormulaModel chkFormulaModel = new ChkFormulaModel();
            chkFormulaModel.loadDynaObj2Model(formula, memberMap, false);
            chkModelList.add(chkFormulaModel);
        }
        return chkModelList;
    }

    public static List<ChkFormulaModel> getFormulaModelListByCTX(ICalContext ctx, String status) {
        List<DynamicObject> formulaList = ChkCheckServiceHelper.getFormulaListByCTX(ctx, status);
        ArrayList<ChkFormulaModel> chkModelList = new ArrayList<ChkFormulaModel>(formulaList.size());
        Map<String, Map<Long, DynamicObject>> memberMap = ChkCheckServiceHelper.batchGetMemberDataForLoadDynaObj2Model(formulaList);
        for (DynamicObject formula : formulaList) {
            ChkFormulaModel chkFormulaModel = new ChkFormulaModel();
            chkFormulaModel.loadDynaObj2Model(formula, memberMap, false);
            chkModelList.add(chkFormulaModel);
        }
        return chkModelList;
    }

    public static List<DynamicObject> getFormulaListByCTX(ICalContext ctx, String status) {
        DynamicObject[] docs = ChkCheckServiceHelper.getAllFormulaListByCTX(ctx, status);
        return ChkCheckServiceHelper.doFilter(ctx, docs);
    }

    public static List<DynamicObject> getFormulaListByReportId(ICalContext ctx) {
        List<Long> formulaIds = ChkCheckServiceHelper.getFormulaIdByReportId(ctx);
        DynamicObject[] docs = BusinessDataServiceHelper.loadFromCache((Object[])formulaIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkformulasetting").getDynamicObjectType()).values().toArray(new DynamicObject[0]);
        return ChkCheckServiceHelper.doFilter(ctx, docs);
    }

    public static List<DynamicObject> getFormulaListByReportIdExcludeProcess(ICalContext ctx) {
        List<Long> formulaIds = ChkCheckServiceHelper.getFormulaIdByReportId(ctx);
        DynamicObject[] docs = BusinessDataServiceHelper.loadFromCache((Object[])formulaIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkformulasetting").getDynamicObjectType()).values().toArray(new DynamicObject[0]);
        return ChkCheckServiceHelper.doFilterExcludeProcess(ctx, docs);
    }

    public static DynamicObject[] getAllFormulaListByCTX(ICalContext ctx, String status) {
        List<Long> ids = ChkCheckServiceHelper.getAllFormulaIdsByCTX(ctx, status);
        if (CollectionUtils.isEmpty(ids)) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkformulasetting").getDynamicObjectType()).values().toArray(new DynamicObject[0]);
    }

    public static List<Long> getAllFormulaIdsByCTX(ICalContext ctx, String status) {
        return ChkCheckServiceHelper.getAllFormulaIdsByCTX(ctx, status, true);
    }

    public static List<Long> getAllFormulaIdsByCTX(ICalContext ctx, String status, boolean isDiffTemp) {
        QFilter filter;
        Long modelId = MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
        QFilter fm = new QFilter("model", "=", (Object)modelId);
        if (status != null) {
            fm.and(new QFilter("status", "=", (Object)status));
        }
        if (isDiffTemp && ctx.getProperty("temp") != null) {
            filter = new QFilter("multitemplate.fbasedataid.number", "=", (Object)ctx.getProperty("temp").toString());
            fm.and(filter);
        } else if (isDiffTemp && ctx.getProperty("batchChkTmp") != null) {
            filter = new QFilter("multitemplate.fbasedataid.number", "in", (Object)ctx.getProperty("batchChkTmp").toString().split(","));
            fm.and(filter);
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,mulcslscheme.fbasedataid.id", (QFilter[])new QFilter[]{fm});
        ArrayList<Long> ids = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)doc)) {
            for (DynamicObject obj : doc) {
                if (ctx.getProperty("cslSchemeId") != null && obj.getLong("mulcslscheme.fbasedataid.id") != 0L && obj.getLong("mulcslscheme.fbasedataid.id") != ((Long)ctx.getProperty("cslSchemeId")).longValue()) continue;
                ids.add(obj.getLong("id"));
            }
        }
        return ids;
    }

    private static List<String> getAllFormulas(ICalContext ctx, String formula, Map<String, List<String>> numbermap) {
        if (MapUtils.isEmpty(numbermap)) {
            if (ChkFormulaServiceHelper.isXdmFormula(formula)) {
                return Collections.singletonList(formula);
            }
            if (ChkCheckServiceHelper.mixModeAndNoCurrency(ctx, formula)) {
                ArrayList<String> formulas = new ArrayList<String>();
                formulas.add(formula);
                formulas.add(formula);
                return formulas;
            }
            return Collections.singletonList(formula);
        }
        List<String> dimcarte = ChkCheckServiceHelper.cartesianDim(numbermap);
        return ChkCheckServiceHelper.cartesianFormulaInChkCheck(dimcarte, formula, ctx);
    }

    private static boolean mixModeAndNoCurrency(ICalContext ctx, String formula) {
        return StringUtils.isEmpty((String)ctx.getCurrency()) && ParamConstant.PATTERN_BP.matcher(formula).find() && !ParamConstant.PATTERN_C.matcher(formula).find() && ctx.getProperty("report_process_mode") != null && ctx.getProperty("report_process_mode").equals(ChkCheckReportModeEnum.MIX.getMode());
    }

    public static List<String> getRealFormula(ICalContext ctx, String formula, Map<String, List<String>> numbermap) {
        if (StringUtils.isEmpty((String)formula)) {
            return new ArrayList<String>();
        }
        String curFy = ctx.getYear();
        String curPer = ctx.getPeriod();
        List<String> formulas = ChkCheckServiceHelper.getAllFormulas(ctx, formula, numbermap);
        ArrayList<String> newFormulas = new ArrayList<String>(formulas.size());
        HashSet<String> distinctFormulas = new HashSet<String>(formulas.size());
        for (String f : formulas) {
            List<String> vList = ChkFormulaServiceHelper.getVList(f);
            if (distinctFormulas.add(f)) {
                ctx.setProperty("fillCurrency", "ec");
            } else {
                ctx.setProperty("fillCurrency", "pc");
            }
            List<String> newVList = ChkCheckServiceHelper.fixDefaultDim(ctx, vList, curFy, curPer);
            ctx.setProperty("fillCurrency", null);
            if (newVList == null) {
                return null;
            }
            for (int i = 0; i < newVList.size(); ++i) {
                f = f.replace(" ", "").replace(vList.get(i).replace(" ", ""), newVList.get(i));
            }
            newFormulas.add(ChkCheckServiceHelper.changePercentToDec(f));
        }
        return newFormulas;
    }

    public static String changePercentToDec(String formula) {
        while (formula.indexOf(37) > -1) {
            int percentSymbolPosition = formula.indexOf(37);
            int numberBegin = ChkCheckServiceHelper.getPercentNumberBeginPosition(formula);
            if (numberBegin < percentSymbolPosition) {
                String percentNumber = formula.substring(numberBegin, percentSymbolPosition);
                try {
                    BigDecimal number = new BigDecimal(percentNumber).divide(BigDecimal.valueOf(100L));
                    formula = formula.replace(percentNumber + "%", number.toString());
                    continue;
                }
                catch (Exception ex) {
                    throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u767e\u5206\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"ChkCheckServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0])), new Object[0]);
                }
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u767e\u5206\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"ChkCheckServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return formula;
    }

    private static int getPercentNumberBeginPosition(String formula) {
        int percentSymbolPosition = formula.indexOf("%");
        for (int i = percentSymbolPosition - 1; i >= 0; --i) {
            if (Character.isDigit(formula.charAt(i)) || '.' == formula.charAt(i)) continue;
            return i + 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SDKMark
    public static CheckResultenum check(ICalContext ctx) {
        CheckResultenum checkResultenum;
        WATCH_LOG.startWatch();
        ctx.setNestDataProvider(null);
        ChkSourceEnum sourceType = (ChkSourceEnum)ctx.getProperty("chksourcetype");
        if (sourceType == null) {
            sourceType = ChkSourceEnum.REPORT;
            ctx.setProperty("chksourcetype", sourceType);
        }
        WATCH_LOG.info(String.format("Begin [%s] ChkCheck...", ctx.getProperty("chksourcetype").toString()));
        String key = ChkCheckServiceHelper.generateKey(ctx);
        distributeSessionlessCache.put(key, (Object)String.valueOf(System.currentTimeMillis()), 1800);
        try {
            switch (sourceType) {
                case CHECK_REPORT: {
                    checkResultenum = ChkCheckReportService.getInstance().check(new CalculateService(ctx));
                    break;
                }
                case RECHECK_REPORT: {
                    checkResultenum = ChkCheckReportRecheckService.getInstance().check(new CalculateService(ctx));
                    break;
                }
                case MERGE: {
                    checkResultenum = ChkCheckMergeService.getInstance().check(new CalculateService(ctx));
                    break;
                }
                case INTELLIGENT_SCHEDULE: {
                    checkResultenum = ChkCheckScheduleService.getInstance().check(new CalculateService(ctx));
                    break;
                }
                case NO_REPORT_CHECK: {
                    checkResultenum = ChkCheckReportListNoReportService.getInstance().check(new CalculateService(ctx));
                    break;
                }
                default: {
                    checkResultenum = ChkCheckReportListService.getInstance().check(new CalculateService(ctx));
                }
            }
            CacheGenFactory.getTemporaryCache().invalidateStartsWithKey("chkcheckcache_");
        }
        finally {
            distributeSessionlessCache.remove(key);
        }
        WATCH_LOG.infoEnd(String.format("Finish [%s] ChkCheck...", ctx.getProperty("chksourcetype").toString()));
        return checkResultenum;
    }

    public static boolean isKeyValid(String key) {
        if (distributeSessionlessCache.get(key) != null) {
            Long cachedTime = LongUtil.toLong((Object)distributeSessionlessCache.get(key));
            if ((System.currentTimeMillis() - cachedTime) / 1000L / 60L >= 30L) {
                distributeSessionlessCache.remove(key);
                return false;
            }
            return true;
        }
        return false;
    }

    public static Map<Pair<Long, Long>, CheckResultenum> check(ICalContext ctx, boolean isBatch) {
        WATCH_LOG.startWatch();
        WATCH_LOG.info(String.format("Begin BatchChkCheck... ctx=[%s]", ctx));
        boolean clickCheck = (Boolean)ctx.getProperty("clickCheck");
        if (!isBatch) {
            throw new UnsupportedOperationException("only supported batchReport check");
        }
        ChkCheckServiceHelper.prepareCommonData(ctx);
        ChkCheckServiceHelper.checkPeriodStatus(ctx, true);
        ChkCheckServiceHelper.checkFlowStatus(ctx, true);
        DynamicObjectCollection reportlist = (DynamicObjectCollection)ctx.getProperty("selecttemplatelist");
        Map tempMap = (Map)ctx.getProperty("tempmap");
        Map org2FormulaIds = (Map)ctx.getProperty("batchcheckorg");
        Map temp2Formulas = (Map)ctx.getProperty("temp2formulaid");
        Map formulaId2Process = (Map)ctx.getProperty("batchformulaid2process");
        Map firstversionTempMap = (Map)ctx.getProperty("firstversionmap");
        Map org2CurMap = (Map)ctx.getProperty("org2Currency");
        HashMap<String, List<Long>> ecMap = new HashMap<String, List<Long>>();
        ChkCheckServiceHelper.buildOrg2ECMap(ctx, org2CurMap, ecMap);
        Map<Long, List<DynamicObject>> org2SelectReports = reportlist.stream().collect(Collectors.groupingBy(r -> r.getLong("entity")));
        ConcurrentHashMap<Pair<Long, Long>, CheckResultenum> results = new ConcurrentHashMap<Pair<Long, Long>, CheckResultenum>();
        ConcurrentSkipListSet<String> errMsgs = new ConcurrentSkipListSet<String>();
        CountDownLatch latch = new CountDownLatch(org2SelectReports.size());
        CopyOnWriteArrayList<ICalContext> ctxList = new CopyOnWriteArrayList<ICalContext>();
        ConcurrentHashMap<Long, Long> firstTmpId2RealTmpId = new ConcurrentHashMap<Long, Long>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : org2SelectReports.entrySet()) {
            long orgId = entry.getKey();
            String orgNum = MemberReader.findEntityMemberById((String)ctx.getCubeNumber(), (Long)orgId).getNumber();
            ThreadPoolService.runReportListChkThread(() -> {
                CalContext singleCtx = null;
                try {
                    boolean isEc;
                    singleCtx = new CalContext(ctx.getCubeNumber(), ctx.getModelId(), ctx.getYearId(), ctx.getPeriodId(), ctx.getScenarioId());
                    singleCtx.setProperty("chksourcetype", ChkSourceEnum.REPORT);
                    ChkCheckServiceHelper.copyProperty(ctx, singleCtx, BATCH_COPY_PROPERTY);
                    String templateNumbers = ((List)entry.getValue()).stream().map(r -> r.getString("template.number")).collect(Collectors.joining(","));
                    for (DynamicObject report : (List)entry.getValue()) {
                        firstTmpId2RealTmpId.putIfAbsent((Long)firstversionTempMap.get(report.getString("template.number")), report.getLong("template.id"));
                    }
                    singleCtx.setProperty("org", orgNum);
                    singleCtx.setProperty("batchChkTmp", templateNumbers);
                    singleCtx.setProperty("originalOrgId", orgId);
                    if (org2CurMap.containsKey(orgId)) {
                        String[] ecPcCurrency = (String[])org2CurMap.get(orgId);
                        singleCtx.setProperty("ecCurrency", ecPcCurrency[0]);
                        singleCtx.setProperty("pcCurrency", ecPcCurrency[1]);
                    }
                    List entityValidFormulaSettings = (List)org2FormulaIds.get(orgId);
                    ArrayList tempValidFormulaSetting = new ArrayList(10);
                    Arrays.stream(templateNumbers.split(",")).forEach(t -> {
                        if (temp2Formulas.get(t) != null) {
                            ((List)temp2Formulas.get(t)).stream().filter(f1 -> tempValidFormulaSetting.stream().noneMatch(f2 -> f2.getLong("id") == f1.getLong("id"))).forEach(tempValidFormulaSetting::add);
                        }
                    });
                    ArrayList<DynamicObject> finalValidFormulaSetting = new ArrayList<DynamicObject>();
                    HashMap finalFormulaId2Process = new HashMap();
                    boolean bl = isEc = ecMap.containsKey("isEc") && ((List)ecMap.get("isEc")).contains(orgId);
                    if (isEc) {
                        singleCtx.setProcessList(ParamConstant.ERptProcess);
                    } else {
                        singleCtx.setProcessList(ParamConstant.RptProcess);
                    }
                    if (CollectionUtils.isNotEmpty(tempValidFormulaSetting) && CollectionUtils.isNotEmpty((Collection)entityValidFormulaSettings)) {
                        HashSet<Long> needCheckFormulaIds = new HashSet<Long>();
                        for (DynamicObject dy : tempValidFormulaSetting) {
                            long id = dy.getLong("id");
                            if (!entityValidFormulaSettings.contains(id) || needCheckFormulaIds.contains(id)) continue;
                            needCheckFormulaIds.add(id);
                            finalValidFormulaSetting.add(dy);
                            List processes = (List)formulaId2Process.get(id);
                            ArrayList finalProcess = new ArrayList(processes);
                            if (isEc) {
                                finalProcess.removeAll(ParamConstant.RptProcess);
                            } else {
                                finalProcess.removeAll(ParamConstant.ERptProcess);
                            }
                            finalFormulaId2Process.put(id, finalProcess);
                        }
                    }
                    singleCtx.setProperty("needcheckformulalist", finalValidFormulaSetting);
                    singleCtx.setProperty("report_process", finalFormulaId2Process);
                    HashSet tempIds = new HashSet();
                    Arrays.stream(templateNumbers.split(",")).forEach(t -> tempIds.add(firstversionTempMap.get(t)));
                    singleCtx.setProperty("tmpIds", tempIds);
                    ctxList.add(singleCtx);
                    ChkCheckBatchReportService.getInstance().check(new CalculateService(singleCtx));
                }
                catch (Exception e) {
                    LOG.error(String.format("org[%s] reportListChk error!", orgNum), (Throwable)e);
                    errMsgs.add(e.getMessage());
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            if (!latch.await(1L, TimeUnit.HOURS)) {
                LOG.info("BatchChkCheck timeout...");
            }
        }
        catch (InterruptedException e) {
            LOG.error("checkUpChk error!", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new KDBizException((Throwable)e, FiBcmErrorCode.create((String)"fi.bcm.batchChkCheckError"), new Object[0]);
        }
        boolean saveSuccess = ChkCheckServiceHelper.batchSave(ctxList, errMsgs, results, firstTmpId2RealTmpId);
        if (!saveSuccess) {
            results.clear();
        }
        CacheGenFactory.getTemporaryCache().invalidateStartsWithKey("chkcheckcache_");
        if (clickCheck && MapUtils.isEmpty(results) && CollectionUtils.isNotEmpty(errMsgs)) {
            throw new KDBizException(String.join((CharSequence)System.lineSeparator(), errMsgs));
        }
        WATCH_LOG.infoEnd("Finish BatchChkCheck...");
        return results;
    }

    private static boolean batchSave(List<ICalContext> ctxList, Set<String> errMsgs, Map<Pair<Long, Long>, CheckResultenum> results, Map<Long, Long> firstTmpId2RealTmpId) {
        try (TXHandle txHandle = TX.required();){
            ArrayList newReports = new ArrayList();
            ArrayList oldReports = new ArrayList();
            try {
                ctxList.forEach(ctx -> {
                    List oldReportAfterCheck;
                    List newReportAfterCheck = (List)ctx.getProperty("newReportAfterCheck");
                    if (newReportAfterCheck != null) {
                        newReports.addAll(newReportAfterCheck);
                    }
                    if ((oldReportAfterCheck = (List)ctx.getProperty("oldReportAfterCheck")) != null) {
                        oldReports.addAll(oldReportAfterCheck);
                    }
                });
                SaveServiceHelper.save((DynamicObject[])newReports.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])oldReports.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                LOG.error("batchSave error!", (Throwable)e);
                errMsgs.add(e.getMessage());
                txHandle.markRollback();
                boolean bl = false;
                if (txHandle != null) {
                    if (var5_5 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        ctxList.forEach(ctx -> {
            ChkStatusBuilder csb = (ChkStatusBuilder)ctx.getProperty("csb");
            if (csb != null) {
                Map<String, Pair<Integer, Integer>> tmpResults = csb.syncStatus(true);
                tmpResults.forEach((k, v) -> results.put(Pair.onePair((Object)ChkCheckServiceHelper.getRealOrgId(ctx), firstTmpId2RealTmpId.get(LongUtil.toLong((Object)k))), ((Integer)v.p1).intValue() == ChkStatusEnum.UNPASS.getStatus() ? CheckResultenum.FAIL : CheckResultenum.SUCCESS));
            }
        });
        return true;
    }

    private static void buildOrg2ECMap(ICalContext ctx, Map<Long, String[]> org2CurMap, Map<String, List<Long>> ecMap) {
        Set orgIds = (Set)ctx.getProperty("selectorgids");
        orgIds.forEach(orgId -> {
            boolean isEc = ChkCheckServiceHelper.isEc(org2CurMap, ctx.getCurrency(), orgId);
            if (isEc) {
                ecMap.computeIfAbsent("isEc", k -> new ArrayList()).add(orgId);
            } else {
                ecMap.computeIfAbsent("isPc", k -> new ArrayList()).add(orgId);
            }
        });
    }

    private static void copyProperty(ICalContext source, ICalContext dest, String[] propertyName) {
        for (String property : propertyName) {
            dest.setProperty(property, source.getProperty(property));
        }
    }

    private static void prepareCommonData(ICalContext ctx) {
        long modelId = MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
        long yearId = MemberReader.findFyMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getYear()).getId();
        long periodId = MemberReader.findPeriodMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getPeriod()).getId();
        long scenarioId = MemberReader.findScenaMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getScenario()).getId();
        ctx.setProperty("modelId", modelId);
        ctx.setProperty("yearId", yearId);
        ctx.setProperty("periodId", periodId);
        ctx.setProperty("scenarioId", scenarioId);
        ctx.setProperty("islink", "0");
        ChkCheckServiceHelper.collectTempAndOrg(ctx);
        ChkCheckServiceHelper.fillBpNumber2Id(ctx);
        Map<Long, DynamicObject> effectiveFormulaSetting = ChkCheckServiceHelper.getEffectiveFormulaSetting(ctx);
        Map<String, List<Long>> noReportTemplate2FormulaSetting = ChkCheckServiceHelper.noReportTemplate2FormulaSetting((List)ctx.getProperty("tempnumbers"), effectiveFormulaSetting.values().toArray(new DynamicObject[0]));
        Set orgIds = (Set)ctx.getProperty("selectorgids");
        HashMap org2Currency = new HashMap();
        orgIds.forEach(id -> {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)id);
            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                org2Currency.putIfAbsent(id, new String[2]);
                ((String[])org2Currency.get((Object)id))[0] = node.getCurrency();
                ((String[])org2Currency.get((Object)id))[1] = node.getParent().getCurrency();
            }
        });
        ctx.setProperty("org2Currency", org2Currency);
        Map<Long, List<Long>> chkFormulaSettings = ChkCheckServiceHelper.getOrgValidChkFormulaSettings(ctx);
        ctx.setProperty("batchcheckorg", chkFormulaSettings);
        ctx.setProperty("noreportsetting", noReportTemplate2FormulaSetting);
        QFilter qFilter = new QFilter("model", "=", (Object)ctx.getModelId());
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
        ctx.setProperty("alltemplate", templates);
        ctx.setProperty("memberData", ChkCheckServiceHelper.getMemberData(effectiveFormulaSetting.values().toArray(new DynamicObject[0])));
    }

    private static Map<Long, List<Long>> getOrgValidChkFormulaSettings(ICalContext ctx) {
        List ckms = (List)ctx.getProperty("ckms");
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>();
        Set selectOrgs = (Set)ctx.getProperty("selectorgids");
        ckms.forEach(ckm -> selectOrgs.forEach(orgId -> {
            RangeStatus status = new RangeStatus();
            IDNumberTreeNode baseTreeNode = MemberReader.findEntityMemberById((String)ctx.getCubeNumber(), (Long)orgId).getBaseTreeNode();
            List nodes = baseTreeNode.getShareNodes();
            ArrayList<Long> list = new ArrayList<Long>();
            nodes.forEach(node -> list.add(node.getId()));
            list.add(baseTreeNode.getId());
            ChkCheckServiceHelper.isInnerRange(ctx, ckm, status, list.iterator());
            if (StringUtils.isNotEmpty((String)ctx.getScenario())) {
                ChkCheckServiceHelper.isInnerRange(ctx, status, "bcm_scenemembertree", ckm, ctx.getProperty("scenarioId"));
            }
            if (status.isInner) {
                resultMap.computeIfAbsent((Long)orgId, k -> new ArrayList()).add(ckm.getId());
            }
        }));
        return resultMap;
    }

    private static void collectTempAndOrg(ICalContext ctx) {
        DynamicObjectCollection reportlist = (DynamicObjectCollection)ctx.getProperty("selecttemplatelist");
        QFilter filter2 = new QFilter("model", "=", (Object)ctx.getModelId()).and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,versionnumber", (QFilter[])new QFilter[]{filter2});
        HashMap<Long, String> tempMap = new HashMap<Long, String>();
        HashMap<String, Long> firstVersionMap = new HashMap<String, Long>();
        for (DynamicObject dot : templates) {
            tempMap.put(dot.getLong("id"), dot.getString("number"));
            if (dot.getInt("versionnumber") != 1) continue;
            firstVersionMap.put(dot.getString("number"), dot.getLong("id"));
        }
        ctx.setProperty("tempmap", tempMap);
        ctx.setProperty("firstversionmap", firstVersionMap);
        ArrayList templateNumbers = new ArrayList();
        HashSet selectOrgs = new HashSet();
        reportlist.forEach(report -> {
            String templateNumber = (String)tempMap.get(report.getLong("template.id"));
            if (StringUtils.isNotEmpty((String)templateNumber)) {
                templateNumbers.add(templateNumber);
            }
            selectOrgs.add(report.getLong("entity"));
        });
        ctx.setProperty("tempnumbers", templateNumbers);
        ctx.setProperty("selectorgids", selectOrgs);
        Collection orgs = MemberReader.getAllNodeByDimNum((String)"Entity", (String)ctx.getCubeNumber());
        HashMap orgMap = new HashMap(orgs.size());
        orgs.forEach(o -> orgMap.put(o.getId(), o.getNumber()));
        ctx.setProperty("orgmap", orgMap);
    }

    public static Pair<CheckResultenum, String> intelligentScheduleCheck(ICalContext ctx) {
        if (ChkSourceEnum.INTELLIGENT_SCHEDULE != ctx.getProperty("chksourcetype")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u667a\u80fd\u8c03\u5ea6\u573a\u666f\u3002", (String)"ChkCheckScheduleService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        List orgList = (List)ctx.getProperty("chk_org_list");
        if (CollectionUtils.isEmpty((Collection)orgList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChkCheckScheduleService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (orgList.size() > 1000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u6b21\u6821\u9a8c\u4e0d\u80fd\u8d85\u8fc71000\u5bb6\u7ec4\u7ec7\u3002", (String)"ChkCheckScheduleService_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        CountDownLatch countDownLatch = new CountDownLatch(orgList.size());
        AtomicBoolean complete = new AtomicBoolean(true);
        AtomicInteger failedCount = new AtomicInteger();
        ConcurrentHashMap<String, Set<String>> errorMsg = new ConcurrentHashMap<String, Set<String>>();
        for (Pair org : orgList) {
            ThreadPoolService.runScheduleChkThread(() -> {
                try {
                    if (ctx instanceof CalContext) {
                        CalContext singleOrgContext_ec = new CalContext(ctx.getCubeNumber(), (String)org.p1, ctx.getYear(), ctx.getPeriod(), ctx.getScenario(), null);
                        singleOrgContext_ec.setProcessList(ChkCheckServiceHelper.getEcProcessList(ctx));
                        singleOrgContext_ec.setProperty("chksourcetype", ctx.getProperty("chksourcetype"));
                        singleOrgContext_ec.setProperty("originalOrgId", org.p2);
                        ChkCheckServiceHelper.check(singleOrgContext_ec);
                        CalContext singleOrgContext_pc = new CalContext(ctx.getCubeNumber(), (String)org.p1, ctx.getYear(), ctx.getPeriod(), ctx.getScenario(), null);
                        singleOrgContext_pc.setProcessList(ChkCheckServiceHelper.getPcProcessList(ctx));
                        singleOrgContext_pc.setProperty("chksourcetype", ctx.getProperty("chksourcetype"));
                        singleOrgContext_pc.setProperty("originalOrgId", org.p2);
                        singleOrgContext_pc.setProperty("PCSchedule", 1);
                        ChkCheckServiceHelper.check(singleOrgContext_pc);
                    }
                }
                catch (Exception e) {
                    LOG.error("IntelligentScheduleCheck Exception!", (Throwable)e);
                    complete.set(false);
                    if (e instanceof KDBizException && FiBcmErrorCode.matchErrorCode((KDException)((KDException)e), (String)"fi.bcm.periodClosedError")) {
                        errorMsg.computeIfAbsent(((KDBizException)((Object)((Object)e))).getErrorCode().getCode(), k -> new CopyOnWriteArraySet()).add(org.p1);
                    } else {
                        errorMsg.computeIfAbsent("", k -> new CopyOnWriteArraySet()).add(e.getMessage());
                    }
                    failedCount.getAndIncrement();
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            LOG.error("IntelligentScheduleCheck InterruptedException!", (Throwable)e);
            complete.set(false);
            errorMsg.computeIfAbsent("", k -> new LinkedHashSet()).add(e.getMessage());
            Thread.currentThread().interrupt();
        }
        if (complete.get()) {
            return Pair.onePair((Object)CheckResultenum.COMPLETE, (Object)StringUtils.getEmpty());
        }
        if (failedCount.get() == orgList.size()) {
            return Pair.onePair((Object)CheckResultenum.FAIL, (Object)ChkCheckServiceHelper.formatMsg(errorMsg));
        }
        return Pair.onePair((Object)CheckResultenum.COMPLETE, (Object)ChkCheckServiceHelper.formatMsg(errorMsg));
    }

    private static String formatMsg(Map<String, Set<String>> errorMsg) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        errorMsg.forEach((k, v) -> {
            String message = FiBcmErrorCode.getMessage((String)k);
            if (StringUtils.isNotEmpty((String)message)) {
                errorMsgBuilder.append(String.format(message, String.join((CharSequence)",", v)));
            } else {
                errorMsgBuilder.append(String.join((CharSequence)",", v));
            }
        });
        return errorMsgBuilder.toString();
    }

    private static List<String> getEcProcessList(ICalContext ctx) {
        List<String> processList = ctx.getProcessList();
        if (CollectionUtils.isEmpty(processList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u7a0b\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChkCheckScheduleService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return processList.stream().filter(ParamConstant.ERptProcess::contains).collect(Collectors.toList());
    }

    private static List<String> getPcProcessList(ICalContext ctx) {
        List<String> processList = ctx.getProcessList();
        if (CollectionUtils.isEmpty(processList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u7a0b\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChkCheckScheduleService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return processList.stream().filter(p -> !ParamConstant.ERptProcess.contains(p)).collect(Collectors.toList());
    }

    public static String getResultkey(long chkformulaId, String process, String currency) {
        return chkformulaId + "@" + process + "@" + currency;
    }

    public static DynamicObject getReport(ICalContext ctx, List<DynamicObject> oldReportAfterCheck, Map<String, List<DynamicObject>> oldresultmap, ChkResultModel resultModel, Map<String, Boolean> allChkResultModel) {
        String resultkey = ChkCheckServiceHelper.getResultkey(resultModel.getSetid(), resultModel.getProcess(), resultModel.getCurrency());
        List<DynamicObject> reports = oldresultmap.get(resultkey);
        DynamicObject report = null;
        String fulllformula = resultModel.getFulllformula();
        String fullrformula = resultModel.getFullrformula();
        if (CollectionUtils.isNotEmpty(reports)) {
            if (allChkResultModel != null && allChkResultModel.get(resultkey).booleanValue()) {
                Optional<DynamicObject> matchedReport = reports.stream().filter(dy -> fulllformula.equals(dy.getString("fulllformula")) && fullrformula.equals(dy.getString("fullrformula"))).findFirst();
                if (matchedReport.isPresent()) {
                    report = matchedReport.get();
                    oldReportAfterCheck.add(report);
                    reports.remove(report);
                }
            } else {
                String[] split = resultkey.split("@");
                ChkCheckServiceHelper.deleteOldResult(ctx, oldresultmap, resultkey, split);
            }
        }
        return report;
    }

    private static void deleteOldResult(ICalContext ctx, Map<String, List<DynamicObject>> oldresultmap, String resultkey, String[] split) {
        ArrayList<QFilter> fl = new ArrayList<QFilter>();
        fl.add(new QFilter("model", "=", (Object)ctx.getModelId()));
        fl.add(new QFilter("year", "=", (Object)ctx.getYearId()));
        fl.add(new QFilter("period", "=", (Object)ctx.getPeriodId()));
        fl.add(new QFilter("scenario", "=", (Object)ctx.getScenarioId()));
        fl.add(new QFilter("org", "in", ctx.getProperty("orgIds")));
        long processId = MemberReader.findProcessMemberByNum((String)ctx.getCubeNumber(), (String)split[1]).getId();
        fl.add(new QFilter("process", "=", (Object)processId));
        long currencyId = MemberReader.findCurrencyMemberByNum((String)ctx.getCubeNumber(), (String)split[2]).getId();
        fl.add(new QFilter("currency", "=", (Object)currencyId));
        fl.add(new QFilter("chkformula", "=", (Object)Long.parseLong(split[0])));
        DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])fl.toArray(new QFilter[0]));
        oldresultmap.remove(resultkey);
    }

    public static void checkFlowStatus(ICalContext ctx, boolean isBatch) {
        if (!isBatch) {
            ChkCheckServiceHelper.checkFlowStatus(ctx);
            return;
        }
        Map org2CurMap = (Map)ctx.getProperty("org2Currency");
        Set selectOrgs = (Set)ctx.getProperty("selectorgids");
        Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(ctx.getModelId(), selectOrgs, ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId());
        String currency = (String)ctx.getProperty("currency");
        mcStatusMap.forEach((id, status) -> {
            boolean isEc = ChkCheckServiceHelper.isEc(org2CurMap, currency, id);
            if (status.getFlow().isSubmit() && isEc) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"ChkCheckServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (status.getPcFlow().isSubmit() && !isEc) {
                throw new KDBizException(ResManager.loadKDString((String)"Rpt-\u6298\u7b97\u5e01\u62a5\u8868\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"ChkCheckServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        });
    }

    private static boolean isEc(Map<Long, String[]> org2CurMap, String currency, Long id) {
        return "EC".equals(currency) || "DC".equals(currency) || org2CurMap.containsKey(id) && currency.equals(org2CurMap.get(id)[0]);
    }

    public static void checkFlowStatus(ICalContext ctx) {
        if (CollectionUtils.isNotEmpty((Collection)((Collection)ctx.getProperty("report_process_list")))) {
            Set processes = (Set)ctx.getProperty("report_process_list");
            if (ChkCheckServiceHelper.containEcProcess(processes)) {
                ChkCheckServiceHelper.checkEcFlowStatus(ctx);
            } else if (ChkCheckServiceHelper.containPcProcess(processes)) {
                ChkCheckServiceHelper.checkPcFlowStatus(ctx);
            } else {
                ChkCheckServiceHelper.checkParentEcFlowStatus(ctx);
            }
            return;
        }
        if (ChkCtxConstant.CHECK_ORG_ERPT.equals(ctx.getProperty("mcstatus")) || ChkCtxConstant.CHECK_ORG_RPT.equals(ctx.getProperty("mcstatus"))) {
            boolean isArchive = false;
            try {
                String sceneNum = MemberReader.findScenaMemberById((Long)ctx.getModelId(), (Long)ctx.getScenarioId()).getNumber();
                String yearNum = MemberReader.findFyMemberById((Long)ctx.getModelId(), (Long)ctx.getYearId()).getNumber();
                String periodNum = MemberReader.findPeriodMemberById((Long)ctx.getModelId(), (Long)ctx.getPeriodId()).getNumber();
                isArchive = LockScopeServiceHelper.isExistArchiving(ctx.getModelId(), sceneNum, yearNum, periodNum);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (isArchive) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u5df2\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u52fe\u7a3d\u3002", (String)"ChkCheckServiceHelper_17", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(ctx.getModelId(), Collections.singletonList(ChkCheckServiceHelper.getRealOrgId(ctx)), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId());
            McStatus mcStatus = mcStatusMap.get(ChkCheckServiceHelper.getRealOrgId(ctx));
            if (ChkCtxConstant.CHECK_ORG_ERPT.equals(ctx.getProperty("mcstatus")) && mcStatus != null && mcStatus.getFlow().isSubmit()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u5df2\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u52fe\u7a3d\u3002", (String)"ChkCheckServiceHelper_71", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (ChkCtxConstant.CHECK_ORG_ERPT.equals(ctx.getProperty("mcstatus")) && mcStatus != null && mcStatus.getArchive().isArchive()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u5df2\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u52fe\u7a3d\u3002", (String)"ChkCheckServiceHelper_17", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (ChkCtxConstant.CHECK_ORG_RPT.equals(ctx.getProperty("mcstatus")) && mcStatus != null && mcStatus.getPcFlow().isSubmit()) {
                throw new KDBizException(ResManager.loadKDString((String)"Rpt-\u6298\u7b97\u5e01\u62a5\u8868\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"ChkCheckServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        if (ChkCtxConstant.CHECK_PARENT_ORG_ERPT.equals(ctx.getProperty("mcstatus"))) {
            ChkCheckServiceHelper.checkParentEcFlowStatus(ctx);
        }
    }

    public static void checkParentEcFlowStatus(ICalContext ctx) {
        Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(ctx.getModelId(), Collections.singletonList(ctx.getProperty("orgparent")), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId());
        McStatus mcStatus = mcStatusMap.get(ctx.getProperty("orgparent"));
        if (mcStatus != null && mcStatus.getFlow().isSubmit()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7ERpt-\u9ed8\u8ba4\u5e01\u62a5\u8868\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"ChkCheckServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public static void checkPcFlowStatus(ICalContext ctx) {
        Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(ctx.getModelId(), Collections.singletonList(ChkCheckServiceHelper.getRealOrgId(ctx)), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId());
        McStatus mcStatus = mcStatusMap.get(ChkCheckServiceHelper.getRealOrgId(ctx));
        if (mcStatus != null && mcStatus.getPcFlow().isSubmit()) {
            throw new KDBizException(ResManager.loadKDString((String)"Rpt-\u6298\u7b97\u5e01\u62a5\u8868\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"ChkCheckServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public static void checkEcFlowStatus(ICalContext ctx) {
        Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(ctx.getModelId(), Collections.singletonList(ChkCheckServiceHelper.getRealOrgId(ctx)), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId());
        McStatus mcStatus = mcStatusMap.get(ChkCheckServiceHelper.getRealOrgId(ctx));
        if (mcStatus != null && mcStatus.getFlow().isSubmit()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"ChkCheckServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public static Long getRealOrgId(ICalContext ctx) {
        return ctx.getProperty("originalOrgId") == null ? ctx.getOrgId() : (Long)ctx.getProperty("originalOrgId");
    }

    public static boolean containEcProcess(Collection<String> source) {
        for (String eRptProcess : ParamConstant.ERptProcess) {
            if (!source.contains(eRptProcess)) continue;
            return true;
        }
        return false;
    }

    public static boolean containPcProcess(Collection<String> source) {
        for (String eRptProcess : ParamConstant.RptProcess) {
            if (!source.contains(eRptProcess)) continue;
            return true;
        }
        return false;
    }

    public static DynamicObject getDimSetting(QFilter qFilter, List<String> dimList) {
        DynamicObject chineseSetting = ChkCheckServiceHelper.getDimSetting(qFilter);
        if (chineseSetting != null) {
            dimList.addAll(Arrays.asList(chineseSetting.getString("selectdims").split(";")));
        }
        if (dimList.isEmpty()) {
            dimList.add(DimTypesEnum.ACCOUNT.getNumber());
        }
        return chineseSetting;
    }

    public static DynamicObject getDimSetting(QFilter qFilter) {
        DynamicObjectCollection settings = QueryServiceHelper.query((String)"bcm_chkdisplaysetting", (String)"type,selectdims", (QFilter[])new QFilter[]{qFilter});
        DynamicObject chineseSetting = null;
        for (DynamicObject dot : settings) {
            if (dot.getInt("type") != 1) continue;
            chineseSetting = dot;
        }
        return chineseSetting;
    }

    public static void addFormulaResultModel(CalculateService service, List<ChkFormulaModel> list, List<ChkResultModel> results) {
        for (ChkFormulaModel ckm : list) {
            ChkCheckServiceHelper.addResults(service, results, ckm);
        }
    }

    public static boolean isText(String formula) {
        return ChkCheckServiceHelper.isWrapped(formula, "\"");
    }

    private static boolean isWrapped(String formula, String wrap) {
        return formula.startsWith(wrap) && formula.endsWith(wrap);
    }

    public static void checkPeriodStatus(ICalContext ctx) {
        boolean checkPeriodStatus;
        if (ConfigServiceHelper.getBoolParam(ctx.getModelId(), ConfigEnum.CM012.getNumber()) && !(checkPeriodStatus = PeriodSettingHelper.checkPeriodStatus(ctx.getModelId(), ctx.getOrg(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), "datastatus"))) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.periodClosedError"), new Object[]{ctx.getOrg()});
        }
    }

    public static void checkPeriodStatus(ICalContext ctx, boolean isBatch) {
        if (!isBatch) {
            ChkCheckServiceHelper.checkPeriodStatus(ctx);
            return;
        }
        if (ConfigServiceHelper.getBoolParam(ctx.getModelId(), ConfigEnum.CM012.getNumber())) {
            Set selectOrgs = (Set)ctx.getProperty("selectorgids");
            Map orgMap = (Map)ctx.getProperty("orgmap");
            Set<String> orgNumbers = selectOrgs.stream().map(orgMap::get).collect(Collectors.toSet());
            Set<String> statusOpenOrg = PeriodSettingHelper.batchSelectPeriodStatusOpen(ctx.getModelId(), orgNumbers, ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), "datastatus");
            if (orgNumbers.size() != statusOpenOrg.size()) {
                StringJoiner sj = new StringJoiner("\uff0c");
                orgNumbers.forEach(org -> {
                    if (!statusOpenOrg.contains(org)) {
                        sj.add((CharSequence)org);
                    }
                });
                if (sj.length() > 0) {
                    throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.periodClosedError"), new Object[]{sj.toString()});
                }
            }
        }
    }

    public static void checkIsQuoteLocked(ICalContext ctx) {
        if (MergeControlHelper.isQuoteLocked(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), (Long)ctx.getProperty("originalOrgId"))) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scenarioVersionError"), new Object[0]);
        }
    }

    private static void initBackgroundDim(ICalContext ctx, Map<String, Set<String>> map) {
        HashSet<String> years = new HashSet<String>();
        years.add(ctx.getYear());
        map.put(DimTypesEnum.YEAR.getShortNumber(), years);
        HashSet<String> periods = new HashSet<String>();
        periods.add(ctx.getPeriod());
        map.put(DimTypesEnum.PERIOD.getShortNumber(), periods);
        HashSet<String> scenarios = new HashSet<String>();
        scenarios.add(ctx.getScenario());
        map.put(DimTypesEnum.SCENARIO.getShortNumber(), scenarios);
        HashSet<String> orgs = new HashSet<String>();
        orgs.add(ctx.getOrg());
        String orgParentNumber = (String)ctx.getProperty("orgpnumber");
        if (StringUtils.isNotEmpty((String)orgParentNumber)) {
            orgs.add(orgParentNumber + "_" + ctx.getOrg());
        }
        map.put(DimTypesEnum.ENTITY.getShortNumber(), orgs);
        HashSet<String> currencies = new HashSet<String>();
        if (StringUtils.isNotEmpty((String)ctx.getCurrency())) {
            currencies.add(ctx.getCurrency());
        } else {
            String ec = (String)ctx.getProperty("ecCurrency");
            String pc = (String)ctx.getProperty("pcCurrency");
            if (StringUtils.isNotEmpty((String)ec)) {
                currencies.add(ec);
            }
            if (StringUtils.isNotEmpty((String)pc)) {
                currencies.add(pc);
            }
        }
        map.put(DimTypesEnum.CURRENCY.getShortNumber(), currencies);
    }

    private static boolean includeLastPeriod(String formula) {
        return formula.contains("\"P.LastPeriod\"");
    }

    private static boolean includeLastYear(String formula) {
        return formula.contains("\"FY.LastYear\"");
    }

    private static void parseFormula(Map<String, Set<String>> olapQueryMap, String leftformula) {
        Pair<String, List<IFormula>> pair = ChkFormulaServiceHelper.parseFormula(leftformula);
        if (!CollectionUtils.isEmpty((Collection)((Collection)pair.p2))) {
            ChkCheckServiceHelper.fillOlapQueryMap(olapQueryMap, (List)pair.p2);
        }
    }

    private static void fillOlapQueryMap(Map<String, Set<String>> olapQueryMap, List<IFormula> formulas) {
        for (IFormula f : formulas) {
            for (int i = 0; i < f.getParamList().size(); ++i) {
                ParamItem formulaParam = (ParamItem)f.getParamList().get(i);
                String[] formulaParamDimAndMember = formulaParam.toString().split("\\.", 2);
                if (formulaParamDimAndMember.length <= 1) continue;
                if (!olapQueryMap.containsKey(formulaParamDimAndMember[0])) {
                    olapQueryMap.put(formulaParamDimAndMember[0], new HashSet());
                }
                olapQueryMap.get(formulaParamDimAndMember[0]).add(formulaParamDimAndMember[1]);
            }
        }
    }

    public static boolean formulaError(ICalContext ctx, List<String> formulas) {
        if (formulas == null && ctx.getProperty("return") != null) {
            ctx.removeProperty("return");
            return true;
        }
        return false;
    }

    public static void addResults(CalculateService service, List<ChkResultModel> results, ChkFormulaModel ckm) {
        ICalContext ctx = service.get_ctx();
        Map<String, List<String>> numbermap = ChkCheckServiceHelper.getMapDim(ckm, ctx);
        if (numbermap == null) {
            return;
        }
        List<String> lefts = ChkCheckServiceHelper.getRealFormula(ctx, ckm.getLeftformula(), numbermap);
        if (ChkCheckServiceHelper.formulaError(ctx, lefts)) {
            return;
        }
        List<String> rights = ChkCheckServiceHelper.getRealFormula(ctx, ckm.getRightformula(), numbermap);
        if (ChkCheckServiceHelper.formulaError(ctx, rights)) {
            return;
        }
        if (lefts == null || lefts.isEmpty()) {
            return;
        }
        if (rights == null || rights.isEmpty()) {
            lefts.forEach(leftformula -> {
                List<String> formulas = ChkFormulaServiceHelper.getVList(leftformula);
                List<String> newFormulas = ChkCheckServiceHelper.fillDefaultMember(service.get_ctx(), formulas);
                String replacedLeftResult = leftformula;
                for (int i = 0; i < formulas.size(); ++i) {
                    String formula = formulas.get(i);
                    String newFormula = newFormulas.get(i);
                    replacedLeftResult = replacedLeftResult.replace(formula, newFormula);
                }
                ExpressStatus lstatus = service.addCalculateExpress((String)leftformula);
                ChkCheckServiceHelper.setResultModelTemplate(results, ckm, lstatus, replacedLeftResult);
            });
            return;
        }
        if (lefts.size() > rights.size()) {
            String rightformula2 = rights.get(0);
            lefts.forEach(leftformula -> ChkCheckServiceHelper.initResultModel(service, results, ckm, leftformula, rightformula2));
        } else if (lefts.size() < rights.size()) {
            String leftformula2 = lefts.get(0);
            rights.forEach(rightformula -> ChkCheckServiceHelper.initResultModel(service, results, ckm, leftformula2, rightformula));
        } else {
            for (int i = 0; i < lefts.size(); ++i) {
                String leftformula3 = lefts.get(i);
                String rightformula3 = rights.get(i);
                ChkCheckServiceHelper.initResultModel(service, results, ckm, leftformula3, rightformula3);
            }
        }
    }

    public static List<String> fillDefaultMember(ICalContext ctx, List<String> originalFormulas) {
        ArrayList<String> formulaList = new ArrayList<String>();
        originalFormulas.forEach(originalFormula -> {
            Pair<String, List<IFormula>> formulas = ChkFormulaServiceHelper.parseFormula(originalFormula);
            if (CollectionUtils.isNotEmpty((Collection)((Collection)formulas.p2))) {
                ((List)formulas.p2).forEach(f -> {
                    if (VFormula.getVName().equals(f.getName())) {
                        ChkCheckServiceHelper.fillDefaultDimMember(ctx, f);
                        formulaList.add(f.toString());
                    }
                });
            }
        });
        return formulaList;
    }

    private static void fillDefaultDimMember(ICalContext ctx, IFormula f) {
        ArrayList dims = new ArrayList();
        f.getParamList().forEach(p -> dims.add(ChkCheckServiceHelper.extractDimShortNum(p)));
        if (!dims.contains(DimTypesEnum.ENTITY.getShortNumber())) {
            f.getParamList().add(new ParamItem(DimTypesEnum.ENTITY.getShortNumber() + "." + ctx.getOrg()));
        }
        if (!dims.contains(DimTypesEnum.YEAR.getShortNumber())) {
            f.getParamList().add(new ParamItem(DimTypesEnum.YEAR.getShortNumber() + "." + ctx.getYear()));
        }
        if (!dims.contains(DimTypesEnum.PERIOD.getShortNumber())) {
            f.getParamList().add(new ParamItem(DimTypesEnum.PERIOD.getShortNumber() + "." + ctx.getPeriod()));
        }
        if (!dims.contains(DimTypesEnum.SCENARIO.getShortNumber())) {
            f.getParamList().add(new ParamItem(DimTypesEnum.SCENARIO.getShortNumber() + "." + ctx.getScenario()));
        }
        if (!dims.contains(DimTypesEnum.CURRENCY.getShortNumber())) {
            f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + ChkCheckServiceHelper.getCurrency(ctx, ctx.getProcess(), ctx.getCurrency())));
        }
    }

    private static void initResultModel(CalculateService service, List<ChkResultModel> results, ChkFormulaModel ckm, String leftformula, String rightformula) {
        service.setCollectChildParseExpr(true);
        ExpressStatus lstatus = service.addCalculateExpress(leftformula);
        ExpressStatus rstatus = service.addCalculateExpress(rightformula);
        ChkCheckServiceHelper.setResultModelTemplate(service, results, ckm, lstatus, rstatus, leftformula, rightformula);
    }

    public static CheckResultenum fillCheckResult2Rep(ChkResultModel resultModel, DynamicObject rep) {
        if (resultModel.isPass()) {
            rep.set("chkresulttype", (Object)(resultModel.isForcePass() ? ChkResultTypeEnum.FORCEPASS.getIndex() : ChkResultTypeEnum.PASS.getIndex()));
        } else {
            rep.set("chkresulttype", (Object)(CHKCheckEffectEnum.TipAndReport == resultModel.getCheckEffect() ? ChkResultTypeEnum.UNPASSBUTNOTEFFECT.getIndex() : ChkResultTypeEnum.UNPASS.getIndex()));
        }
        String note = rep.getString("note");
        CheckResultenum result = resultModel.getResult();
        if (CHKCheckEffectEnum.NoteAndReport == resultModel.getCheckEffect() && StringUtils.isNotEmpty((String)note)) {
            rep.set("chkresulttype", (Object)ChkResultTypeEnum.PASS.getIndex());
            result = CheckResultenum.SUCCESS;
        }
        return result;
    }

    public static void fillRepProperty(CalculateService service, ChkResultModel resultModel, DynamicObject rep) {
        rep.set("chineseformula", (Object)resultModel.getCkm().getChineseformula());
        rep.set("template", (Object)resultModel.getTmpid());
        rep.set("chkformula", (Object)resultModel.getSetid());
        rep.set("calcresultexpr", (Object)resultModel.getBalance());
        String leftresult = ChkCheckServiceHelper.getResult(resultModel.getLeftstatus(), service);
        String rightresult = ChkCheckServiceHelper.getResult(resultModel.getRightstatus(), service);
        rep.set("leftresult", (Object)leftresult);
        rep.set("rightresult", (Object)rightresult);
        rep.set("fulllformula", (Object)resultModel.getFulllformula());
        rep.set("fullrformula", (Object)resultModel.getFullrformula());
        rep.set("modifier", (Object)RequestContext.get().getUserId());
        rep.set("modifytime", (Object)TimeServiceHelper.now());
        Map<String, Object> formulaResultMap = service.getResultMap();
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        ChkCheckServiceHelper.fillResult(resultModel.getLeftstatus(), resultModel, formulaResultMap, resultMap, "leftformula", "leftResultMap");
        ChkCheckServiceHelper.fillResult(resultModel.getRightstatus(), resultModel, formulaResultMap, resultMap, "rightformula", "rightResultMap");
        try {
            rep.set("resultmap", (Object)JSONUtils.toString(resultMap));
        }
        catch (IOException e) {
            LOG.error("save resultmap failed!", (Throwable)e);
        }
    }

    private static void fillResult(ExpressStatus exprStatus, ChkResultModel resultModel, Map<String, Object> calculateResultMap, Map<String, Map<String, Object>> resultMap, String formula, String resultMapKey) {
        if (exprStatus == null) {
            return;
        }
        if (ChkCheckServiceHelper.isText(exprStatus.getParseExpr())) {
            return;
        }
        List<Object> exprs = null;
        if (!CollectionUtils.isEmpty(exprStatus.getChildParseExpr()) && exprStatus.getChildParseExpr().size() > 1) {
            exprs = exprStatus.getChildParseExpr();
        } else {
            exprs = new ArrayList<String>(1);
            exprs.add(exprStatus.getParseExpr());
        }
        EncoderService coder = new EncoderService();
        for (int i = 0; i < exprs.size(); ++i) {
            exprs.set(i, coder.getCode());
        }
        HashMap<String, Object> exprResultMap = new HashMap<String, Object>(16);
        String expandFormula = "leftformula".equals(formula) ? resultModel.getExpandLFormula() : resultModel.getExpandRFormula();
        if (expandFormula == null) {
            return;
        }
        expandFormula = ChkCheckServiceHelper.dealExpandFormula(expandFormula, exprs, calculateResultMap, exprResultMap);
        exprResultMap.put(formula, expandFormula);
        resultMap.put(resultMapKey, exprResultMap);
    }

    private static String getResult(ExpressStatus expressStatus, CalculateService service) {
        if (expressStatus == null) {
            return StringUtils.getEmpty();
        }
        String originalResult = service.trans2EvalExpress(expressStatus);
        return originalResult.length() > 2000 ? originalResult.substring(0, 2000) : originalResult;
    }

    private static String changeExpr(ExpressStatus leftstatus, Map<String, String> keyMap) {
        String leftExpr = leftstatus.getParseExpr();
        int i = 0;
        for (Map.Entry<String, String> entry : keyMap.entrySet()) {
            leftExpr = leftExpr.replace(entry.getKey(), String.format("{%d}", i++));
        }
        i = 0;
        for (Map.Entry<String, String> entry : keyMap.entrySet()) {
            leftExpr = leftExpr.replace(String.format("{%d}", i++), entry.getValue());
        }
        return leftExpr;
    }

    public static void setProcess2Report(ICalContext ctx, DynamicObject rep, String processNum, String currency) {
        if (processNum != null) {
            Map<String, Long> bp_Number2Id = ctx.getBpNumber2Id();
            rep.set("process", (Object)bp_Number2Id.get(processNum));
            if (SysMembConstant.BP4CHK.contains(processNum)) {
                rep.set("orgparent", ctx.getProperty("orgparent"));
            }
            if (rep.get("currency") == null || rep.get("currency") instanceof Long && (Long)rep.get("currency") == -1L) {
                rep.set("currency", (Object)MemberReader.findCurrencyMemberByNum((String)ctx.getCubeNumber(), (String)currency).getId());
            }
        }
    }

    public static String getFullrformula(CalculateService service, ICalContext ctx, ChkResultModel resultModel) {
        String fullrformula;
        if (resultModel.getRightstatus() == null) {
            return StringUtils.getEmpty();
        }
        if (!resultModel.setRightresult(service)) {
            resultModel.setRightresult(BigDecimal.ZERO);
        }
        fullrformula = (fullrformula = service.trans2FormulaEexprss(resultModel.getRightstatus())).contains("ROUND(") || fullrformula.contains("ABS(") || fullrformula.contains("LEN(") || resultModel.getJudge() ? ChkCheckServiceHelper.setDefaultDimForJudgeEqual(ctx, resultModel.getRightformula(), resultModel.getRightformulatemp(), resultModel.getJudge()) : ChkCheckServiceHelper.fillTempToFormula(resultModel.getRightformulatemp(), fullrformula);
        return fullrformula;
    }

    public static String getFulllformula(CalculateService service, ICalContext ctx, ChkResultModel resultModel) {
        String fulllformula;
        if (resultModel.getLeftstatus() == null) {
            return StringUtils.getEmpty();
        }
        if (!resultModel.setLeftresult(service)) {
            resultModel.setLeftresult(BigDecimal.ZERO);
        }
        fulllformula = (fulllformula = service.trans2FormulaEexprss(resultModel.getLeftstatus())).contains("ROUND(") || fulllformula.contains("ABS(") || fulllformula.contains("LEN(") || resultModel.getJudge() ? ChkCheckServiceHelper.setDefaultDimForJudgeEqual(ctx, resultModel.getLeftformla(), resultModel.getLeftformlatemp(), resultModel.getJudge()) : ChkCheckServiceHelper.fillTempToFormula(resultModel.getLeftformlatemp(), fulllformula);
        return fulllformula;
    }

    public static List<QFilter> getDeleteDirtyFilters(ICalContext ctx) {
        Long orgparent;
        ArrayList<QFilter> fl = new ArrayList<QFilter>();
        fl.add(new QFilter("org", "in", ctx.getProperty("orgIds")));
        if (Objects.nonNull(ctx.getProperty("processIds"))) {
            fl.add(new QFilter("process", "in", ctx.getProperty("processIds")));
        }
        fl.add(new QFilter("period", "=", (Object)ctx.getPeriodId()));
        fl.add(new QFilter("year", "=", (Object)ctx.getYearId()));
        fl.add(new QFilter("currency", "=", (Object)ctx.getCurrencyId()).or(new QFilter("currency", "=", (Object)0)));
        fl.add(new QFilter("model", "=", (Object)ctx.getModelId()));
        fl.add(new QFilter("scenario", "=", (Object)ctx.getScenarioId()));
        Long phaseID = (Long)ctx.getProperty("phase");
        if (phaseID != null) {
            fl.add(new QFilter("phase", "=", (Object)phaseID).or("phase", "=", (Object)0));
        }
        if ((orgparent = (Long)ctx.getProperty("orgparent")) != null) {
            fl.add(new QFilter("orgparent", "=", (Object)orgparent).or("orgparent", "=", (Object)0));
        }
        Set<Long> ids = ChkCheckServiceHelper.getAllFormulaIds(ctx);
        fl.add(new QFilter("chkformula", "in", ids));
        fl.add(new QFilter("cslscheme", "in", Arrays.asList((Long)ctx.getProperty("cslSchemeId"), 0L)));
        return fl;
    }

    public static Set<Long> getAllFormulaIds(ICalContext ctx) {
        DynamicObject[] dys = ChkCheckServiceHelper.getAllFormulaListByCTX(ctx, null);
        HashSet<Long> ids = new HashSet<Long>(dys.length);
        if (dys != null) {
            for (DynamicObject obj : dys) {
                long id = obj.getLong("id");
                ids.add(id);
            }
        }
        return ids;
    }

    public static List<Long> getFormulaIdByReportId(ICalContext ctx) {
        QFilter qFilter = new QFilter("id", "in", ctx.getProperty("reportIds")).and(new QFilter("model", "=", (Object)ctx.getModelId()));
        DynamicObjectCollection chkreports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"chkformula.id", (QFilter[])qFilter.toArray());
        return chkreports.stream().map(dy -> dy.getLong("chkformula.id")).collect(Collectors.toList());
    }

    private static String setDefaultDimForJudgeEqual(ICalContext ctx, String fullFormula, String formulaWithTemp, boolean isJudge) {
        List<String> vList = ChkFormulaServiceHelper.getVList(fullFormula);
        List<String> vWithTempList = ChkFormulaServiceHelper.getVList(formulaWithTemp);
        List<String> fullVList = isJudge ? vList : ChkCheckServiceHelper.fillDefaultMember(ctx, vList);
        List<String> newVList = ChkCheckServiceHelper.fixDefaultDim(ctx, fullVList, ctx.getYear(), ctx.getPeriod());
        ChkCheckServiceHelper.fillTempToFormula(newVList, vWithTempList);
        if (CollectionUtils.isNotEmpty(newVList)) {
            for (int k = 0; k < newVList.size(); ++k) {
                fullFormula = fullFormula.replace(vList.get(k), newVList.get(k));
            }
        }
        return fullFormula;
    }

    private static void setResultModelTemplate(CalculateService service, List<ChkResultModel> results, ChkFormulaModel ckm, ExpressStatus lstatus, ExpressStatus rstatus, String lFormula, String rFormula) {
        String currency;
        String process = ChkCheckServiceHelper.compareDimByPattern(lFormula, ckm.getLeftformula(), ParamConstant.PATTERN_BP);
        if (process == null) {
            process = ChkCheckServiceHelper.compareDimByPattern(rFormula, ckm.getRightformula(), ParamConstant.PATTERN_BP);
        }
        if ((currency = ChkCheckServiceHelper.compareDimByPattern(lFormula, ckm.getLeftformula(), ParamConstant.PATTERN_C)) == null) {
            currency = ChkCheckServiceHelper.compareDimByPattern(rFormula, ckm.getRightformula(), ParamConstant.PATTERN_C);
        }
        ChkResultModel resultModel = new ChkResultModel(lstatus, rstatus, ckm.getLformulatemp(), ckm.getRformulatemp(), lFormula, rFormula, Integer.parseInt(ckm.getComparetype()), ckm.getId());
        resultModel.setCheckEffect(CHKCheckEffectEnum.getCHKCheckEffectByIndex((String)ckm.getChkeffecttype()));
        resultModel.setAllowamount(ckm.getAllowamount());
        resultModel.setProcess(process);
        resultModel.setCurrency(currency);
        resultModel.setCkm(ckm);
        results.add(resultModel);
    }

    private static void setExpandFormula(ChkResultModel resultModel, Map<String, String> formulaOldString2UUID, boolean isLeft) {
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        try {
            String formula = isLeft ? resultModel.getLeftformla() : resultModel.getRightformula();
            if (StringUtils.isEmpty((String)formula)) {
                return;
            }
            Pair<String, List<IFormula>> parse = parser.parse(formula, coder);
            Map<String, List<IFormula>> collect = ((List)parse.p2).stream().collect(Collectors.groupingBy(IFormula::getName));
            ArrayList<IFormula> iFormulas = new ArrayList<IFormula>(10);
            if (collect.get(VFormula.getVName()) != null) {
                iFormulas.addAll((Collection)collect.get(VFormula.getVName()));
            }
            if (collect.get("X") != null) {
                iFormulas.addAll((Collection<IFormula>)collect.get("X"));
            }
            String buildFormula = ChkCheckServiceHelper.buildExpandFormula(formula, parse, formulaOldString2UUID, iFormulas);
            if (isLeft) {
                resultModel.setExpandLFormula(buildFormula);
            } else {
                resultModel.setExpandRFormula(buildFormula);
            }
        }
        catch (Exception e) {
            LOG.error("expandFormula error:", (Throwable)e);
        }
    }

    private static String buildExpandFormula(String formula, Pair<String, List<IFormula>> parsePair, Map<String, String> formulaOldString2UUID, List<IFormula> finalFormulas) {
        if (CollectionUtils.isNotEmpty(finalFormulas)) {
            for (IFormula f : finalFormulas) {
                IFormula formula1 = ((List)parsePair.p2).stream().filter(ifn -> f.toString().equals(ifn.toString())).findFirst().orElse(null);
                if (formula1 == null) continue;
                formula = formula.replace(f.toString(), "<" + formulaOldString2UUID.get(f.toString()) + "|" + formula1.getUUID() + "/>");
            }
        }
        return formula;
    }

    private static String dealExpandFormula(String abstractFormula, List<String> exprs, Map<String, Object> formulaResultMap, Map<String, Object> resultMap) {
        String[] split = abstractFormula.split("/>");
        block0: for (String expr : exprs) {
            String target = "|" + expr;
            if (!abstractFormula.contains(target)) continue;
            for (String str : split) {
                if (!str.contains(target)) continue;
                int startIndex = str.indexOf("<") + 1;
                String pairFormula = str.substring(startIndex);
                String[] formulas = pairFormula.split("\\|");
                if (formulaResultMap.get(formulas[0]) instanceof Exception) {
                    resultMap.put(expr, "Exception: " + ((Exception)formulaResultMap.get(formulas[0])).getMessage());
                } else {
                    resultMap.put(expr, formulaResultMap.get(formulas[0]));
                }
                abstractFormula = abstractFormula.replace("<" + pairFormula + "/>", formulas[1]);
                continue block0;
            }
        }
        return abstractFormula;
    }

    private static void setResultModelTemplate(List<ChkResultModel> results, ChkFormulaModel ckm, ExpressStatus lstatus, String lFormula) {
        String process = ChkCheckServiceHelper.compareDimByPattern(lFormula, ckm.getLeftformula(), ParamConstant.PATTERN_BP);
        String currency = ChkCheckServiceHelper.compareDimByPattern(lFormula, ckm.getLeftformula(), ParamConstant.PATTERN_C);
        ChkResultModel resultModel = new ChkResultModel(lstatus, ckm.getLformulatemp(), lFormula, ckm.getId());
        resultModel.setCheckEffect(CHKCheckEffectEnum.getCHKCheckEffectByIndex((String)ckm.getChkeffecttype()));
        resultModel.setAllowamount(ckm.getAllowamount());
        resultModel.setProcess(process);
        resultModel.setCurrency(currency);
        resultModel.setCkm(ckm);
        resultModel.setJudge(true);
        results.add(resultModel);
    }

    public static String compareDimByPattern(String newformula, String orginalformula, Pattern pattern) {
        Matcher matcher = pattern.matcher(newformula);
        Matcher matcher1 = pattern.matcher(orginalformula);
        while (matcher.find()) {
            String process = matcher.group().split("\\.")[1].replace("\"", "");
            String process1 = null;
            if (matcher1.find()) {
                process1 = matcher1.group().split("\\.")[1].replace("\"", "");
            }
            if (process.equals(process1)) continue;
            return process;
        }
        return null;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isChinese(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!ChkCheckServiceHelper.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumber(String strName) {
        return NumberUtils.isNumber((String)strName);
    }

    public static String getDimMembEntityNumByDimNum(String dimNum) {
        switch (dimNum.toLowerCase(Locale.ENGLISH)) {
            case "entity": {
                return "bcm_entitymembertree";
            }
            case "account": {
                return "bcm_accountmembertree";
            }
            case "year": {
                return "bcm_fymembertree";
            }
            case "period": {
                return "bcm_periodmembertree";
            }
            case "scenario": {
                return "bcm_scenemembertree";
            }
            case "process": {
                return "bcm_processmembertree";
            }
            case "currency": {
                return "bcm_currencymembertree";
            }
            case "audittrail": {
                return "bcm_audittrialmembertree";
            }
            case "changetype": {
                return "bcm_changetypemembertree";
            }
            case "internalcompany": {
                return "bcm_icmembertree";
            }
            case "multigaap": {
                return "bcm_rulemembertree";
            }
            case "version": {
                return "bcm_eb_versionmembertree";
            }
            case "datatype": {
                return "eb_datetypemembertree";
            }
            case "datasort": {
                return "bcm_datasortmembertree";
            }
            case "mycompany": {
                return "bcm_mycompanymembertree";
            }
            case "metric": {
                return "eb_metricmembertree";
            }
            case "extends": {
                return "bcm_structofextend";
            }
        }
        return "bcm_userdefinedmembertree";
    }

    public static FormulaPoolManager getPoolMng(String formula) {
        CalculateService service = (CalculateService)ThreadCache.get((Object)"getCalculateService-from-cache", () -> {
            ICalContext ctx = ChkCheckServiceHelper.getICalContext();
            CalculateService service1 = new CalculateService(ctx);
            return service1;
        });
        service.clear();
        service.addCalculateExpress(ChkCheckServiceHelper.changePercentToDec(formula));
        return service.getPoolMng();
    }

    public static ICalContext getICalContext() {
        CalContext ctx = new CalContext("CUBTest0314581578804632254464", "01300", "FY2015", "M_M10", "Actual", "CNY");
        ctx.setProperty("BP", "IRpt");
        return ctx;
    }

    public static boolean isSpecialFormula(String formula) {
        boolean isJudge = false;
        FormulaPoolManager poolMng = ChkCheckServiceHelper.getPoolMng(formula);
        if (poolMng.pull("IF") != null || poolMng.pull("AND") != null || poolMng.pull("OR") != null || poolMng.pull("ROUND") != null || poolMng.pull("ABS") != null || poolMng.pull("LEN") != null) {
            isJudge = true;
        }
        return isJudge;
    }

    public static String transferXFromula(String fullformula) {
        List<String> xList = ChkFormulaServiceHelper.getXList(fullformula);
        for (String xFormula : xList) {
            fullformula = Pattern.compile(xFormula, 16).matcher(fullformula.replace(" ", "")).replaceFirst(ChkFormulaServiceHelper.formatXdmExpression(xFormula));
        }
        return fullformula;
    }

    private static String fillTempToFormula(String formulawithtemp, String fullformula) {
        return (String)GlobalCacheServiceHelper.getOrLoadChkCheckCache((String)(formulawithtemp + fullformula), () -> {
            Pair<String, List<IFormula>> pairwithtmp = ChkFormulaServiceHelper.parseFormula(formulawithtemp);
            Pair<String, List<IFormula>> fullformulapair = ChkFormulaServiceHelper.parseFormula(fullformula);
            if (CollectionUtils.isEmpty((Collection)((Collection)pairwithtmp.p2)) || fullformulapair.p1 == null || CollectionUtils.isEmpty((Collection)((Collection)fullformulapair.p2))) {
                return formulawithtemp;
            }
            ArrayList<String> formulas = new ArrayList<String>(((List)pairwithtmp.p2).size());
            for (int i = 0; i < ((List)pairwithtmp.p2).size(); ++i) {
                IFormula tmpf = (IFormula)((List)pairwithtmp.p2).get(i);
                IFormula fullf = (IFormula)((List)fullformulapair.p2).get(i);
                if (ChkFormulaServiceHelper.isXdmFormula(fullf.toString())) {
                    formulas.add(fullf.toString());
                    continue;
                }
                for (int j = 0; j < tmpf.getParamList().size(); ++j) {
                    ParamItem pi = (ParamItem)tmpf.getParamList().get(j);
                    String sn = pi.toString().split("\\.")[0];
                    if (!"@TMP".equals(sn)) continue;
                    fullf.getParamList().add(0, pi);
                    break;
                }
                formulas.add(ChkCheckServiceHelper.fixMarkToFormula(fullf));
            }
            return ChkCheckServiceHelper.fixFormulaIntoLetter(formulas, (String)fullformulapair.p1);
        });
    }

    private static void fillTempToFormula(List<String> vList, List<String> vListWithTemp) {
        if (vList.size() == vListWithTemp.size()) {
            for (int i = 0; i < vList.size(); ++i) {
                String fullFormulaWithTemp = ChkCheckServiceHelper.fillTempToFormula(vListWithTemp.get(i), vList.get(i));
                vList.set(i, fullFormulaWithTemp);
            }
        }
    }

    public static List<QFilter> getComFilter(ICalContext ctx) {
        Long orgparent;
        ArrayList<QFilter> fl = new ArrayList<QFilter>();
        fl.add(new QFilter("org", "in", ctx.getProperty("orgIds")));
        if (Objects.nonNull(ctx.getProperty("processIds"))) {
            fl.add(new QFilter("process", "in", ctx.getProperty("processIds")));
        }
        fl.add(new QFilter("period", "=", (Object)ctx.getPeriodId()));
        fl.add(new QFilter("year", "=", (Object)ctx.getYearId()));
        fl.add(new QFilter("currency", "=", (Object)ctx.getCurrencyId()));
        fl.add(new QFilter("model", "=", (Object)ctx.getModelId()));
        fl.add(new QFilter("scenario", "=", (Object)ctx.getScenarioId()));
        Long phaseID = (Long)ctx.getProperty("phase");
        if (phaseID != null) {
            fl.add(new QFilter("phase", "=", (Object)phaseID));
        }
        if ((orgparent = (Long)ctx.getProperty("orgparent")) != null) {
            fl.add(new QFilter("orgparent", "in", Arrays.asList(orgparent, 0L)));
        }
        fl.add(new QFilter("cslscheme", "in", Arrays.asList((Long)ctx.getProperty("cslSchemeId"), 0L)));
        return fl;
    }

    public static Map<String, List<DynamicObject>> getOldResultMap(List<QFilter> fl) {
        DynamicObject[] objs;
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"bcm_chkreport", (String)"id,chkresulttype,calcresultexpr,note,leftresult,rightresult,chkformula,fulllformula,fullrformula,template,modifier,modifytime,chineseformula,process,phase,currency,forcedpasser,forcedpasstime,orgparent,resultmap,cslscheme", (QFilter[])fl.toArray(new QFilter[0]))) {
            String chkformula = obj.getString("chkformula.id");
            if (StringUtils.isEmpty((String)chkformula)) continue;
            String key = ChkCheckServiceHelper.buildKey(obj);
            map.computeIfAbsent(key, k -> new ArrayList()).add(obj);
        }
        return map;
    }

    public static DynamicObject initReportByCtx(ICalContext ctx) {
        DynamicObject rep = BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkreport");
        rep.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        rep.set("model", (Object)ctx.getModelId());
        rep.set("year", (Object)ctx.getYearId());
        rep.set("period", (Object)ctx.getPeriodId());
        rep.set("scenario", (Object)ctx.getScenarioId());
        rep.set("currency", (Object)ctx.getCurrencyId());
        rep.set("org", (Object)ctx.getOrgId());
        if (ctx.getProperty("phase") != null) {
            rep.set("phase", ctx.getProperty("phase"));
        }
        return rep;
    }

    public static void fillProperty2CTX4ChkCheckSetting(ICalContext ctx) {
        long modelId = MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
        IDNumberTreeNode entityMember = MemberReader.findEntityMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getOrg());
        ctx.setProperty("modelId", modelId);
        ChkCheckServiceHelper.setOrg(entityMember, ctx);
    }

    public static void fillCommonProperty2CTX(ICalContext ctx) {
        long modelId = MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
        long yearId = MemberReader.findFyMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getYear()).getId();
        long periodId = MemberReader.findPeriodMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getPeriod()).getId();
        long scenarioId = MemberReader.findScenaMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getScenario()).getId();
        Set<Long> templateId = Collections.singleton(ChkCheckServiceHelper.getTemplateIdByNumberForChk(modelId, (String)ctx.getProperty("temp")));
        IDNumberTreeNode entityMember = MemberReader.findEntityMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getOrg());
        ctx.setProperty("modelId", modelId);
        ctx.setProperty("yearId", yearId);
        ctx.setProperty("periodId", periodId);
        ctx.setProperty("scenarioId", scenarioId);
        ChkCheckServiceHelper.setOrg(entityMember, ctx);
        ctx.setProperty("tmpIds", templateId);
        ctx.setProperty("hasfill", true);
    }

    public static void setOrg(IDNumberTreeNode entity, ICalContext ctx) {
        HashSet<Long> storageAndShareNodeIds = new HashSet<Long>(16);
        storageAndShareNodeIds.add(entity.getId());
        entity.getShareNodes().forEach(node -> storageAndShareNodeIds.add(node.getId()));
        ctx.setProperty("orgIds", storageAndShareNodeIds);
        ctx.setProperty("orgId", entity.getId());
        IDNumberTreeNode parent = entity.getParent();
        if (ctx.getProperty("originalOrgId") != null && !ctx.getProperty("originalOrgId").equals(entity.getId())) {
            IDNumberTreeNode entityMemberById = MemberReader.findEntityMemberById((String)ctx.getCubeNumber(), (Long)((Long)ctx.getProperty("originalOrgId")));
            parent = entityMemberById.getParent();
        }
        if (parent != null) {
            if (ctx.getProperty("orgparent") == null) {
                ctx.setProperty("orgparent", parent.getId());
            }
            if (ctx.getProperty("orgpnumber") == null) {
                ctx.setProperty("orgpnumber", parent.getNumber());
            }
        }
    }

    public static void fillProcessIdsByProcessList(ICalContext ctx) {
        if (CollectionUtils.isNotEmpty(ctx.getProcessList())) {
            Map<String, Long> bp_Number2Id = ctx.getBpNumber2Id();
            ctx.setProperty("processIds", ctx.getProcessList().stream().map(bp_Number2Id::get).collect(Collectors.toList()));
        } else {
            LOG.warn(String.format("No ProcessList in CTX!model[%s]", ctx.getCubeNumber()));
        }
    }

    public static void transferNoneSpecificCurrency(ICalContext ctx, String ecCurrency, String pcCurrency) {
        if ("EC".equals(ctx.getCurrency())) {
            ctx.setProperty("currency", ecCurrency);
        }
        if ("PC".equals(ctx.getCurrency())) {
            ctx.setProperty("currency", ChkCheckServiceHelper.getPcCurrency(ecCurrency, pcCurrency));
        }
        if ("DC".equals(ctx.getCurrency())) {
            ctx.setProperty("currency", ParamConstant.pcProList.contains(ctx.getProcess()) ? ChkCheckServiceHelper.getPcCurrency(ecCurrency, pcCurrency) : ecCurrency);
        }
    }

    private static String getPcCurrency(String ecCurrency, String pcCurrency) {
        return StringUtils.isEmpty((String)pcCurrency) ? ecCurrency : pcCurrency;
    }

    public static boolean isEcCurrency(ICalContext ctx, String ecCurrency) {
        return ctx.getCurrency().equals(ecCurrency) || "EC".equals(ctx.getCurrency());
    }

    public static boolean isParentCurrency(ICalContext ctx, String pcCurrency) {
        if (StringUtils.isEmpty((String)pcCurrency)) {
            return true;
        }
        return ctx.getCurrency().equals(pcCurrency) || "PC".equals(ctx.getCurrency());
    }

    public static String getEcCurrency(ICalContext ctx, long modelid) {
        QFilter qf = new QFilter("id", "=", (Object)ChkCheckServiceHelper.getRealOrgId(ctx));
        QFilter modelQf = new QFilter("model", "=", (Object)modelid);
        DynamicObject orgCurrency = OrgCurrencyServiceHelper.getOrgCurrency(new QFilter[]{qf, modelQf}, modelid, ctx.getYear(), ctx.getPeriod());
        return orgCurrency.getString("currency.number");
    }

    public static String[] getEcCcyAndPcCcy(ICalContext ctx, long modelid) {
        String modelNum = MemberReader.findModelNumberById((Object)modelid);
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((String)modelNum, (Long)ChkCheckServiceHelper.getRealOrgId(ctx));
        return new String[]{entityNode.getCurrency(), entityNode.getParent().getCurrency() == null ? entityNode.getCurrency() : entityNode.getParent().getCurrency()};
    }

    private static List<String> cartesianDim(Map<String, List<String>> numbermap) {
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<String, List<String>>> entrySet = numbermap.entrySet();
        ArrayList<String[]> ls = new ArrayList<String[]>(entrySet.size());
        for (Map.Entry<String, List<String>> entry : entrySet) {
            ArrayList<String> l = new ArrayList<String>(entry.getValue().size());
            for (String s : entry.getValue()) {
                l.add(entry.getKey() + "." + s);
            }
            ls.add(l.toArray(new String[0]));
        }
        List ll = CartesianUtil.cartesianProduct((Object[][])((Object[][])ls.toArray((T[])new String[ls.size()][])));
        ll.forEach(e -> {
            StringBuilder bf = new StringBuilder();
            bf.append(e);
            bf.deleteCharAt(0);
            bf.deleteCharAt(bf.length() - 1);
            list.add(bf.toString());
        });
        return list;
    }

    public static void removeFixDimInMap(String lFormula, String rFormula, Map<String, List<String>> numbermap) {
        List<String> leftList = ChkFormulaServiceHelper.getVList(lFormula);
        HashMap<String, Boolean> needRemove = new HashMap<String, Boolean>();
        leftList.forEach(formula -> {
            Pair<String, List<IFormula>> lPair = ChkFormulaServiceHelper.parseFormula(formula);
            ChkCheckServiceHelper.checkIfRemove(numbermap, lPair, needRemove);
        });
        List<String> leftXList = ChkFormulaServiceHelper.getXList(lFormula);
        ChkCheckServiceHelper.checkIfRemoveXFormula(numbermap, leftXList, needRemove);
        if (StringUtils.isNotEmpty((String)rFormula)) {
            List<String> rightList = ChkFormulaServiceHelper.getVList(rFormula);
            rightList.forEach(formula -> {
                Pair<String, List<IFormula>> rPair = ChkFormulaServiceHelper.parseFormula(formula);
                ChkCheckServiceHelper.checkIfRemove(numbermap, rPair, needRemove);
            });
            List<String> rightXList = ChkFormulaServiceHelper.getXList(rFormula);
            ChkCheckServiceHelper.checkIfRemoveXFormula(numbermap, rightXList, needRemove);
        }
        needRemove.forEach((dim, remove) -> {
            if (Boolean.TRUE.equals(remove)) {
                numbermap.remove(dim);
            }
        });
    }

    private static void checkIfRemove(Map<String, List<String>> numbermap, Pair<String, List<IFormula>> pair, Map<String, Boolean> needRemove) {
        if (pair.p2 == null) {
            return;
        }
        for (IFormula f : (List)pair.p2) {
            Set formulaDims = f.getParamList().stream().map(pi -> pi.toString().split("\\.")[0]).collect(Collectors.toSet());
            numbermap.forEach((dim, value) -> {
                if (formulaDims.contains(dim) && needRemove.get(dim) == null) {
                    needRemove.put((String)dim, true);
                }
                if (!formulaDims.contains(dim)) {
                    needRemove.put((String)dim, false);
                }
            });
        }
    }

    private static void checkIfRemoveXFormula(Map<String, List<String>> numbermap, List<String> xFormulas, Map<String, Boolean> needRemove) {
        for (String xFormula : xFormulas) {
            CommonFormulaModel commonFormulaModel = ChkFormulaServiceHelper.parseXdmFormulaModel(xFormula);
            numbermap.forEach((dim, value) -> {
                if (DimTypesEnum.AUDITTRIAL.getShortNumber().equals(dim) || DimTypesEnum.PROCESS.getShortNumber().equals(dim)) {
                    boolean isEmpty = StringUtils.isEmpty((String)commonFormulaModel.getDim(DimTypesEnum.getDimNumber((String)dim, (long)0L)));
                    if (needRemove.get(dim) == null) {
                        needRemove.put((String)dim, !isEmpty);
                    } else if (isEmpty) {
                        needRemove.put((String)dim, false);
                    }
                }
            });
        }
    }

    private static String fixMarkToFormula(IFormula f) {
        StringBuilder formula = new StringBuilder("V(");
        for (ParamItem p : f.getParamList()) {
            formula.append('\"');
            formula.append(p);
            formula.append('\"');
            formula.append(',');
        }
        formula.deleteCharAt(formula.length() - 1);
        formula.append(')');
        return formula.toString();
    }

    public static List<String> cartesianFormulaInChkCheck(List<String> dimcarte, String formula, ICalContext ctx) {
        ArrayList<String> list = new ArrayList<String>(dimcarte.size());
        try {
            for (String s : dimcarte) {
                String[] ss;
                Expression exp = ExcelFormulaPaserHelper.parse((String)formula);
                for (String str : ss = s.split(",")) {
                    ExcelFormulaPaserHelper.walk((Expression)exp, expr -> {
                        if (expr instanceof FunctionExpr && ((FunctionExpr)expr).getFuncionName().equalsIgnoreCase("V")) {
                            StringExpr s1;
                            String[] dim;
                            FunctionExpr fun = (FunctionExpr)expr;
                            Set<Object> dims = ChkCheckServiceHelper.getDims(fun);
                            if (!ChkCheckServiceHelper.containDim(dims, (dim = (s1 = new StringExpr(str.trim())).getValue().split("\\."))[0])) {
                                fun.getParameters().add(s1);
                            }
                            if (ChkCheckServiceHelper.needFillCurrency(fun) && StringUtils.isEmpty((String)ctx.getCurrency())) {
                                String processNumber = fun.getParameters().stream().filter(parameter -> parameter instanceof StringExpr).map(parameter -> ((StringExpr)parameter).getValue().split("\\.")).filter(split -> DimTypesEnum.PROCESS.getShortNumber().equals(split[0].trim())).findFirst().map(split -> split[1]).orElse("ERpt");
                                ChkCheckServiceHelper.fillCurrency2Formula(ctx, fun, processNumber);
                            }
                        }
                        if (expr instanceof FunctionExpr && ((FunctionExpr)expr).getFuncionName().equalsIgnoreCase("X")) {
                            String[] split2 = str.trim().split("\\.", 2);
                            if (DimTypesEnum.PROCESS.getShortNumber().equalsIgnoreCase(split2[0]) || DimTypesEnum.AUDITTRIAL.getShortNumber().equalsIgnoreCase(split2[0])) {
                                ((FunctionExpr)expr).getParameters().add(new StringExpr(str.trim()));
                            }
                        }
                    });
                }
                list.add(exp.toString().replace(" ", ""));
            }
        }
        catch (Exception e) {
            LOG.error("cartesianFormulaInChkCheck error!", (Throwable)e);
        }
        return list;
    }

    private static boolean needFillCurrency(FunctionExpr fun) {
        List dimNums = fun.getParameters().stream().filter(parameter -> parameter instanceof StringExpr).map(parameter -> ((StringExpr)parameter).getValue().split("\\.")[0]).collect(Collectors.toList());
        return dimNums.contains(DimTypesEnum.PROCESS.getShortNumber()) && !dimNums.contains(DimTypesEnum.CURRENCY.getShortNumber());
    }

    private static void fillCurrency2Formula(ICalContext ctx, FunctionExpr fun, String dim) {
        if (ParamConstant.ERptProcess.contains(dim)) {
            fun.getParameters().add(new StringExpr(DimTypesEnum.CURRENCY.getShortNumber() + "." + ctx.getProperty("ecCurrency")));
        } else {
            fun.getParameters().add(new StringExpr(DimTypesEnum.CURRENCY.getShortNumber() + "." + (StringUtils.isEmpty((String)((String)ctx.getProperty("pcCurrency"))) ? ctx.getProperty("ecCurrency") : ctx.getProperty("pcCurrency"))));
        }
    }

    private static boolean containDim(Set<Object> dims, String dim) {
        return dims.contains(dim);
    }

    private static Set<Object> getDims(FunctionExpr fun) {
        Set<Object> dims = fun.getParameters().stream().map(p -> {
            if (p instanceof StringExpr) {
                StringExpr param = (StringExpr)p;
                return param.getValue().split("\\.")[0].trim();
            }
            return p;
        }).collect(Collectors.toSet());
        return dims;
    }

    public static List<String> fixDefaultDim(ICalContext ctx, List<String> oldformulas, String curFy, String curPer) {
        ArrayList<String> list = new ArrayList<String>(oldformulas.size());
        HashSet<String> distinctFormulas = new HashSet<String>();
        for (String formula : oldformulas) {
            Pair<String, List<IFormula>> pair = ChkFormulaServiceHelper.parseFormula(formula);
            if (pair.p2 == null) continue;
            ArrayList<String> formulas = new ArrayList<String>(((List)pair.p2).size());
            for (IFormula f : (List)pair.p2) {
                String yn = "";
                String yp = "";
                String oldbp = null;
                String scene = ctx.getScenario();
                boolean filledCurrency = false;
                Iterator iterator = f.getParamList().iterator();
                while (iterator.hasNext()) {
                    ParamItem pi = (ParamItem)iterator.next();
                    String[] splitArr = pi.toString().split("\\.", 2);
                    String sn = splitArr[0];
                    String sm = splitArr[1];
                    if (DimTypesEnum.CURRENCY.getShortNumber().equalsIgnoreCase(sn)) {
                        filledCurrency = true;
                    }
                    if (ctx.getProperty("isCvtDiff") != null && DimTypesEnum.PROCESS.getShortNumber().equalsIgnoreCase(sn)) {
                        oldbp = sm;
                        iterator.remove();
                    }
                    if (curFy != null && DimTypesEnum.YEAR.getShortNumber().equalsIgnoreCase(sn)) {
                        yn = sm;
                        iterator.remove();
                    }
                    if (curPer != null && DimTypesEnum.PERIOD.getShortNumber().equalsIgnoreCase(sn)) {
                        yp = sm;
                        iterator.remove();
                    }
                    if (!DimTypesEnum.SCENARIO.getShortNumber().equalsIgnoreCase(sn)) continue;
                    scene = sm;
                }
                if (ctx.getProperty("isCvtDiff") != null) {
                    String cvtDiffProcess = Objects.equals(ctx.getProcess(), "Rpt") ? "IRpt" : ctx.getProcess();
                    f.getParamList().add(new ParamItem(DimTypesEnum.PROCESS.getShortNumber() + "." + (oldbp == null ? cvtDiffProcess : oldbp)));
                }
                if (StringUtils.isNotEmpty((String)yn)) {
                    boolean isLastYear = false;
                    long modeId = ctx.getModelId() != null ? ctx.getModelId() : MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
                    String exchangePeriodForLastYear = ConfigServiceHelper.getExchangePeriodForLastYear(modeId, scene, curPer);
                    if ("CurrentYear".equals(yn)) {
                        yn = curFy;
                    } else if ("LastYear".equals(yn)) {
                        Optional year = PeriodUtils.getLastYear((String)ctx.getCubeNumber(), (String)curFy);
                        isLastYear = true;
                        if (year.isPresent()) {
                            yn = (String)year.get();
                        } else {
                            ctx.setProperty("return", true);
                            return null;
                        }
                    }
                    if (StringUtils.isNotEmpty((String)yp)) {
                        if ("CurrentPeriod".equals(yp)) {
                            yp = curPer;
                        } else if ("LastPeriod".equals(yp)) {
                            String[] yearandperiod = PeriodUtils.getLastPeriodIncludeYear((String)ctx.getCubeNumber(), (String)yn, (String)curPer, (boolean)true);
                            if (yearandperiod[0] == null) {
                                ctx.setProperty("return", true);
                                return null;
                            }
                            yn = yearandperiod[0];
                            yp = yearandperiod[1];
                        }
                        f.getParamList().add(new ParamItem(DimTypesEnum.PERIOD.getShortNumber() + "." + yp));
                    } else if (isLastYear) {
                        yp = exchangePeriodForLastYear;
                        f.getParamList().add(new ParamItem(DimTypesEnum.PERIOD.getShortNumber() + "." + yp));
                    }
                    f.getParamList().add(new ParamItem(DimTypesEnum.YEAR.getShortNumber() + "." + yn));
                } else if (StringUtils.isNotEmpty((String)yp)) {
                    if ("CurrentPeriod".equals(yp)) {
                        yp = curPer;
                    } else if ("LastPeriod".equals(yp)) {
                        String[] yearandperiod = PeriodUtils.getLastPeriodIncludeYear((String)ctx.getCubeNumber(), (String)curFy, (String)curPer, (boolean)true);
                        if (yearandperiod[0] == null) {
                            ctx.setProperty("return", true);
                            return null;
                        }
                        yn = yearandperiod[0];
                        yp = yearandperiod[1];
                        f.getParamList().add(new ParamItem(DimTypesEnum.YEAR.getShortNumber() + "." + yn));
                    }
                    f.getParamList().add(new ParamItem(DimTypesEnum.PERIOD.getShortNumber() + "." + yp));
                }
                if (StringUtils.isEmpty((String)ctx.getCurrency()) && !filledCurrency) {
                    int reportProcessMode = (Integer)ctx.getProperty("report_process_mode");
                    if (reportProcessMode == ChkCheckReportModeEnum.ONLY_ERPT.getMode()) {
                        f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + ctx.getProperty("ecCurrency")));
                    }
                    if (reportProcessMode == ChkCheckReportModeEnum.ONLY_NON_ERPT.getMode()) {
                        f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + (StringUtils.isEmpty((String)((String)ctx.getProperty("pcCurrency"))) ? ctx.getProperty("ecCurrency") : ctx.getProperty("pcCurrency"))));
                    }
                    if (reportProcessMode == ChkCheckReportModeEnum.MIX.getMode()) {
                        if (ctx.getProperty("fillCurrency") != null && "ec".equals(ctx.getProperty("fillCurrency"))) {
                            f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + ctx.getProperty("ecCurrency")));
                        } else if (ctx.getProperty("fillCurrency") != null && "pc".equals(ctx.getProperty("fillCurrency"))) {
                            f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + (StringUtils.isEmpty((String)((String)ctx.getProperty("pcCurrency"))) ? ctx.getProperty("ecCurrency") : ctx.getProperty("pcCurrency"))));
                        } else if (distinctFormulas.add(formula)) {
                            f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + ctx.getProperty("ecCurrency")));
                        } else {
                            f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + (StringUtils.isEmpty((String)((String)ctx.getProperty("pcCurrency"))) ? ctx.getProperty("ecCurrency") : ctx.getProperty("pcCurrency"))));
                        }
                    }
                }
                Map memberShortNum2Dseq = MemberReader.getMemberShortNum2Dseq((String)ctx.getCubeNumber());
                f.getParamList().sort(Comparator.comparing(ChkCheckServiceHelper::extractDimShortNum, Comparator.comparing(p -> memberShortNum2Dseq.getOrDefault(p, 0))));
                formulas.add(ChkCheckServiceHelper.fixMarkToFormula(f));
            }
            list.add(ChkCheckServiceHelper.fixFormulaIntoLetter(formulas, (String)pair.p1));
        }
        return list;
    }

    private static String extractDimShortNum(ParamItem p) {
        return p.toString().split("\\.")[0];
    }

    public static String fixFormulaIntoLetter(List<String> formulas, String letter) {
        StringBuilder sb = new StringBuilder();
        int flag = 0;
        for (int i = 0; i < letter.length(); ++i) {
            if (letter.charAt(i) >= 'A' && letter.charAt(i) <= 'Z') {
                if (!ExpressionServiceHelper.checkFactorComplete(i, letter)) continue;
                String f = formulas.get(flag);
                sb.append(f);
                ++flag;
                continue;
            }
            sb.append(letter.charAt(i));
        }
        return sb.toString();
    }

    public static Map<String, List<String>> getMapDim(ChkFormulaModel ckm, ICalContext ctx) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>(16);
        List<MemberRangeEntry> mres = ckm.getMapdim();
        Map memmap = (Map)ctx.getProperty("filter");
        boolean hasNoFilledAT = (Boolean)GlobalCacheServiceHelper.getOrLoadChkCheckCache((String)String.format("%s|%s", ckm.getLeftformula(), ckm.getRightformula()), () -> ChkCheckServiceHelper.getATContainFlag(ckm));
        Long modelId = ctx.getModelId();
        boolean isExistATDim = MemberReader.isExistAuditTrailDimension((long)modelId);
        if (CollectionUtils.isEmpty(mres)) {
            String auditTrail = null;
            if (memmap != null) {
                auditTrail = (String)memmap.get(DimTypesEnum.AUDITTRIAL.getNumber());
            }
            if (hasNoFilledAT && isExistATDim) {
                map.put(DimTypesEnum.AUDITTRIAL.getShortNumber(), StringUtils.isEmpty((String)auditTrail) ? Lists.newArrayList((Object[])new String[]{"ATTotal"}) : Lists.newArrayList((Object[])new String[]{auditTrail}));
            }
        }
        if (memmap != null) {
            String reportBp = (String)memmap.get(DimTypesEnum.PROCESS.getNumber());
            if (ParamConstant.ERptProcess.contains(reportBp)) {
                map.put(DimTypesEnum.PROCESS.getShortNumber(), ParamConstant.ERptProcess);
            } else if (ParamConstant.RptProcess.contains(reportBp)) {
                map.put(DimTypesEnum.PROCESS.getShortNumber(), ParamConstant.RptProcess);
            } else {
                map.put(DimTypesEnum.PROCESS.getShortNumber(), Lists.newArrayList((Object[])new String[]{reportBp}));
            }
        } else if (CollectionUtils.isNotEmpty(ctx.getProcessList())) {
            map.put(DimTypesEnum.PROCESS.getShortNumber(), ctx.getProcessList());
        } else {
            map.put(DimTypesEnum.PROCESS.getShortNumber(), Collections.singletonList("ERpt"));
        }
        Map<String, String> dimShortNumberByNumber = ChkCheckServiceHelper.getDimShortNumberByNumber(ckm.getModelId());
        for (MemberRangeEntry mre : mres) {
            HashSet<String> allNumbers = new HashSet<String>();
            if (map.containsKey(mre.getDimension().getNumber())) continue;
            ChkCheckServiceHelper.fillAllNumbers(ckm, mre, allNumbers);
            if (memmap != null) {
                if (allNumbers.isEmpty()) {
                    return null;
                }
            } else if (CHKReportType.CWPREPORT.getSign().equals(ctx.getProperty("reporttype")) && DimTypesEnum.AUDITTRIAL.getNumber().equals(mre.getDimension().getNumber())) {
                allNumbers.clear();
                allNumbers.add("None");
            }
            map.put(dimShortNumberByNumber.get(mre.getDimension().getNumber()), Lists.newArrayList(allNumbers));
        }
        if (!map.containsKey(DimTypesEnum.AUDITTRIAL.getShortNumber()) && isExistATDim) {
            map.put(DimTypesEnum.AUDITTRIAL.getShortNumber(), Lists.newArrayList((Object[])new String[]{"ATTotal"}));
        }
        Map reportProcess = (Map)ctx.getProperty("report_process");
        map.put(DimTypesEnum.PROCESS.getShortNumber(), (List<String>)reportProcess.get(ckm.getId()));
        List auditList = (List)map.get(DimTypesEnum.AUDITTRIAL.getShortNumber());
        if (CollectionUtils.isNotEmpty((Collection)auditList)) {
            ctx.setProperty("audittrail", auditList.get(0));
        }
        ChkCheckServiceHelper.removeFixDimInMap(ckm.getLeftformula(), ckm.getRightformula(), map);
        return map;
    }

    private static void fillAllNumbers(ChkFormulaModel ckm, MemberRangeEntry mre, Set<String> allnumbers) {
        boolean pureXdmFormula = ckm.isPureXdmFormula();
        for (ChkMember cm : mre.getAllMembProperties()) {
            if (pureXdmFormula && ChkMemberRangeLimitTypeEnum.COMMON.getLimitType().equals(cm.getLimittype()) && !"AuditTrail".equals(cm.getDimension().getNumber())) {
                allnumbers.add("None");
                continue;
            }
            Set<String> numbers = cm.getCustomProperty() == null ? QueryMemberDetailsHelper.queryMemberNumbersByRange(cm.getDimension().getMemberEntityNumber(), cm.getId(), cm.getNumber(), cm.getScope(), String.valueOf(ckm.getModelId()), DetailTypeEnum.OTHERS) : QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number(cm.getDimension().getMemberEntityNumber(), cm.getId(), cm.getNumber(), cm.getScope(), String.valueOf(ckm.getModelId()), DetailTypeEnum.OTHERS);
            allnumbers.addAll(numbers);
        }
    }

    private static boolean getATContainFlag(ChkFormulaModel ckm) {
        Pair<String, List<IFormula>> pair = ChkFormulaServiceHelper.parseFormula(ckm.getLeftformula());
        boolean hasNoFilledAT = ChkCheckServiceHelper.hasNoFilledAT(pair, false);
        if (hasNoFilledAT) {
            return true;
        }
        pair = ChkFormulaServiceHelper.parseFormula(ckm.getRightformula());
        return ChkCheckServiceHelper.hasNoFilledAT(pair, false);
    }

    private static boolean hasNoFilledAT(Pair<String, List<IFormula>> pair, boolean hasNoFilledAT) {
        if (pair.p2 == null) {
            return false;
        }
        block0: for (IFormula f : (List)pair.p2) {
            for (int i = 0; i < f.getParamList().size(); ++i) {
                String[] sn2n;
                CommonFormulaModel commonFormulaModel;
                ParamItem pi = (ParamItem)f.getParamList().get(i);
                if (ChkFormulaServiceHelper.isXdmFormula(f.toString()) ? StringUtils.isNotEmpty((String)(commonFormulaModel = ChkFormulaServiceHelper.parseXdmFormulaModel(f.toString())).getDim(DimTypesEnum.AUDITTRIAL.getNumber())) : (sn2n = pi.toString().split("\\."))[0].equals(DimTypesEnum.AUDITTRIAL.getShortNumber())) continue block0;
            }
            hasNoFilledAT = true;
        }
        return hasNoFilledAT;
    }

    private static Map<String, String> getDimShortNumberByNumber(long modelId) {
        Map dimensionShortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelId));
        HashMap<String, String> dimensionNumber2ShortNumberMap = new HashMap<String, String>();
        dimensionShortNumber2NumberMap.forEach((k, v) -> dimensionNumber2ShortNumberMap.put((String)v, (String)k));
        return dimensionNumber2ShortNumberMap;
    }

    public static List<DynamicObject> doFilter(ICalContext ctx, DynamicObject[] docs) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        if (docs.length < 1) {
            return list;
        }
        long modelId = MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
        Map<String, Map<Long, DynamicObject>> memberMap = ChkCheckServiceHelper.getMemberData(docs);
        List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(modelId);
        for (DynamicObject obj : docs) {
            ChkFormulaModel ckm = new ChkFormulaModel();
            ckm.loadDynaObj2ModelEx(obj, memberMap);
            if (!ChkCheckServiceHelper.isInnerCslscheme(ckm, (Long)ctx.getProperty("cslSchemeId")) || !ChkCheckServiceHelper.isCtxInnerRange(ctx, ckm) || !ConvertDifferenceHandle.isApply(ctx.getYearId(), ctx.getPeriodId(), ckm.getEffectivePeriod(), yearIdsList)) continue;
            list.add(obj);
        }
        return list;
    }

    public static List<ChkFormulaModel> doFilter(ICalContext ctx, List<ChkFormulaModel> ckms) {
        ArrayList<ChkFormulaModel> list = new ArrayList<ChkFormulaModel>(10);
        if (ckms.isEmpty()) {
            return list;
        }
        long modelId = MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
        List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(modelId);
        for (ChkFormulaModel ckm : ckms) {
            if (!ChkCheckServiceHelper.isInnerCslscheme(ckm, (Long)ctx.getProperty("cslSchemeId")) || !ChkCheckServiceHelper.isCtxInnerRange(ctx, ckm) || !ConvertDifferenceHandle.isApply(ctx.getYearId(), ctx.getPeriodId(), ckm.getEffectivePeriod(), yearIdsList)) continue;
            list.add(ckm);
        }
        return list;
    }

    private static List<DynamicObject> doFilterExcludeProcess(ICalContext ctx, DynamicObject[] docs) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        if (docs.length < 1) {
            return list;
        }
        long modelId = MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
        Map<String, Map<Long, DynamicObject>> memberMap = ChkCheckServiceHelper.getMemberData(docs);
        List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(modelId);
        for (DynamicObject obj : docs) {
            ChkFormulaModel ckm = new ChkFormulaModel();
            ckm.loadDynaObj2ModelEx(obj, memberMap);
            if (!ChkCheckServiceHelper.isInnerCslscheme(ckm, (Long)ctx.getProperty("cslSchemeId")) || !ChkCheckServiceHelper.isCtxInnerRangeExcludeProcess(ctx, ckm) || !ConvertDifferenceHandle.isApply(ctx.getYearId(), ctx.getPeriodId(), ckm.getEffectivePeriod(), yearIdsList)) continue;
            list.add(obj);
        }
        return list;
    }

    public static boolean isCtxInnerRange(ICalContext ctx, ChkFormulaModel ckm) {
        RangeStatus status = new RangeStatus();
        Set orgids = (Set)ctx.getProperty("orgIds");
        Iterator<Object> ot = orgids.iterator();
        ChkCheckServiceHelper.isInnerRange(ctx, ckm, status, ot);
        ChkCheckServiceHelper.removeProcess(ctx, ckm, status);
        if (StringUtils.isNotEmpty((String)ctx.getScenario())) {
            ChkCheckServiceHelper.isInnerRange(ctx, status, "bcm_scenemembertree", ckm, ctx.getScenarioId());
        }
        return status.isInner;
    }

    private static void removeProcess(ICalContext ctx, ChkFormulaModel ckm, RangeStatus status) {
        List processIds = (List)ctx.getProperty("processIds");
        Map<String, Long> bp_Number2Id = ctx.getBpNumber2Id();
        if (CollectionUtils.isEmpty((Collection)processIds)) {
            Map formulaId2Process = (Map)ctx.getProperty("report_process");
            if (formulaId2Process != null && formulaId2Process.containsKey(ckm.getId()) && bp_Number2Id != null) {
                List formulaProcessNumbers = (List)formulaId2Process.get(ckm.getId());
                List<Long> formulaProcessIds = formulaProcessNumbers.stream().map(bp_Number2Id::get).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(formulaProcessIds)) {
                    ChkCheckServiceHelper.removeNotInnerProcessIds(ckm, formulaProcessIds, bp_Number2Id);
                    ChkCheckServiceHelper.removeNotInnerProcessNums(bp_Number2Id, formulaProcessNumbers, formulaProcessIds, status);
                }
            }
        } else {
            ChkCheckServiceHelper.removeProcessInProcessList(ctx, ckm, status, processIds, bp_Number2Id);
        }
    }

    private static void removeProcessInProcessList(ICalContext ctx, ChkFormulaModel ckm, RangeStatus status, List<Long> processIds, Map<String, Long> bp_Number2Id) {
        ArrayList<Long> allProcessIds = new ArrayList<Long>(processIds);
        ArrayList<String> processList = new ArrayList<String>(ctx.getProcessList());
        ChkCheckServiceHelper.removeNotInnerProcessIds(ckm, allProcessIds, bp_Number2Id);
        ChkCheckServiceHelper.removeNotInnerProcessNums(bp_Number2Id, processList, allProcessIds, status);
        Map formulaId2Process = (Map)ctx.getProperty("report_process");
        formulaId2Process.put(ckm.getId(), processList);
    }

    public static boolean isCtxInnerRangeExcludeProcess(ICalContext ctx, ChkFormulaModel ckm) {
        RangeStatus status = new RangeStatus();
        Set orgids = (Set)ctx.getProperty("orgIds");
        Iterator<Object> ot = orgids.iterator();
        ChkCheckServiceHelper.isInnerRange(ctx, ckm, status, ot);
        Optional<MemberRangeEntry> processRange = ckm.getScope().stream().filter(e -> e.getDimension().getMemberEntityNumber().equals("bcm_processmembertree")).findFirst();
        Map formulaId2Process = (Map)ctx.getProperty("report_process");
        if (!processRange.isPresent()) {
            formulaId2Process.put(ckm.getId(), Collections.singletonList("EIRpt"));
        } else {
            Set currentProcesses;
            Set<String> processes = new HashSet<String>();
            ChkCheckServiceHelper.fillAllNumbers(ckm, processRange.get(), processes);
            if (ChkCheckServiceHelper.notChkRptProcess(ctx)) {
                processes.removeAll(ParamConstant.RptProcess);
            }
            if (StringUtils.isEmpty((String)((String)ctx.getProperty("pcCurrency")))) {
                processes = processes.stream().filter(ParamConstant.ERptProcess::contains).collect(Collectors.toSet());
            }
            if (CollectionUtils.isEmpty((Collection)(currentProcesses = (Set)ctx.getProperty("report_process_list")))) {
                ctx.setProperty("report_process_list", processes);
            } else {
                currentProcesses.addAll(processes);
            }
            formulaId2Process.put(ckm.getId(), new ArrayList<String>(processes));
        }
        if (StringUtils.isNotEmpty((String)ctx.getScenario())) {
            ChkCheckServiceHelper.isInnerRange(ctx, status, "bcm_scenemembertree", ckm, ctx.getScenarioId());
        }
        return status.isInner;
    }

    public static boolean isInnerRange(ICalContext ctx, ChkFormulaModel ckm, RangeStatus status, Iterator<Object> ot) {
        boolean hasIsInner = false;
        while (ot.hasNext()) {
            status.isInner = true;
            ChkCheckServiceHelper.isInnerRange(ctx, status, "bcm_entitymembertree", ckm, ot.next());
            if (status.isUnScope) break;
            if (!status.isInner) continue;
            hasIsInner = true;
        }
        status.isInner = !status.isUnScope && hasIsInner;
        return status.isInner;
    }

    private static boolean isInnerCslscheme(ChkFormulaModel ckm, Long schemeId) {
        DynamicObjectCollection mulcslscheme = ckm.getMulCslscheme();
        if (CollectionUtils.isNotEmpty((Collection)mulcslscheme)) {
            Set mulCslIds = mulcslscheme.stream().map(c -> c.getLong("fbasedataid.id")).collect(Collectors.toSet());
            return mulCslIds.contains(schemeId);
        }
        return true;
    }

    public static void removeRptProcess(ICalContext ctx) {
        List<String> processList = ctx.getProcessList();
        if (CollectionUtils.isEmpty(processList)) {
            return;
        }
        if (ChkCheckServiceHelper.notChkRptProcess(ctx)) {
            List<String> newProcessList = processList.stream().filter(process -> !ParamConstant.RptProcess.contains(process)).collect(Collectors.toList());
            ctx.setProcessList(newProcessList);
        }
    }

    private static void removeNotInnerProcessNums(Map<String, Long> bp_Number2Id, List<String> formulaProcessNumbers, List<Long> formulaProcessIds, RangeStatus status) {
        if (CollectionUtils.isEmpty(formulaProcessIds)) {
            status.isInner = false;
            return;
        }
        formulaProcessNumbers.removeIf(s -> !formulaProcessIds.contains(bp_Number2Id.get(s)));
    }

    private static void removeNotInnerProcessIds(ChkFormulaModel ckm, List<Long> allProcessIds, Map<String, Long> bp_Number2Id) {
        Iterator<Long> iterator = allProcessIds.iterator();
        Optional<MemberRangeEntry> processRange = ckm.getScope().stream().filter(e -> e.getDimension().getMemberEntityNumber().equals("bcm_processmembertree")).findFirst();
        if (!processRange.isPresent()) {
            Long id = bp_Number2Id.get("ERpt");
            if (allProcessIds.contains(id)) {
                allProcessIds.clear();
                allProcessIds.add(id);
            } else {
                allProcessIds.clear();
            }
            return;
        }
        while (iterator.hasNext()) {
            Long processId = iterator.next();
            processRange.ifPresent(memberRangeEntry -> {
                if (memberRangeEntry.getAllMembProperties().stream().noneMatch(p -> {
                    boolean isCustom = p.getCustomProperty() != null;
                    return new MembRangeItem("bcm_processmembertree", (Long)p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), isCustom, (Object)ckm.getModelId()).isMatched(processId);
                })) {
                    iterator.remove();
                }
            });
        }
    }

    public static Map<String, Map<Long, DynamicObject>> getMemberData(DynamicObject[] docs) {
        return (Map)ThreadCache.get((Object)("memberData" + Objects.hashCode(docs)), () -> ChkCheckServiceHelper.getMemberData(docs, "memberrange", "memberid", "id,name,number,longnumber", o -> ChkMemberTypeEnum.PROPERTY.getMemberType().equals(o.getString("membboundtype")) ? "bcm_definedpropertyvalue" : o.getDynamicObject("dimension").getString("membermodel")));
    }

    public static Map<String, Map<Long, DynamicObject>> batchGetMemberDataForLoadDynaObj2Model(Collection<DynamicObject> docs) {
        return ChkCheckServiceHelper.getMemberData(docs.toArray(new DynamicObject[0]));
    }

    public static Map<String, Map<Long, DynamicObject>> getMemberData(DynamicObject[] docs, String memCollectionPropName, String memIdPropName, String queryMemPropNames, Function<DynamicObject, String> groupNameFunc) {
        HashMap<String, Map<Long, DynamicObject>> memberMap = new HashMap<String, Map<Long, DynamicObject>>();
        if (docs == null) {
            return memberMap;
        }
        for (DynamicObject d : docs) {
            String key;
            if (memCollectionPropName != null) {
                for (DynamicObject o : d.getDynamicObjectCollection(memCollectionPropName)) {
                    key = groupNameFunc.apply(o);
                    memberMap.computeIfAbsent(key, k -> new HashMap()).put(o.getLong(memIdPropName), null);
                }
                continue;
            }
            key = groupNameFunc.apply(d);
            memberMap.computeIfAbsent(key, k -> new HashMap()).put(d.getLong(memIdPropName), null);
        }
        for (Map.Entry entry : memberMap.entrySet()) {
            String entityName = (String)entry.getKey();
            Map bcmMap = (Map)entry.getValue();
            DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)queryMemPropNames, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)bcmMap.keySet().toArray())});
            if (cols == null) continue;
            for (DynamicObject obj : cols) {
                bcmMap.put(obj.getLong("id"), obj);
            }
        }
        return memberMap;
    }

    private static void isInnerRange(ICalContext ctx, RangeStatus status, String entity, ChkFormulaModel ckm, Object cpId) {
        if (cpId == null || !status.isInner) {
            return;
        }
        ckm.getScope().stream().filter(e -> e.getDimension().getMemberEntityNumber().equals(entity)).findFirst().ifPresent(memberRangeEntry -> status.isInner = memberRangeEntry.getAllMembProperties().stream().anyMatch(p -> {
            boolean isCustom = p.getCustomProperty() != null;
            MembRangeItem membRangeItem = new MembRangeItem(entity, (Long)p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), isCustom, (Object)ckm.getModelId());
            if ("bcm_entitymembertree".equals(entity) && ctx.getPeriodId() != null) {
                Map orgByMergeStruct = (Map)ThreadCache.get((Object)(membRangeItem.genKey(cpId) + "EffectiveOrgByMergeStruct"), () -> {
                    ArrayList<Long> orgIds = new ArrayList<Long>(10);
                    membRangeItem.matchItems(o -> orgIds.add((Long)o.getId()));
                    FilterOrgStructParam orgParam = new FilterOrgStructParam((long)ctx.getModelId(), (long)ctx.getScenarioId(), ctx.getYearId(), (long)ctx.getPeriodId());
                    return EntityVersioningUtil.filterEffectiveOrgByMergeStruct(orgParam, orgIds);
                });
                return orgByMergeStruct.containsKey(LongUtil.toLong((Object)cpId)) && membRangeItem.isMatched(cpId);
            }
            return membRangeItem.isMatched(cpId);
        }));
        ckm.getUnScope().stream().filter(e -> e.getDimension().getMemberEntityNumber().equals(entity)).findFirst().ifPresent(memberRangeEntry -> {
            boolean isOutbound = memberRangeEntry.getAllMembProperties().stream().anyMatch(p -> {
                boolean isCustom = p.getCustomProperty() != null;
                return new MembRangeItem(entity, (Long)p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), isCustom, (Object)ckm.getModelId()).isMatched(cpId);
            });
            if (isOutbound) {
                status.isUnScope = true;
                status.isInner = false;
            }
        });
    }

    public static List<String> compareDim(ParamList paramList, Map<String, String> dimNumMap) {
        Set paramDims = paramList.stream().map(p -> p.getParam().toString().split("\\.")[0].toLowerCase(Locale.ENGLISH).replace("\"", "")).collect(Collectors.toSet());
        List diff = ListUtils.subtract(new ArrayList<String>(dimNumMap.keySet()), new ArrayList(paramDims));
        return diff.stream().map(dim -> dim.toUpperCase(Locale.ENGLISH)).collect(Collectors.toList());
    }

    public static void fillCslScheme(ICalContext ctx) {
        Long realOrgId = ChkCheckServiceHelper.getRealOrgId(ctx);
        ctx.setProperty("cslSchemeId", MemberReader.findEntityMemberById((String)ctx.getCubeNumber(), (Long)realOrgId).getProperty("cslscheme.id"));
    }

    public static void batchSetExpandFormula2Model(CalculateService service, List<ChkResultModel> chkResultModels) {
        Map<String, String> formulaOldString2UUID = service.getFormulaOldString2UUID();
        for (ChkResultModel resultModel : chkResultModels) {
            ChkCheckServiceHelper.setExpandFormula(resultModel, formulaOldString2UUID, true);
            ChkCheckServiceHelper.setExpandFormula(resultModel, formulaOldString2UUID, false);
        }
    }

    public static long getTemplateIdByNumberForChk(long modelId, String number) {
        if (StringUtils.isEmpty((String)number)) {
            return 0L;
        }
        String key = modelId + "_template_" + number;
        Long id = (Long)ThreadCache.get((Object)key);
        if (id == null) {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("number", "=", (Object)number);
            qFilter.and("versionnumber", "=", (Object)1);
            qFilter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
            DynamicObject dcs = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id", (QFilter[])qFilter.toArray());
            id = dcs != null ? Long.valueOf(dcs.getLong("id")) : Long.valueOf(0L);
            ThreadCache.put((Object)key, (Object)id);
        }
        return id;
    }

    public static String addDimToFormula(String formula, String shortnumber, String dimmem) {
        if (StringUtils.isEmpty((String)formula) || formula.indexOf(63) > -1) {
            return formula;
        }
        List<String> vList = ChkFormulaServiceHelper.getVList(formula);
        ArrayList<String> newVList = new ArrayList<String>(vList.size());
        for (String v : vList) {
            String newV = v.substring(0, v.length() - 1) + ",\"" + shortnumber + "." + dimmem + "\")";
            newVList.add(newV);
        }
        for (int i = 0; i < newVList.size(); ++i) {
            formula = formula.replace(vList.get(i), (CharSequence)newVList.get(i));
        }
        return formula;
    }

    public static String checkFormula(String formula, List<String> needdims) {
        if (StringUtils.isEmpty((String)formula) || CollectionUtils.isEmpty(needdims)) {
            return null;
        }
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        List<String> vList = ChkFormulaServiceHelper.getVList(formula);
        for (String v : vList) {
            Pair<String, List<IFormula>> pair = null;
            try {
                pair = parser.parse(v, coder);
            }
            catch (Exception e) {
                return null;
            }
            for (IFormula f : (List)pair.p2) {
                List formulaDims = f.getParamList().stream().map(p -> p.toString().split("\\.")[0]).collect(Collectors.toList());
                for (String needdim : needdims) {
                    if (formulaDims.contains(needdim)) continue;
                    return needdim;
                }
            }
        }
        return null;
    }

    public static String getShowDimByFullFormula(String fulllformula, long chkid) {
        return ChkCheckServiceHelper.getShowDimByFullFormula(fulllformula, chkid, null, null);
    }

    public static String getShowDimByFullFormula(String fulllformula, long chkid, Map<Long, String> shortNum, MemberMsgCache memCache) {
        Object modelId;
        IFormula f;
        if (StringUtils.isEmpty((String)fulllformula)) {
            return fulllformula;
        }
        String newFormula = fulllformula;
        if (ChkFormulaServiceHelper.isJudgeFormula(fulllformula) || ChkFormulaServiceHelper.hasXdmFormula(fulllformula)) {
            newFormula = ChkCheckServiceHelper.getVFromFormula(newFormula);
        }
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        try {
            Pair<String, List<IFormula>> pair = parser.parse(newFormula, coder);
            f = (IFormula)((List)pair.p2).get(0);
        }
        catch (Exception e) {
            return "";
        }
        ArrayList<String> dims = new ArrayList<String>();
        ArrayList<String> nums = new ArrayList<String>();
        if (f.getName().equals("V")) {
            for (ParamItem s : f.getParamList()) {
                String[] strs = s.toString().split("\\.");
                if (strs[0].equals(DimTypesEnum.PROCESS.getShortNumber()) && strs[1].equals("CS")) {
                    dims.add(strs[0]);
                    nums.add("Rpt");
                    continue;
                }
                dims.add(strs[0]);
                nums.add(strs[1]);
            }
        }
        if (memCache != null) {
            modelId = memCache.getModelId();
        } else {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)chkid, (String)"bcm_chkformulasetting", (String)"model.id");
            modelId = obj.get("model.id");
        }
        HashSet<String> dimSet = new HashSet<String>(16);
        List<Dimension> dimensions = ChkCheckServiceHelper.getMapDims(modelId, chkid);
        StringBuilder sb = new StringBuilder();
        if (dimensions != null) {
            for (Dimension me : dimensions) {
                int i;
                String shortNumber = shortNum != null ? shortNum.get(me.getId()) : BusinessDataServiceHelper.loadSingle((Object)me.getId(), (String)"bcm_dimension").getString("shortnumber");
                if (!dimSet.add(shortNumber) || (i = dims.indexOf(shortNumber)) < 0) continue;
                String memnum = (String)nums.get(i);
                String memname = memCache != null ? (String)memCache.getMsg(me.getNumber(), memnum, "name") : QueryServiceHelper.queryOne((String)me.getMemberEntityNumber(), (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)memnum), new QFilter("dimension", "=", (Object)me.getId())}).getString("name");
                sb.append(me.getName());
                sb.append('.');
                sb.append(memname);
                sb.append(',');
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static List<Dimension> getMapDims(Object modelId, long chkid) {
        String key = "ckdimmap" + modelId.toString();
        Map<Long, List<Dimension>> dimmap = (Map<Long, List<Dimension>>)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)key, () -> ChkCheckServiceHelper.reloadMap(modelId));
        if (!dimmap.containsKey(chkid)) {
            dimmap = ChkCheckServiceHelper.reloadMap(modelId);
            GlobalCacheServiceHelper.replaceCache((CacheTypeEnum)CacheTypeEnum.CommonCache, (String)key, dimmap);
        }
        return dimmap.get(chkid);
    }

    private static Map<Long, List<Dimension>> reloadMap(Object modelId) {
        Map docs = BusinessDataServiceHelper.loadFromCache((String)"bcm_chkformulasetting", (String)"memberrange.dimension,memberrange.limittype", (QFilter[])new QFilter[]{new QFilter("model", "=", modelId)});
        HashMap<Long, List<Dimension>> map = new HashMap<Long, List<Dimension>>(docs.size());
        for (DynamicObject obj : docs.values()) {
            ArrayList<Dimension> ds = new ArrayList<Dimension>();
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("memberrange");
            for (DynamicObject o : entries) {
                if (!ChkMemberRangeLimitTypeEnum.COMMON.getLimitType().equals(o.getString("limittype"))) continue;
                DynamicObject dim = o.getDynamicObject("dimension");
                Dimension d = new Dimension();
                d.setId(dim.getLong("id"));
                d.setName(dim.getString("name"));
                d.setNumber(dim.getString("number"));
                d.setMemberEntityNumber(dim.getString("membermodel"));
                ds.add(d);
            }
            map.put(obj.getLong("id"), ds);
        }
        return map;
    }

    public static Map<Long, String> getId2ShortNum(long modelId) {
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        HashMap<Long, String> result = new HashMap<Long, String>(dimensions.size());
        dimensions.forEach(dim -> result.put(dim.getLong("id"), dim.getString("shortnumber")));
        return result;
    }

    private static String getVFromFormula(String newFormula) {
        int beginPosition = newFormula.indexOf("V(");
        int endPosition = newFormula.indexOf(41, beginPosition);
        if (beginPosition > -1 && endPosition > beginPosition) {
            return newFormula.substring(beginPosition, endPosition + 1);
        }
        return "";
    }

    public static List<Long> getFormulaSettingIdsByNum(Collection<String> nums, long modelId) {
        QFilter modelqf = new QFilter("model", "=", (Object)modelId).and(new QFilter("status", "=", (Object)CHKFormulaStatusEnum.enable.getIndex())).and(new QFilter("multitemplate.fbasedataid.number", "in", nums));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id", (QFilter[])new QFilter[]{modelqf});
        return doc.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    public static String buildKey(DynamicObject obj) {
        long chkformula = obj.getLong("chkformula.id");
        String process = StringUtils.isEmpty((String)obj.getString("process.number")) ? "null" : obj.getString("process.number");
        String currency = StringUtils.isEmpty((String)obj.getString("currency.number")) ? "null" : obj.getString("currency.number");
        return ChkCheckServiceHelper.getResultkey(chkformula, process, currency);
    }

    public static void fillCurrency(ICalContext ctx, long modelId) {
        String[] ecCcyAndPcCcy = ChkCheckServiceHelper.getEcCcyAndPcCcy(ctx, modelId);
        String ecCurrency = ecCcyAndPcCcy[0];
        String pcCurrency = ecCcyAndPcCcy[1];
        ctx.setProperty("ecCurrency", ecCurrency);
        ctx.setProperty("pcCurrency", pcCurrency);
        if (ctx.getProperty("filter") != null) {
            Map memmap = (Map)ctx.getProperty("filter");
            ctx.setProcess((String)memmap.get(DimTypesEnum.PROCESS.getNumber()));
        }
        ChkCheckServiceHelper.transferNoneSpecificCurrency(ctx, (String)ctx.getProperty("ecCurrency"), (String)ctx.getProperty("pcCurrency"));
        if (StringUtils.isNotEmpty((String)ctx.getCurrency())) {
            long currencyId = MemberReader.findCurrencyMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getCurrency()).getId();
            ctx.setProperty("currencyId", currencyId);
        }
    }

    public static void fillProcessListByProcess(ICalContext ctx) {
        String process = ctx.getProcess();
        if (ParamConstant.ERptProcess.contains(process)) {
            if (ChkCheckServiceHelper.isEcCurrency(ctx, (String)ctx.getProperty("ecCurrency"))) {
                ctx.setProperty("mcstatus", ChkCtxConstant.CHECK_ORG_ERPT);
                ctx.setProcessList(ParamConstant.ERptProcess);
            } else {
                ctx.setProperty("skipcheck", ResManager.loadKDString((String)"\u5f53\u524d\u8fc7\u7a0b\u53ea\u5141\u8bb8\u6821\u9a8c\u5f53\u524d\u7ec4\u7ec7\u672c\u4f4d\u5e01\u5e01\u79cd\u3002", (String)"ChkCheckServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        } else if (ParamConstant.RptProcess.contains(process)) {
            if (ChkCheckServiceHelper.isParentCurrency(ctx, (String)ctx.getProperty("pcCurrency"))) {
                ctx.setProperty("mcstatus", ChkCtxConstant.CHECK_ORG_RPT);
                ctx.setProcessList(ParamConstant.RptProcess);
            } else if (ChkCheckServiceHelper.isEcCurrency(ctx, (String)ctx.getProperty("ecCurrency"))) {
                ctx.setProperty("skipcheck", ResManager.loadKDString((String)"\u5f53\u524d\u8fc7\u7a0b\u4e0d\u5141\u8bb8\u6821\u9a8c\u5f53\u524d\u7ec4\u7ec7\u672c\u4f4d\u5e01\u5e01\u79cd\u3002", (String)"ChkCheckServiceHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]));
            } else {
                ctx.setProcessList(ParamConstant.RptProcess);
            }
        } else if (!ChkCheckServiceHelper.isParentCurrency(ctx, (String)ctx.getProperty("pcCurrency"))) {
            ctx.setProperty("skipcheck", ResManager.loadKDString((String)"\u5f53\u524d\u8fc7\u7a0b\u53ea\u5141\u8bb8\u6821\u9a8c\u4e0a\u7ea7\u7ec4\u7ec7\u672c\u4f4d\u5e01\u5e01\u79cd\u3002", (String)"ChkCheckServiceHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]));
        } else {
            ctx.setProperty("mcstatus", ChkCtxConstant.CHECK_PARENT_ORG_ERPT);
            ctx.setProcessList(Collections.singletonList(process));
        }
    }

    public static boolean notChkRptProcess(ICalContext ctx) {
        return ChkCheckServiceHelper.pcNotInvolved(ctx) && ChkCheckServiceHelper.targetCcyNotMatch(ctx);
    }

    public static boolean pcNotInvolved(ICalContext ctx) {
        return StringUtils.isEmpty((String)((String)ctx.getProperty("pcCurrency"))) || ctx.getProperty("pcCurrency").equals(ctx.getProperty("ecCurrency"));
    }

    public static boolean targetCcyNotMatch(ICalContext ctx) {
        return StringUtils.isEmpty((String)ctx.getCurrency()) || ctx.getCurrency().equals(ctx.getProperty("ecCurrency"));
    }

    public static String getCurrency(ICalContext ctx, String process, String currency) {
        if (currency == null) {
            currency = ParamConstant.ERptProcess.contains(process) ? (String)ctx.getProperty("ecCurrency") : (StringUtils.isEmpty((String)((String)ctx.getProperty("pcCurrency"))) ? (String)ctx.getProperty("ecCurrency") : (String)ctx.getProperty("pcCurrency"));
        }
        return currency;
    }

    public static void fillBpNumber2Id(ICalContext ctx) {
        Map processes = MemberReader.getAllNodeFromCache((String)"bcm_processmembertree", (Object)ctx.getModelId());
        HashMap<String, Long> bp_Number2Id = new HashMap<String, Long>();
        processes.forEach((id, process) -> {
            if (process.isShare()) {
                return;
            }
            bp_Number2Id.put(process.getNumber(), process.getId());
        });
        ctx.setBpNumber2Id(bp_Number2Id);
    }

    public static Map<String, List<Long>> noReportTemplate2FormulaSetting(List<String> templateNumbers, DynamicObject[] dynamicObjects) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection multitemplate = dynamicObject.getDynamicObjectCollection("multitemplate");
            if (!CollectionUtils.isNotEmpty((Collection)multitemplate)) continue;
            multitemplate.sort((dy1, dy2) -> dy1.getString("fbasedataid.number").compareToIgnoreCase(dy2.getString("fbasedataid.number")));
            boolean isAllocate = false;
            for (DynamicObject t : multitemplate) {
                String tempNum = t.getString("fbasedataid.number");
                if (!templateNumbers.contains(tempNum)) continue;
                if (isAllocate) {
                    map.computeIfAbsent(tempNum, k -> new ArrayList()).add(dynamicObject.getLong("id"));
                    continue;
                }
                isAllocate = true;
            }
        }
        return map;
    }

    public static boolean isChkSettingSame(List<DynamicObject> oldresults, Set<String> leftAndRightFormula) {
        return oldresults.stream().allMatch(dy -> {
            String fulllformula = dy.getString("fulllformula");
            String fullrformula = dy.getString("fullrformula");
            return leftAndRightFormula.contains(fulllformula + "@@@" + fullrformula);
        });
    }

    public static String buildChkScope(ChkFormulaModel ckm) {
        StringBuilder str = new StringBuilder();
        List<MemberRangeEntry> memberRangeEntries = ckm.getMemberRangeEntries();
        for (MemberRangeEntry entry : memberRangeEntries) {
            Dimension dimension = entry.getDimension();
            if (!DimTypesEnum.SCENARIO.getShortNumber().equals(dimension.getShortNumber()) && !DimTypesEnum.ENTITY.getShortNumber().equals(dimension.getShortNumber()) && !DimTypesEnum.PROCESS.getShortNumber().equals(dimension.getShortNumber())) continue;
            if (DimTypesEnum.ENTITY.getShortNumber().equals(dimension.getShortNumber())) {
                Map<String, List<ChkMember>> orgMap = entry.getAllMembProperties().stream().collect(Collectors.groupingBy(ChkMember::getLimittype));
                for (Map.Entry<String, List<ChkMember>> listEntry : orgMap.entrySet()) {
                    if (ChkMemberRangeLimitTypeEnum.INBOUND.getLimitType().equals(listEntry.getKey())) {
                        str.append("ValidEntities").append(":");
                    } else {
                        str.append("InvalidEntities").append(":");
                    }
                    ArrayList<String> memberList = new ArrayList<String>(entry.getAllMembProperties().size());
                    for (ChkMember member : entry.getAllMembProperties()) {
                        memberList.add(MemberRangeUtil.getMemberRangeNumber((int)member.getScope()) + "[" + member.getNumber() + "]");
                    }
                    str.append(String.join((CharSequence)",", memberList)).append(";");
                }
                continue;
            }
            str.append(dimension.getShortNumber()).append(":");
            ArrayList<String> memberList = new ArrayList<String>(entry.getAllMembProperties().size());
            for (ChkMember member : entry.getAllMembProperties()) {
                memberList.add(MemberRangeUtil.getMemberRangeNumber((int)member.getScope()) + "[" + member.getNumber() + "]");
            }
            str.append(String.join((CharSequence)",", memberList)).append(";");
        }
        return str.toString();
    }

    public static String buildChkSuitDim(ChkFormulaModel ckm) {
        StringBuilder str = new StringBuilder();
        List<MemberRangeEntry> memberRangeEntries = ckm.getMemberRangeEntries();
        for (MemberRangeEntry entry : memberRangeEntries) {
            Dimension dimension = entry.getDimension();
            if (DimTypesEnum.SCENARIO.getShortNumber().equals(dimension.getShortNumber()) || DimTypesEnum.ENTITY.getShortNumber().equals(dimension.getShortNumber()) || DimTypesEnum.PROCESS.getShortNumber().equals(dimension.getShortNumber())) continue;
            str.append(dimension.getShortNumber()).append(":");
            ArrayList<String> memberList = new ArrayList<String>(entry.getAllMembProperties().size());
            for (ChkMember member : entry.getAllMembProperties()) {
                memberList.add(MemberRangeUtil.getMemberRangeNumber((int)member.getScope()) + "[" + member.getNumber() + "]");
            }
            str.append(String.join((CharSequence)",", memberList)).append(";");
        }
        return str.toString();
    }

    public static boolean isCheckDimCombOver(ChkFormulaModel ckm) {
        LinkedHashMap numberMap = new LinkedHashMap(16);
        List<MemberRangeEntry> mres = ckm.getMapdim();
        List bpMres = ckm.getMemberRangeEntries().stream().filter(mre -> mre.getDimension().getShortNumber().equals(DimTypesEnum.PROCESS.getShortNumber())).collect(Collectors.toList());
        mres.addAll(bpMres);
        mres.forEach(mre -> {
            HashSet<String> membnums = new HashSet<String>(10);
            ChkCheckServiceHelper.fillAllNumbers(ckm, mre, membnums);
            numberMap.put(mre.getDimension().getShortNumber(), Lists.newArrayList(membnums));
        });
        return numberMap.values().stream().mapToLong(List::size).reduce(1L, (a, b) -> a * b) >= 500000L;
    }

    public static Map<Long, DynamicObject> getEffectiveFormulaSetting(ICalContext ctx) {
        ArrayList<ChkFormulaModel> ckms = new ArrayList<ChkFormulaModel>();
        HashMap formulaId2Process = new HashMap();
        HashMap<String, List> temp2FormulaId = new HashMap<String, List>();
        ctx.setProperty("temp2formulaid", temp2FormulaId);
        ctx.setProperty("batchformulaid2process", formulaId2Process);
        ctx.setProperty("ckms", ckms);
        DynamicObject[] allFormulaListByCTX = ChkCheckServiceHelper.getAllFormulaListByCTX(ctx, CHKFormulaStatusEnum.enable.getIndex());
        HashMap<Long, DynamicObject> removeNotEffective = new HashMap<Long, DynamicObject>();
        if (allFormulaListByCTX.length < 1) {
            return removeNotEffective;
        }
        long modelId = MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
        List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(modelId);
        Map<String, Map<Long, DynamicObject>> memberMap = ChkCheckServiceHelper.getMemberData(allFormulaListByCTX);
        ArrayList<String> ecAndPcProcess = new ArrayList<String>();
        ecAndPcProcess.addAll(ParamConstant.ERptProcess);
        ecAndPcProcess.addAll(ParamConstant.RptProcess);
        ctx.setProcessList(ecAndPcProcess);
        ChkCheckServiceHelper.fillBpNumber2Id(ctx);
        ChkCheckServiceHelper.fillProcessIdsByProcessList(ctx);
        for (DynamicObject formulaObj : allFormulaListByCTX) {
            DynamicObjectCollection multitemplate = formulaObj.getDynamicObjectCollection("multitemplate");
            if (CollectionUtils.isEmpty((Collection)multitemplate)) continue;
            ChkFormulaModel ckm = new ChkFormulaModel();
            ckm.loadDynaObj2ModelEx(formulaObj, memberMap);
            if (!ChkCheckServiceHelper.isInnerCslscheme(ckm, (Long)ctx.getProperty("cslSchemeId")) || !ConvertDifferenceHandle.isApply(ctx.getYearId(), ctx.getPeriodId(), ckm.getEffectivePeriod(), yearIdsList)) continue;
            ckms.add(ckm);
            ctx.setProperty("report_process", new HashMap());
            RangeStatus status = new RangeStatus();
            ChkCheckServiceHelper.removeProcess(ctx, ckm, status);
            if (!status.isInner) continue;
            formulaId2Process.putAll((Map)ctx.getProperty("report_process"));
            removeNotEffective.putIfAbsent(formulaObj.getLong("id"), formulaObj);
            for (DynamicObject t : multitemplate) {
                String tempNum = t.getString("fbasedataid.number");
                temp2FormulaId.computeIfAbsent(tempNum, k -> new ArrayList()).add(formulaObj);
            }
        }
        ctx.getProcessList().clear();
        ctx.setProperty("processIds", null);
        ctx.setProperty("report_process", null);
        return removeNotEffective;
    }

    @SDKMark
    public static List<DynamicObject> getChkReport(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId, Long currencyId, String templateNumber, Long chkcheckUser, Date chkcheckDate, String selectFields) {
        if (modelId == null) {
            throw new IllegalArgumentException("modelId can not be null!");
        }
        if (scenarioId == null) {
            throw new IllegalArgumentException("scenarioId can not be null!");
        }
        if (yearId == null) {
            throw new IllegalArgumentException("yearId can not be null!");
        }
        if (periodId == null) {
            throw new IllegalArgumentException("periodId can not be null!");
        }
        QFilter baseQf = new QFilter("model", "=", (Object)modelId).and(new QFilter("scenario", "=", (Object)scenarioId)).and(new QFilter("year", "=", (Object)yearId)).and(new QFilter("period", "=", (Object)periodId));
        if (orgId != null) {
            baseQf.and(new QFilter("org", "=", (Object)orgId));
        }
        if (currencyId != null) {
            baseQf.and(new QFilter("currency", "=", (Object)currencyId));
        }
        QFilter userAndTimeQf = new QFilter("1", "=", (Object)1);
        if (chkcheckUser != null) {
            userAndTimeQf.and(new QFilter("modifier", "=", (Object)chkcheckUser));
        }
        if (chkcheckDate != null) {
            LocalDate ld = chkcheckDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDateTime ldtMin = LocalDateTime.of(ld, LocalTime.MIN);
            LocalDateTime ldtMax = LocalDateTime.of(ld, LocalTime.MAX);
            userAndTimeQf.and(new QFilter("modifytime", ">=", (Object)ldtMin)).and(new QFilter("modifytime", "<=", (Object)ldtMax));
        }
        if (StringUtils.isEmpty((String)selectFields)) {
            selectFields = "id,chkresulttype,chkformula.chkeffecttype,chkformula.number,chkformula.name,chkformula.multitemplate,currency.name,process.name,org.name,orgparent.name,note,modifier.name,modifytime,forcedpasser.name,forcedpasstime";
        }
        List<DynamicObject> chkReports = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_chkreport", (String)selectFields, (QFilter[])new QFilter[]{baseQf, userAndTimeQf, new QFilter("chkformula.status", "=", (Object)CHKFormulaStatusEnum.enable.getIndex())})).collect(Collectors.toList());
        if (templateNumber != null) {
            long templateId = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)templateNumber), new QFilter("versionnumber", "=", (Object)BigDecimal.ONE)}).getLong("id");
            DynamicObjectCollection status = QueryServiceHelper.query((String)"bcm_status", (String)"tmp", (QFilter[])new QFilter[]{baseQf, new QFilter("tmp", "=", (Object)templateId)});
            if (status.isEmpty()) {
                return Collections.emptyList();
            }
            Iterator<DynamicObject> iterator = chkReports.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = iterator.next();
                List allowTempIds = next.getDynamicObjectCollection("chkformula.multitemplate").stream().map(r -> r.getLong("fbasedataid.id")).collect(Collectors.toList());
                if (allowTempIds.contains(templateId)) continue;
                iterator.remove();
            }
        }
        return chkReports;
    }

    public static long findTotalProcess(String modelNum, long processId) {
        IDNumberTreeNode node = ChkCheckServiceHelper.findTotalProcessNode(modelNum, processId);
        return node.getId();
    }

    public static IDNumberTreeNode findTotalProcessNode(String modelNum, long processId) {
        IDNumberTreeNode node = MemberReader.findProcessMemberById((String)modelNum, (Long)processId);
        String process = node.getNumber();
        if (ParamConstant.CHILD_PROCESS_2_PARENT.containsKey(process)) {
            String totalProcess = (String)ParamConstant.CHILD_PROCESS_2_PARENT.get(process);
            node = MemberReader.findProcessMemberByNum((String)modelNum, (String)totalProcess);
        }
        return node;
    }

    public static String generateKey(ICalContext ctx) {
        return ChkCheckServiceHelper.generateKey(ctx.getCubeNumber(), ctx.getOrg(), ctx.getScenario(), ctx.getYear(), ctx.getPeriod());
    }

    public static String generateKey(String modelNumber, String org, String scenario, String year, String period) {
        return Joiner.on((String)"|").join((Object)modelNumber, (Object)org, new Object[]{scenario, year, period});
    }

    public static class RangeStatus {
        private boolean isInner = true;
        private boolean isUnScope = false;
    }
}

