/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.serviceHelper;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkStatusGenEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;

public class ChkCheckStatusHelper {
    public static final Log LOG = LogFactory.getLog(ChkCheckStatusHelper.class);

    private static Map<String, Pair<Integer, Integer>> initStatusMap(Long modelId, Set<Long> orgs, Long yearId, Long scenId, Long periodId, Map<Long, Long> org_curr, Long cslschemeId) {
        QFBuilder qBuilder = new QFBuilder();
        qBuilder.add("model", "=", (Object)modelId);
        qBuilder.add("org", "in", orgs);
        qBuilder.add("scenario", "=", (Object)scenId);
        qBuilder.add("year", "=", (Object)yearId);
        qBuilder.add("period", "=", (Object)periodId);
        qBuilder.add("cslscheme", "in", Arrays.asList(cslschemeId, 0L));
        ArrayList bpIds = new ArrayList(6);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        ParamConstant.ERptProcess.forEach(p -> bpIds.add(MemberReader.findProcessMemberByNum((String)modelNum, (String)p).getId()));
        ArrayList rptPorcessIds = new ArrayList(3);
        ParamConstant.RptProcess.forEach(p -> {
            Long id = MemberReader.findProcessMemberByNum((String)modelNum, (String)p).getId();
            bpIds.add(id);
            rptPorcessIds.add(id);
        });
        DynamicObjectCollection status = QueryServiceHelper.query((String)"bcm_status", (String)"tmp.id,tmp.number,tmp.group,org.id,currency.id,process.id,audittrail.id,checkedstatus,cslscheme.id,chkresult,modifytime", (QFilter[])qBuilder.toArray());
        HashMap<String, Pair<Integer, Integer>> stsMap = new HashMap<String, Pair<Integer, Integer>>(16);
        status.forEach(s -> {
            String key = s.getString("cslscheme.id");
            key = key + s.getString("org.id") + s.getString("tmp.id") + s.getString("currency.id");
            Long ec = (Long)org_curr.get(s.getLong("org.id"));
            if (ec != null && ec.longValue() != s.getLong("currency.id")) {
                key = "0" + key;
            }
            if (!stsMap.containsKey(key)) {
                stsMap.put(key, Pair.onePair((Object)ChkStatusEnum.PASS.getStatus(), (Object)(s.getInt("chkresult") == 0 ? ChkStatusEnum.PASS.getStatus() : s.getInt("chkresult"))));
            }
        });
        qBuilder.add("process", "in", bpIds);
        qBuilder.add("chkresulttype", "=", (Object)String.valueOf(ChkResultTypeEnum.UNPASS.getIndex()));
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"chkformula.id, org.id,currency.id, process.id, cslscheme.id", (QFilter[])qBuilder.toArray());
        if (!reports.isEmpty()) {
            List chkSettingIds = reports.stream().map(report -> report.getLong("chkformula.id")).collect(Collectors.toList());
            DynamicObjectCollection chkSetting = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,multitemplate.fbasedataid.id,status", (QFilter[])new QFBuilder("id", "in", chkSettingIds).toArray());
            ArrayListMultimap enableSetting = ArrayListMultimap.create();
            chkSetting.stream().filter(setting -> CHKFormulaStatusEnum.enable.getIndex().equals(setting.getString("status"))).forEach(arg_0 -> ChkCheckStatusHelper.lambda$initStatusMap$5((Multimap)enableSetting, arg_0));
            if (enableSetting.size() > 0) {
                List<DynamicObject> afterReports = reports.stream().filter(arg_0 -> ChkCheckStatusHelper.lambda$initStatusMap$6((Multimap)enableSetting, arg_0)).collect(Collectors.toList());
                afterReports.forEach(arg_0 -> ChkCheckStatusHelper.lambda$initStatusMap$7((Multimap)enableSetting, cslschemeId, rptPorcessIds, stsMap, arg_0));
            }
        }
        stsMap.entrySet().forEach(e -> {
            if (((Integer)((Pair)e.getValue()).p2).intValue() != ChkStatusEnum.NOFORMULA.getStatus() && !((Integer)((Pair)e.getValue()).p1).equals(((Pair)e.getValue()).p2)) {
                e.setValue(Pair.onePair((Object)((Pair)e.getValue()).p1, (Object)((Pair)e.getValue()).p1));
            }
        });
        return stsMap;
    }

    @SDKMark
    public static Map<String, Pair<Integer, Integer>> getChkStatusMap(long model, Set<Long> orgs, long year, long scen, long period, Map<Long, Long> org_cur, long cslscheme) {
        QFBuilder qBuilder = new QFBuilder();
        qBuilder.add("org", "in", orgs);
        qBuilder.add("period", "=", (Object)period);
        qBuilder.add("year", "=", (Object)year);
        qBuilder.add("model", "=", (Object)model);
        qBuilder.add("scenario", "=", (Object)scen);
        qBuilder.add("cslscheme", "in", Arrays.asList(cslscheme, 0L));
        ArrayList bpIds = new ArrayList(6);
        ArrayList erptPorcessIds = new ArrayList(3);
        String modelNum = MemberReader.findModelNumberById((Object)model);
        ParamConstant.ERptProcess.forEach(p -> {
            Long id = MemberReader.findProcessMemberByNum((String)modelNum, (String)p).getId();
            bpIds.add(id);
            erptPorcessIds.add(id);
        });
        ParamConstant.RptProcess.forEach(p -> {
            Long id = MemberReader.findProcessMemberByNum((String)modelNum, (String)p).getId();
            bpIds.add(id);
        });
        qBuilder.add("process", "in", bpIds);
        DynamicObjectCollection status = QueryServiceHelper.query((String)"bcm_status", (String)"tmp.id,tmp.number,tmp.group,org.id,currency.id,process.id,process.number,checkedstatus,chkresult,isnewgenerate,cslscheme.id,modifytime", (QFilter[])qBuilder.toArray());
        boolean isOld = false;
        if (!status.isEmpty()) {
            for (DynamicObject s2 : status) {
                if (ChkStatusGenEnum.NEW.getGenerateType().equals(s2.getString("isnewgenerate"))) continue;
                isOld = true;
                break;
            }
        }
        if (isOld) {
            return ChkCheckStatusHelper.initStatusMap(model, orgs, year, scen, period, org_cur, cslscheme);
        }
        HashMap<String, Pair<Integer, Integer>> stsMap = new HashMap<String, Pair<Integer, Integer>>(16);
        status.forEach(s -> {
            String key = s.getString("cslscheme.id") + s.getString("org.id") + s.getString("tmp.id") + s.getString("currency.id");
            if (!erptPorcessIds.contains(s.getLong("process.id"))) {
                key = "0" + key;
            }
            if (!stsMap.containsKey(key) || ((Integer)((Pair)stsMap.get((Object)key)).p1).intValue() != ChkStatusEnum.UNPASS.getStatus()) {
                stsMap.put(key, Pair.onePair((Object)s.getInt("checkedstatus"), (Object)(s.getInt("chkresult") == 0 ? s.getInt("checkedstatus") : s.getInt("chkresult"))));
            }
        });
        return stsMap;
    }

    public static Pair<Integer, Integer> getStatus(String cslScheme, String org, Long tmp, String ccy, Map<String, Pair<Integer, Integer>> stsMap, boolean isEcCurrency) {
        Pair<Integer, Integer> sts;
        String key = cslScheme + org + tmp + ccy;
        String oldkey = "0" + org + tmp + ccy;
        if (!isEcCurrency) {
            key = "0" + key;
            oldkey = "0" + oldkey;
        }
        if ((sts = stsMap.get(key)) == null && (sts = stsMap.get(oldkey)) == null) {
            return Pair.onePair((Object)ChkStatusEnum.UNCHECK.getStatus(), (Object)ChkStatusEnum.UNCHECK.getStatus());
        }
        return sts;
    }

    public static void resetCheckStatus(ICalContext ctx) {
        Map org2TempNums = (Map)ctx.getProperty("org2TempNums");
        if (MapUtils.isEmpty((Map)org2TempNums)) {
            return;
        }
        HashMap orgCurrMap = new HashMap(16);
        if ("EC".equals(ctx.getCurrency()) || "DC".equals(ctx.getCurrency())) {
            QFilter qFilter = new QFilter("model", "=", (Object)ctx.getModelId()).and(new QFilter("number", "in", org2TempNums.keySet()));
            DynamicObjectCollection orgCurrencys = OrgCurrencyServiceHelper.getOrgsCurrency(qFilter.toArray(), ctx.getYearId(), ctx.getPeriodId());
            orgCurrencys.forEach(c -> orgCurrMap.put(c.getString("number"), c.getString("currency.number")));
        }
        QFilter chkFilter = new QFilter("model.number", "=", (Object)ctx.getCubeNumber());
        DynamicObjectCollection chkFormulaSettings = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,multitemplate.fbasedataid.number", (QFilter[])chkFilter.toArray());
        Map chkFormulaId2TemplateNums = chkFormulaSettings.stream().filter(dy -> StringUtils.isNotEmpty((String)dy.getString("multitemplate.fbasedataid.number"))).collect(Collectors.groupingBy(dy -> dy.getLong("id"), Collectors.mapping(dy -> dy.getString("multitemplate.fbasedataid.number"), Collectors.toList())));
        if (ctx.getModelId() == null || ctx.getYearId() == null || ctx.getPeriodId() == null || ctx.getScenarioId() == null || ctx.getCurrency() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\uff0c\u60c5\u666f\uff0c\u8d22\u5e74\uff0c\u671f\u95f4\uff0c\u5e01\u79cd\u90fd\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ChkCheckServiceHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        org2TempNums.forEach((org, tempNums) -> {
            ArrayList<QFilter> fl = new ArrayList<QFilter>();
            fl.add(new QFilter("model", "=", (Object)ctx.getModelId()));
            fl.add(new QFilter("year", "=", (Object)ctx.getYearId()));
            fl.add(new QFilter("period", "=", (Object)ctx.getPeriodId()));
            fl.add(new QFilter("scenario", "=", (Object)ctx.getScenarioId()));
            Long orgId = MemberReader.findEntityMemberByNum((String)ctx.getCubeNumber(), (String)org).getId();
            fl.add(new QFilter("org", "=", (Object)orgId));
            if (orgCurrMap.containsKey(org)) {
                String currencyNum = (String)orgCurrMap.get(org);
                fl.add(new QFilter("currency", "in", Arrays.asList(MemberReader.findCurrencyMemberByNum((String)ctx.getCubeNumber(), (String)currencyNum).getId(), 0L)));
            } else {
                fl.add(new QFilter("currency", "in", Arrays.asList(ctx.getCurrencyId(), 0L)));
            }
            ArrayList<QFilter> bcmStatusFilters = new ArrayList<QFilter>(fl);
            bcmStatusFilters.add(new QFilter("tmp.number", "in", tempNums));
            DeleteServiceHelper.delete((String)"bcm_status", (QFilter[])bcmStatusFilters.toArray(new QFilter[0]));
            DynamicObjectCollection tmp = QueryServiceHelper.query((String)"bcm_status", (String)"tmp.number", (QFilter[])fl.toArray(new QFilter[0]));
            List existTempNums = tmp.stream().map(dy -> dy.getString("tmp.number")).collect(Collectors.toList());
            ArrayList delChkFormulaId = new ArrayList();
            chkFormulaId2TemplateNums.forEach((id, templates) -> {
                if (CollectionUtils.isNotEmpty((Collection)templates) && CollectionUtils.isEmpty((Collection)ListUtils.intersection((List)existTempNums, (List)templates))) {
                    delChkFormulaId.add(id);
                }
            });
            if (CollectionUtils.isNotEmpty(delChkFormulaId)) {
                ArrayList<QFilter> chkReportFilters = new ArrayList<QFilter>(fl);
                chkReportFilters.add(new QFilter("chkformula", "in", delChkFormulaId));
                DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])chkReportFilters.toArray(new QFilter[0]));
            }
        });
    }

    public static void dealChkStsAfterChangeReport(long modelId, long senceId, long yearId, long periodId, long cslschemeId, DynamicObject[] reports) {
        List orgs = Arrays.stream(reports).map(r -> r.getLong("org.id")).collect(Collectors.toList());
        DynamicObjectCollection queryReports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"id,chkresulttype,process.id,org.id,chkformula.id", (QFilter[])new QFilter[]{new QFilter("chkresulttype", "=", (Object)String.valueOf(ChkResultTypeEnum.UNPASS.getIndex())), new QFilter("model", "=", (Object)modelId), new QFilter("period", "=", (Object)periodId), new QFilter("year", "=", (Object)yearId), new QFilter("scenario", "=", (Object)senceId), new QFilter("cslscheme", "in", Arrays.asList(cslschemeId, 0L)), new QFilter("org", "in", orgs)});
        HashSet<String> reportSet = new HashSet<String>();
        if (!queryReports.isEmpty()) {
            List chkSettingIds = queryReports.stream().map(report -> report.getLong("chkformula.id")).collect(Collectors.toList());
            DynamicObjectCollection chkSetting = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,status,multitemplate.fbasedataid.id", (QFilter[])new QFBuilder("id", "in", chkSettingIds).toArray());
            ArrayListMultimap enableSetting = ArrayListMultimap.create();
            chkSetting.stream().filter(setting -> CHKFormulaStatusEnum.enable.getIndex().equals(setting.getString("status"))).forEach(set -> enableSetting.put((Object)set.getLong("id"), set));
            if (enableSetting.size() > 0) {
                List afterReports = queryReports.stream().filter(chk -> enableSetting.containsKey((Object)chk.getLong("chkformula.id"))).collect(Collectors.toList());
                for (DynamicObject rep : afterReports) {
                    List multi = enableSetting.get((Object)rep.getLong("chkformula.id"));
                    for (DynamicObject set2 : multi) {
                        String key = rep.get("org.id") + "|" + set2.get("multitemplate.fbasedataid.id") + "|" + rep.get("process.id");
                        reportSet.add(key);
                    }
                }
            }
        }
        DynamicObject[] queryStatus = BusinessDataServiceHelper.load((String)"bcm_status", (String)"id,checkedstatus,chkresult,org.id,tmp.id,process.id,process.number,currency.id,currency.number,modifytime", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("period", "=", (Object)periodId), new QFilter("year", "=", (Object)yearId), new QFilter("scenario", "=", (Object)senceId), new QFilter("cslscheme", "in", Arrays.asList(cslschemeId, 0L)), new QFilter("org", "in", orgs)}, null);
        List<DynamicObject> orgStatusList_EC = Arrays.stream(queryStatus).filter(s -> s.getLong("tmp.id") == 0L && "ERpt".equals(s.getString("process.number"))).collect(Collectors.toList());
        List<DynamicObject> orgStatusList_PC = Arrays.stream(queryStatus).filter(s -> s.getLong("tmp.id") == 0L && "Rpt".equals(s.getString("process.number"))).collect(Collectors.toList());
        ArrayList<DynamicObject> needUpdateSts = new ArrayList<DynamicObject>(10);
        for (DynamicObject rep : reports) {
            String orgid = rep.getString("org.id");
            String bpid = rep.getString("process.id");
            rep.getDynamicObjectCollection("chkformula.multitemplate").forEach(tmp -> {
                String key = orgid + "|" + tmp.get("fbasedataid.id") + "|" + bpid;
                if (!reportSet.contains(key)) {
                    DynamicObject status = Arrays.stream(queryStatus).filter(sts -> orgid.equals(sts.getString("org.id")) && tmp.getString("fbasedataid.id").equals(sts.getString("tmp.id")) && bpid.equals(sts.getString("process.id"))).findAny().orElse(null);
                    if (status != null && status.getInt("checkedstatus") == ChkStatusEnum.UNPASS.getStatus()) {
                        status.set("checkedstatus", (Object)ChkStatusEnum.PASS.getStatus());
                        status.set("chkresult", (Object)ChkStatusEnum.PASS.getStatus());
                        status.set("modifytime", (Object)TimeServiceHelper.now());
                        needUpdateSts.add(status);
                    }
                } else {
                    DynamicObject status = Arrays.stream(queryStatus).filter(sts -> orgid.equals(sts.getString("org.id")) && tmp.getString("fbasedataid.id").equals(sts.getString("tmp.id")) && bpid.equals(sts.getString("process.id"))).findAny().orElse(null);
                    if (status != null && status.getInt("checkedstatus") == ChkStatusEnum.PASS.getStatus()) {
                        status.set("checkedstatus", (Object)ChkStatusEnum.UNPASS.getStatus());
                        status.set("chkresult", (Object)ChkStatusEnum.UNPASS.getStatus());
                        status.set("modifytime", (Object)TimeServiceHelper.now());
                        needUpdateSts.add(status);
                    }
                }
            });
        }
        SaveServiceHelper.save((DynamicObject[])needUpdateSts.toArray(new DynamicObject[0]));
        ChkCheckStatusHelper.updateOrgAndMergeChkSts(modelId, senceId, yearId, periodId, queryStatus, needUpdateSts, orgStatusList_EC, true);
        ChkCheckStatusHelper.updateOrgAndMergeChkSts(modelId, senceId, yearId, periodId, queryStatus, needUpdateSts, orgStatusList_PC, false);
    }

    private static void updateOrgAndMergeChkSts(long modelId, long senceId, long yearId, long periodId, DynamicObject[] allStatus, List<DynamicObject> needUpdateStatus, List<DynamicObject> orgStatusList, boolean isEC) {
        if (orgStatusList == null || orgStatusList.isEmpty()) {
            return;
        }
        String process = isEC ? "ERpt" : "Rpt";
        Map<Long, List<DynamicObject>> org2NeedUpdateStatus = needUpdateStatus.stream().collect(Collectors.groupingBy(s -> s.getLong("org.id")));
        Map<Long, List<DynamicObject>> org2Status = Arrays.stream(allStatus).collect(Collectors.groupingBy(s -> s.getLong("org.id")));
        for (DynamicObject orgStatus : orgStatusList) {
            McStatus mcStatus = MergeStatusHelper.getMcStatusByCurrencyNumber(modelId, senceId, yearId, periodId, orgStatus.getLong("org.id"), orgStatus.getString("currency.number"));
            if (mcStatus.getChkStatus().isNeeded()) break;
            int originalSts = orgStatus.getInt("checkedstatus");
            String ecNumber = MemberReader.findEntityMemberById((Long)modelId, (Long)orgStatus.getLong("org.id")).getCurrency();
            List<DynamicObject> orgNeedUpSts = org2NeedUpdateStatus.get(orgStatus.getLong("org.id"));
            Set<Object> needUpdateIds = new HashSet();
            if (orgNeedUpSts != null) {
                needUpdateIds = orgNeedUpSts.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
                for (DynamicObject status : orgNeedUpSts) {
                    if (!process.equals(status.getString("process.number")) || !ChkCheckStatusHelper.isCcyMatchBp(isEC, ecNumber, status)) break;
                    if (ChkStatusEnum.UNPASS.getStatus() != status.getInt("checkedstatus")) continue;
                    orgStatus.set("checkedstatus", (Object)ChkStatusEnum.UNPASS.getStatus());
                    orgStatus.set("chkresult", (Object)ChkStatusEnum.UNPASS.getStatus());
                    orgStatus.set("modifytime", (Object)TimeServiceHelper.now());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{status});
                    ChkCheckStatusHelper.updateMergeChkStatus(modelId, senceId, yearId, periodId, orgStatus.getLong("org.id"), orgStatus.getString("currency.number"), false);
                    return;
                }
            }
            List<DynamicObject> orgAllSts = org2Status.get(orgStatus.getLong("org.id"));
            for (DynamicObject status : orgAllSts) {
                if (!process.equals(status.getString("process.number")) || needUpdateIds.contains(status.getLong("id")) || !ChkCheckStatusHelper.isCcyMatchBp(isEC, ecNumber, status)) break;
                if (ChkStatusEnum.UNPASS.getStatus() != status.getInt("checkedstatus")) continue;
                orgStatus.set("checkedstatus", (Object)ChkStatusEnum.UNPASS.getStatus());
                orgStatus.set("chkresult", (Object)ChkStatusEnum.UNPASS.getStatus());
                orgStatus.set("modifytime", (Object)TimeServiceHelper.now());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{status});
                ChkCheckStatusHelper.updateMergeChkStatus(modelId, senceId, yearId, periodId, orgStatus.getLong("org.id"), orgStatus.getString("currency.number"), false);
                return;
            }
            if (!ChkCheckStatusHelper.isCcyMatchBp(isEC, ecNumber, orgStatus) || ChkStatusEnum.UNPASS.getStatus() != originalSts && !"U".equals(mcStatus.getChkStatus().getStatus())) continue;
            orgStatus.set("checkedstatus", (Object)ChkStatusEnum.PASS.getStatus());
            orgStatus.set("chkresult", (Object)ChkStatusEnum.PASS.getStatus());
            orgStatus.set("modifytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{orgStatus});
            ChkCheckStatusHelper.updateMergeChkStatus(modelId, senceId, yearId, periodId, orgStatus.getLong("org.id"), orgStatus.getString("currency.number"), true);
        }
    }

    private static boolean isCcyMatchBp(boolean isEC, String ecNumber, DynamicObject status) {
        return isEC == status.getString("currency.number").equals(ecNumber);
    }

    private static void updateMergeChkStatus(long modelId, long sceneId, long yearId, long periodId, long orgId, String currency, boolean isPass) {
        if (isPass) {
            MergeStatusHelper.updateChkStatusSuccess(modelId, sceneId, yearId, periodId, orgId, currency);
        } else {
            MergeStatusHelper.updateChkStatusFail(modelId, sceneId, yearId, periodId, orgId, currency);
        }
    }

    @SDKMark
    public static Map<String, Pair<ChkStatusEnum, ChkStatusEnum>> getTemplateChkStatus(List<Long> reportIds) {
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"model,scenario,year,period,org,process,chkformula.multitemplate.fbasedataid.number", (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds)});
        if (CollectionUtils.isEmpty((Collection)reports)) {
            throw new KDBizException("cannot find any reports!");
        }
        HashSet templateNumbers = new HashSet();
        reports.forEach(report -> templateNumbers.add(report.getString("chkformula.multitemplate.fbasedataid.number")));
        DynamicObject dynamicObject = (DynamicObject)reports.get(0);
        long modelId = dynamicObject.getLong("model");
        long orgId = dynamicObject.getLong("org");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (entityNode.isShare()) {
            entityNode.getBaseTreeNode().getShareNodes().forEach(node -> orgIds.add(node.getId()));
        } else {
            entityNode.getShareNodes().forEach(node -> orgIds.add(node.getId()));
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("org", "in", orgIds);
        qFilter.and("period", "=", (Object)dynamicObject.getLong("period"));
        qFilter.and("year", "=", (Object)dynamicObject.getLong("year"));
        qFilter.and("scenario", "=", (Object)dynamicObject.getLong("scenario"));
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        ArrayList<Long> erptProcessIds = new ArrayList<Long>();
        ArrayList<Long> rptProcessIds = new ArrayList<Long>();
        ParamConstant.ERptProcess.forEach(bp -> erptProcessIds.add(MemberReader.findProcessMemberByNum((String)modelNumber, (String)bp).getId()));
        ParamConstant.RptProcess.forEach(bp -> rptProcessIds.add(MemberReader.findProcessMemberByNum((String)modelNumber, (String)bp).getId()));
        qFilter.and("process", "in", (Object)CollectionUtils.union(erptProcessIds, rptProcessIds));
        qFilter.and("tmp.number", "in", templateNumbers);
        DynamicObjectCollection status = QueryServiceHelper.query((String)"bcm_status", (String)"tmp.number,process,chkresult,isnewgenerate,currency.number", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, Pair<ChkStatusEnum, ChkStatusEnum>> result = new HashMap<String, Pair<ChkStatusEnum, ChkStatusEnum>>();
        if (CollectionUtils.isEmpty((Collection)status)) {
            return result;
        }
        HashMap<String, ChkStatusEnum> erptResult = new HashMap<String, ChkStatusEnum>();
        HashMap<String, ChkStatusEnum> rptResult = new HashMap<String, ChkStatusEnum>();
        for (DynamicObject s : status) {
            if (!ChkStatusGenEnum.NEW.getGenerateType().equals(s.getString("isnewgenerate"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u65e7\u7248\u672c\u6570\u636e\uff0c\u8bf7\u5148\u5728\u62a5\u8868\u91cd\u65b0\u8fdb\u884c\u52fe\u7a3d\u68c0\u67e5\uff01", (String)"ChkCheckStatusHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            ChkCheckStatusHelper.collectResult(erptProcessIds, erptResult, s);
            ChkCheckStatusHelper.collectResult(rptProcessIds, rptResult, s);
        }
        erptResult.forEach((k, v) -> result.putIfAbsent((String)k, (Pair<ChkStatusEnum, ChkStatusEnum>)Pair.onePair((Object)v, (Object)(rptResult.containsKey(k) ? (ChkStatusEnum)rptResult.get(k) : ChkStatusEnum.UNCHECK))));
        rptResult.forEach((k, v) -> result.putIfAbsent((String)k, (Pair<ChkStatusEnum, ChkStatusEnum>)Pair.onePair((Object)ChkStatusEnum.UNCHECK, (Object)v)));
        return result;
    }

    private static void collectResult(List<Long> processIds, Map<String, ChkStatusEnum> result, DynamicObject s) {
        if (processIds.contains(s.getLong("process"))) {
            String templateNumber = s.getString("tmp.number");
            if (result.get(templateNumber) == ChkStatusEnum.UNPASS) {
                return;
            }
            int chkresult = s.getInt("chkresult");
            if (result.get(templateNumber) == ChkStatusEnum.PASS && chkresult != ChkStatusEnum.UNPASS.getStatus()) {
                return;
            }
            ChkStatusEnum statusEnum = ChkStatusEnum.getStatusEnum((int)chkresult);
            if (statusEnum != null) {
                result.put(templateNumber, statusEnum);
            }
        }
    }

    private static /* synthetic */ void lambda$initStatusMap$7(Multimap enableSetting, Long cslschemeId, List rptPorcessIds, HashMap stsMap, DynamicObject rp) {
        Collection settings = enableSetting.get((Object)rp.getLong("chkformula.id"));
        for (DynamicObject setting : settings) {
            String key = StringUtils.isEmpty((String)rp.getString("cslscheme.id")) || "0".equals(rp.getString("cslscheme.id")) ? cslschemeId + rp.getString("org.id") + setting.getString("multitemplate.fbasedataid.id") + rp.getString("currency.id") : rp.getString("cslscheme.id") + rp.getString("org.id") + setting.getString("multitemplate.fbasedataid.id") + rp.getString("currency.id");
            if (rptPorcessIds.contains(rp.getLong("process.id"))) {
                key = "0" + key;
            }
            if (!stsMap.containsKey(key) || ChkStatusEnum.UNPASS.getStatus() == ((Integer)((Pair)stsMap.get((Object)key)).p1).intValue()) continue;
            stsMap.put(key, Pair.onePair((Object)ChkStatusEnum.UNPASS.getStatus(), (Object)ChkStatusEnum.UNPASS.getStatus()));
        }
    }

    private static /* synthetic */ boolean lambda$initStatusMap$6(Multimap enableSetting, DynamicObject chk) {
        return enableSetting.containsKey((Object)chk.getLong("chkformula.id"));
    }

    private static /* synthetic */ void lambda$initStatusMap$5(Multimap enableSetting, DynamicObject set) {
        enableSetting.put((Object)set.getLong("id"), (Object)set);
    }
}

