/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.serviceHelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaPoolManager;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.script.CommonFormulaModel;
import kd.fi.bcm.business.script.XdmExpressionGenerator;
import kd.fi.bcm.business.serviceHelper.ExpressionServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.formula.EncoderService;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class ChkFormulaServiceHelper {
    public static final List<Pair<String, String>> SYMBOLS = Arrays.asList(Pair.onePair((Object)"1", (Object)"="), Pair.onePair((Object)"2", (Object)">"), Pair.onePair((Object)"3", (Object)">="), Pair.onePair((Object)"4", (Object)"<"), Pair.onePair((Object)"5", (Object)"<="), Pair.onePair((Object)"6", (Object)"<>"));
    private static final Log LOG = LogFactory.getLog(ChkFormulaServiceHelper.class);
    private static final ExpressParser PARSER = new ExpressParser();
    private static final EncoderService ENCODER = new EncoderService();

    public static String changeNum2Symbol(String Number2) {
        for (Pair<String, String> symbol : SYMBOLS) {
            if (!((String)symbol.p1).equals(Number2)) continue;
            return (String)symbol.p2;
        }
        return "";
    }

    public static String changeSymbol2Num(String sym) {
        for (Pair<String, String> symbol : SYMBOLS) {
            if (!((String)symbol.p2).equals(sym)) continue;
            return (String)symbol.p1;
        }
        return "";
    }

    @SDKMark
    public static String tranFormulas(String formula, long modelid, int style) {
        QFilter qFilter2;
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        DynamicObject dot = QueryServiceHelper.queryOne((String)"bcm_chkdisplaysetting", (String)"selectdims", (QFilter[])new QFilter[]{qFilter, qFilter2 = new QFilter("type", "=", (Object)style)});
        if (dot != null && dot.getString("selectdims").equals(" ")) {
            return "";
        }
        String tempFormula = "" + formula;
        try {
            while ((tempFormula.indexOf("V(") > -1 || tempFormula.indexOf("X(") > -1) && tempFormula.indexOf("\")") > 0) {
                if (tempFormula.indexOf("V(") < 0) {
                    tempFormula = ChkFormulaServiceHelper.getTempFormula(tempFormula, "X(", modelid, style);
                    continue;
                }
                if (tempFormula.indexOf("X(") < 0 || tempFormula.indexOf("V(") < tempFormula.indexOf("X(")) {
                    tempFormula = ChkFormulaServiceHelper.getTempFormula(tempFormula, "V(", modelid, style);
                    continue;
                }
                tempFormula = ChkFormulaServiceHelper.getTempFormula(tempFormula, "X(", modelid, style);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return tempFormula;
    }

    private static String getTempFormula(String tempFormula, String str, long modelid, int style) {
        int beginPosition = tempFormula.indexOf(str);
        int endPosition = tempFormula.indexOf("\")", beginPosition);
        String v = tempFormula.substring(beginPosition, endPosition + 2);
        tempFormula = tempFormula.substring(0, beginPosition) + ChkFormulaServiceHelper.tranSingleFormula(v, modelid, style) + tempFormula.substring(endPosition + 2);
        return tempFormula;
    }

    public static String tranFormulasQuick(String formula, long modelid, int style, DynamicObject dot, DynamicObjectCollection templates) {
        if (dot != null && dot.getString("selectdims").equals(" ")) {
            return "";
        }
        String tempFormula = "" + formula;
        String resultFormula = "" + formula;
        try {
            int newVLength = 0;
            while ((tempFormula.indexOf("V(") > -1 || tempFormula.indexOf("X(") > -1) && tempFormula.indexOf("\")") > 0) {
                String newV;
                String v;
                int endPosition;
                int beginPosition;
                if (tempFormula.indexOf("V(") < 0) {
                    beginPosition = tempFormula.indexOf("X(");
                    endPosition = tempFormula.indexOf("\")", beginPosition);
                    v = tempFormula.substring(beginPosition, endPosition + 2);
                    tempFormula = tempFormula.substring(0, beginPosition) + tempFormula.substring(endPosition + 2);
                    newV = ChkFormulaServiceHelper.tranSingleFormulaQuick(v, modelid, style, dot, templates);
                    resultFormula = resultFormula.substring(0, beginPosition + newVLength) + newV + resultFormula.substring(endPosition + newVLength + 2);
                    newVLength += newV.length();
                    continue;
                }
                if (tempFormula.indexOf("X(") < 0 || tempFormula.indexOf("V(") < tempFormula.indexOf("X(")) {
                    beginPosition = tempFormula.indexOf("V(");
                    endPosition = tempFormula.indexOf("\")", beginPosition);
                    v = tempFormula.substring(beginPosition, endPosition + 2);
                    tempFormula = tempFormula.substring(0, beginPosition) + tempFormula.substring(endPosition + 2);
                    newV = ChkFormulaServiceHelper.tranSingleFormulaQuick(v, modelid, style, dot, templates);
                    resultFormula = resultFormula.substring(0, beginPosition + newVLength) + newV + resultFormula.substring(endPosition + newVLength + 2);
                    newVLength += newV.length();
                    continue;
                }
                beginPosition = tempFormula.indexOf("X(");
                endPosition = tempFormula.indexOf("\")", beginPosition);
                v = tempFormula.substring(beginPosition, endPosition + 2);
                tempFormula = tempFormula.substring(0, beginPosition) + tempFormula.substring(endPosition + 2);
                newV = ChkFormulaServiceHelper.tranSingleFormulaQuick(v, modelid, style, dot, templates);
                resultFormula = resultFormula.substring(0, beginPosition + newVLength) + newV + resultFormula.substring(endPosition + newVLength + 2);
                newVLength += newV.length();
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return resultFormula;
    }

    public static String tranFormulasQuick(String formula, long modelid, int style, DynamicObject dot, DynamicObjectCollection templates, String type) {
        if (dot != null && dot.getString("selectdims").equals(" ")) {
            return "";
        }
        String tempFormula = "" + formula;
        String resultFormula = "" + formula;
        try {
            int newVLength = 0;
            while ((tempFormula.indexOf("V(") > -1 || tempFormula.indexOf("X(") > -1) && tempFormula.indexOf("\")") > 0) {
                String newV;
                String v;
                int endPosition;
                int beginPosition;
                if (tempFormula.indexOf("V(") < 0) {
                    beginPosition = tempFormula.indexOf("X(");
                    endPosition = tempFormula.indexOf("\")", beginPosition);
                    v = tempFormula.substring(beginPosition, endPosition + 2);
                    tempFormula = tempFormula.substring(0, beginPosition) + tempFormula.substring(endPosition + 2);
                    newV = ChkFormulaServiceHelper.tranSingleFormulaQuick(v, modelid, style, dot, templates);
                    resultFormula = resultFormula.substring(0, beginPosition + newVLength) + newV + resultFormula.substring(endPosition + newVLength + 2);
                    newVLength += newV.length();
                    continue;
                }
                if (tempFormula.indexOf("X(") < 0 || tempFormula.indexOf("V(") < tempFormula.indexOf("X(")) {
                    beginPosition = tempFormula.indexOf("V(");
                    endPosition = tempFormula.indexOf("\")", beginPosition);
                    v = tempFormula.substring(beginPosition, endPosition + 2);
                    tempFormula = tempFormula.substring(0, beginPosition) + tempFormula.substring(endPosition + 2);
                    newV = ChkFormulaServiceHelper.tranSingleFormulaQuick(v, modelid, style, dot, templates, type);
                    resultFormula = resultFormula.substring(0, beginPosition + newVLength) + newV + resultFormula.substring(endPosition + newVLength + 2);
                    newVLength += newV.length();
                    continue;
                }
                beginPosition = tempFormula.indexOf("X(");
                endPosition = tempFormula.indexOf("\")", beginPosition);
                v = tempFormula.substring(beginPosition, endPosition + 2);
                tempFormula = tempFormula.substring(0, beginPosition) + tempFormula.substring(endPosition + 2);
                newV = ChkFormulaServiceHelper.tranSingleFormulaQuick(v, modelid, style, dot, templates);
                resultFormula = resultFormula.substring(0, beginPosition + newVLength) + newV + resultFormula.substring(endPosition + newVLength + 2);
                newVLength += newV.length();
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return resultFormula;
    }

    private static String tranSingleFormula(String formula, long modelid, int style) {
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        try {
            Pair<String, List<IFormula>> pair = parser.parse(formula, coder);
            StringBuilder sb = new StringBuilder();
            int flag = 0;
            for (int i = 0; i < ((String)pair.p1).length(); ++i) {
                if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                    if (!ExpressionServiceHelper.checkFactorComplete(i, (String)pair.p1)) continue;
                    sb.append(ChkFormulaServiceHelper.translateChkformla(((IFormula)((List)pair.p2).get(flag)).toString(), modelid, style));
                    ++flag;
                    continue;
                }
                sb.append(((String)pair.p1).charAt(i));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String tranSingleFormulaQuick(String formula, long modelid, int style, DynamicObject dot, DynamicObjectCollection templates) {
        if (ChkFormulaServiceHelper.isXdmFormula(formula)) {
            String xdmFormula = ChkFormulaServiceHelper.parseXdmFormula(formula);
            CommonFormulaModel xdmFormulaBuilder = (CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)xdmFormula);
            if (style == 2) {
                return XdmExpressionGenerator.generateFormulaExpressionNotNullMember(xdmFormulaBuilder);
            }
            return (String)xdmFormulaBuilder.getCondition("chinesename");
        }
        try {
            Pair<String, List<IFormula>> pair = PARSER.parse(formula, ENCODER);
            StringBuilder sb = new StringBuilder();
            int flag = 0;
            for (int i = 0; i < ((String)pair.p1).length(); ++i) {
                if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                    if (!ExpressionServiceHelper.checkFactorComplete(i, (String)pair.p1)) continue;
                    sb.append(ChkFormulaServiceHelper.translateChkformlaQuick(((IFormula)((List)pair.p2).get(flag)).toString(), modelid, style, dot, templates));
                    ++flag;
                    continue;
                }
                sb.append(((String)pair.p1).charAt(i));
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            ENCODER.reset();
        }
    }

    private static String tranSingleFormulaQuick(String formula, long modelid, int style, DynamicObject dot, DynamicObjectCollection templates, String type) {
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        try {
            Pair<String, List<IFormula>> pair = parser.parse(formula, coder);
            StringBuilder sb = new StringBuilder();
            int flag = 0;
            for (int i = 0; i < ((String)pair.p1).length(); ++i) {
                if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                    if (!ExpressionServiceHelper.checkFactorComplete(i, (String)pair.p1)) continue;
                    sb.append(ChkFormulaServiceHelper.translateChkformlaQuick(((IFormula)((List)pair.p2).get(flag)).toString(), modelid, style, dot, templates, type));
                    ++flag;
                    continue;
                }
                sb.append(((String)pair.p1).charAt(i));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String translateChkformlaQuick(String formula, long modelid, int style, DynamicObject dot, DynamicObjectCollection templates) {
        if (dot == null) {
            dot = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_chkdisplaysetting"));
            dot.set("selectdims", (Object)(style == 1 ? "account" : "account;changetype"));
        }
        if (dot.getString("selectdims").equals(" ")) {
            return "";
        }
        List selectdims = Arrays.stream(dot.getString("selectdims").split(";")).map(dim -> dim.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        String modelNumber = MemberReader.findModelNumberById((Object)modelid);
        Map dimShortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)modelNumber);
        ArrayList selectShort = new ArrayList();
        for (Map.Entry entry : dimShortNumber2NumberMap.entrySet()) {
            if (!selectdims.contains(((String)entry.getValue()).toLowerCase(Locale.ENGLISH))) continue;
            selectShort.add(entry.getKey());
        }
        Formula fm = new Formula(formula);
        for (DimFormula dimFormula : fm.getDimFormulas()) {
            if (!selectShort.contains(dimFormula.getShortNum())) continue;
            dimFormula.setIsselect(true);
        }
        StringBuilder result = new StringBuilder();
        if (style == 2) {
            result.append("V(");
            result.append(kd.bos.util.StringUtils.isEmpty((String)fm.getTemplate()) ? "" : fm.getTemplate() + '!');
            for (DimFormula df : fm.getDimFormulas()) {
                if (!df.isselect) continue;
                result.append('\"');
                result.append(df.getShortNum()).append('.').append(df.memberNum).append("\",");
            }
            result.deleteCharAt(result.length() - 1);
            result.append(')');
        } else {
            result.append(kd.bos.util.StringUtils.isEmpty((String)fm.getTemplate()) ? "" : ChkFormulaServiceHelper.getTemplateName(fm.getTemplate(), templates) + '!');
            Map map = MemberReader.getDimNumberMapNameById((long)modelid);
            String name = null;
            String dimname = null;
            for (DimFormula df : fm.getDimFormulas()) {
                if (!df.isselect) continue;
                if (!dimShortNumber2NumberMap.containsKey(df.getShortNum())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ef4\u5ea6%1$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ChkFormulaServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                String dimNumber = (String)dimShortNumber2NumberMap.get(df.getShortNum());
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)df.getMemberNum());
                if (node == IDNumberTreeNode.NotFoundTreeNode) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ef4\u5ea6%1$s\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ChkFormulaServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                name = node.getName();
                dimname = (String)map.get(dimNumber);
                result.append(dimname);
                result.append('!');
                result.append(name);
                result.append('|');
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            } else {
                result.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5176\u4ed6\u53ef\u5c55\u793a\u7684\u7ef4\u5ea6\u3002", (String)"ChkFormulaServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        return result.toString();
    }

    public static String translateChkformlaQuick(String formula, long modelid, int style, DynamicObject dot, DynamicObjectCollection templates, String type) {
        if (dot == null) {
            dot = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_chkdisplaysetting"));
            dot.set("selectdims", (Object)(style == 1 ? "account" : "account;changetype"));
        }
        if (dot.getString("selectdims").equals(" ")) {
            return "";
        }
        List<String> selectdims = Arrays.asList(dot.getString("selectdims").split(";"));
        String modelNumber = MemberReader.findModelNumberById((Object)modelid);
        Map dimShortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)modelNumber);
        ArrayList selectShort = new ArrayList();
        for (Map.Entry entry : dimShortNumber2NumberMap.entrySet()) {
            if (!selectdims.contains(((String)entry.getValue()).toLowerCase(Locale.ENGLISH))) continue;
            selectShort.add(entry.getKey());
        }
        Formula fm = new Formula(formula);
        for (DimFormula dimFormula : fm.getDimFormulas()) {
            if (!selectShort.contains(dimFormula.getShortNum())) continue;
            dimFormula.setIsselect(true);
        }
        StringBuilder result = new StringBuilder();
        if (style == 2) {
            result.append("V(");
            result.append(kd.bos.util.StringUtils.isEmpty((String)fm.getTemplate()) ? "" : fm.getTemplate() + '!');
            for (DimFormula df : fm.getDimFormulas()) {
                if (!df.isselect) continue;
                result.append('\"');
                result.append(df.getShortNum()).append('.').append(df.memberNum).append("\",");
            }
            result.deleteCharAt(result.length() - 1);
            result.append(')');
        } else {
            String string = MemberReader.findModelNumberById((Object)modelid);
            Map dimShortNum2NumMap = MemberReader.getDimensionShortNumber2NumberMap((String)string);
            Map dimNumber2NameMap = MemberReader.getDimNumberMapNameById((long)modelid);
            if ("name".equals(type)) {
                result.append(kd.bos.util.StringUtils.isEmpty((String)fm.getTemplate()) ? "" : ChkFormulaServiceHelper.getTemplateName(fm.getTemplate(), templates) + '!');
                for (DimFormula df : fm.getDimFormulas()) {
                    if (!df.isselect) continue;
                    String dimNum = (String)dimShortNum2NumMap.get(df.getShortNum());
                    IDNumberTreeNode memberNode = MemberReader.findMemberByNumber((String)string, (String)dimNum, (String)df.getMemberNum());
                    String name = memberNode.getName();
                    String dimname = (String)dimNumber2NameMap.get(dimNum);
                    result.append(dimname);
                    result.append('!');
                    result.append(name);
                    result.append('|');
                }
            } else {
                result.append(kd.bos.util.StringUtils.isEmpty((String)fm.getTemplate()) ? "" : fm.getTemplate() + "-" + ChkFormulaServiceHelper.getTemplateName(fm.getTemplate(), templates) + '!');
                for (DimFormula df : fm.getDimFormulas()) {
                    if (!df.isselect) continue;
                    String dimNum = (String)dimShortNum2NumMap.get(df.getShortNum());
                    IDNumberTreeNode memberNode = MemberReader.findMemberByNumber((String)string, (String)dimNum, (String)df.getMemberNum());
                    String name = memberNode.getName();
                    String number = memberNode.getNumber();
                    String dimname = (String)dimNumber2NameMap.get(dimNum);
                    result.append(dimNum).append("-").append(dimname);
                    result.append('!');
                    result.append(number).append("-").append(name);
                    result.append('|');
                }
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            } else {
                result.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5176\u4ed6\u53ef\u5c55\u793a\u7684\u7ef4\u5ea6\u3002", (String)"ChkFormulaServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        return result.toString();
    }

    public static String translateChkformla(String formula, long modelid, int style) {
        return ChkFormulaServiceHelper.translateChkformla(formula, modelid, style, dimNumber -> {}, false);
    }

    public static boolean isXdmFormula(String formula) {
        return formula.startsWith("X(\"");
    }

    public static boolean hasXdmFormula(String formula) {
        return formula.contains("X(\"");
    }

    public static String translateChkformla(String formula, long modelid, int style, Consumer<String> checkDim, boolean throwExIfNoMember) {
        return ChkFormulaServiceHelper.translateChkformla(formula, modelid, style, checkDim, null, throwExIfNoMember);
    }

    public static String translateChkformla(String formula, long modelid, int style, Consumer<String> checkDim, BiFunction<String, String, Boolean> func, boolean throwExIfNoMember) {
        if (ChkFormulaServiceHelper.isXdmFormula(formula)) {
            return (String)((CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)ChkFormulaServiceHelper.parseXdmFormula(formula))).getCondition("chinesename");
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        QFilter qFilter2 = new QFilter("type", "=", (Object)style);
        DynamicObject dot = (DynamicObject)ThreadCache.get((Object)(modelid + "_" + style), () -> QueryServiceHelper.queryOne((String)"bcm_chkdisplaysetting", (String)"selectdims", (QFilter[])new QFilter[]{qFilter, qFilter2}));
        if (dot == null) {
            dot = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_chkdisplaysetting"));
            dot.set("selectdims", (Object)(style != 1 && MemberReader.isExistChangeTypeDimension((long)modelid) ? "account;changetype" : "account"));
        }
        if (dot.getString("selectdims").equals(" ")) {
            return "";
        }
        List selectdims = Arrays.stream(dot.getString("selectdims").split(";")).map(dim -> dim.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        ArrayList selectShort = new ArrayList();
        String modelNum = MemberReader.findModelNumberById((Object)modelid);
        Map dimensionShortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum);
        dimensionShortNumber2NumberMap.forEach((shortNumber, number) -> {
            if (selectdims.contains(number.toLowerCase(Locale.ENGLISH))) {
                selectShort.add(shortNumber);
            }
        });
        Formula fm = new Formula(formula);
        for (DimFormula dimFormula : fm.getDimFormulas()) {
            checkDim.accept(dimFormula.getShortNum());
            if (!selectShort.contains(dimFormula.getShortNum())) continue;
            dimFormula.setIsselect(true);
        }
        StringBuilder result = new StringBuilder();
        if (style == 2) {
            result.append("V(");
            result.append(kd.bos.util.StringUtils.isEmpty((String)fm.getTemplate()) ? "" : fm.getTemplate() + '!');
            for (DimFormula df : fm.getDimFormulas()) {
                if (!df.isselect) continue;
                result.append('\"');
                result.append(df.getShortNum()).append('.').append(df.memberNum).append("\",");
            }
            result.deleteCharAt(result.length() - 1);
            result.append(')');
        } else {
            QFilter qFilter3 = new QFilter("templatetype", "in", Arrays.asList(String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType()))).and(new QFilter("status", "=", (Object)"1"));
            DynamicObjectCollection dycol = (DynamicObjectCollection)ThreadCache.get((Object)("alltemplates" + modelNum), () -> QueryServiceHelper.query((String)"bcm_templateentity", (String)"number,name", (QFilter[])new QFilter[]{qFilter, tempFilter}, (String)"versionnumber desc"));
            result.append(kd.bos.util.StringUtils.isEmpty((String)fm.getTemplate()) ? "" : ChkFormulaServiceHelper.getTemplateName(fm.getTemplate(), dycol) + '!');
            for (DimFormula df : fm.getDimFormulas()) {
                Long dimId;
                if (func != null && func.apply(df.getShortNum(), df.getMemberNum()).booleanValue()) continue;
                String dimNumber = (String)dimensionShortNumber2NumberMap.get(df.getShortNum());
                DynamicObject mem = null;
                if (StringUtils.isNotEmpty((String)dimNumber) && (dimId = MemberReader.getDimensionIdByNum((long)modelid, (String)dimNumber)) != null) {
                    mem = MemberReader.getDimensionDynById((long)dimId);
                }
                if (mem == null && throwExIfNoMember) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ef4\u5ea6%1$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ChkFormulaServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), df.getShortNum()));
                }
                IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNum, (String)dimNumber, (String)df.getMemberNum());
                if (memberByNumber == IDNumberTreeNode.NotFoundTreeNode && throwExIfNoMember) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ef4\u5ea6%1$s\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ChkFormulaServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), df.getShortNum(), df.getMemberNum()));
                }
                if (!df.isselect || mem == null || memberByNumber == IDNumberTreeNode.NotFoundTreeNode) continue;
                result.append(mem.getString("name"));
                result.append('!');
                result.append(memberByNumber.getName());
                result.append('|');
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            } else {
                result.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5176\u4ed6\u53ef\u5c55\u793a\u7684\u7ef4\u5ea6\u3002", (String)"ChkFormulaServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        return result.toString();
    }

    public static String translateChkformla(String formula, long modelid, int style, String dims) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        List<String> selectdims = Arrays.asList(dims.split(";"));
        ArrayList<String> selectShort = new ArrayList<String>();
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter[]{qFilter});
        for (Object dy : col) {
            if (!selectdims.contains(dy.getString("number").toLowerCase(Locale.ENGLISH))) continue;
            selectShort.add(dy.getString("shortnumber"));
        }
        Formula fm = new Formula(formula);
        for (DimFormula dimFormula : fm.getDimFormulas()) {
            if (!selectShort.contains(dimFormula.getShortNum())) continue;
            dimFormula.setIsselect(true);
        }
        StringBuilder result = new StringBuilder();
        if (style == 2) {
            result.append("V(");
            result.append(kd.bos.util.StringUtils.isEmpty((String)fm.getTemplate()) ? "" : fm.getTemplate() + '!');
            for (DimFormula df : fm.getDimFormulas()) {
                if (!df.isselect) continue;
                result.append('\"');
                result.append(df.getShortNum()).append('.').append(df.memberNum).append("\",");
            }
            result.deleteCharAt(result.length() - 1);
            result.append(')');
        } else {
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
            result.append(kd.bos.util.StringUtils.isEmpty((String)fm.getTemplate()) ? "" : ChkFormulaServiceHelper.getTemplateName(fm.getTemplate(), dynamicObjectCollection) + '!');
            for (DimFormula df : fm.getDimFormulas()) {
                if (!df.isselect) continue;
                String entityName = DimensionServiceHelper.getDimMembEntityNumByShortNum(df.getShortNum());
                result.append(DimensionServiceHelper.queryDimensionMemberByNumber(entityName, modelid, df.getMemberNum()).getString("name"));
                result.append('|');
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            } else {
                result.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5176\u4ed6\u53ef\u5c55\u793a\u7684\u7ef4\u5ea6\u3002", (String)"ChkFormulaServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        return result.toString();
    }

    public static String getTemplateName(String templateNumber, DynamicObjectCollection col) {
        templateNumber = templateNumber.replaceAll(String.valueOf('\"'), "");
        for (DynamicObject dot : col) {
            if (!dot.getString("number").equals(templateNumber)) continue;
            return dot.getString("name");
        }
        return "";
    }

    public static String formatDim(String dim, String dimNumber) {
        return String.format("%s['%s']", dim, dimNumber);
    }

    public static String formatXdmExpression(String extendsFormula) {
        String xdmFormula = ChkFormulaServiceHelper.parseXdmFormula(extendsFormula);
        String processNum = null;
        String atNum = null;
        Matcher matcher = ParamConstant.PATTERN_BP.matcher(extendsFormula);
        Matcher matcher1 = ParamConstant.PATTERN_AT.matcher(extendsFormula);
        if (matcher.find()) {
            processNum = matcher.group().split("\\.")[1].replace("\"", "");
        }
        if (matcher1.find()) {
            atNum = matcher1.group().split("\\.")[1].replace("\"", "");
        }
        CommonFormulaModel xdmFormulaBuilder = (CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)xdmFormula);
        String expression = (String)xdmFormulaBuilder.getCondition("extendsFormula");
        for (DimTypesEnum dimTypesEnum : ParamConstant.CONTEXT_DIMENSIONS_ENUM) {
            if (dimTypesEnum == DimTypesEnum.PROCESS && expression.contains(ChkFormulaServiceHelper.formatDim(dimTypesEnum.getNumber(), null))) {
                expression = expression.replace(ChkFormulaServiceHelper.formatDim(dimTypesEnum.getNumber(), null), ChkFormulaServiceHelper.formatDim(dimTypesEnum.getNumber(), processNum));
            }
            if (dimTypesEnum == DimTypesEnum.AUDITTRIAL && expression.contains(ChkFormulaServiceHelper.formatDim(dimTypesEnum.getNumber(), null))) {
                expression = expression.replace(ChkFormulaServiceHelper.formatDim(dimTypesEnum.getNumber(), null), ChkFormulaServiceHelper.formatDim(dimTypesEnum.getNumber(), atNum));
            }
            expression = expression.replace(ChkFormulaServiceHelper.formatDim(dimTypesEnum.getNumber(), null), "").replace(",,", ",").replace("(,", "(").replace(",)", ")");
        }
        return expression;
    }

    public static void checkSpecialFunctionIsNumber(FormulaPoolManager poolMng, long modelId) {
        HashMap<String, String> dimShortNumbers = new HashMap<String, String>();
        List<String> dims = ChkFormulaServiceHelper.getNeedCheckDims(modelId, dimShortNumbers);
        Map<String, Integer> dataTypes = ChkFormulaServiceHelper.getVllDataType(modelId, dims);
        List<IFormula> vFormulaList = poolMng.pull("V");
        if (vFormulaList == null) {
            return;
        }
        ChkFormulaServiceHelper.checkFunctionDataType("ROUND", poolMng, dimShortNumbers, dims, dataTypes, vFormulaList);
        ChkFormulaServiceHelper.checkFunctionDataType("ABS", poolMng, dimShortNumbers, dims, dataTypes, vFormulaList);
    }

    private static void checkFunctionDataType(String funName, FormulaPoolManager poolMng, Map<String, String> dimShortNumbers, List<String> dims, Map<String, Integer> dataTypes, List<IFormula> vFormulaList) {
        if (poolMng.pull(funName) != null) {
            for (IFormula formula : poolMng.pull(funName)) {
                String tempFormula = formula.toString().replace(" ", "");
                if (!vFormulaList.stream().anyMatch(iFormula -> tempFormula.contains(iFormula.toString()) && !ChkFormulaServiceHelper.checkVFunctionIsNumberType(iFormula, dataTypes, dims, dimShortNumbers))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u91cc\u7684\u6570\u636e\u7c7b\u578b\u53ea\u80fd\u662f\uff1a\u9ed8\u8ba4\u7c7b\u578b\u3001\u6570\u503c\u3001\u8d27\u5e01\u3001\u6bd4\u4f8b\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"ChkCheckServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]), funName.toLowerCase(Locale.ENGLISH)));
            }
        }
    }

    private static Map<String, Integer> getVllDataType(long modelId, List<String> dims) {
        HashMap<String, Integer> dataTypes = new HashMap<String, Integer>();
        for (String dim : dims) {
            Map memberDataType = MemberReader.getMemberDataType((long)modelId, (String)DimEntityNumEnum.getEntieyNumByNumber((String)dim), (String)dim);
            memberDataType.forEach((k, v) -> dataTypes.put((String)k, v.getCode()));
        }
        return dataTypes;
    }

    private static List<String> getNeedCheckDims(long modelId, Map<String, String> dimShortNumbers) {
        List dims = DataTypeEnum.getDataTypePerSetDims((Object)modelId);
        for (String dim : dims) {
            dimShortNumbers.put(dim, DimTypesEnum.getShortNumberByNumber((String)dim));
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)"bcm", (String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter[]{new QFilter("model,membermodel", "=", (Object)modelId), new QFilter("issysdimension", "=", (Object)"0")}, null);
        if (ds != null) {
            while (ds.hasNext()) {
                Row dataRow = ds.next();
                dims.add(dataRow.getString("number"));
                dimShortNumbers.put(dataRow.getString("number"), dataRow.getString("shortnumber"));
            }
        }
        return dims;
    }

    private static boolean checkVFunctionIsNumberType(IFormula vf, Map<String, Integer> dataTypes, List<String> dims, Map<String, String> dimShortNumbers) {
        boolean isNumberType = false;
        int dataType = 0;
        block0: for (String dim : dims) {
            if (dataType > 0) break;
            String dimShortNumber = dimShortNumbers.get(dim);
            for (int k = 0; k < vf.getParamList().size(); ++k) {
                ParamItem pi = (ParamItem)vf.getParamList().get(k);
                String sn = pi.toString().split("\\.")[0];
                String sm = pi.toString().split("\\.")[1];
                if (!sn.equalsIgnoreCase(dimShortNumber)) continue;
                String key = dim + "_" + sm;
                if (dataTypes.get(key) == null || (dataType = dataTypes.get(key).intValue()) != DataTypeEnum.ENUMTP.getCode() || dataTypes.get(key + "_item") == null) continue block0;
                dataType = dataTypes.get(key + "_item");
                continue block0;
            }
        }
        if (dataType < 3 || dataType == 5) {
            isNumberType = true;
        }
        return isNumberType;
    }

    public static boolean includeExcelFormula(FormulaPoolManager poolMng) {
        boolean isExcel = false;
        if (poolMng.pull("IF") != null || poolMng.pull("AND") != null || poolMng.pull("OR") != null) {
            isExcel = true;
        }
        return isExcel;
    }

    public static List<String> getVList(String formula) {
        return (List)GlobalCacheServiceHelper.getOrLoadChkCheckCache((String)String.format("%s|getVList", formula), () -> ChkFormulaServiceHelper.getFormulaStringList(formula, VFormula.getVName()));
    }

    public static List<String> getXList(String formula) {
        return (List)GlobalCacheServiceHelper.getOrLoadChkCheckCache((String)String.format("%s|getXList", formula), () -> ChkFormulaServiceHelper.getFormulaStringList(formula, "X"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IFormula> getIFormulaList(String fullformula, String formulaName) {
        Pair<String, List<IFormula>> pair;
        try {
            pair = PARSER.parse(fullformula, ENCODER);
        }
        catch (Exception e) {
            LOG.error(String.format("parse formula error! formula[%s]", fullformula), (Throwable)e);
            ArrayList<IFormula> arrayList = new ArrayList<IFormula>();
            return arrayList;
        }
        finally {
            ENCODER.reset();
        }
        return ((List)pair.p2).stream().filter(f -> formulaName.equals(f.getName())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFormulaStringList(String fullformula, String formulaName) {
        Pair<String, List<IFormula>> pair;
        if (kd.bos.util.StringUtils.isEmpty((String)fullformula)) {
            return new ArrayList<String>();
        }
        try {
            pair = PARSER.parse(fullformula, ENCODER);
        }
        catch (Exception e) {
            LOG.error(String.format("parse formula error! formula[%s]", fullformula), (Throwable)e);
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        finally {
            ENCODER.reset();
        }
        return ((List)pair.p2).stream().filter(f -> formulaName.equals(f.getName())).map(Object::toString).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<IFormula>> getFormulaStringList(String fullformula, List<String> formulaNames) {
        Pair<String, List<IFormula>> pair;
        if (kd.bos.util.StringUtils.isEmpty((String)fullformula)) {
            return new HashMap<String, List<IFormula>>();
        }
        try {
            pair = PARSER.parse(fullformula, ENCODER);
        }
        catch (Exception e) {
            LOG.error(String.format("parse formula error! formula[%s]", fullformula), (Throwable)e);
            HashMap<String, List<IFormula>> hashMap = new HashMap<String, List<IFormula>>();
            return hashMap;
        }
        finally {
            ENCODER.reset();
        }
        return ((List)pair.p2).stream().filter(f -> formulaNames.contains(f.getName())).collect(Collectors.groupingBy(IFormula::getName));
    }

    public static boolean isJudgeFormula(String formula) {
        return (Boolean)GlobalCacheServiceHelper.getOrLoadChkCheckCache((String)("isJudgeFormula" + formula), () -> {
            Map<String, List<IFormula>> formulaStringList = ChkFormulaServiceHelper.getFormulaStringList(formula, Arrays.asList("IF", "AND", "OR"));
            return MapUtils.isNotEmpty(formulaStringList);
        });
    }

    public static String parseXdmFormula(String extendsFormula) {
        if (!ChkFormulaServiceHelper.hasXdmFormula(extendsFormula)) {
            return extendsFormula;
        }
        int start = extendsFormula.indexOf("X(\"");
        int subStart = start + "X(\"".length();
        int end = extendsFormula.indexOf("\"", subStart);
        return extendsFormula.substring(subStart, end);
    }

    public static CommonFormulaModel parseXdmFormulaModel(String extendsFormula) {
        String formula = ChkFormulaServiceHelper.parseXdmFormula(extendsFormula);
        return (CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)formula);
    }

    public static String getXdmFormula(IFormula f, int style) {
        CommonFormulaModel xdmFormulaBuilder = (CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)((ParamItem)f.getParamList().get(0)).toString());
        if (style == 2) {
            return (String)xdmFormulaBuilder.getCondition("extendsFormula");
        }
        return (String)xdmFormulaBuilder.getCondition("chinesename");
    }

    public static Pair<String, List<IFormula>> parseFormula(String formula) {
        Pair<String, List<IFormula>> pair = Pair.onePair(null, null);
        try {
            pair = PARSER.parse(formula, ENCODER);
        }
        catch (Exception e) {
            LOG.error(String.format("parse formula[%s] error!", formula), (Throwable)e);
        }
        finally {
            ENCODER.reset();
        }
        return pair;
    }

    public static String replaceSpace(String formula) {
        return formula.replace(" ", "");
    }

    static class DimFormula {
        private String shortNum;
        private String memberNum;
        private boolean isselect;

        public DimFormula(String dimformula) {
            int pointIndex = dimformula.indexOf(46);
            this.shortNum = dimformula.substring(0, pointIndex);
            this.memberNum = dimformula.substring(pointIndex + 1, dimformula.length());
            this.isselect = false;
        }

        public String getShortNum() {
            return this.shortNum;
        }

        public String getMemberNum() {
            return this.memberNum;
        }

        public boolean isIsselect() {
            return this.isselect;
        }

        public void setIsselect(boolean isselect) {
            this.isselect = isselect;
        }
    }

    static class Formula {
        private List<DimFormula> formulas = new ArrayList<DimFormula>(10);
        private String template = "";

        public Formula(String formula) {
            formula = formula.substring(2, formula.length() - 1);
            ArrayList dims = new ArrayList();
            String[] temp = formula.split(",");
            boolean hasTemplate = false;
            if (temp[0].contains("@TMP")) {
                this.template = temp[0].replaceAll("@TMP.", "");
                hasTemplate = true;
            }
            Collections.addAll(dims, temp);
            if (hasTemplate) {
                dims.remove(0);
            }
            for (String s : dims) {
                this.formulas.add(new DimFormula(s.replaceAll(String.valueOf('\"'), "")));
            }
        }

        public List<DimFormula> getDimFormulas() {
            return this.formulas;
        }

        public String getTemplate() {
            return this.template;
        }
    }
}

