/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.serviceHelper.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.model.ChkResultModel;
import kd.fi.bcm.business.chkcheck.model.ChkStatusBuilder;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.ChkCheckService;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.ChkCtxConstant;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.CheckResultenum;
import kd.fi.bcm.common.enums.chkcheck.ChkCheckReportModeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractChkCheckService
implements ChkCheckService {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractChkCheckService.class);

    @Override
    public CheckResultenum check(CalculateService service) {
        ICalContext ctx = service.get_ctx();
        this.beforeCheck(ctx);
        List<ChkFormulaModel> allFormulaModel = this.getAllFormulaModel(ctx);
        this.deleteReports(ctx);
        ChkStatusBuilder csb = new ChkStatusBuilder(ctx);
        if (CollectionUtils.isEmpty(allFormulaModel)) {
            ctx.setProperty("noFormula", true);
            ctx.setProperty("csb", csb);
            csb.save();
            this.updateMergeChkStatus(ctx, CheckResultenum.NOFORMULA);
            return CheckResultenum.NOFORMULA;
        }
        ChkCheckServiceHelper.removeRptProcess(ctx);
        if (CollectionUtils.isEmpty(ctx.getProcessList()) && CollectionUtils.isEmpty((Collection)((Collection)ctx.getProperty("report_process_list")))) {
            ctx.setProperty("csb", csb);
            csb.save();
            this.updateMergeChkStatus(ctx, CheckResultenum.SUCCESS);
            return CheckResultenum.SUCCESS;
        }
        List<ChkResultModel> chkResultModels = this.initFormulaResultModel(service, allFormulaModel);
        if (CollectionUtils.isEmpty(chkResultModels)) {
            ctx.setProperty("csb", csb);
            csb.save();
            this.updateMergeChkStatus(ctx, CheckResultenum.SUCCESS);
            return CheckResultenum.SUCCESS;
        }
        ChkCheckServiceHelper.batchSetExpandFormula2Model(service, chkResultModels);
        boolean isBatch = !ConfigServiceHelper.getBoolParam(ctx.getCubeNumber(), "isSingleChkCheck");
        String traceKey = String.format("ChkCheckCalculate:%s|%s|%s|%s", ctx.getYear(), ctx.getPeriod(), ctx.getScenario(), ctx.getOrg());
        try (TraceSpan span = Tracer.create((String)traceKey, (String)"ChkCheckCalculate");){
            service.batchCalculate(isBatch);
        }
        ArrayList<DynamicObject> newReportAfterCheck = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> oldReportAfterCheck = new ArrayList<DynamicObject>();
        CheckResultenum result = this.checkResult(service, csb, chkResultModels, newReportAfterCheck, oldReportAfterCheck);
        this.afterCheck(ctx, csb, newReportAfterCheck, oldReportAfterCheck);
        return result;
    }

    protected void updateMergeChkStatus(ICalContext ctx, CheckResultenum chkResult) {
    }

    protected CheckResultenum checkResult(CalculateService service, ChkStatusBuilder csb, List<ChkResultModel> chkResultModels, List<DynamicObject> newReportAfterCheck, List<DynamicObject> oldReportAfterCheck) {
        ICalContext ctx = service.get_ctx();
        Map<String, List<DynamicObject>> oldresultmap = this.getOldresultmap(ctx);
        ctx.setProperty("allresultkey", new ArrayList<String>(oldresultmap.keySet()));
        return this.checkResult(service, csb, chkResultModels, newReportAfterCheck, oldReportAfterCheck, oldresultmap);
    }

    protected List<ChkResultModel> initFormulaResultModel(CalculateService service, List<ChkFormulaModel> chkFormulaModels) {
        ArrayList<ChkResultModel> chkResultModels = new ArrayList<ChkResultModel>();
        ChkCheckServiceHelper.addFormulaResultModel(service, chkFormulaModels, chkResultModels);
        this.customOperation(service.get_ctx(), chkResultModels);
        return chkResultModels;
    }

    protected void customOperation(ICalContext ctx, List<ChkResultModel> chkResultModels) {
    }

    protected void deleteInvalidReports(ICalContext ctx, List<DynamicObject> oldReportAfterRecheck) {
    }

    protected CheckResultenum checkResult(CalculateService service, ChkStatusBuilder csb, List<ChkResultModel> chkResultModels, List<DynamicObject> newReportAfterCheck, List<DynamicObject> oldReportAfterCheck, Map<String, List<DynamicObject>> oldresultmap) {
        ICalContext ctx = service.get_ctx();
        HashMap<String, Boolean> allChkResultModel = new HashMap<String, Boolean>();
        HashMap<String, Set<String>> leftAndRightFormulas = new HashMap<String, Set<String>>();
        for (ChkResultModel resultModel : chkResultModels) {
            String fulllformula = ChkCheckServiceHelper.getFulllformula(service, ctx, resultModel);
            String fullrformula = ChkCheckServiceHelper.getFullrformula(service, ctx, resultModel);
            resultModel.setFulllformula(fulllformula);
            resultModel.setFullrformula(fullrformula);
            String chkId = String.valueOf(resultModel.getSetid());
            leftAndRightFormulas.computeIfAbsent(chkId, k -> new HashSet()).add(fulllformula + "@@@" + fullrformula);
        }
        this.checkIfChkSettingSame(oldresultmap, allChkResultModel, leftAndRightFormulas);
        CheckResultenum issuccess = CheckResultenum.SUCCESS;
        for (ChkResultModel resultModel : chkResultModels) {
            Map processList = (Map)ctx.getProperty("report_process");
            if (!CollectionUtils.isNotEmpty((Collection)((Collection)processList.get(resultModel.getSetid())))) continue;
            String filledProcess = resultModel.getProcess();
            if (filledProcess == null) {
                for (String process : (List)processList.get(resultModel.getSetid())) {
                    String currency = this.getCurrency(ctx, process);
                    if (ChkCheckReportModeEnum.MIX.getMode().equals(ctx.getProperty("report_process_mode")) && !currency.equals(resultModel.getCurrency())) continue;
                    resultModel.setProcess(process);
                    resultModel.setCurrency(currency);
                    CheckResultenum result = this.getCheckResult(service, csb, newReportAfterCheck, oldReportAfterCheck, oldresultmap, resultModel, allChkResultModel);
                    issuccess = this.dealCheckResult(issuccess, result);
                }
                continue;
            }
            String currency = this.getCurrency(ctx, filledProcess);
            resultModel.setCurrency(currency);
            CheckResultenum result = this.getCheckResult(service, csb, newReportAfterCheck, oldReportAfterCheck, oldresultmap, resultModel, allChkResultModel);
            issuccess = this.dealCheckResult(issuccess, result);
        }
        return issuccess;
    }

    private CheckResultenum dealCheckResult(CheckResultenum issuccess, CheckResultenum result) {
        if (result.getIndex() > issuccess.getIndex()) {
            issuccess = result;
        }
        return issuccess;
    }

    protected Map<String, List<DynamicObject>> getOldresultmap(ICalContext ctx) {
        List<QFilter> fl = this.oldResultMapFilter(ctx);
        return ChkCheckServiceHelper.getOldResultMap(fl);
    }

    protected void checkIfChkSettingSame(Map<String, List<DynamicObject>> oldresultmap, Map<String, Boolean> allChkResultModel, Map<String, Set<String>> leftAndRightFormulas) {
        leftAndRightFormulas.forEach((chkId, formulas) -> oldresultmap.forEach((k, v) -> {
            if (k.contains((CharSequence)chkId)) {
                boolean chkSettingSame = ChkCheckServiceHelper.isChkSettingSame(v, formulas);
                allChkResultModel.put((String)k, chkSettingSame);
            }
        }));
    }

    protected CheckResultenum getCheckResult(CalculateService service, ChkStatusBuilder csb, List<DynamicObject> newReportAfterCheck, List<DynamicObject> oldReportAfterCheck, Map<String, List<DynamicObject>> oldresultmap, ChkResultModel resultModel, Map<String, Boolean> allChkResultModel) {
        DynamicObject report = this.getReport(service, newReportAfterCheck, oldReportAfterCheck, oldresultmap, resultModel, allChkResultModel);
        if (this.checkReport(report, resultModel.getFulllformula(), resultModel.getFullrformula())) {
            return CheckResultenum.SUCCESS;
        }
        ICalContext ctx = service.get_ctx();
        String process = resultModel.getProcess();
        String currency = resultModel.getCurrency();
        this.fillRepProperty(ctx, service, resultModel, report);
        ChkCheckServiceHelper.setProcess2Report(ctx, report, process, currency);
        this.checkPass(report, resultModel);
        CheckResultenum result = ChkCheckServiceHelper.fillCheckResult2Rep(resultModel, report);
        csb.collectStatus(resultModel.getCkm(), process, AbstractChkCheckService.isReportPass(report));
        return result;
    }

    protected void fillRepProperty(ICalContext ctx, CalculateService service, ChkResultModel resultModel, DynamicObject report) {
        ChkCheckServiceHelper.fillRepProperty(service, resultModel, report);
        if (resultModel.isText()) {
            if (ctx.getProperty("reportHasTxt") != null) {
                ((HashMap)ctx.getProperty("reportHasTxt")).put(report.getLong("id"), true);
            } else {
                HashMap<Long, Boolean> reportHasTxt = new HashMap<Long, Boolean>(16);
                reportHasTxt.put(report.getLong("id"), true);
                ctx.setProperty("reportHasTxt", reportHasTxt);
            }
        }
    }

    private static boolean isReportPass(DynamicObject report) {
        return ChkResultTypeEnum.UNPASS.getIndex() != report.getInt("chkresulttype");
    }

    protected boolean checkReport(DynamicObject report, String fulllformula, String fullrformula) {
        return report == null;
    }

    protected DynamicObject getReport(CalculateService service, List<DynamicObject> newReportAfterCheck, List<DynamicObject> oldReportAfterCheck, Map<String, List<DynamicObject>> oldresultmap, ChkResultModel resultModel, Map<String, Boolean> allChkResultModel) {
        ICalContext ctx = service.get_ctx();
        DynamicObject report = ChkCheckServiceHelper.getReport(ctx, oldReportAfterCheck, oldresultmap, resultModel, allChkResultModel);
        if (report == null) {
            report = ChkCheckServiceHelper.initReportByCtx(ctx);
            newReportAfterCheck.add(report);
        }
        return report;
    }

    protected void checkPass(DynamicObject report, ChkResultModel resultModel) {
        if (!resultModel.isPass()) {
            int index = report.getInt("chkresulttype");
            if (ChkResultTypeEnum.FORCEPASS.getIndex() == index) {
                resultModel.setForcePass(true);
            }
        }
    }

    protected String getCurrency(ICalContext ctx, String process) {
        return ctx.getCurrency();
    }

    protected List<QFilter> oldResultMapFilter(ICalContext ctx) {
        List<Long> ids = ChkCheckServiceHelper.getAllFormulaIdsByCTX(ctx, null);
        List<QFilter> comFilter = ChkCheckServiceHelper.getComFilter(ctx);
        comFilter.add(new QFilter("chkformula", "in", ids));
        return comFilter;
    }

    protected void deleteLastCheckReports(ICalContext ctx) {
        List<QFilter> fdl = ChkCheckServiceHelper.getDeleteDirtyFilters(ctx);
        fdl.add(new QFilter("note", "=", (Object)""));
        fdl.add(new QFilter("chkresulttype", "!=", (Object)String.valueOf(ChkResultTypeEnum.FORCEPASS.getIndex())));
        if (CollectionUtils.isNotEmpty(fdl)) {
            DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])fdl.toArray(new QFilter[0]));
        }
    }

    protected List<ChkFormulaModel> getAllFormulaModel(ICalContext ctx) {
        return ChkCheckServiceHelper.getFormulaModelListByCTX(ctx, CHKFormulaStatusEnum.enable.getIndex());
    }

    protected List<DynamicObject> getAllFormulaSettings(ICalContext ctx) {
        return ChkCheckServiceHelper.getFormulaListByCTX(ctx, CHKFormulaStatusEnum.enable.getIndex());
    }

    protected void fillCurrencyAndProcess2Ctx(ICalContext ctx, long modelId) {
        this.fillCurrency(ctx, modelId);
        this.fillProcess(ctx);
    }

    protected void fillProcessListByProcess(ICalContext ctx) {
        ChkCheckServiceHelper.fillProcessListByProcess(ctx);
    }

    protected void fillProcessListByCurrency(ICalContext ctx) {
        if (ChkCheckServiceHelper.isEcCurrency(ctx, (String)ctx.getProperty("ecCurrency"))) {
            ctx.setProperty("mcstatus", ChkCtxConstant.CHECK_ORG_ERPT);
            ctx.setProcessList(ParamConstant.ERptProcess);
        } else if (ChkCheckServiceHelper.isParentCurrency(ctx, (String)ctx.getProperty("pcCurrency"))) {
            ctx.setProperty("mcstatus", ChkCtxConstant.CHECK_ORG_RPT);
            ctx.setProcessList(ParamConstant.RptProcess);
        } else {
            ctx.setProcessList(ParamConstant.RptProcess);
        }
    }

    protected void fillCurrency(ICalContext ctx, long modelId) {
        ChkCheckServiceHelper.fillCurrency(ctx, modelId);
    }

    protected void fillReportProcessProperty(ICalContext ctx) {
        ctx.setProperty("report_process", new HashMap());
    }

    protected void checkFlowStatus(ICalContext ctx) {
        ChkCheckServiceHelper.checkFlowStatus(ctx);
    }

    protected void afterCheck(ICalContext ctx, ChkStatusBuilder csb, List<DynamicObject> newReportAfterCheck, List<DynamicObject> oldReportAfterCheck) {
        this.deleteInvalidReports(ctx, oldReportAfterCheck);
        this.removePassedReport(newReportAfterCheck, oldReportAfterCheck);
        this.removeAllZeroReport(ctx, newReportAfterCheck, oldReportAfterCheck);
        SaveServiceHelper.save((DynamicObject[])newReportAfterCheck.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])oldReportAfterCheck.toArray(new DynamicObject[0]));
        csb.save();
    }

    protected void removeAllZeroReport(ICalContext ctx, List<DynamicObject> newReportAfterCheck, List<DynamicObject> oldReportAfterCheck) {
        this.removeAllZero(ctx, newReportAfterCheck);
        List<DynamicObject> oldReportPassed = oldReportAfterCheck.stream().filter(rel -> !String.valueOf(ChkResultTypeEnum.FORCEPASS.getIndex()).equals(rel.getString("chkresulttype")) && !StringUtils.isNotEmpty((String)rel.getString("note"))).collect(Collectors.toList());
        this.removeAllZero(ctx, oldReportPassed);
    }

    private void removeAllZero(ICalContext ctx, List<DynamicObject> reports) {
        HashMap reportHasTxt = (HashMap)ctx.getProperty("reportHasTxt");
        reports.removeIf(report -> {
            boolean allZero;
            if (reportHasTxt != null && Boolean.TRUE.equals(reportHasTxt.get(report.getLong("id")))) {
                return false;
            }
            if (StringUtils.isEmpty((String)report.getString("rightresult"))) {
                return false;
            }
            if (ChkResultTypeEnum.UNPASS.getIndex() == report.getInt("chkresulttype")) {
                return false;
            }
            String fulllformula = report.getString("fulllformula");
            String fullrformula = report.getString("fullrformula");
            if (ChkFormulaServiceHelper.hasXdmFormula(fulllformula) || ChkFormulaServiceHelper.hasXdmFormula(fullrformula)) {
                return false;
            }
            String leftresult = report.getString("leftresult");
            String rightresult = report.getString("rightresult");
            Matcher leftMatcher = ParamConstant.PATTERN_NUMBER.matcher(leftresult);
            Matcher rightMatcher = ParamConstant.PATTERN_NUMBER.matcher(rightresult);
            boolean bl = allZero = this.checkIfAllZero(leftMatcher) && this.checkIfAllZero(rightMatcher);
            if (!allZero) {
                return false;
            }
            return !fulllformula.replaceAll("[0%.+*/\\-]", "").trim().isEmpty() && !fullrformula.replaceAll("[0%.+*/\\-]", "").trim().isEmpty();
        });
    }

    private boolean checkIfAllZero(Matcher matcher) {
        boolean anyMatch = false;
        while (matcher.find()) {
            anyMatch = true;
            String group = matcher.group();
            if (BigDecimal.ZERO.compareTo(new BigDecimal(group)) == 0) continue;
            return false;
        }
        return anyMatch;
    }

    protected void removePassedReport(List<DynamicObject> newReportAfterCheck, List<DynamicObject> oldReportAfterCheck) {
        boolean isOnlySaveFailChk = ConfigServiceHelper.getGlobalBoolParam("isOnlySaveFailChk");
        if (isOnlySaveFailChk) {
            newReportAfterCheck.removeIf(rel -> String.valueOf(ChkResultTypeEnum.PASS.getIndex()).equals(rel.getString("chkresulttype")));
            List oldReportPassed = oldReportAfterCheck.stream().filter(rel -> String.valueOf(ChkResultTypeEnum.PASS.getIndex()).equals(rel.getString("chkresulttype")) && StringUtils.isEmpty((String)rel.getString("note"))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(oldReportPassed)) {
                oldReportAfterCheck.removeAll(oldReportPassed);
                List id = oldReportPassed.stream().map(rel -> rel.getLong("id")).collect(Collectors.toList());
                DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])new QFilter[]{new QFilter("id", "in", id)});
            }
        }
    }

    protected void valid(ICalContext ctx) {
        if (ctx.getCurrency() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e01\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractChkCheckService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private void prepare(ICalContext ctx) {
        if (!ctx.isFilled()) {
            this.fillCommonProperty2CTX(ctx);
            this.fillBpNumber2Id(ctx);
            this.fillCurrencyAndProcess2Ctx(ctx, ctx.getModelId());
            this.fillReportProcessProperty(ctx);
            this.fillCslScheme(ctx);
        }
    }

    private void fillCslScheme(ICalContext ctx) {
        ChkCheckServiceHelper.fillCslScheme(ctx);
    }

    private void fillBpNumber2Id(ICalContext ctx) {
        ChkCheckServiceHelper.fillBpNumber2Id(ctx);
    }

    protected void beforeCheck(ICalContext ctx) {
        this.prepare(ctx);
        this.valid(ctx);
        this.checkStatus(ctx);
    }

    protected void fillProcess(ICalContext ctx) {
        if (StringUtils.isEmpty((String)ctx.getProcess())) {
            this.fillProcessListByCurrency(ctx);
        } else {
            this.fillProcessListByProcess(ctx);
        }
        ChkCheckServiceHelper.fillProcessIdsByProcessList(ctx);
    }

    private void deleteReports(ICalContext ctx) {
        this.deleteInvalidReports(ctx);
        this.deleteLastCheckReports(ctx);
    }

    protected void deleteInvalidReports(ICalContext ctx) {
        List<QFilter> fl = ChkCheckServiceHelper.getComFilter(ctx);
        fl.add(new QFilter("chkformula", "=", (Object)0));
        fl.add(new QFilter("note", "=", (Object)""));
        fl.add(new QFilter("chkresulttype", "!=", (Object)String.valueOf(ChkResultTypeEnum.FORCEPASS.getIndex())));
        DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])fl.toArray(new QFilter[0]));
    }

    protected void fillCommonProperty2CTX(ICalContext ctx) {
        ChkCheckServiceHelper.fillCommonProperty2CTX(ctx);
    }

    private void checkStatus(ICalContext ctx) {
        if (ctx.getProperty("skipcheck") != null) {
            throw new KDBizException((String)ctx.getProperty("skipcheck"));
        }
        ChkCheckServiceHelper.checkPeriodStatus(ctx);
        this.checkFlowStatus(ctx);
        ChkCheckServiceHelper.checkIsQuoteLocked(ctx);
    }
}

