/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.serviceHelper.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.model.ChkResultModel;
import kd.fi.bcm.business.chkcheck.model.ChkStatusBuilder;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.AbstractChkCheckService;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class ChkCheckBatchReportService
extends AbstractChkCheckService {
    private static final ChkCheckBatchReportService CHK_CHECK_BATCH_REPORT_SERVICE = new ChkCheckBatchReportService();

    protected ChkCheckBatchReportService() {
    }

    public static ChkCheckBatchReportService getInstance() {
        return CHK_CHECK_BATCH_REPORT_SERVICE;
    }

    @Override
    protected void beforeCheck(ICalContext ctx) {
        IDNumberTreeNode entity = MemberReader.findEntityMemberById((String)ctx.getCubeNumber(), (Long)ChkCheckServiceHelper.getRealOrgId(ctx)).getBaseTreeNode();
        ctx.setProperty("org", entity.getNumber());
        ChkCheckServiceHelper.setOrg(entity, ctx);
        ChkCheckServiceHelper.transferNoneSpecificCurrency(ctx, (String)ctx.getProperty("ecCurrency"), (String)ctx.getProperty("pcCurrency"));
        if (StringUtils.isNotEmpty((String)ctx.getCurrency())) {
            long currencyId = MemberReader.findCurrencyMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getCurrency()).getId();
            ctx.setProperty("currencyId", currencyId);
        }
        this.valid(ctx);
        this.fillProcess(ctx);
    }

    @Override
    protected List<DynamicObject> getAllFormulaSettings(ICalContext ctx) {
        return (List)ctx.getProperty("needcheckformulalist");
    }

    @Override
    protected List<ChkFormulaModel> getAllFormulaModel(ICalContext ctx) {
        List<DynamicObject> formulaList = this.getAllFormulaSettings(ctx);
        ArrayList<ChkFormulaModel> chkModelList = new ArrayList<ChkFormulaModel>(formulaList.size());
        Map<String, Map<Long, DynamicObject>> memberMap = ChkCheckServiceHelper.batchGetMemberDataForLoadDynaObj2Model(formulaList);
        for (DynamicObject formula : formulaList) {
            ChkFormulaModel chkFormulaModel = new ChkFormulaModel();
            chkFormulaModel.loadDynaObj2Model(formula, memberMap, false);
            chkModelList.add(chkFormulaModel);
        }
        return chkModelList;
    }

    @Override
    protected void deleteInvalidReports(ICalContext ctx) {
    }

    @Override
    protected List<ChkResultModel> initFormulaResultModel(CalculateService service, List<ChkFormulaModel> formulaSettings) {
        ArrayList<ChkResultModel> chkResultModels = new ArrayList<ChkResultModel>();
        ICalContext ctx = service.get_ctx();
        Map memberMap = (Map)ctx.getProperty("memberData");
        for (ChkFormulaModel ckm : formulaSettings) {
            ChkCheckServiceHelper.addResults(service, chkResultModels, ckm);
        }
        this.customOperation(ctx, chkResultModels);
        return chkResultModels;
    }

    @Override
    protected void afterCheck(ICalContext ctx, ChkStatusBuilder csb, List<DynamicObject> newReportAfterCheck, List<DynamicObject> oldReportAfterCheck) {
        this.deleteInvalidReports(ctx, oldReportAfterCheck);
        this.removePassedReport(newReportAfterCheck, oldReportAfterCheck);
        this.removeAllZeroReport(ctx, newReportAfterCheck, oldReportAfterCheck);
        ctx.setProperty("newReportAfterCheck", newReportAfterCheck);
        ctx.setProperty("oldReportAfterCheck", oldReportAfterCheck);
        ctx.setProperty("csb", csb);
    }
}

