/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.serviceHelper.service;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.model.ChkStatusBuilder;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.AbstractChkCheckService;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.common.ChkCtxConstant;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.CheckResultenum;
import kd.fi.bcm.common.enums.chkcheck.ChkStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.lang.StringUtils;

public class ChkCheckMergeService
extends AbstractChkCheckService {
    private static final ChkCheckMergeService CHK_CHECK_MERGE_SERVICE = new ChkCheckMergeService();
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ChkCheckMergeService.class);

    protected ChkCheckMergeService() {
    }

    public static ChkCheckMergeService getInstance() {
        return CHK_CHECK_MERGE_SERVICE;
    }

    @Override
    public CheckResultenum check(CalculateService service) {
        CheckResultenum result = null;
        try {
            result = super.check(service);
        }
        catch (Exception e) {
            this.trans2NeedChk(service.get_ctx());
            log.error("ChkCheck[Merge] failed: ", (Throwable)e);
            throw e;
        }
        return result;
    }

    private void trans2NeedChk(ICalContext ctx) {
        this.fillCommonProperty2CTX(ctx);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)ChkCheckServiceHelper.getRealOrgId(ctx));
        long baseOrgId = orgNode.isShare() ? orgNode.getCopyfromId() : orgNode.getId();
        MergeStatusHelper.updateChkStatusNeedChk(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, ctx.getCurrency());
    }

    @Override
    protected void beforeCheck(ICalContext ctx) {
        super.beforeCheck(ctx);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)ChkCheckServiceHelper.getRealOrgId(ctx));
        long baseOrgId = orgNode.isShare() ? orgNode.getCopyfromId() : orgNode.getId();
        MergeStatusHelper.updateChkStatusProcessing(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, ctx.getCurrency());
    }

    @Override
    protected void fillProcessListByCurrency(ICalContext ctx) {
        if (ChkCheckServiceHelper.isEcCurrency(ctx, (String)ctx.getProperty("ecCurrency"))) {
            ctx.setProperty("mcstatus", ChkCtxConstant.CHECK_ORG_ERPT);
            if (ChkCheckServiceHelper.isParentCurrency(ctx, (String)ctx.getProperty("pcCurrency")) && StringUtils.isNotEmpty((String)((String)ctx.getProperty("pcCurrency")))) {
                ctx.setProcessList(ParamConstant.MergeEcProcess);
            } else {
                ctx.setProcessList(ParamConstant.ERptProcess);
            }
        } else if (ChkCheckServiceHelper.isParentCurrency(ctx, (String)ctx.getProperty("pcCurrency"))) {
            ctx.setProperty("mcstatus", ChkCtxConstant.CHECK_ORG_RPT);
            ctx.setProcessList(ParamConstant.MergePcProcess);
        } else {
            ctx.setProcessList(ParamConstant.RptProcess);
        }
    }

    @Override
    protected List<ChkFormulaModel> getAllFormulaModel(ICalContext ctx) {
        List allFormulaModel = (List)GlobalCacheServiceHelper.getOrLoadChkCheckCache((String)("mergeChk-allChkFormulaModel-" + ctx.getCubeNumber()), () -> ChkCheckServiceHelper.getAllFormulaModel(ctx, CHKFormulaStatusEnum.enable.getIndex()));
        return ChkCheckServiceHelper.doFilter(ctx, allFormulaModel);
    }

    @Override
    protected void updateMergeChkStatus(ICalContext ctx, CheckResultenum chkResult) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)ChkCheckServiceHelper.getRealOrgId(ctx));
        long baseOrgId = orgNode.isShare() ? orgNode.getCopyfromId() : orgNode.getId();
        if (chkResult == CheckResultenum.SUCCESS || chkResult == CheckResultenum.NOFORMULA) {
            MergeStatusHelper.updateChkStatusSuccess(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, ctx.getCurrency());
        } else if (chkResult == CheckResultenum.FAIL) {
            MergeStatusHelper.updateChkStatusFail(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, ctx.getCurrency());
        }
    }

    @Override
    protected void afterCheck(ICalContext ctx, ChkStatusBuilder csb, List<DynamicObject> newReportAfterCheck, List<DynamicObject> oldReportAfterCheck) {
        super.afterCheck(ctx, csb, newReportAfterCheck, oldReportAfterCheck);
        QFilter qFilter = new QFilter("model", "=", (Object)ctx.getModelId());
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)ChkCheckServiceHelper.getRealOrgId(ctx));
        long baseOrgId = orgNode.isShare() ? orgNode.getCopyfromId() : orgNode.getId();
        qFilter.and(new QFilter("org", "=", (Object)baseOrgId));
        qFilter.and(new QFilter("scenario", "=", (Object)ctx.getScenarioId()));
        qFilter.and(new QFilter("year", "=", (Object)ctx.getYearId()));
        qFilter.and(new QFilter("period", "=", (Object)ctx.getPeriodId()));
        qFilter.and(new QFilter("currency", "=", (Object)ctx.getCurrencyId()));
        if (ctx.getCurrency().equals(ctx.getProperty("ecCurrency"))) {
            qFilter.and(new QFilter("process", "=", (Object)MemberReader.findProcessMemberByNum((String)ctx.getCubeNumber(), (String)"ERpt").getId()));
        } else {
            qFilter.and(new QFilter("process", "=", (Object)MemberReader.findProcessMemberByNum((String)ctx.getCubeNumber(), (String)"Rpt").getId()));
        }
        qFilter.and(new QFilter("tmp", "=", (Object)0L));
        qFilter.and(new QFilter("cslscheme", "=", (Object)0L));
        DynamicObject status = QueryServiceHelper.queryOne((String)"bcm_status", (String)"process,currency,checkedstatus", (QFilter[])qFilter.toArray());
        if (status == null) {
            log.info("query status null:" + qFilter.toString());
            MergeStatusHelper.updateChkStatusNeedChk(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, ctx.getCurrency());
        } else if (ChkStatusEnum.PASS.getStatus() == status.getInt("checkedstatus")) {
            MergeStatusHelper.updateChkStatusSuccess(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, ctx.getCurrency());
        } else if (ChkStatusEnum.UNPASS.getStatus() == status.getInt("checkedstatus")) {
            MergeStatusHelper.updateChkStatusFail(ctx.getModelId(), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId(), baseOrgId, ctx.getCurrency());
        }
    }
}

