/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.serviceHelper.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.model.ChkResultModel;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.AbstractChkCheckService;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.common.enums.chkcheck.ChkCheckReportModeEnum;

public class ChkCheckReportRecheckService
extends AbstractChkCheckService {
    private static final ChkCheckReportRecheckService CHK_CHECK_CHECK_UP_REPORT_SERVICE = new ChkCheckReportRecheckService();

    private ChkCheckReportRecheckService() {
    }

    public static ChkCheckReportRecheckService getInstance() {
        return CHK_CHECK_CHECK_UP_REPORT_SERVICE;
    }

    @Override
    protected void deleteLastCheckReports(ICalContext ctx) {
        ArrayList<QFilter> fl = new ArrayList<QFilter>();
        fl.add(new QFilter("org", "in", ctx.getProperty("orgIds")));
        fl.add(new QFilter("period", "=", (Object)ctx.getPeriodId()));
        fl.add(new QFilter("year", "=", (Object)ctx.getYearId()));
        fl.add(new QFilter("model", "=", (Object)ctx.getModelId()));
        fl.add(new QFilter("scenario", "=", (Object)ctx.getScenarioId()));
        List<Long> ids = ChkCheckServiceHelper.getFormulaIdByReportId(ctx);
        fl.add(new QFilter("chkformula", "in", ids));
        fl.add(new QFilter("currency.number", "in", Arrays.asList(ctx.getCurrency(), (String)ctx.getProperty("ecCurrency"), (String)ctx.getProperty("pcCurrency"))));
        DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])fl.toArray(new QFilter[0]));
    }

    @Override
    protected List<QFilter> oldResultMapFilter(ICalContext ctx) {
        ArrayList<QFilter> fl = new ArrayList<QFilter>();
        fl.add(new QFilter("id", "in", ctx.getProperty("reportIds")));
        return fl;
    }

    @Override
    protected String getCurrency(ICalContext ctx, String process) {
        String currency = super.getCurrency(ctx, process);
        return ChkCheckServiceHelper.getCurrency(ctx, process, currency);
    }

    @Override
    protected void fillCurrencyAndProcess2Ctx(ICalContext ctx, long modelId) {
        this.fillCurrency(ctx, modelId);
    }

    @Override
    protected void checkPass(DynamicObject report, ChkResultModel resultModel) {
        report.set("note", null);
        report.set("forcedpasser", null);
        report.set("forcedpasstime", null);
    }

    @Override
    protected void deleteInvalidReports(ICalContext ctx, List<DynamicObject> oldReportAfterRecheck) {
        QFilter qFilters = new QFilter("id", "in", ctx.getProperty("reportIds"));
        List oldReportId = oldReportAfterRecheck.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        qFilters.and(new QFilter("id", "not in", oldReportId));
        qFilters.and(new QFilter("currency.number", "in", Arrays.asList(ctx.getCurrency(), (String)ctx.getProperty("ecCurrency"), (String)ctx.getProperty("pcCurrency"))));
        DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])qFilters.toArray());
    }

    @Override
    protected List<DynamicObject> getAllFormulaSettings(ICalContext ctx) {
        return ChkCheckServiceHelper.getFormulaListByReportIdExcludeProcess(ctx);
    }

    @Override
    protected List<ChkFormulaModel> getAllFormulaModel(ICalContext ctx) {
        List<DynamicObject> formulaList = this.getAllFormulaSettings(ctx);
        ArrayList<ChkFormulaModel> chkModelList = new ArrayList<ChkFormulaModel>(formulaList.size());
        Map<String, Map<Long, DynamicObject>> memberMap = ChkCheckServiceHelper.batchGetMemberDataForLoadDynaObj2Model(formulaList);
        for (DynamicObject formula : formulaList) {
            ChkFormulaModel chkFormulaModel = new ChkFormulaModel();
            chkFormulaModel.loadDynaObj2Model(formula, memberMap, false);
            chkModelList.add(chkFormulaModel);
        }
        return chkModelList;
    }

    @Override
    protected void checkFlowStatus(ICalContext ctx) {
        Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(ctx.getModelId(), Collections.singletonList(ChkCheckServiceHelper.getRealOrgId(ctx)), ctx.getScenarioId(), ctx.getYearId(), ctx.getPeriodId());
        McStatus mcStatus = mcStatusMap.get(ChkCheckServiceHelper.getRealOrgId(ctx));
        if (mcStatus.getFlow().isSubmit()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"ChkCheckServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    @Override
    protected void valid(ICalContext ctx) {
    }

    @Override
    protected void fillReportProcessProperty(ICalContext ctx) {
        super.fillReportProcessProperty(ctx);
        if (ChkCheckServiceHelper.notChkRptProcess(ctx)) {
            ctx.setProperty("report_process_mode", ChkCheckReportModeEnum.ONLY_ERPT.getMode());
        } else {
            ctx.setProperty("report_process_mode", ChkCheckReportModeEnum.MIX.getMode());
        }
    }
}

