/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.serviceHelper.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.model.ChkResultModel;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.AbstractChkCheckService;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.chkcheck.ChkCheckReportModeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ChkCheckReportService
extends AbstractChkCheckService {
    private static final ChkCheckReportService CHK_CHECK_CHECK_UP_REPORT_SERVICE = new ChkCheckReportService();

    protected ChkCheckReportService() {
    }

    public static ChkCheckReportService getInstance() {
        return CHK_CHECK_CHECK_UP_REPORT_SERVICE;
    }

    @Override
    protected void deleteLastCheckReports(ICalContext ctx) {
    }

    @Override
    protected List<QFilter> oldResultMapFilter(ICalContext ctx) {
        ArrayList<QFilter> fl = new ArrayList<QFilter>();
        fl.add(new QFilter("id", "in", ctx.getProperty("reportIds")));
        return fl;
    }

    @Override
    protected String getCurrency(ICalContext ctx, String process) {
        String currency = super.getCurrency(ctx, process);
        return ChkCheckServiceHelper.getCurrency(ctx, process, currency);
    }

    @Override
    protected void fillReportProcessProperty(ICalContext ctx) {
        QFilter qFilter = new QFilter("id", "in", ctx.getProperty("reportIds"));
        DynamicObjectCollection report = QueryServiceHelper.query((String)"bcm_chkreport", (String)"id,chkformula.id,process,currency", (QFilter[])qFilter.toArray());
        HashMap<Long, Set> map = new HashMap<Long, Set>();
        HashMap formulaId2ReportId = new HashMap();
        HashSet processes = new HashSet();
        ArrayList erptProcesses = new ArrayList();
        ArrayList nonErptProcesses = new ArrayList();
        report.forEach(dy -> {
            long formulaId = dy.getLong("chkformula.id");
            formulaId2ReportId.computeIfAbsent(formulaId, k -> new ArrayList()).add(dy.getLong("id"));
            String process = MemberReader.findProcessMemberById((String)ctx.getCubeNumber(), (Long)dy.getLong("process")).getNumber();
            if (!map.containsKey(formulaId)) {
                map.put(formulaId, new HashSet());
            }
            if (ChkCheckServiceHelper.notChkRptProcess(ctx) && ParamConstant.RptProcess.contains(process)) {
                return;
            }
            ((Set)map.get(formulaId)).add(process);
            if (ParamConstant.ERptProcess.contains(process)) {
                erptProcesses.add(process);
            } else {
                nonErptProcesses.add(process);
            }
            processes.add(process);
        });
        HashMap formulaId2Process = new HashMap();
        map.forEach((k, v) -> {
            List cfr_ignored_0 = formulaId2Process.put(k, new ArrayList(v));
        });
        ctx.setProperty("report_process", formulaId2Process);
        ctx.setProperty("report_process_list", processes);
        int reportProcessMode = 0;
        reportProcessMode = erptProcesses.isEmpty() ? ChkCheckReportModeEnum.ONLY_NON_ERPT.getMode() : (nonErptProcesses.isEmpty() ? ChkCheckReportModeEnum.ONLY_ERPT.getMode().intValue() : ChkCheckReportModeEnum.MIX.getMode().intValue());
        ctx.setProperty("report_process_mode", reportProcessMode);
        ctx.setProperty("report_formulaid2reportid", formulaId2ReportId);
    }

    @Override
    protected void checkFlowStatus(ICalContext ctx) {
        Set processes = (Set)ctx.getProperty("report_process_list");
        if (CollectionUtils.isEmpty((Collection)processes)) {
            return;
        }
        ChkCheckServiceHelper.checkFlowStatus(ctx);
    }

    @Override
    protected List<DynamicObject> getAllFormulaSettings(ICalContext ctx) {
        return ChkCheckServiceHelper.getFormulaListByReportId(ctx);
    }

    @Override
    protected List<ChkFormulaModel> getAllFormulaModel(ICalContext ctx) {
        List<DynamicObject> formulaList = this.getAllFormulaSettings(ctx);
        ArrayList<ChkFormulaModel> chkModelList = new ArrayList<ChkFormulaModel>(formulaList.size());
        Map<String, Map<Long, DynamicObject>> memberMap = ChkCheckServiceHelper.batchGetMemberDataForLoadDynaObj2Model(formulaList);
        for (DynamicObject formula : formulaList) {
            ChkFormulaModel chkFormulaModel = new ChkFormulaModel();
            chkFormulaModel.loadDynaObj2Model(formula, memberMap, false);
            chkModelList.add(chkFormulaModel);
        }
        return chkModelList;
    }

    @Override
    protected void fillCurrencyAndProcess2Ctx(ICalContext ctx, long modelId) {
        this.fillCurrency(ctx, modelId);
    }

    @Override
    protected void valid(ICalContext ctx) {
        if (ctx.getProperty("report_process_list") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u6821\u9a8c\u62a5\u544a\u5217\u8868\u4f20\u5165\u7684\u8fc7\u7a0b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractChkCheckService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    @Override
    protected boolean checkReport(DynamicObject report, String fulllformula, String fullrformula) {
        if (report == null) {
            return true;
        }
        boolean isNewReport = StringUtils.isEmpty((String)report.getString("fulllformula")) && StringUtils.isEmpty((String)report.getString("fullrformula"));
        boolean formulaDiff = !fulllformula.equals(report.getString("fulllformula")) || !fullrformula.equals(report.getString("fullrformula"));
        return super.checkReport(report, fulllformula, fullrformula) || formulaDiff && !isNewReport;
    }

    @Override
    protected DynamicObject getReport(CalculateService service, List<DynamicObject> newReportAfterCheck, List<DynamicObject> oldReportAfterCheck, Map<String, List<DynamicObject>> oldresultmap, ChkResultModel resultModel, Map<String, Boolean> allChkResultModel) {
        String resultkey = ChkCheckServiceHelper.getResultkey(resultModel.getSetid(), resultModel.getProcess(), resultModel.getCurrency());
        String fulllformula = resultModel.getFulllformula();
        String fullrformula = resultModel.getFullrformula();
        ICalContext ctx = service.get_ctx();
        List allResultKey = null;
        if (ctx.getProperty("allresultkey") != null) {
            allResultKey = (List)ctx.getProperty("allresultkey");
        }
        if (allResultKey != null && !allResultKey.contains(resultkey)) {
            return null;
        }
        List<DynamicObject> reports = oldresultmap.get(resultkey);
        if (allChkResultModel != null && allChkResultModel.get(resultkey).booleanValue()) {
            Optional<DynamicObject> matchedReport = reports.stream().filter(dy -> fulllformula.equals(dy.getString("fulllformula")) && fullrformula.equals(dy.getString("fullrformula"))).findFirst();
            if (matchedReport.isPresent()) {
                DynamicObject report = matchedReport.get();
                oldReportAfterCheck.add(report);
                reports.remove(report);
                return report;
            }
            return null;
        }
        return super.getReport(service, newReportAfterCheck, oldReportAfterCheck, oldresultmap, resultModel, allChkResultModel);
    }

    @Override
    protected void customOperation(ICalContext ctx, List<ChkResultModel> chkResultModels) {
        super.customOperation(ctx, chkResultModels);
        Map formulaId2ReportId = (Map)ctx.getProperty("report_formulaid2reportid");
        ArrayList deleteReportIds = new ArrayList();
        List formulaIds = chkResultModels.stream().map(chkResultModel -> chkResultModel.getSetid()).collect(Collectors.toList());
        formulaId2ReportId.forEach((k, v) -> {
            if (!formulaIds.contains(k)) {
                deleteReportIds.addAll(v);
            }
        });
        ctx.removeProperty("report_formulaid2reportid");
        if (CollectionUtils.isNotEmpty(deleteReportIds)) {
            QFilter qFilters = new QFilter("id", "in", deleteReportIds);
            DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])qFilters.toArray());
        }
    }
}

