/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.serviceHelper.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.service.AbstractChkCheckService;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.chkcheck.ChkCheckReportModeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;

public class ChkCheckScheduleService
extends AbstractChkCheckService {
    private static final ChkCheckScheduleService CHK_CHECK_SCHEDULE_SERVICE = new ChkCheckScheduleService();

    protected ChkCheckScheduleService() {
    }

    public static ChkCheckScheduleService getInstance() {
        return CHK_CHECK_SCHEDULE_SERVICE;
    }

    @Override
    protected void deleteLastCheckReports(ICalContext ctx) {
        ArrayList<QFilter> fl = new ArrayList<QFilter>();
        fl.add(new QFilter("model", "=", (Object)ctx.getModelId()));
        fl.add(new QFilter("year", "=", (Object)ctx.getYearId()));
        fl.add(new QFilter("period", "=", (Object)ctx.getPeriodId()));
        fl.add(new QFilter("scenario", "=", (Object)ctx.getScenarioId()));
        fl.add(new QFilter("org", "in", ctx.getProperty("orgIds")));
        fl.add(new QFilter("process", "in", ctx.getProperty("processIds")));
        Long orgparent = (Long)ctx.getProperty("orgparent");
        if (orgparent != null) {
            fl.add(new QFilter("orgparent", "=", (Object)orgparent).or("orgparent", "=", (Object)0));
        }
        Set<Long> ids = ChkCheckServiceHelper.getAllFormulaIds(ctx);
        fl.add(new QFilter("chkformula", "in", ids));
        fl.add(new QFilter("note", "=", (Object)""));
        fl.add(new QFilter("chkresulttype", "!=", (Object)String.valueOf(ChkResultTypeEnum.FORCEPASS.getIndex())));
        if (CollectionUtils.isNotEmpty(fl)) {
            DeleteServiceHelper.delete((String)"bcm_chkreport", (QFilter[])fl.toArray(new QFilter[0]));
        }
    }

    @Override
    protected void fillProcess(ICalContext ctx) {
        List<String> processList = ctx.getProcessList();
        List erpt = ListUtils.intersection(processList, (List)ParamConstant.ERptProcess);
        List rpt = ListUtils.intersection(processList, (List)ParamConstant.RptProcess);
        HashSet<String> newProcess = new HashSet<String>(processList);
        if (!erpt.isEmpty() && erpt.size() < ParamConstant.ERptProcess.size()) {
            newProcess.addAll(ParamConstant.ERptProcess);
        }
        if (!rpt.isEmpty() && rpt.size() < ParamConstant.RptProcess.size()) {
            newProcess.addAll(ParamConstant.RptProcess);
        }
        if (ChkCheckServiceHelper.notChkRptProcess(ctx)) {
            ParamConstant.RptProcess.forEach(newProcess::remove);
        }
        ctx.setProcessList(new ArrayList<String>(newProcess));
        ctx.setProperty("report_process_list", newProcess);
        ChkCheckServiceHelper.fillProcessIdsByProcessList(ctx);
    }

    @Override
    protected void fillCurrency(ICalContext ctx, long modelId) {
        super.fillCurrency(ctx, modelId);
        if (ctx.getCurrency() == null && CollectionUtils.isNotEmpty(ctx.getProcessList())) {
            if (ctx.getProperty("PCSchedule") != null) {
                ctx.setProperty("currency", ctx.getProperty("pcCurrency"));
            } else {
                ctx.setProperty("currency", ctx.getProperty("ecCurrency"));
            }
            if (StringUtils.isNotEmpty((String)ctx.getCurrency())) {
                long currencyId = MemberReader.findCurrencyMemberByNum((String)ctx.getCubeNumber(), (String)ctx.getCurrency()).getId();
                ctx.setProperty("currencyId", currencyId);
            }
        }
    }

    @Override
    protected void valid(ICalContext ctx) {
        if (ctx.getModelId() < 0L || ctx.getYearId() < 0L || ctx.getPeriodId() < 0L || ctx.getScenarioId() < 0L || ctx.getOrgId() < 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u65e0\u6548\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u3002", (String)"ChkCheckScheduleService_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    @Override
    protected void fillReportProcessProperty(ICalContext ctx) {
        super.fillReportProcessProperty(ctx);
        if (!ctx.getProperty("ecCurrency").equals(ctx.getProperty("pcCurrency"))) {
            ctx.setProperty("report_process_mode", ChkCheckReportModeEnum.MIX.getMode());
        } else {
            ctx.setProperty("report_process_mode", ChkCheckReportModeEnum.ONLY_ERPT.getMode());
        }
    }

    @Override
    protected String getCurrency(ICalContext ctx, String process) {
        String currency = super.getCurrency(ctx, process);
        if (currency == null) {
            currency = ParamConstant.ERptProcess.contains(process) ? (String)ctx.getProperty("ecCurrency") : (String)ctx.getProperty("pcCurrency");
        }
        return currency;
    }
}

