/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.chkcheck.CheckResultenum;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class ChkCheckTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ChkCheckTask.class);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String message = ResManager.loadKDString((String)"\u6267\u884c\u52fe\u7a3d\u68c0\u67e5\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"ChkCheckTask_0", (String)"fi-bcm-business", (Object[])new Object[0]);
        HashMap<String, Object> feedbackData = new HashMap<String, Object>();
        this.feedbackProgress(10);
        try {
            if (this.isStop()) {
                this.stop();
            }
            this.doChkByType(map, feedbackData);
        }
        catch (Exception e) {
            LOG.error("--->\u6267\u884c\u52fe\u7a3d\u68c0\u67e5\u4efb\u52a1\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            this.feedbackCustomdata(feedbackData);
        }
    }

    private void doChkByType(Map<String, Object> map, Map<String, Object> feedbackData) {
        block8: {
            int type = (Integer)map.get("type");
            feedbackData.put("type", map.get("type"));
            List ctxList = (List)ObjectSerialUtil.deSerializedBytes((String)map.get("ctxs").toString());
            try {
                if (1 == type) {
                    CheckResultenum resultenum = ChkCheckServiceHelper.check((ICalContext)ctxList.get(0));
                    feedbackData.put("result", ObjectSerialUtil.toByteSerialized((Object)resultenum));
                    break block8;
                }
                if (2 == type) {
                    Map<Pair<Long, Long>, CheckResultenum> chkResult = ChkCheckServiceHelper.check((ICalContext)ctxList.get(0), true);
                    feedbackData.put("result", ObjectSerialUtil.toByteSerialized(chkResult));
                    break block8;
                }
                if (3 != type && 4 != type) break block8;
                ArrayList errorMsg = new ArrayList();
                CountDownLatch countDownLatch = new CountDownLatch(ctxList.size());
                ctxList.forEach(ctx -> ThreadPoolService.runReportListChkThread(() -> {
                    try {
                        ChkCheckServiceHelper.check(ctx);
                    }
                    catch (Exception e) {
                        errorMsg.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u5df2\u7ecf\u8df3\u8fc7\u52fe\u7a3d\u68c0\u67e5\uff0c\u5177\u4f53\u539f\u56e0\uff1a%2$s\u3002", (String)"CheckUpChkReportPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ctx.getOrg(), e.getMessage()));
                        LOG.error("chkCheck Error:" + e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }));
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    LOG.error("ChkCheckError--Interrupted!", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                if (!errorMsg.isEmpty()) {
                    feedbackData.put("errorMsg", ObjectSerialUtil.toByteSerialized(errorMsg));
                }
            }
            catch (KDBizException kde) {
                LOG.error("ChkCheckTask error:", (Throwable)kde);
                feedbackData.put("errorMsg", ObjectSerialUtil.toByteSerialized((Object)kde.getMessage()));
            }
            catch (Exception e) {
                LOG.error("ChkCheckTask error:", (Throwable)e);
            }
        }
    }
}

