/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.chkcheck.model.ChkFormulaModel;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.model.FormulaPoolManager;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.serviceHelper.ExpressionServiceHelper;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.chkcheck.CHKTypeEnum;
import kd.fi.bcm.fel.exception.EvalException;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.expr.IntExpr;
import kd.fi.bcm.spread.formula.expr.NameExpr;
import kd.fi.bcm.spread.formula.expr.NumberExpr;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class CheckedFormulaUtil {
    public static final Log LOG = LogFactory.getLog(CheckedFormulaUtil.class);

    public static FormulaBuilder transToFormulaOld(String data, IPageCache pageCache) {
        FormulaBuilder fb = new FormulaBuilder();
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c == '{') {
                i += 2;
                StringBuilder keysb = new StringBuilder();
                while (i < data.length() && (c = data.charAt(i)) != '\"') {
                    keysb.append(c);
                    ++i;
                }
                String key = keysb.toString();
                CheckedFormulaUtil.putToFb(fb, pageCache, key);
                ++i;
                continue;
            }
            if (c == '>' || c == '<' || c == '=') {
                fb.compsb.append(c);
                char next = data.charAt(i + 1);
                if (next == '>' || next == '<' || next == '=') {
                    fb.compsb.append(next);
                    ++i;
                }
                fb.switchSide();
                if (!"+*/".contains(String.valueOf(data.charAt(i + 1)))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u6b63\u786e\u6027\u3002", (String)"CheckedFormulaUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            fb.append(c);
        }
        return fb;
    }

    public static FormulaBuilder transToFormula(String data, IPageCache pageCache) {
        int beginPosition;
        FormulaBuilder fb = new FormulaBuilder();
        String leftStr = "";
        String rightStr = "";
        String comStr = "";
        int n = data.indexOf(60) > -1 ? data.indexOf(60) : (data.indexOf(62) > -1 ? data.indexOf(62) : (beginPosition = data.indexOf(61) > -1 ? data.indexOf(61) : -1));
        if (beginPosition == -1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u6b63\u786e\u6027\u3002", (String)"CheckedFormulaUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        leftStr = data.substring(0, beginPosition);
        String tempData = data.substring(beginPosition + 1);
        comStr = data.substring(beginPosition, beginPosition + 1);
        if (tempData.indexOf(61) > -1 || tempData.indexOf(62) > -1) {
            comStr = data.substring(beginPosition, beginPosition + 2);
            rightStr = data.substring(beginPosition + 2);
        } else {
            rightStr = data.substring(beginPosition + 1);
        }
        StringBuilder checkFormula = new StringBuilder();
        CheckedFormulaUtil.transToFormulaJudge(leftStr, pageCache, fb, checkFormula);
        fb.switchSide();
        checkFormula.append(comStr);
        CheckedFormulaUtil.transToFormulaJudge(rightStr, pageCache, fb, checkFormula);
        fb.compsb.append(comStr);
        return fb;
    }

    public static Object[] transToFormulaJudge(String data, IPageCache pageCache, FormulaBuilder fb, StringBuilder checkFormula) {
        String tempData = CheckedFormulaUtil.dealJudgeFormula(data, fb, checkFormula, pageCache);
        while (tempData.length() > 0) {
            tempData = CheckedFormulaUtil.dealJudgeFormula(tempData, fb, checkFormula, pageCache);
        }
        Object[] result = new Object[]{fb, checkFormula.toString()};
        return result;
    }

    private static String dealJudgeFormula(String data, FormulaBuilder fb, StringBuilder checkFormula, IPageCache pageCache) {
        int beginPosition = data.indexOf(123);
        if (beginPosition > 0) {
            fb.appendString(data.substring(0, beginPosition));
            checkFormula.append(data.substring(0, beginPosition));
            return data.substring(beginPosition, data.length());
        }
        if (beginPosition == -1) {
            fb.appendString(data);
            checkFormula.append(data);
            return "";
        }
        String key = data.substring(beginPosition + 1, data.indexOf(125)).replaceAll("\"", "");
        CheckedFormulaUtil.putToFb(fb, pageCache, key);
        checkFormula.append(3.186);
        return data.substring(data.indexOf(125) + 1, data.length());
    }

    private static void putToFb(FormulaBuilder fb, IPageCache pageCache, String key) {
        if (pageCache.get(key) != null) {
            fb.appendNoTmp(pageCache.get(key));
        }
        if (pageCache.get(key + "formula_withtemp") != null) {
            fb.appendWithTmp(pageCache.get(key + "formula_withtemp"));
        } else {
            fb.appendWithTmp(pageCache.get(key));
        }
    }

    public static String buildDatabyFormula(String formula, IPageCache pageCache, long modelid) {
        Pair<String, List<IFormula>> pair;
        if (ChkFormulaServiceHelper.isXdmFormula(formula)) {
            return CheckedFormulaUtil.buildDatabyXFormula(formula, pageCache);
        }
        StringBuilder sb = new StringBuilder();
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        try {
            pair = parser.parse(formula, coder);
        }
        catch (Exception e) {
            LOG.error(String.format("parse formula[%s] error!", formula), (Throwable)e);
            return sb.toString();
        }
        int flag = 0;
        for (int i = 0; i < ((String)pair.p1).length(); ++i) {
            if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                if (!ExpressionServiceHelper.checkFactorComplete(i, (String)pair.p1)) continue;
                IFormula f = (IFormula)((List)pair.p2).get(flag);
                String tmpnum = "";
                String withtmp = f.toString();
                boolean istmp = false;
                for (int j = 0; j < f.getParamList().size(); ++j) {
                    ParamItem pi = (ParamItem)f.getParamList().get(j);
                    if (pi.getParam() instanceof IntExpr || pi.getParam() instanceof NumberExpr) {
                        f.getParamList().remove(pi);
                        continue;
                    }
                    String sn = pi.toString().split("\\.", 2)[0];
                    String sm = pi.toString().split("\\.", 2)[1];
                    if (!"@TMP".equals(sn)) continue;
                    tmpnum = sm;
                    f.getParamList().remove(pi);
                    istmp = true;
                    break;
                }
                String notmp = f.toString();
                String key = "";
                String text = "";
                if (istmp) {
                    key = "formula_temp_" + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH);
                    pageCache.put(key, notmp);
                    pageCache.put(key + "formula_withtemp", withtmp);
                    pageCache.put(key + "formula_temp", tmpnum);
                    text = ChkFormulaServiceHelper.translateChkformla(withtmp, modelid, 1);
                } else {
                    key = "formula_fx_" + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH);
                    pageCache.put(key, notmp);
                    text = ChkFormulaServiceHelper.translateChkformla(notmp, modelid, 1);
                }
                sb.append("{\"");
                sb.append(key);
                sb.append("\",\"");
                sb.append(text);
                sb.append("\"}");
                ++flag;
                continue;
            }
            String oper = String.valueOf(((String)pair.p1).charAt(i));
            sb.append(oper);
        }
        return sb.toString();
    }

    public static String buildDatabyFormulaJudge(String formula, IPageCache pageCache, long modelid, String formulaPrefix) {
        StringBuffer sb = new StringBuffer();
        String tempData = CheckedFormulaUtil.buildJudgeFormulaDisplay(formula, sb, pageCache, modelid, formulaPrefix);
        while (tempData.length() > 0) {
            tempData = CheckedFormulaUtil.buildJudgeFormulaDisplay(tempData, sb, pageCache, modelid, formulaPrefix);
        }
        return sb.toString();
    }

    private static String buildJudgeFormulaDisplay(String data, StringBuffer sb, IPageCache pageCache, long modelid, String formulaPrefix) {
        int beginPosition = data.indexOf(formulaPrefix);
        if (beginPosition > 0) {
            sb.append(data.substring(0, beginPosition));
            return data.substring(beginPosition);
        }
        if (beginPosition == -1) {
            sb.append(data);
            return "";
        }
        try {
            String item = data.substring(beginPosition, data.indexOf(")") + 1);
            sb.append(CheckedFormulaUtil.buildDatabyFormula(item, pageCache, modelid));
            return data.substring(data.indexOf(41) + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Object packFormula(ChkFormulaModel model, IPageCache pageCache) {
        String left = model.getLformulatemp();
        left = ChkFormulaServiceHelper.isJudgeFormula(left) ? CheckedFormulaUtil.buildDatabyFormula(left, pageCache, model.getModelId()) : CheckedFormulaUtil.parseFormulaForBuildData(left, model, pageCache);
        String right = model.getRformulatemp();
        right = ChkFormulaServiceHelper.isJudgeFormula(right) ? CheckedFormulaUtil.buildDatabyFormula(right, pageCache, model.getModelId()) : CheckedFormulaUtil.parseFormulaForBuildData(right, model, pageCache);
        String compare = CHKTypeEnum.getCHKTypeEnumByIndex((int)Integer.parseInt(model.getComparetype())).getName();
        String formula = left + compare + right;
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"updateText");
        data.put("data", (Object)formula);
        return data;
    }

    public static boolean isSpecialFormula(String formula) {
        boolean isJudge = false;
        if ((formula = formula.toUpperCase(Locale.ENGLISH)).contains("IF(") || formula.contains("AND(") || formula.contains("OR(") || formula.contains("ROUND(") || formula.contains("ABS(") || formula.contains("LEN(")) {
            isJudge = true;
        }
        return isJudge;
    }

    private static String parseFormulaForBuildData(String formula, ChkFormulaModel model, IPageCache pageCache) {
        String newFormula = formula;
        List<String> vList = ChkFormulaServiceHelper.getVList(formula);
        for (String v : vList) {
            String newV = CheckedFormulaUtil.buildDatabyFormula(v, pageCache, model.getModelId());
            newFormula = StringUtils.replaceOnce((String)newFormula, (String)v, (String)newV);
        }
        List<String> xList = ChkFormulaServiceHelper.getXList(formula);
        for (String xformula : xList) {
            String newV = CheckedFormulaUtil.buildDatabyXFormula(xformula, pageCache);
            newFormula = StringUtils.replaceOnce((String)newFormula, (String)xformula, (String)newV);
        }
        return newFormula;
    }

    private static String buildDatabyXFormula(String xformula, IPageCache pageCache) {
        Pair<String, List<IFormula>> pair;
        StringBuilder sb = new StringBuilder();
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        try {
            pair = parser.parse(xformula, coder);
        }
        catch (Exception e) {
            LOG.error(String.format("parse formula[%s] error!", xformula), (Throwable)e);
            return sb.toString();
        }
        int flag = 0;
        for (int i = 0; i < ((String)pair.p1).length(); ++i) {
            if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                if (!ExpressionServiceHelper.checkFactorComplete(i, (String)pair.p1)) continue;
                IFormula f = (IFormula)((List)pair.p2).get(flag);
                String withtmp = f.toString();
                String text = ChkFormulaServiceHelper.getXdmFormula(f, 1);
                String key = CheckedFormulaUtil.getComboSign("formula_extends_");
                pageCache.put(key, withtmp);
                sb.append("{\"");
                sb.append(key);
                sb.append("\",\"");
                sb.append(text);
                sb.append("\"}");
                ++flag;
                continue;
            }
            String oper = String.valueOf(((String)pair.p1).charAt(i));
            sb.append(oper);
        }
        return sb.toString();
    }

    private static String extractTemplateNumber(String xdmScript) {
        int commaIndex;
        int tmpIndex = xdmScript.indexOf("@TMP.");
        if (tmpIndex > -1 && (commaIndex = xdmScript.indexOf(",", tmpIndex)) > -1) {
            return xdmScript.substring(tmpIndex + "@TMP.".length(), commaIndex);
        }
        return "";
    }

    public static Object buildJudgeFormula(ChkFormulaModel model, IPageCache pageCache) {
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"updateText");
        String value = CheckedFormulaUtil.buildDatabyFormulaJudge(model.getLformulatemp(), pageCache, model.getModelId(), "V(");
        value = CheckedFormulaUtil.buildDatabyFormulaJudge(value, pageCache, model.getModelId(), "X(");
        data.put("data", (Object)value);
        return data;
    }

    public static Object packAddText(String key, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"");
        sb.append(key);
        sb.append("\",\"");
        sb.append(text);
        sb.append("\"}");
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"addText");
        data.put("data", (Object)sb.toString());
        return data;
    }

    public static Object packAddTextNoEdit(String key, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"");
        sb.append(key);
        sb.append("\",\"");
        sb.append(text);
        sb.append("\"}");
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"addTextNoEdit");
        data.put("data", (Object)sb.toString());
        return data;
    }

    public static void checkFormula(String formula, IPageCache pageCache, ChkFormulaModel model, String expr) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)formula)) {
            FormulaBuilder formulas;
            try {
                formulas = CheckedFormulaUtil.transToFormula(formula, pageCache);
                model.setLeftformula(formulas.leftsb.toString());
                model.setLformulatemp(formulas.leftwithtmpsb.toString());
                model.setRightformula(formulas.rigntsb.toString());
                model.setRformulatemp(formulas.rihhtwithtmpsb.toString());
                model.setComparetype(String.valueOf(CHKTypeEnum.getCHKTypeEnumByName((String)formulas.compsb.toString()).getIndex()));
            }
            catch (Exception e) {
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaError"), new Object[0]);
            }
            if (kd.bos.util.StringUtils.isEmpty((String)formulas.compsb.toString())) {
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaError"), new Object[0]);
            }
            FormulaBuilder numFormula = CheckedFormulaUtil.transToFormula(expr, pageCache);
            CheckedFormulaUtil.checkCanExcecuteDiff(numFormula.leftsb.toString(), numFormula.compsb.toString(), true);
            CheckedFormulaUtil.checkCanExcecuteDiff(numFormula.rigntsb.toString(), numFormula.compsb.toString(), true);
        }
    }

    public static void checkCanExcecute(Object[] resultList) {
        ICalContext ctx = ChkCheckServiceHelper.getICalContext();
        CalculateService service = new CalculateService(ctx);
        try {
            String formula = (String)resultList[1];
            formula = ChkCheckServiceHelper.changePercentToDec(formula);
            Object result = CheckedFormulaUtil.getResult(service, formula, true);
            CheckedFormulaUtil.checkResult(service, result);
            result = CheckedFormulaUtil.getResult(service, formula, false);
            CheckedFormulaUtil.checkResult(service, result);
        }
        catch (Exception e) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaError"), new Object[0]);
        }
    }

    private static void checkResult(CalculateService service, Object result) {
        service.getResultMap().forEach((k, v) -> {
            if (v instanceof InvalidParamException) {
                throw new KDBizException(((InvalidParamException)((Object)((Object)v))).getMessage());
            }
        });
        if (result instanceof RuntimeException) {
            if (result instanceof EvalException) {
                return;
            }
            throw new KDBizException(((RuntimeException)result).getCause().getMessage());
        }
        if (result != null && result.toString().length() > 0) {
            String resultStr = result.toString();
            if (!(result instanceof String && (resultStr.equalsIgnoreCase("false") || resultStr.equalsIgnoreCase("true")) || result instanceof Boolean)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u7684\u7ed3\u679c\u9519\u8bef\u3002\u7ed3\u679c\u53ea\u80fd\u662f\u201c\u901a\u8fc7\u201d\u6216\u8005\u662f\u201c\u4e0d\u901a\u8fc7\u201d\u3002\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002%s", (String)"CheckedFormulaUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), result.toString()));
            }
        } else {
            throw new KDBizException("result is null");
        }
    }

    private static Object getResult(CalculateService service, String formula, boolean flag) {
        ExpressStatus expressStatus = service.addCalculateExpress(formula);
        FormulaPoolManager poolMng = service.getPoolMng();
        List<IFormula> ifFormulas = poolMng.pull("IF");
        if (CollectionUtils.isNotEmpty(ifFormulas)) {
            ifFormulas.forEach(ifFormula -> ((ParamItem)ifFormula.getParamList().get(0)).fixParam(flag));
        }
        service.batchCalculate();
        return service.evalExpress(expressStatus);
    }

    public static void checkCanExcecuteDiff(String formula, String compareType, boolean canBeChar) {
        block8: {
            ICalContext ctx = ChkCheckServiceHelper.getICalContext();
            CalculateService service = new CalculateService(ctx);
            try {
                Object result = service.singleCalculate(ChkCheckServiceHelper.changePercentToDec(formula));
                service.getResultMap().forEach((k, v) -> {
                    if (v instanceof InvalidParamException) {
                        throw new KDBizException(((InvalidParamException)((Object)((Object)v))).getMessage());
                    }
                });
                if (result instanceof RuntimeException) {
                    if (result instanceof EvalException) {
                        return;
                    }
                    if (kd.bos.util.StringUtils.isEmpty((String)((RuntimeException)result).getCause().getMessage())) {
                        throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaError"), new Object[0]);
                    }
                    throw new KDBizException(((RuntimeException)result).getCause().getMessage());
                }
                if (result != null) {
                    if (result instanceof Integer || result instanceof Long || result instanceof BigInteger || result instanceof BigDecimal) break block8;
                    if (canBeChar) {
                        CheckedFormulaUtil.checkFormulaStr(result, compareType);
                        break block8;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u7ed3\u679c\u9519\u8bef\uff0c\u7ed3\u679c\u5e94\u4e3a\u6570\u503c\u3002\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"CheckedFormulaUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                throw new NullPointerException("result is null");
            }
            catch (Exception e) {
                if (e instanceof KDBizException) {
                    throw new KDBizException(e.getMessage());
                }
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaError"), new Object[0]);
            }
        }
    }

    private static void checkFormulaStr(Object result, String compareType) {
        if (result instanceof String) {
            String res = (String)result;
            if (!CHKTypeEnum.EQUAL.getName().equals(compareType) && !CHKTypeEnum.NOT_EQUALS.getName().equals(compareType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u524d\u6587\u672c\u53ea\u652f\u6301\u201c=\u201d\u548c\u201c<>\u201d\u6bd4\u8f83\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"CheckedFormulaUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u7684\u7ed3\u679c\u9519\u8bef\u3002\u7ed3\u679c\u53ea\u80fd\u662f\u6570\u503c\u6216\u6587\u672c\u3002\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"CheckedFormulaUtil_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public static Object[] changeVFuntionToNumber(String formula, IPageCache pageCache) {
        try {
            FormulaBuilder fb = new FormulaBuilder();
            StringBuilder checkFormula = new StringBuilder();
            return CheckedFormulaUtil.transToFormulaJudge(formula, pageCache, fb, checkFormula);
        }
        catch (Exception e) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaError"), new Object[0]);
        }
    }

    public static String getFormulaFromObjectResult(Object[] result) {
        FormulaBuilder formulas = (FormulaBuilder)result[0];
        return formulas.getLeftsb().toString();
    }

    public static void checkFormulaJudge(Object[] resultList, ChkFormulaModel model) {
        FormulaBuilder formulas = (FormulaBuilder)resultList[0];
        if (!StringUtil.equals((String)model.getLeftformula(), (String)formulas.leftsb.toString())) {
            model.setLeftformula(formulas.leftsb.toString());
        }
        if (!StringUtil.equals((String)model.getLformulatemp(), (String)formulas.leftwithtmpsb.toString())) {
            model.setLformulatemp(formulas.leftwithtmpsb.toString());
        }
        if (!StringUtil.equals((String)model.getRightformula(), (String)formulas.rigntsb.toString())) {
            model.setRightformula(formulas.rigntsb.toString());
        }
        if (!StringUtil.equals((String)model.getRformulatemp(), (String)formulas.rihhtwithtmpsb.toString())) {
            model.setRformulatemp(formulas.rihhtwithtmpsb.toString());
        }
    }

    public static String[] getFormulaForDiff(String formula, IPageCache pageCache) {
        String[] resultList = new String[3];
        Object[] transList = CheckedFormulaUtil.changeVFuntionToNumber(formula, pageCache);
        FormulaBuilder fb = (FormulaBuilder)transList[0];
        resultList[0] = fb.leftsb.toString();
        resultList[1] = fb.leftwithtmpsb.toString();
        resultList[2] = (String)transList[1];
        return resultList;
    }

    public static String getComboSign(String type) {
        return type + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH);
    }

    public static boolean validFormulaTextItem(String formula) {
        ExpressParser parser = new ExpressParser();
        EncoderService encoder = new EncoderService();
        try {
            boolean hasErrStr = parser.parseAll(formula, encoder).stream().anyMatch(p -> p instanceof NameExpr);
            if (hasErrStr) {
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaTextFormatError"), new Object[0]);
            }
        }
        catch (KDBizException kde) {
            throw kde;
        }
        catch (Exception e) {
            LOG.info("--> parse formula error:", (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u6b63\u786e\u6027\u3002", (String)"CheckedFormulaUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return true;
    }

    public static String removeTextFormulaItem(String formula) {
        int start;
        while ((start = formula.indexOf("\"")) != -1) {
            int end = formula.indexOf("\"", start + 1);
            if (end == -1) {
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.chkFormulaMissingSymbol"), new Object[0]);
            }
            formula = formula.replace(formula.substring(start, end + 1), "");
        }
        return formula;
    }

    public static String rebuildDatabyFormula(String data, IPageCache pageCache, long modelid) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c == '{') {
                sb.append(c);
                sb.append(data.charAt(++i));
                ++i;
                StringBuilder keysb = new StringBuilder();
                while (i < data.length()) {
                    c = data.charAt(i);
                    sb.append(c);
                    if (c == '\"') break;
                    keysb.append(c);
                    ++i;
                }
                String key = keysb.toString();
                String text = "";
                text = pageCache.get(key + "formula_withtemp") != null ? ChkFormulaServiceHelper.translateChkformla(pageCache.get(key + "formula_withtemp"), modelid, 1) : ChkFormulaServiceHelper.translateChkformla(pageCache.get(key), modelid, 1);
                sb.append(",\"");
                sb.append(text);
                sb.append('\"');
                sb.append(data.charAt(++i));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Object packGetText() {
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"getText");
        data.put("data", (Object)TimeServiceHelper.getTimeStamp());
        return data;
    }

    public static void existsFormula(String prop, String value, String name, long chkFormulaId, long modelId) {
        boolean is = QueryServiceHelper.exists((String)"bcm_chkformulasetting", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter(prop, "=", (Object)value), new QFilter("id", "!=", (Object)chkFormulaId)});
        if (is) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u8be5%s\u3002", (String)"CheckedFormulaUtil_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
        }
    }

    public static class FormulaBuilder {
        private StringBuilder leftsb = new StringBuilder();
        private StringBuilder leftwithtmpsb = new StringBuilder();
        private StringBuilder compsb = new StringBuilder();
        private StringBuilder rigntsb = new StringBuilder();
        private StringBuilder rihhtwithtmpsb = new StringBuilder();
        private boolean isLeft = true;
        private char lastChar = (char)32;

        public void switchSide() {
            if (!this.isLeft) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u6b63\u786e\u6027\uff0c\u5e26\u6709\u4e24\u4e2a\u6bd4\u8f83\u7b26\u3002", (String)"CheckedFormulaUtil_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.isLeft = false;
        }

        public void append(char str) {
            String op = "+-*/";
            if (str >= '0' && str <= '9' || str == '(' || str == ')' || str == '.' || op.contains(String.valueOf(str))) {
                if (op.contains(String.valueOf(str)) && this.lastChar == str) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u6b63\u786e\u6027\u3002", (String)"CheckedFormulaUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (this.isLeft) {
                    this.leftsb.append(str);
                    this.leftwithtmpsb.append(str);
                } else {
                    this.rigntsb.append(str);
                    this.rihhtwithtmpsb.append(str);
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u6b63\u786e\u6027\u3002", (String)"CheckedFormulaUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.lastChar = str;
        }

        public void appendString(String str) {
            if (this.isLeft) {
                this.leftsb.append(str);
                this.leftwithtmpsb.append(str);
            } else {
                this.rigntsb.append(str);
                this.rihhtwithtmpsb.append(str);
            }
            this.lastChar = str.charAt(str.length() - 1);
        }

        public void appendNoTmp(String str) {
            if (this.isLeft) {
                this.leftsb.append(str);
            } else {
                this.rigntsb.append(str);
            }
            this.lastChar = (char)32;
        }

        public void appendWithTmp(String str) {
            if (this.isLeft) {
                this.leftwithtmpsb.append(str);
            } else {
                this.rihhtwithtmpsb.append(str);
            }
            this.lastChar = (char)32;
        }

        public StringBuilder getLeftsb() {
            return this.leftsb;
        }

        public StringBuilder getRigntsb() {
            return this.rigntsb;
        }

        public StringBuilder getCompsb() {
            return this.compsb;
        }
    }
}

