/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.list.column.TemplateTextItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.chkcheck.util.CheckedFormulaUtil;
import kd.fi.bcm.business.chkcheck.util.NumberQuantileValueUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.util.NumberUtils;
import org.apache.commons.lang.StringUtils;

public class FormulaAnalyseUtil {
    protected static Log log = LogFactory.getLog(FormulaAnalyseUtil.class);

    public static void packageFormulaResult(PackageDataEvent e, List<Map<String, Object>> data, String result, String resultMap, String fieldKey, TemplateTextItem templateTextItem, Set<String> noTempFormulas) {
        try {
            Map allFormulaMap = (Map)JSONUtils.cast((String)resultMap, HashMap.class);
            String formula = FormulaAnalyseUtil.getFormula(fieldKey, allFormulaMap);
            if (StringUtils.isBlank((String)formula)) {
                templateTextItem.setTem(FormulaAnalyseUtil.getResult(e, fieldKey));
                return;
            }
            if (CheckedFormulaUtil.isSpecialFormula(formula)) {
                formula = FormulaAnalyseUtil.lowerLinkFormula(formula);
            }
            Matcher matcher = ParamConstant.PATTERN_FORMULA.matcher(formula);
            TreeSet<String> treeSet = new TreeSet<String>((s1, s2) -> s2.compareToIgnoreCase((String)s1));
            HashSet<String> negativeNumber = new HashSet<String>();
            HashMap<String, Object> formulaMap = new HashMap<String, Object>(16);
            while (matcher.find()) {
                String group = matcher.group();
                treeSet.add(group);
                Object value = FormulaAnalyseUtil.getFormulaMap(fieldKey, allFormulaMap).get(group);
                if (value instanceof String) {
                    formulaMap.put(group, String.format("\"%s\"", value));
                    continue;
                }
                String str = Objects.toString(value);
                if (NumberUtils.isNumber((String)str) && new BigDecimal(str).compareTo(BigDecimal.ZERO) < 0) {
                    negativeNumber.add(group);
                }
                formulaMap.put(group, value);
            }
            boolean onlyOneFactor = "".equals(formula.replaceAll(ParamConstant.PATTERN_FORMULA.pattern(), "").trim());
            for (String s : treeSet) {
                if (noTempFormulas.contains(s)) {
                    formula = formula.replace(s, formulaMap.get(s) == null ? "0" : Objects.toString(formulaMap.get(s)));
                    continue;
                }
                if (negativeNumber.contains(s) && !onlyOneFactor) {
                    formula = formula.replace(s, String.format("(#{%s})", s));
                    continue;
                }
                if (formulaMap.get(s) instanceof String && ((String)formulaMap.get(s)).contains("Exception: ")) {
                    formula = (String)formulaMap.get(s);
                    continue;
                }
                formula = formula.replace(s, String.format("#{%s}", s));
            }
            templateTextItem.setTem(formula);
            AtomicBoolean hasText = new AtomicBoolean(false);
            formulaMap.forEach((k, v) -> {
                if (!hasText.get() && treeSet.contains(k) && v instanceof String) {
                    hasText.set(true);
                }
            });
            for (Map.Entry entry : formulaMap.entrySet()) {
                String k2 = (String)entry.getKey();
                Object v2 = entry.getValue();
                v2 = treeSet.contains(k2) && v2 == null ? (hasText.get() ? "\"\"" : "0") : String.valueOf(v2);
                formulaMap.put(k2, v2);
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                map.put("key", k2);
                map.put("id", e.getRowData().getLong("id"));
                if (StringUtils.isBlank((String)Objects.toString(v2))) {
                    map.put("text", result);
                } else {
                    map.put("text", NumberQuantileValueUtil.change2QuantileValue(Objects.toString(v2)));
                }
                data.add(map);
            }
        }
        catch (IOException ioException) {
            log.error("resultmap json2object error!", (Throwable)ioException);
        }
    }

    private static String lowerLinkFormula(String formula) {
        formula = formula.replace("ROUND(", "round(");
        formula = formula.replace("ABS(", "abs(");
        formula = formula.replace("LEN(", "len(");
        return formula;
    }

    @SDKMark
    public static Map<String, String> packFormulaResult(String resultMap) {
        Map rresultMap;
        Object result;
        boolean onlyOneFactor;
        TreeSet<String> treeSet;
        Matcher matcher;
        Map lresultMap;
        Object lmap;
        Map allFormulaMap = null;
        try {
            allFormulaMap = (Map)JSONUtils.cast((String)resultMap, HashMap.class);
        }
        catch (IOException e) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> leftAndRightResultMap = new HashMap<String, String>();
        if (allFormulaMap.containsKey("leftResultMap") && (lmap = allFormulaMap.get("leftResultMap")) instanceof Map && (lresultMap = (Map)lmap).containsKey("leftformula")) {
            String leftFormula = Objects.toString(lresultMap.get("leftformula"));
            matcher = ParamConstant.PATTERN_FORMULA.matcher(leftFormula);
            treeSet = new TreeSet<String>((s1, s2) -> s2.compareToIgnoreCase((String)s1));
            while (matcher.find()) {
                treeSet.add(matcher.group());
            }
            onlyOneFactor = "".equals(leftFormula.replaceAll(ParamConstant.PATTERN_FORMULA.pattern(), "").trim());
            String leftResult = FormulaAnalyseUtil.lowerLinkFormula(leftFormula);
            for (String key : treeSet) {
                result = lresultMap.get(key);
                if (result == null) {
                    leftResult = leftResult.replace(key, NumberQuantileValueUtil.change2QuantileValue(BCMConstant.Zero.toString()));
                    continue;
                }
                if (!onlyOneFactor && NumberUtils.isNegativeNumber((String)Objects.toString(result))) {
                    leftResult = leftResult.replace(key, String.format("(%s)", result));
                    continue;
                }
                leftResult = leftResult.replace(key, Objects.toString(result));
            }
            leftAndRightResultMap.put("left", leftResult);
        }
        if (allFormulaMap.containsKey("rightResultMap") && (lmap = allFormulaMap.get("rightResultMap")) instanceof Map && (rresultMap = (Map)lmap).containsKey("rightformula")) {
            String rightFormula = Objects.toString(rresultMap.get("rightformula"));
            matcher = ParamConstant.PATTERN_FORMULA.matcher(rightFormula);
            treeSet = new TreeSet((s1, s2) -> s2.compareToIgnoreCase((String)s1));
            while (matcher.find()) {
                treeSet.add(matcher.group());
            }
            onlyOneFactor = "".equals(rightFormula.replaceAll(ParamConstant.PATTERN_FORMULA.pattern(), "").trim());
            String rightResult = FormulaAnalyseUtil.lowerLinkFormula(rightFormula);
            for (String key : treeSet) {
                result = rresultMap.get(key);
                if (result == null) {
                    rightResult = rightResult.replace(key, NumberQuantileValueUtil.change2QuantileValue(BCMConstant.Zero.toString()));
                    continue;
                }
                if (!onlyOneFactor && NumberUtils.isNegativeNumber((String)Objects.toString(result))) {
                    rightResult = rightResult.replace(key, String.format("(%s)", result));
                    continue;
                }
                rightResult = rightResult.replace(key, Objects.toString(result));
            }
            leftAndRightResultMap.put("right", rightResult);
        }
        return leftAndRightResultMap;
    }

    private static String getFormula(String fieldKey, Map<String, Object> allFormulaMap) {
        Map<String, Object> formulaMap = FormulaAnalyseUtil.getFormulaMap(fieldKey, allFormulaMap);
        if (formulaMap == null) {
            return null;
        }
        if ("leftresultcol".equals(fieldKey)) {
            return formulaMap.containsKey("leftformula") ? Objects.toString(formulaMap.get("leftformula")) : null;
        }
        return formulaMap.containsKey("rightformula") ? Objects.toString(formulaMap.get("rightformula")) : null;
    }

    private static Map<String, Object> getFormulaMap(String fieldKey, Map<String, Object> allFormulaMap) {
        if ("leftresultcol".equals(fieldKey)) {
            return (Map)allFormulaMap.get("leftResultMap");
        }
        return (Map)allFormulaMap.get("rightResultMap");
    }

    public static String getFullFormula(PackageDataEvent e, String fieldKey) {
        if (fieldKey.equals("leftresultcol")) {
            return e.getRowData().getString("fulllformula");
        }
        return e.getRowData().getString("fullrformula");
    }

    public static String getResult(PackageDataEvent e, String fieldKey) {
        if (fieldKey.equals("leftresultcol")) {
            return e.getRowData().getString("leftresult");
        }
        return e.getRowData().getString("rightresult");
    }
}

