/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.chkcheck.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.fel.common.StringUtils;

public class NumberQuantileValueUtil {
    public static String change2QuantileValue(String value, String scaleStr) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (NumberUtils.isNumber((String)value)) {
            BigDecimal bd = new BigDecimal(value);
            return NumberQuantileValueUtil.parseNumber(",###,##0" + scaleStr, bd);
        }
        return value;
    }

    public static String change2QuantileValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (NumberUtils.isNumber((String)value)) {
            BigDecimal bd = new BigDecimal(value);
            return NumberQuantileValueUtil.parseNumber(",###,##0.00", bd);
        }
        return value;
    }

    public static String change2QuantileValueDefault2Zero(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (NumberUtils.isNumber((String)value)) {
            BigDecimal bd = new BigDecimal(value);
            return NumberQuantileValueUtil.parseNumber(",###,##0.00####", bd);
        }
        return value;
    }

    @SDKMark
    public static String change2QuantileValueNoEndZero(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (NumberUtils.isNumber((String)value)) {
            BigDecimal bd = new BigDecimal(value);
            return NumberQuantileValueUtil.parseNumber(",###,##0.######", bd);
        }
        return value;
    }

    public static String parseNumber(String pattern, BigDecimal bd) {
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(bd);
    }
}

