/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.computing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.computing.BizRuleExecutor;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.TemplateUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.bizrule.BizRuleServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.BRExecStatusEnum;
import kd.fi.bcm.common.enums.BizRuleDebugLogInfoEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.log.BizRuleDebugLogInfo;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import org.apache.commons.collections.CollectionUtils;

public class BizRuleExecStarter {
    public static boolean execBizRuleWhenSave(Object templateId, BizRuleExecParam param, ApplicationTypeEnum app) {
        return BizRuleExecStarter.execBizRule(templateId, param, "execwhensave", app, null);
    }

    public static boolean execBizRuleWhenExtData2Olap(Object templateId, BizRuleExecParam param, ApplicationTypeEnum app) {
        return BizRuleExecStarter.execBizRule(templateId, param, "extdata2olap", app, null);
    }

    public static boolean execBizRuleWhenOpen(Object templateId, BizRuleExecParam param, ApplicationTypeEnum app) {
        return BizRuleExecStarter.execBizRule(templateId, param, "execwhenopen", app, null);
    }

    public static boolean execBizRule(Object templateId, BizRuleExecParam param, ApplicationTypeEnum app, BizRuleExecuteTypeEnum type) {
        return BizRuleExecStarter.execBizRule(templateId, param, null, app, type);
    }

    private static boolean execBizRule(Object templateId, BizRuleExecParam param, String property, ApplicationTypeEnum app, BizRuleExecuteTypeEnum type) {
        Collection allocateRecords;
        if (param == null) {
            return false;
        }
        if (templateId != null && (Long)templateId > 0L) {
            templateId = TemplateUtils.getTemplateFirstVersionId((Long)templateId);
            QFilter filter = new QFilter("template", "=", templateId);
            if (StringUtils.isNotEmpty((String)property) && !"extdata2olap".equals(property)) {
                filter.and(property, "=", (Object)true);
            }
            if ((allocateRecords = QueryServiceHelper.query((String)"bcm_brallocateentity", (String)"bizrule.id", (QFilter[])new QFilter[]{filter})).isEmpty()) {
                return false;
            }
            HashSet dispenseRuleIds = new HashSet(allocateRecords.size());
            allocateRecords.forEach(e -> dispenseRuleIds.add(e.getLong("bizrule.id")));
            allocateRecords = BizRuleServiceHelper.getBizRule((String)param.getModelNum(), f -> f.add("bizrule.id", "in", (Object)dispenseRuleIds), (String[])new String[]{param.getProcessNumber()});
            if (allocateRecords.isEmpty()) {
                return false;
            }
        } else {
            allocateRecords = BizRuleServiceHelper.getBizRule((String)param.getModelNum(), null, (String[])new String[]{param.getProcessNumber()});
        }
        if ((allocateRecords = "extdata2olap".equals(property) ? (Collection)allocateRecords.stream().filter(rule -> BizRuleExecuteTypeEnum.XSYN_ONLY.getCode().equals(rule.getString("bizrule.executetype"))).collect(Collectors.toList()) : (type != null ? (Collection)allocateRecords.stream().filter(rule -> BizRuleExecuteTypeEnum.ALL.getCode().equals(rule.getString("bizrule.executetype"))).collect(Collectors.toList()) : (Collection)allocateRecords.stream().filter(rule -> BizRuleExecuteTypeEnum.ALL.getCode().equals(rule.getString("bizrule.executetype")) || BizRuleExecuteTypeEnum.RPT_ONLY.getCode().equals(rule.getString("bizrule.executetype"))).collect(Collectors.toList()))).isEmpty()) {
            return false;
        }
        ArrayList bizRuleList = new ArrayList();
        allocateRecords.forEach(e -> {
            String content = e.getString("bizrule.content");
            if (StringUtils.isNotEmpty((String)content)) {
                bizRuleList.add(Pair.onePair((Object)e.getLong("bizrule.id"), (Object)content));
            }
        });
        if (bizRuleList.isEmpty()) {
            return false;
        }
        DynamicObject[] records = BizRuleExecStarter.createExecRecord(allocateRecords.toArray(new DynamicObject[0]), param, param.getModelId());
        param.setBizRuleList(bizRuleList);
        ArrayList<BizRuleExecParam> excuteParams = new ArrayList<BizRuleExecParam>();
        excuteParams.add(param);
        Map<Long, String> result = OlapServiceHelper.excuteScript4ReportParams(param.getModelNum(), excuteParams, app);
        for (DynamicObject record : records) {
            String reason;
            long bizRuleId = record.getLong("bizrule");
            List infolist = (List)ThreadCache.get((Object)String.valueOf(bizRuleId));
            String executeInfoMsg = "";
            if (CollectionUtils.isNotEmpty((Collection)infolist)) {
                executeInfoMsg = infolist.stream().filter(log -> log.getLevel() == BizRuleDebugLogInfoEnum.LOG).map(BizRuleDebugLogInfo::getInfo).collect(Collectors.joining(","));
            }
            if (StringUtils.isNotEmpty((String)(reason = result.get(bizRuleId)))) {
                record.set("execstatus", (Object)BRExecStatusEnum.FAILED.getIndex());
                record.set("reason", (Object)(reason + System.lineSeparator() + executeInfoMsg));
            } else {
                record.set("execstatus", (Object)BRExecStatusEnum.SUCCESS.getIndex());
                record.set("reason", (Object)executeInfoMsg);
            }
            if (ThreadCache.get((Object)(bizRuleId + "startTime")) != null) {
                record.set("starttime", ThreadCache.get((Object)(bizRuleId + "startTime")));
            }
            if (ThreadCache.get((Object)(bizRuleId + "endTime")) != null) {
                record.set("endtime", ThreadCache.get((Object)(bizRuleId + "endTime")));
                continue;
            }
            record.set("endtime", (Object)System.currentTimeMillis());
        }
        if (result.values().stream().anyMatch(StringUtils::isNotEmpty)) {
            ThreadCache.put((Object)"ruleExecResult", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])records);
        return true;
    }

    public static List<Long> getRuleByTmp(List<Long> templateIds) {
        boolean isFalse = false;
        ArrayList<Long> bizRuleIdList = new ArrayList<Long>();
        DynamicObjectCollection tmp = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number, model.id", (QFilter[])new QFBuilder("id", "in", templateIds).toArray());
        if (tmp == null || tmp.isEmpty()) {
            return new ArrayList<Long>(1);
        }
        long modelId = ((DynamicObject)tmp.get(0)).getLong("model.id");
        Set numbers = tmp.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        QFilter filter = new QFilter("model.id", "=", (Object)modelId);
        filter.and("template.number", "in", numbers);
        ArrayList bizRuleIdListTemp = new ArrayList();
        QueryServiceHelper.query((String)"bcm_brallocateentity", (String)"bizrule.id", (QFilter[])new QFilter[]{filter}).forEach(e -> bizRuleIdListTemp.add(e.getLong("bizrule.id")));
        if (!bizRuleIdListTemp.isEmpty()) {
            QFilter filter1 = new QFilter("id", "in", (Object)bizRuleIdListTemp.toArray());
            filter1.and(new QFilter("deletestatus", "=", (Object)isFalse));
            filter1.and(new QFilter("status", "=", (Object)"1"));
            QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id", (QFilter[])new QFilter[]{filter1}, (String)"executeseq").forEach(e -> bizRuleIdList.add(e.getLong("id")));
        }
        return bizRuleIdList;
    }

    public static void execBizRule(List<Long> ids, BizRuleExecParam param, boolean isSync, boolean isDebug) {
        String properties = isDebug ? "id, name, number, debug, model.id, processcatalog" : "id, name, number, content, model.id, processcatalog";
        DynamicObject[] rules = (DynamicObject[])QueryServiceHelper.query((String)"bcm_bizruleentity", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids.toArray())}).toArray((Object[])new DynamicObject[0]);
        if (rules.length == 0) {
            return;
        }
        DynamicObject[] records = BizRuleExecStarter.createExecRecord(rules, param, rules[0].getLong("model.id"));
        if (!isSync) {
            ThreadPoolService.runRulesAsyncThread(() -> new BizRuleExecutor(rules, records, param, isDebug).run());
        } else {
            new BizRuleExecutor(rules, records, param, isDebug).run();
        }
    }

    public static void execBizRule(List<Long> bizRuleIds, BizRuleExecParam param, boolean isDebug) {
        BizRuleExecStarter.execBizRule(bizRuleIds, param, false, isDebug);
    }

    public static DynamicObject[] createExecRecord(Object[] bizRuleIds, Object modelId) {
        DynamicObject[] execInfos = new DynamicObject[bizRuleIds.length];
        for (int i = 0; i < bizRuleIds.length; ++i) {
            execInfos[i] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_brexecuteinfoentity");
            BizRuleExecStarter.setExecRecord(execInfos[i], modelId, bizRuleIds[i]);
        }
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])execInfos);
    }

    public static DynamicObject[] createExecRecord(DynamicObject[] bizRules, BizRuleExecParam param, Object modelId) {
        DynamicObject[] execInfos = new DynamicObject[bizRules.length];
        long entityId = param.getEntityId();
        long fyId = param.getFyId();
        long periodId = param.getPeriodId();
        long currencyId = param.getCurrencyId();
        long scenarioId = param.getScenarioId();
        long processid = param.getProcessId();
        String rulePropertyName = bizRules[0].getDataEntityType().getProperties().containsKey((Object)"bizrule_id") ? "bizrule_id" : "id";
        for (int i = 0; i < bizRules.length; ++i) {
            execInfos[i] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_brexecuteinfoentity");
            BizRuleExecStarter.setExecRecord(execInfos[i], modelId, bizRules[i].getLong(rulePropertyName), entityId, scenarioId, fyId, periodId, currencyId, processid);
        }
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])execInfos);
    }

    private static void setExecRecord(DynamicObject execInfo, Object modelId, Object bizRuleId) {
        execInfo.set("bizrule", bizRuleId);
        execInfo.set("model", modelId);
        execInfo.set("starttime", (Object)System.currentTimeMillis());
        execInfo.set("execstatus", (Object)BRExecStatusEnum.EXECUTING.getIndex());
        execInfo.set("executor", (Object)RequestContext.get().getUserId());
    }

    private static void setExecRecord(DynamicObject execInfo, Object modelId, Object bizRuleId, Long entity, Long scenario, Long year, Long period, Long currency, Long processid) {
        BizRuleExecStarter.setExecRecord(execInfo, modelId, bizRuleId);
        execInfo.set("entity", (Object)entity);
        execInfo.set("scenario", (Object)scenario);
        execInfo.set("year", (Object)year);
        execInfo.set("period", (Object)period);
        execInfo.set("currency", (Object)currency);
        execInfo.set("process", (Object)processid);
    }
}

