/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.computing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;

public class BizRuleExecuteHelper {
    private static final Log log = LogFactory.getLog(BizRuleExecuteHelper.class);

    public static void executeBizRule(long modelId, List<Long> orgIdList, long sceneId, long yearId, long periodId, List<Long> processIdList) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        Map<Long, List<Long>> process2ruleIdMap = BizRuleExecuteHelper.findBizRuleIdListMapByProcess(modelId, processIdList);
        for (Long orgId : orgIdList) {
            IDNumberTreeNode entityMemberNode = MemberReader.findEntityMemberById((String)modelNumber, (Long)orgId);
            if (entityMemberNode.getId() == -1L) {
                log.error("BCM_Intelligent_scheduling_ORG, org is not exit, continue next, orgId = {}", (Object)orgId);
                continue;
            }
            String entityNumber = entityMemberNode.getNumber();
            String currencyNumber = entityMemberNode.getCurrency();
            IDNumberTreeNode currencyMemberNode = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)currencyNumber);
            IDNumberTreeNode sceneMemberNode = MemberReader.findScenaMemberById((String)modelNumber, (Long)sceneId);
            String sceneNumber = sceneMemberNode.getNumber();
            IDNumberTreeNode yearMemberNode = MemberReader.findFyMemberById((String)modelNumber, (Long)yearId);
            String yearNumber = yearMemberNode.getNumber();
            IDNumberTreeNode periodMemberNode = MemberReader.findPeriodMemberById((String)modelNumber, (Long)periodId);
            String periodNumber = periodMemberNode.getNumber();
            for (Long processId : processIdList) {
                List<Long> bizRuleIds = process2ruleIdMap.get(processId);
                if (bizRuleIds == null) {
                    log.error("BCM_Intelligent_scheduling_PROCESS, process no biz rules, continue next, processId = {}", (Object)processId);
                    continue;
                }
                BizRuleExecParam param = new BizRuleExecParam(modelNumber);
                param.addCommonParamPair(PresetConstant.ENTITY_DIM, orgId, entityNumber);
                param.addCommonParamPair(PresetConstant.SCENE_DIM, Long.valueOf(sceneId), sceneNumber);
                param.addCommonParamPair(PresetConstant.FY_DIM, Long.valueOf(yearId), yearNumber);
                param.addCommonParamPair(PresetConstant.PERIOD_DIM, Long.valueOf(periodId), periodNumber);
                param.addCommonParamPair(PresetConstant.CURRENCY_DIM, currencyMemberNode.getId(), currencyNumber);
                IDNumberTreeNode processMemberNode = MemberReader.findProcessMemberById((String)modelNumber, (Long)processId);
                param.addCommonParamPair(PresetConstant.PROCESS_DIM, processId, processMemberNode.getNumber());
                BizRuleExecStarter.execBizRule(bizRuleIds, param, false);
            }
        }
    }

    private static Map<Long, List<Long>> findBizRuleIdListMapByProcess(long modelId, List<Long> processIdList) {
        HashMap<Long, List<Long>> process2ruleIdMap = new HashMap<Long, List<Long>>(16);
        QFBuilder qf = new QFBuilder();
        qf.add("model.id", "=", (Object)modelId);
        qf.add("bizrule.status", "=", (Object)"1");
        qf.add("member", "in", processIdList);
        qf.add(new QFilter("bizrule.deletestatus", "=", (Object)false));
        Collection rules = BusinessDataServiceHelper.loadFromCache((String)"bcm_bizrulealloprocess", (String)"member, bizrule.id", (QFilter[])qf.toArray()).values();
        for (DynamicObject rule : rules) {
            long processId = rule.getLong("member");
            ArrayList<Long> ruleIds = (ArrayList<Long>)process2ruleIdMap.get(processId);
            if (ruleIds == null) {
                ruleIds = new ArrayList<Long>(10);
            }
            ruleIds.add(rule.getLong("bizrule.id"));
            process2ruleIdMap.put(processId, ruleIds);
        }
        return process2ruleIdMap;
    }
}

