/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.computing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.BRExecStatusEnum;
import kd.fi.bcm.common.enums.BizRuleDebugLogInfoEnum;
import kd.fi.bcm.common.log.BizRuleDebugLogInfo;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import org.apache.commons.lang3.StringUtils;

public class BizRuleExecutor
implements Runnable {
    private DynamicObject[] rules;
    private Map<Long, DynamicObject> record4rule = new HashMap<Long, DynamicObject>(16);
    private BizRuleExecParam param;
    private boolean isDebug;

    BizRuleExecutor(DynamicObject[] rules, DynamicObject[] records, BizRuleExecParam param, boolean isDebug) {
        this.rules = rules;
        this.param = param;
        this.isDebug = isDebug;
        if (rules.length != records.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u89c4\u5219\u6570\u548c\u6267\u884c\u7ed3\u679c\u6570\u4e0d\u5339\u914d\u3002", (String)"BizRuleExecutor_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        for (int i = 0; i < rules.length; ++i) {
            this.record4rule.put(rules[i].getLong("id"), records[i]);
        }
    }

    @Override
    public void run() {
        ArrayList<Pair> rulePairs = new ArrayList<Pair>();
        for (DynamicObject rule : this.rules) {
            rulePairs.add(Pair.onePair((Object)rule.getLong("id"), (Object)(this.isDebug ? rule.getString("debug") : rule.getString("content"))));
        }
        this.param.setBizRuleList(rulePairs);
        String modelNum = this.param.getModelNum();
        Map<Long, String> result = OlapServiceHelper.excuteScript4ReportParams(modelNum, Lists.newArrayList((Object[])new BizRuleExecParam[]{this.param}), null, this.isDebug);
        ArrayList recIds = new ArrayList();
        this.record4rule.forEach((k, v) -> recIds.add(v.getLong("id")));
        Map recs = BusinessDataServiceHelper.loadFromCache((Object[])recIds.toArray(), (String)"bcm_brexecuteinfoentity");
        for (DynamicObject rule : this.rules) {
            CharSequence[] infos;
            Long ruleId = rule.getLong("id");
            DynamicObject record = (DynamicObject)recs.get(this.record4rule.get(ruleId).getLong("id"));
            if (StringUtils.isEmpty((CharSequence)result.get(ruleId))) {
                record.set("execstatus", (Object)BRExecStatusEnum.SUCCESS.getIndex());
            } else {
                record.set("execstatus", (Object)BRExecStatusEnum.FAILED.getIndex());
                record.set("reason", (Object)result.get(ruleId));
                ThreadCache.put((Object)(ruleId + "errorinfo"), (Object)result.get(ruleId));
            }
            record.set("endtime", (Object)System.currentTimeMillis());
            List infolist = (List)ThreadCache.get((Object)ruleId.toString());
            if (infolist == null || infolist.isEmpty() || (infos = this.isDebug ? (String[])infolist.stream().map(BizRuleDebugLogInfo::getInfo).toArray(String[]::new) : (String[])infolist.stream().filter(log -> log.getLevel() == BizRuleDebugLogInfoEnum.LOG).map(BizRuleDebugLogInfo::getInfo).toArray(String[]::new)).length <= 0) continue;
            String info = String.join((CharSequence)"\n", infos);
            if (StringUtils.isEmpty((CharSequence)result.get(ruleId))) {
                record.set("reason", (Object)info);
            } else {
                record.set("reason", (Object)(info + "\n" + result.get(ruleId)));
            }
            ThreadCache.put((Object)(ruleId + "loginfo"), (Object)info);
        }
        if (recs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])recs.values().toArray(new DynamicObject[0]));
        }
    }
}

