/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.config.ChildConfigMember;
import kd.fi.bcm.business.config.ConfigModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class BatchConfigModel
extends ConfigModel {
    private List<ChildConfigMember> childConfigMembers = Lists.newArrayListWithExpectedSize((int)10);

    public BatchConfigModel(ConfigModel configModel, List<ChildConfigEnum> childConfigEnums) {
        super(configModel.getNumber(), configModel.getName(), configModel.getDescription());
        if (childConfigEnums == null || childConfigEnums.isEmpty()) {
            return;
        }
        childConfigEnums.forEach(childConfigEnum -> this.childConfigMembers.add(new ChildConfigMember((ChildConfigEnum)childConfigEnum)));
    }

    @Override
    public DynamicObject[] toDy(Object model) {
        DynamicObject[] dynamicObjects = new DynamicObject[1];
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_adjustbiztypeconfig");
        dy.set("number", (Object)this.getNumber());
        Map<Lang, String> trans = BatchConfigModel.getLanguageTranslate(this.getName(), this.getNumber());
        dy.set("name", LanguageUtil.getName(this.getName(), trans));
        Map<Lang, String> trans_des = BatchConfigModel.getLanguageTranslate(this.getDescription(), this.getNumber());
        dy.set("description", LanguageUtil.getName(this.getDescription(), trans_des));
        dy.set("model", model);
        DynamicObjectCollection childConfigs = dy.getDynamicObjectCollection("entryentity");
        this.childConfigMembers.forEach(childConfigMember -> {
            DynamicObject dy1 = childConfigs.addNew();
            dy1.set("seq", (Object)childConfigs.size());
            dy1.set("isshow", (Object)(childConfigMember.isConfig() ? "1" : "0"));
            if (StringUtil.equals((String)"CM045", (String)this.getNumber()) && StringUtil.equals((String)ChildConfigEnum.BOTTOMREFRESH.getBusinesstypevalue(), (String)childConfigMember.getBusinesstypevalue())) {
                dy1.set("isshow", (Object)(ConfigServiceHelper.getBoolParam(LongUtil.toLong((Object)model), "CM045") ? "1" : "0"));
            }
            dy1.set("presetname", LanguageUtil.getValue(childConfigMember.getPresetname(), "ChildConfigEnum_" + childConfigMember.getBusinesstypevalue(), "fi-bcm-business"));
            dy1.set("showname", LanguageUtil.getValue(childConfigMember.getShowname(), "ChildConfigEnum_" + childConfigMember.getBusinesstypevalue(), "fi-bcm-business"));
            dy1.set("entrydescription", LanguageUtil.getValue(childConfigMember.getEntrydescription(), "ChildConfigEnum_des_" + childConfigMember.getBusinesstypevalue(), "fi-bcm-business"));
            dy1.set("businesstypevalue", (Object)childConfigMember.getBusinesstypevalue());
        });
        dynamicObjects[0] = dy;
        return dynamicObjects;
    }

    public List<ChildConfigMember> getChildConfigMembers() {
        return this.childConfigMembers;
    }
}

