/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.config;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.config.ConfigAdapterService;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.StringUtil;

public class CmConfigAdapterService
implements ConfigAdapterService {
    private static final String CONFIG = "config";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String ID = "id";
    private static final String JSON = "json";

    @Override
    public boolean getBool(long modelid, String key) {
        return (Boolean)ThreadCache.get((Object)(modelid + "|" + key), () -> {
            if ("CM010".equals(key) || "CM011".equals(key)) {
                return ConfigServiceHelper.isHwApp();
            }
            Object value = AppCacheServiceHelper.get(modelid + "." + key);
            if (value == null) {
                value = CmConfigAdapterService.queryConfig(modelid, key);
                ConfigServiceHelper.cacheIt(modelid, key, value);
            }
            return ConfigServiceHelper.resolverConfigParam(value);
        });
    }

    @Override
    public Pair<Boolean, Set<String>> getConfigOfCMO04(Long modelId) {
        return (Pair)ThreadCache.get((Object)(modelId + "cm004_exceptOrg"), () -> {
            boolean openCM004 = ConfigServiceHelper.getBoolParam(modelId, "CM004");
            HashSet notCheckOrgSet = new HashSet();
            if (openCM004) {
                QFilter filter = new QFilter(MODEL, "=", (Object)modelId);
                filter.and(NUMBER, "=", (Object)"CM004");
                String fields = "orgentity,orgentity.entity,orgentity.entity.number,orgentity.entity.id,orgentity.rangevalue";
                DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_configsetting_cm021", (String)fields, (QFilter[])filter.toArray());
                orgs.forEach(p -> {
                    Set<String> entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange("bcm_entitymembertree", p.getLong("orgentity.entity.id"), p.getString("orgentity.entity.number"), p.getInt("orgentity.rangevalue"), String.valueOf(modelId), DetailTypeEnum.MEMBERPERM);
                    notCheckOrgSet.addAll(entitySet);
                });
            }
            return Pair.onePair((Object)openCM004, notCheckOrgSet);
        });
    }

    private static Object queryConfig(Long modelid, String key) {
        return ThreadCache.get((Object)String.format("querycfg-%d-%s", modelid, key), () -> {
            QFBuilder qf = new QFBuilder();
            qf.add(MODEL, "=", (Object)modelid);
            qf.add(NUMBER, "=", (Object)key);
            DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_configsetting", (String)CONFIG, (QFilter[])qf.toArray());
            if (obj != null) {
                return obj.get(CONFIG);
            }
            return ConfigEnum.getConfigDataByNumber((String)key).isConfig();
        });
    }

    @Override
    public String getString(long modelId, String key) {
        QFBuilder qf = new QFBuilder();
        qf.add(MODEL, "=", (Object)modelId);
        qf.add(NUMBER, "=", (Object)key);
        DynamicObject configModel = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_configsetting", (String)CONFIG, (QFilter[])qf.toArray());
        if (configModel != null) {
            String configVal = configModel.getString(CONFIG);
            return configVal;
        }
        return "";
    }

    @Override
    public boolean getBool(Long modelid, String key, String filedKey) {
        return (Boolean)ThreadCache.get((Object)(modelid + "|" + key + "_" + filedKey), () -> {
            if ("CM010".equals(key) || "CM011".equals(key)) {
                return ConfigServiceHelper.isHwApp();
            }
            Object value = AppCacheServiceHelper.get(modelid + "." + key + "_" + filedKey);
            if (value == null) {
                value = CmConfigAdapterService.queryFiledConfig(modelid, key, filedKey);
                ConfigServiceHelper.cacheIt(modelid, key + "_" + filedKey, value);
            }
            AppCacheServiceHelper.remove(modelid + "." + key + "_" + filedKey);
            return ConfigServiceHelper.resolverConfigParam(value);
        });
    }

    private static Object queryFiledConfig(Long modelid, String key, String filedKey) {
        return ThreadCache.get((Object)String.format("querycfg-%d-%s", modelid, key), () -> CmConfigAdapterService.getAdditionFieldValue(modelid, key, filedKey));
    }

    private static Object getAdditionFieldValue(Long modelId, String configNumber, String controlSign) {
        Map<String, Object> addtionFieldMap = CmConfigAdapterService.getAdditionFieldMap(modelId, configNumber);
        if (addtionFieldMap != null && addtionFieldMap.containsKey(controlSign)) {
            return addtionFieldMap.get(controlSign);
        }
        return null;
    }

    private static Map<String, Object> getAdditionFieldMap(Long modelId, String configNumber) {
        String addtionField;
        QFBuilder configBuilder = new QFBuilder();
        configBuilder.add(new QFilter(MODEL, "=", (Object)modelId));
        configBuilder.add(new QFilter(NUMBER, "=", (Object)configNumber));
        DynamicObject config = QueryServiceHelper.queryOne((String)"bcm_configsetting", (String)JSON, (QFilter[])configBuilder.toArray());
        if (config != null && !StringUtil.isEmptyString((String)(addtionField = config.getString(JSON)))) {
            Map addtionFieldMap = (Map)SerializationUtils.fromJsonString((String)addtionField, Map.class);
            return addtionFieldMap;
        }
        return null;
    }

    @Override
    public Pair<Object, Set<String>> getCfgWithExpOrg(long modelId, String key) {
        String fields = "config,orgentity.entity,orgentity.entity.number,orgentity.entity.id,orgentity.rangevalue";
        QFilter qf = new QFilter(MODEL, "=", (Object)modelId).and(NUMBER, "=", (Object)key);
        DynamicObject cfg = BusinessDataServiceHelper.loadSingle((String)"bcm_configsetting_exptorg", (String)fields, (QFilter[])qf.toArray());
        if (Objects.isNull(cfg)) {
            return Pair.onePair((Object)ConfigEnum.getConfigDataByNumber((String)key).getTextConfig(), Collections.emptySet());
        }
        DynamicObjectCollection orgentity = cfg.getDynamicObjectCollection("orgentity");
        LinkedHashSet allEntityNumberSet = Sets.newLinkedHashSetWithExpectedSize((int)orgentity.size());
        orgentity.forEach(p -> {
            Set<String> entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange("bcm_entitymembertree", p.getLong("entity.id"), p.getString("entity.number"), p.getInt("rangevalue"), String.valueOf(modelId), DetailTypeEnum.MEMBERPERM);
            allEntityNumberSet.addAll(entitySet);
        });
        return Pair.onePair((Object)cfg.get(CONFIG), (Object)allEntityNumberSet);
    }

    @Override
    public boolean getCM012InitPeriodStatus(Long modelId) {
        return (Boolean)ThreadCache.get((Object)String.format("querycfg-%d-CM012-initPeriod", modelId), () -> {
            QFBuilder qf = new QFBuilder();
            qf.add(MODEL, "=", (Object)modelId);
            qf.add(NUMBER, "=", (Object)"CM012");
            DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_configsetting", (String)JSON, (QFilter[])qf.toArray());
            if (obj != null) {
                String initPeriodStatus = obj.getString(JSON);
                if (!StringUtil.isEmptyString((String)initPeriodStatus)) {
                    return "1".equals(initPeriodStatus);
                }
                return false;
            }
            return false;
        });
    }

    @Override
    public boolean getBoolChildParam(Long modelid, String key, String childKey) {
        Object value = AppCacheServiceHelper.get(modelid + "." + key + "." + childKey);
        if (value == null) {
            value = CmConfigAdapterService.queryConfig(modelid, key, childKey);
            ConfigServiceHelper.cacheIt(modelid, key, childKey, value);
        }
        return ConfigServiceHelper.resolverConfigParam(value);
    }

    private static Object queryConfig(Long modelid, String key, String childKey) {
        QFBuilder qf = new QFBuilder();
        qf.add(MODEL, "=", (Object)modelid);
        qf.add(NUMBER, "=", (Object)key);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_adjustbiztypeconfig", (String)"number,model.number,entryentity.isshow,entryentity.businesstypevalue", (QFilter[])qf.toArray());
        try {
            return obj.getDynamicObjectCollection("entryentity").stream().filter(p -> childKey.equalsIgnoreCase(p.getString("businesstypevalue"))).findFirst().get().getBoolean("isshow");
        }
        catch (Exception e) {
            return ChildConfigEnum.getSingleValueByConfigNumber((String)key, (String)childKey).isConfig();
        }
    }

    @Override
    public BigDecimal getAdjustBalance(Long modelid) {
        String balanceKey = modelid + ".adjustbalance";
        Object value = AppCacheServiceHelper.get(balanceKey);
        if (value == null) {
            QFBuilder qf = new QFBuilder();
            qf.add(MODEL, "=", (Object)modelid);
            qf.add(NUMBER, "=", (Object)"CM027");
            DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_adjustbalanceset", (String)"adjustbalance.balance", (QFilter[])qf.toArray());
            value = obj != null ? obj.getBigDecimal("adjustbalance.balance") : BigDecimal.ZERO;
            AppCacheServiceHelper.put(balanceKey, value);
        }
        return InvestUtils.convertToBigDecimal((Object)value).abs();
    }

    @Override
    public String getAdjustContinueType(Long modelid) {
        QFBuilder qf = new QFBuilder();
        qf.add(MODEL, "=", (Object)modelid);
        qf.add(NUMBER, "=", (Object)"CM032");
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_configsetting_continu", (String)"config,linkcreatetype", (QFilter[])qf.toArray());
        String value = null;
        if (obj != null && StringUtil.isEmptyString((String)(value = obj.getString("linkcreatetype")).toString())) {
            value = obj.getString(CONFIG);
        }
        return value == null ? "0" : value.toString();
    }

    @Override
    public JSONObject getJSON(long modelId, String number) {
        QFBuilder configBuilder = new QFBuilder();
        configBuilder.add(new QFilter(MODEL, "=", (Object)modelId));
        configBuilder.add(new QFilter(NUMBER, "=", (Object)number));
        DynamicObject config = QueryServiceHelper.queryOne((String)"bcm_configsetting", (String)JSON, (QFilter[])configBuilder.toArray());
        if (config != null) {
            JSONObject.parseObject((String)config.getString(JSON));
        }
        return null;
    }
}

