/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.config;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.config.BatchConfigModel;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;

public class ConfigModel {
    private String number;
    private String name;
    private String description;
    private boolean config = false;
    private String form;
    private boolean isenable = true;
    private BatchConfigModel batchConfigModel;
    private String textConfig;

    public ConfigModel(String number, String name, String description) {
        this.number = number;
        this.name = name;
        this.description = description;
    }

    public ConfigModel(String number, String name, String description, boolean config, String form, boolean isenable, String textConfig) {
        this.number = number;
        this.name = name;
        this.description = description;
        this.config = config;
        this.form = form;
        this.isenable = isenable;
        this.textConfig = textConfig;
        List childConfigEnums = ChildConfigEnum.getValuesByConfigNumber((String)number);
        if (childConfigEnums == null || childConfigEnums.isEmpty()) {
            return;
        }
        this.batchConfigModel = new BatchConfigModel(this, childConfigEnums);
    }

    public ConfigModel(ConfigEnum configEnum) {
        this(configEnum.getNumber(), configEnum.getZhCnName(), configEnum.getZhCnDescription(), configEnum.isConfig(), configEnum.getForm(), configEnum.isIsenable(), configEnum.getTextConfig());
    }

    public BatchConfigModel getBatchConfigModel() {
        return this.batchConfigModel;
    }

    public DynamicObject[] toDy(Object model) {
        DynamicObject[] dynamicObjects = new DynamicObject[2];
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_configsetting");
        DynamicObjectType dynamicObjectType = dy.getDynamicObjectType();
        dy.set("number", (Object)this.number);
        Map<Lang, String> trans = ConfigModel.getLanguageTranslate(this.name, this.number);
        dy.set("name", LanguageUtil.getName(this.name, trans));
        Map<Lang, String> trans_des = ConfigModel.getLanguageTranslateDesc(this.description, this.number);
        dy.set("description", LanguageUtil.getName(this.description, trans_des));
        dy.set("model", model);
        dy.set("form", (Object)this.form);
        if (this.textConfig != null) {
            dy.set("config", (Object)this.textConfig);
        } else {
            dy.set("config", (Object)(this.config ? "1" : "0"));
        }
        if (!ObjectUtils.isEmpty((Object)dynamicObjectType.getProperty("isenable"))) {
            dy.set("isenable", (Object)(this.isenable ? "1" : "0"));
        }
        dy.set("modifier", (Object)RequestContext.getOrCreate().getUserId());
        dy.set("createtime", (Object)TimeServiceHelper.now());
        dy.set("modifytime", (Object)TimeServiceHelper.now());
        dynamicObjects[0] = dy;
        if (this.hasChildConfig()) {
            dynamicObjects[1] = this.batchConfigModel.toDy(model)[0];
        }
        return dynamicObjects;
    }

    public boolean hasChildConfig() {
        return this.batchConfigModel != null;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isConfig() {
        return this.config;
    }

    public String getForm() {
        return this.form;
    }

    public boolean isIsenable() {
        return this.isenable;
    }

    public static Map<Lang, String> getLanguageTranslate(String name, String number) {
        return LanguageUtil.getTranslate(name, "ConfigEnum_" + number, "fi-bcm-common");
    }

    public static Map<Lang, String> getLanguageTranslateDesc(String name, String number) {
        return ConfigModel.getLanguageTranslate(name, "des_" + number);
    }
}

