/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.config;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.epm.epbs.business.paramsetting.ParamSettingService;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.config.ConfigAdapterService;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;

public class EpbsConfigAdapterService
implements ConfigAdapterService {
    @Override
    public boolean getBool(long modelid, String key) {
        Object o = ParamSettingService.queryParamSetting((long)modelid, (String)key);
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return BooleanUtils.toBoolean((String)o.toString());
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return ConfigEnum.getConfigDataByNumber((String)key).isConfig();
    }

    @Override
    public boolean getBool(Long modelid, String key, String filedKey) {
        return ParamSettingServiceHelper.getBooleanWithChild((long)modelid, (String)key, (String)filedKey);
    }

    @Override
    public String getString(long modelid, String key) {
        return ParamSettingServiceHelper.getString((long)modelid, (String)key);
    }

    @Override
    public Pair<Object, Set<String>> getCfgWithExpOrg(long modelId, String key) {
        JSONObject json = ParamSettingServiceHelper.getJSON((long)modelId, (String)key);
        if (json == null) {
            return Pair.onePair((Object)ConfigEnum.getConfigDataByNumber((String)key).getTextConfig(), Collections.emptySet());
        }
        JSONArray orgentity = json.getJSONArray("entryentity");
        if (CollectionUtils.isEmpty((Collection)orgentity)) {
            return Pair.onePair((Object)ConfigEnum.getConfigDataByNumber((String)key).getTextConfig(), Collections.emptySet());
        }
        LinkedHashSet allEntityNumberSet = Sets.newLinkedHashSetWithExpectedSize((int)orgentity.size());
        orgentity.toJavaList(JSONObject.class).forEach(p -> {
            String memberEntity = "bcm_entitymembertree";
            Set<String> entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange(memberEntity, p.getLong("entity"), MemberReader.findMemberById((long)modelId, (String)memberEntity, (Long)p.getLong("entity")).getNumber(), p.getIntValue("rangevalue"), String.valueOf(modelId), DetailTypeEnum.MEMBERPERM);
            allEntityNumberSet.addAll(entitySet);
        });
        return Pair.onePair((Object)json.get((Object)"config"), (Object)allEntityNumberSet);
    }

    @Override
    public boolean getCM012InitPeriodStatus(Long modelId) {
        return this.getBoolChildParam(modelId, "CM012", "periodStatus");
    }

    @Override
    public boolean getBoolChildParam(Long modelid, String key, String childKey) {
        return ParamSettingServiceHelper.getBooleanWithChild((long)modelid, (String)key, (String)childKey);
    }

    @Override
    public BigDecimal getAdjustBalance(Long modelid) {
        BigDecimal decimal = ParamSettingServiceHelper.getDecimal((long)modelid, (String)"CM027");
        return decimal == null ? BigDecimal.ZERO : decimal;
    }

    @Override
    public String getAdjustContinueType(Long modelid) {
        return ParamSettingServiceHelper.getString((long)modelid, (String)"CM032");
    }

    @Override
    public Pair<Boolean, Set<String>> getConfigOfCMO04(Long modelId) {
        return (Pair)ThreadCache.get((Object)(modelId + "cm004_exceptOrg"), () -> {
            JSONArray entryentity;
            JSONObject json = ParamSettingServiceHelper.getJSON((long)modelId, (String)"CM004");
            boolean openCM004 = json.getBoolean("config");
            HashSet notCheckOrgSet = new HashSet();
            if (openCM004 && (entryentity = json.getJSONArray("entryentity")) != null) {
                entryentity.forEach(e -> {
                    JSONObject p = (JSONObject)e;
                    IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)modelId, (Long)p.getLong("entity"));
                    Set<String> entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange("bcm_entitymembertree", entity.getId(), entity.getNumber(), p.getInteger("rangevalue"), String.valueOf(modelId), DetailTypeEnum.MEMBERPERM);
                    notCheckOrgSet.addAll(entitySet);
                });
            }
            return Pair.onePair((Object)openCM004, notCheckOrgSet);
        });
    }

    @Override
    public JSONObject getJSON(long modelId, String number) {
        return ParamSettingServiceHelper.getJSON((long)modelId, (String)number);
    }
}

