/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.content;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.AESUtil;

public class ContentClientService {
    public static final String APPTOKEN_API = "api/getAppToken.do";
    public static final String LOGIN_API = "api/login.do";
    public static final String USER_TYPE = "UserName";
    private static final Log logger = LogFactory.getLog(ContentClientService.class);
    public static final String SERVER_URL = "url";
    public static final String SERVER_APP = "appId";
    public static final String SERVER_SECRET = "appSecret";
    public static final String SERVER_ACCOUNT = "accountId";
    public static final String SERVER_USER = "userName";
    public static final String SERVER_USERNAME = "csp";

    public static ErrorCode getErrorCode() {
        return new ErrorCode("bcm.content.client", ResManager.loadKDString((String)"\u5185\u5bb9\u670d\u52a1\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ContentClientService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    public static Map<String, String> getServerConfig() {
        HashMap<String, String> map = new HashMap(16);
        try {
            Class<?> aClass = Class.forName("kd.bos.open.res.util.ResourceClientUtil");
            Method findResourceClientInfo = aClass.getMethod("findResourceClientInfoMap", new Class[0]);
            Object resultObject = findResourceClientInfo.invoke(null, new Object[0]);
            if (resultObject == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"ContentClientService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            Map resultMap = (Map)resultObject;
            if (!"S".equals(resultMap.get("billstatus"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"ContentClientService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            map.put(SERVER_URL, (String)resultMap.get("targeturl"));
            map.put(SERVER_ACCOUNT, (String)resultMap.get("targetaccountid"));
            map.put(SERVER_APP, (String)resultMap.get("thirdcode"));
            map.put(SERVER_SECRET, (String)resultMap.get("accesstoken"));
            map.put(SERVER_USER, SERVER_USERNAME);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            logger.error("Resource Client Not Support: " + e);
            map = ContentClientService.getDefaultServerConfig();
        }
        catch (InvocationTargetException e) {
            logger.error("Resource Client Not Support: " + e.getTargetException());
            map = ContentClientService.getDefaultServerConfig();
        }
        return map;
    }

    private static Map<String, String> getDefaultServerConfig() {
        String properties = "number,name,publickey,status,fileserver,server_accountid,phone,server_url,tenantid,accountid";
        DynamicObject apply = BusinessDataServiceHelper.loadSingle((String)"iscr_app_apply", (String)properties, (QFilter[])new QFilter[0]);
        if (apply == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"ContentClientService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!"B".equals(apply.get("status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"ContentClientService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!ContentClientService.isMatchEnvironment(apply)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u7684\u79df\u6237ID\u6216\u8d26\u5957ID\u4e0e\u7533\u8bf7\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"ContentClientService_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
        map.put(SERVER_URL, apply.getString("server_url"));
        map.put(SERVER_ACCOUNT, apply.getString("server_accountid"));
        map.put(SERVER_APP, apply.getString("number"));
        map.put(SERVER_SECRET, apply.getString("publickey"));
        map.put(SERVER_USER, SERVER_USERNAME);
        return map;
    }

    private static boolean isMatchEnvironment(DynamicObject apply) {
        String curTenantId = RequestContext.get().getTenantId();
        String curAccountId = RequestContext.get().getAccountId();
        return curTenantId.equals(apply.getString("tenantid")) && curAccountId.equals(apply.getString("accountid"));
    }

    public static String getSrc() {
        String accessToken;
        Map<String, String> serverConfig = ContentClientService.getServerConfig();
        String serverUrl = serverConfig.get(SERVER_URL);
        logger.info("serverUrl: {}", (Object)serverUrl);
        try {
            String appToken = ContentClientService.getAppToken();
            logger.info("getAppToken Success");
            accessToken = ContentClientService.postAccessToken(appToken);
            logger.info("postAccessToken Success");
        }
        catch (Exception ex) {
            logger.error("getSrc Error: ", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        String userInfo = ContentClientService.encodeUserInfo();
        logger.info("encodeUserInfo: {}", (Object)userInfo);
        String src = serverUrl + "/accessTokenLogin.do?access_token=" + accessToken + "&redirect=" + serverUrl + "/?formId=csp_contentlist&userInfo=" + userInfo;
        logger.info("src: {}", (Object)src);
        return src;
    }

    private static String getAppToken() {
        Map<String, String> serverConfig = ContentClientService.getServerConfig();
        String url = serverConfig.get(SERVER_URL);
        String appId = serverConfig.get(SERVER_APP);
        String appSecret = serverConfig.get(SERVER_SECRET);
        String accountId = serverConfig.get(SERVER_ACCOUNT);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json;charset=UTF-8");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put(SERVER_APP, appId);
        body.put(SERVER_SECRET, appSecret);
        body.put(SERVER_ACCOUNT, accountId);
        try {
            Map<String, Object> data = ContentClientService.postJson(url, header, body, APPTOKEN_API);
            return String.valueOf(data.get("app_token"));
        }
        catch (Exception ex) {
            logger.error("getAppToken Error:", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6APPToken\u5f02\u5e38\u3002", (String)"ContentClientService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static String postAccessToken(String appToken) {
        Map<String, String> serverConfig = ContentClientService.getServerConfig();
        String url = serverConfig.get(SERVER_URL);
        String accountId = serverConfig.get(SERVER_ACCOUNT);
        String userName = serverConfig.get(SERVER_USER);
        HashMap<String, String> header = new HashMap<String, String>();
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("user", userName);
        body.put("apptoken", appToken);
        body.put(SERVER_ACCOUNT, accountId);
        body.put("usertype", USER_TYPE);
        try {
            Map<String, Object> data = ContentClientService.postJson(url, header, body, LOGIN_API);
            return String.valueOf(data.get("access_token"));
        }
        catch (Exception ex) {
            logger.error("postAccessToken Error:", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6AccessToken\u5f02\u5e38\u3002", (String)"ContentClientService_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static Map<String, Object> postJson(String url, Map<String, String> header, Map<String, Object> body, String api) throws IOException {
        String response = HttpClientUtils.postjson((String)(url + "/" + api), header, (String)JacksonUtils.toJson(body));
        Map responseBody = (Map)JSON.parseObject((String)response, Map.class);
        if (responseBody == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u670d\u52a1\u65e0\u6cd5\u8bbf\u95ee\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"ContentClientService_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!"success".equals(responseBody.get("state"))) {
            throw new KDBizException((String)responseBody.get("errorMsg"));
        }
        return (Map)responseBody.get("data");
    }

    private static String encodeUserInfo() {
        RequestContext rc = RequestContext.get();
        Object[] params = new String[]{"[0:0:0:0:0:0:0:1]".equals(rc.getLoginIP()) ? "127.0.0.1" : rc.getLoginIP(), rc.getCurrUserId() + "", rc.getUserName(), rc.getTenantId(), rc.getTenantInfo().getName()};
        String userInfo = "";
        try {
            userInfo = AESUtil.encrypt((String)JSON.toJSON((Object)Joiner.on((char)'|').useForNull("").join(params)).toString());
            userInfo = URLEncoder.encode(userInfo, String.valueOf(StandardCharsets.UTF_8));
            userInfo = URLEncoder.encode(userInfo, String.valueOf(StandardCharsets.UTF_8));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("encodeUserInfo Error:", (Throwable)ex);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error((Throwable)e);
        }
        return userInfo;
    }
}

