/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.service.BizRuleExecuteService;
import kd.fi.bcm.business.convert.IConvertService;
import kd.fi.bcm.business.convert.convertor.ConvertorFactory;
import kd.fi.bcm.business.convert.convertor.IConvertor;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.query.RateSchema;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.olap.OlapSaveBuilder;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public abstract class AbstractConvertService
implements IConvertService {
    protected ICvtContext ctx;
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());
    private List<IConvertor> chain;
    private BizRuleExecuteService bizRuleSrv;

    public AbstractConvertService(ICvtContext ctx) {
        this.ctx = ctx;
        this.chain = ConvertorFactory.genConvertorChain(ctx);
    }

    @Override
    public Set<String> convert() {
        HashSet<String> errorMsgs = new HashSet<String>(16);
        if (!this.ctx.checkPeriodStatusIsOpen()) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u671f\u95f4\u5df2\u5173\u95ed\uff0c\u6298\u7b97\u65e0\u6cd5\u6267\u884c\u3002", (String)"AbstractConvertService_3", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx.getCvtOrgVo().number);
            this.log.info(msg);
            return errorMsgs;
        }
        if (this.ctx.checkPcFlowStatusIsSubmit()) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6298\u7b97\u5e01\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\uff0c\u6298\u7b97\u65e0\u6cd5\u6267\u884c\u3002", (String)"AbstractConvertService_4", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx.getCvtOrgVo().number);
            this.log.info(msg);
            return errorMsgs;
        }
        if (this.ctx.getCvtCurrencyVo() != null && this.ctx.getCvtCurrencyVo().equals(this.ctx.getSrcCurrencyVo())) {
            return errorMsgs;
        }
        boolean existCTDimension = MemberReader.isExistChangeTypeDimension((long)this.ctx.getModelVo().id);
        Boolean noRateCondition = this.whenCvtPathNoRate(this.ctx);
        if (!this.ctx.willBeConvert() || !existCTDimension || noRateCondition.booleanValue()) {
            if (!(this.ctx.isConvert4InvElim() || this.ctx.isConvert4Checking() || this.ctx.getCvtOrgVo().number.contains("_"))) {
                this.getBizRuleExecuteService().executeRule(Arrays.asList("IRpt", "RAdj"), this.ctx.getCvtCurrencyVo().number);
                this.log.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u5b8c\u6210\u3002", (String)"AbstractConvertService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx.getCvtOrgVo().number));
            }
            return errorMsgs;
        }
        if (ConfigServiceHelper.getBoolChildParam(this.ctx.getModelVo().id, "CM049", ChildConfigEnum.BASECONVERT.getBusinesstypevalue())) {
            this.beforeConvert();
            this.chain.forEach(convertor -> {
                convertor.beforeConvert();
                errorMsgs.addAll(convertor.doConvert());
            });
            this.saveCvtValues2CubeDb(this.ctx.getSaveValPairs());
            this.chain.forEach(convertor -> errorMsgs.addAll(convertor.afterConvert()));
            this.log.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u5b8c\u6210\u6807\u51c6\u6298\u7b97\u6267\u884c\u3002", (String)"AbstractConvertService_0", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx.getCvtOrgVo().number));
        }
        this.afterConvert();
        this.handleExceptions(errorMsgs);
        this.log.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u5b8c\u6210\u6807\u51c6\u6298\u7b97\u6267\u884c\u3002", (String)"AbstractConvertService_0", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx.getCvtOrgVo().number));
        return errorMsgs;
    }

    private Boolean whenCvtPathNoRate(ICvtContext ctx) {
        BaseData baseData = new BaseData(ctx.getModelVo(), ctx.getScenarioVo(), ctx.getCvtYearVo(), ctx.getCvtPeriodVo());
        RateSchema orgRate = ExchangeQueryHelper.getRateSchemaByOrg(baseData, ctx.getCvtOrgVo());
        RateModel rm = orgRate.getRateModelBySrcTgt(ctx.getSrcCurrencyVo().number, ctx.getCvtCurrencyVo().number);
        if (rm == RateModel.EMPTY_RATE_MODEL) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void saveCvtValues2CubeDb(List<Pair<String[], Object>> cvtValues) {
        if (cvtValues.isEmpty()) {
            return;
        }
        OlapSaveBuilder save = new OlapSaveBuilder(this.ctx.getModelVo().number);
        save.setSourceEnum(OlapSourceEnum.T1);
        save.setNeedMonitorDataStatus(this.ctx.isNeedMonitorDataStatus());
        save.setCrossDimensions(this.getFilterFields().toArray(new String[0]));
        save.setMeasures(this.ctx.getMeasures());
        this.addfixedDimension(save);
        save.setCellSet(cvtValues);
        save.doSave();
    }

    private void addfixedDimension(OlapSaveBuilder save) {
        this.ctx.getFixDim2MembNumber().forEach((dimNumber, membNumber) -> save.addFixedDimension((String)dimNumber, (String)membNumber));
    }

    protected List<String> getFilterFields() {
        String[] allDimKeys = this.ctx.getSelectDimKes();
        ArrayList<String> filterDimKeys = new ArrayList<String>(10);
        filterDimKeys.addAll(Arrays.asList(allDimKeys));
        filterDimKeys.removeAll(Arrays.asList(this.ctx.getFixDims()));
        return filterDimKeys;
    }

    protected abstract void handleExceptions(Set<String> var1);

    protected abstract void beforeConvert();

    protected abstract void afterConvert();

    protected BizRuleExecuteService getBizRuleExecuteService() {
        if (this.bizRuleSrv == null) {
            ExecuteContext exeCtx = new ExecuteContext(SimpleItem.newOne(this.ctx.getModelVo()), SimpleItem.newOne(this.ctx.getCvtOrgVo()), SimpleItem.newOne(this.ctx.getCvtYearVo()), SimpleItem.newOne(this.ctx.getCvtPeriodVo()), SimpleItem.newOne(this.ctx.getScenarioVo()), false);
            if (this.ctx.getTemplateId() != null) {
                exeCtx.setFromRpt(true);
                exeCtx.setTempids(Collections.singletonList(Long.valueOf(this.ctx.getTemplateId().toString())));
            }
            this.bizRuleSrv = new BizRuleExecuteService(exeCtx);
        }
        return this.bizRuleSrv;
    }
}

