/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.AbstractConvertService;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.util.ToStringHelper;

public class ConvertService
extends AbstractConvertService {
    public static final Set<String> canAddDimensionScopeDimSet = Sets.newHashSet((Object[])new String[]{PresetConstant.ENTITY_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM, PresetConstant.CURRENCY_DIM, PresetConstant.CHANGETYPE_DIM, PresetConstant.PROCESS_DIM, PresetConstant.AUDITTRIAL_DIM});

    public ConvertService(ICvtContext ctx) {
        super(ctx);
    }

    @Override
    protected void beforeConvert() {
        this.clearCvtData();
    }

    protected void clearCvtData() {
        Set<String> accounts;
        if (this.ctx.getCvtCurrencyVo().number == null || this.ctx.getCvtCurrencyVo().number.equals(this.ctx.getSrcCurrencyVo().number)) {
            return;
        }
        RunScriptBuilder run = new RunScriptBuilder(this.ctx.getModelVo().number);
        run.setSourceEnum(OlapSourceEnum.T1);
        run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.SCENE_DIM, (Object)this.ctx.getScenarioVo().number));
        run.appendEqualSign();
        run.appendStr("null");
        run.endRunExpress();
        run.addDimensionScope(PresetConstant.CURRENCY_DIM, this.ctx.getCvtCurrencyVo().number);
        run.addDimensionScope(PresetConstant.PROCESS_DIM, Objects.equals(this.ctx.getProcess(), "Rpt") ? "IRpt" : this.ctx.getProcess());
        run.addDimensionScope(PresetConstant.ENTITY_DIM, this.ctx.getCvtOrgVo().number);
        run.addDimensionScope(PresetConstant.FY_DIM, this.ctx.getCvtYearVo().number);
        run.addDimensionScope(PresetConstant.PERIOD_DIM, this.ctx.getCvtPeriodVo().number);
        BaseData baseData = this.ctx.getBaseData();
        boolean isautoconvert = ExchangeQueryHelper.getAutoConvertByOrg(baseData, this.ctx.getCvtOrgVo());
        if (!isautoconvert && (accounts = this.getValidAccount()).size() > 0) {
            run.addDimensionScope(PresetConstant.ACCOUNT_DIM, accounts.toArray(new String[0]));
        }
        this.ctx.getScopes().iterator().forEachRemaining(e -> {
            if (this.willBeAddDimensionScope((String)e.p1)) {
                run.addDimensionScope((String)e.p1, (String[])e.p2);
            }
        });
        Pair changeType = (Pair)this.ctx.get("scopes_" + PresetConstant.CHANGETYPE_DIM);
        String[] changetypes = changeType == null ? new String[]{} : (String[])changeType.p2;
        HashSet changeSet = Sets.newHashSet();
        if (changetypes != null && changetypes.length > 0) {
            block0: for (String ct : this.ctx.getExchangeTypeFilter()) {
                for (String c : changetypes) {
                    if (!ct.equals(c)) continue;
                    changeSet.add(ct);
                    continue block0;
                }
            }
        }
        if (changeSet.isEmpty()) {
            changeSet.addAll(Sets.newHashSet((Object[])this.ctx.getExchangeTypeFilter()));
        }
        if (MemberReader.isExistChangeTypeDimension((String)this.ctx.getModelVo().number)) {
            run.addDimensionScope(PresetConstant.CHANGETYPE_DIM, changeSet.toArray(new String[0]));
        }
        run.runScript();
    }

    private Set<String> getValidAccount() {
        Long modelId = this.ctx.getModelVo().id;
        return new HashSet<String>((Collection)GlobalCacheServiceHelper.getOrLoadNode((String)("clearCvtAcct#" + modelId), () -> {
            QFilter qfilter = new QFilter("model", "=", (Object)modelId);
            qfilter.and("storagetype", "in", (Object)new String[]{StorageTypeEnum.STORAGE.getOIndex(), StorageTypeEnum.UNSHARE.getOIndex()});
            qfilter.and("exchange", "!=", (Object)ExchangeEnum.NONE.index);
            DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number", (QFilter[])new QFilter[]{qfilter});
            HashSet accountList = new HashSet(accounts.size());
            accounts.forEach(m -> accountList.add(m.getString("number")));
            return accountList;
        }));
    }

    protected boolean willBeAddDimensionScope(String dim) {
        return !canAddDimensionScopeDimSet.contains(dim) || dim.equals(PresetConstant.AUDITTRIAL_DIM) && this.ctx.getConvertAudittrial() == null;
    }

    @Override
    protected void afterConvert() {
        String processNum;
        if (ConfigServiceHelper.getBoolChildParam(this.ctx.getModelVo().id, "CM049", ChildConfigEnum.DIFFCONVERT.getBusinesstypevalue())) {
            new ConvertDifferenceHandle(this.ctx).generate();
            this.log.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u5b8c\u6210\u6298\u7b97\u5dee\u6267\u884c\u3002", (String)"AbstractConvertService_1", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx.getCvtOrgVo().number));
        }
        String string = processNum = Objects.equals(this.ctx.getProcess(), "Rpt") ? "IRpt" : this.ctx.getProcess();
        if ("Rpt".equals(this.ctx.getProcess())) {
            this.getBizRuleExecuteService().executeRule(Collections.singletonList("IRpt"), this.ctx.getCvtCurrencyVo().number, BizRuleExecuteTypeEnum.ALL);
            this.getBizRuleExecuteService().executeRuleMultiRuleExecuteType(Collections.singletonList("RAdj"), this.ctx.getCvtCurrencyVo().number, Sets.newHashSet((Object[])new BizRuleExecuteTypeEnum[]{BizRuleExecuteTypeEnum.ALL, BizRuleExecuteTypeEnum.EXTCONV_ONLY}));
            this.log.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u5b8c\u6210\u3002", (String)"AbstractConvertService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx.getCvtOrgVo().number));
        } else {
            this.getBizRuleExecuteService().executeRule(Collections.singletonList(processNum), this.ctx.getCvtCurrencyVo().number, BizRuleExecuteTypeEnum.ADJEJE_ONLY);
        }
        if (this.ctx.isConvertAll()) {
            ConvertServiceHelper.updateConvertStatus(this.ctx.getModelVo().number, this.ctx.getScenarioVo().number, this.ctx.getCvtYearVo().number, this.ctx.getCvtPeriodVo().number, this.ctx.getCvtOrgVo().number, this.ctx.getSrcCurrencyVo().number, this.ctx.getProcess(), this.ctx.getCvtCurrencyVo().number);
        }
    }

    @Override
    protected void handleExceptions(Set<String> errorMsgs) {
        if (!errorMsgs.isEmpty()) {
            this.log.error("\u6298\u7b97\u627e\u4e0d\u5230\u7684\u6c47\u7387\u8be6\u60c5--->" + ToStringHelper.deepToString(errorMsgs));
        }
    }
}

