/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.convertor;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.convertor.IConvertor;
import kd.fi.bcm.business.convert.convertor.calculate.CalculateEngine;
import kd.fi.bcm.business.convert.convertor.calculate.CalculateEngineProxy;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.exception.CvtExchangeException;
import kd.fi.bcm.business.convert.factor.CvtEquation;
import kd.fi.bcm.business.convert.factor.CvtFactor;
import kd.fi.bcm.business.convert.factor.CvtFactorExpress;
import kd.fi.bcm.business.convert.factor.CvtFactorParser;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.olap.OlapSaveBuilder;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.IMDResultSet;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetMetaData;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ChangewayEnum;
import kd.fi.bcm.common.enums.CvtFactorEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public abstract class AbstractConvertor
implements IConvertor {
    protected ICvtContext _ctx;
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());
    protected List<CvtEquation> equations = new ArrayList<CvtEquation>(10);
    protected MDResultSetMetaData _metadata;
    protected Set<String> errorMsgs = new HashSet<String>(16);
    protected boolean hasExistFilterAccts = false;
    protected List<Pair<String[], Object>> saveValPairs = new ArrayList<Pair<String[], Object>>(10);

    public AbstractConvertor(ICvtContext ctx) {
        this._ctx = ctx;
    }

    @Override
    public void beforeConvert() {
    }

    protected IMDResultSet doQuery() {
        SQLBuilder sql = this.buildSQL(true);
        return this.checkHasAcctFilter(sql) ? OlapServiceHelper.queryData(sql) : new MDResultSet();
    }

    protected SQLBuilder buildSQL(boolean isIncludeNull) {
        boolean isTrue = true;
        boolean isFalse = false;
        SQLBuilder sql = new SQLBuilder(this._ctx.getModelVo().number);
        sql.addSelectField(this._ctx.getSelectDimKes());
        sql.addMeasures(this._ctx.getMeasures());
        boolean hasConvertAudittrial = this._ctx.getConvertAudittrial() != null;
        Recorder hasAcctFilter = new Recorder((Object)isFalse);
        this._ctx.getScopes().iterator().forEachRemaining(e -> {
            if (((String)e.p1).equals(PresetConstant.AUDITTRIAL_DIM)) {
                if (!this._ctx.parallelConvert() && !hasConvertAudittrial) {
                    sql.addFilter((String)e.p1, (String[])e.p2);
                }
            } else if (!((String)e.p1).equals(PresetConstant.PROCESS_DIM)) {
                if (((String)e.p1).equals(PresetConstant.ACCOUNT_DIM)) {
                    sql.addFilter((String)e.p1, this.handleAcctFilter((String[])e.p2));
                    hasAcctFilter.setRecord((Object)isTrue);
                } else {
                    sql.addFilter((String)e.p1, (String[])e.p2);
                }
            }
        });
        String[] auditTrailFilters = this.handleAuditTrailFilter();
        if (!this._ctx.parallelConvert() && hasConvertAudittrial && auditTrailFilters != null) {
            sql.addFilter(PresetConstant.AUDITTRIAL_DIM, auditTrailFilters);
        }
        if (!((Boolean)hasAcctFilter.getRecord()).booleanValue()) {
            sql.addFilter(PresetConstant.ACCOUNT_DIM, this.handleAcctFilter(new String[0]));
        }
        if (MemberReader.isExistChangeTypeDimension((String)this._ctx.getModelVo().number)) {
            this.handleChangeTypeFilter(sql);
        }
        this.handleProcessFilter(sql);
        this.handleUserDefinedFilter(sql);
        sql.setIncludeNull(isIncludeNull);
        sql.setOnlyNumber(isTrue);
        return sql;
    }

    protected void handleUserDefinedFilter(SQLBuilder sql) {
    }

    protected boolean checkHasAcctFilter(SQLBuilder sql) {
        boolean isTrue = true;
        boolean isFalse = false;
        Recorder r = new Recorder((Object)isTrue);
        sql.getFilters().forEach(f -> {
            if (f.p2 == null || ((String[])f.p2).length == 0) {
                r.setRecord((Object)isFalse);
                return;
            }
        });
        return (Boolean)r.getRecord();
    }

    private void handleChangeTypeFilter(SQLBuilder sql) {
        String[] filters = this.getExchangeTypeFilter();
        if (filters != null) {
            sql.replaceOrAddFilter(PresetConstant.CHANGETYPE_DIM, filters);
        }
    }

    private void handleProcessFilter(SQLBuilder sql) {
        String[] filters = this.getProcessFilters();
        if (filters != null && filters.length > 0) {
            sql.addFilter(PresetConstant.PROCESS_DIM, filters);
        }
    }

    protected String[] getProcessFilters() {
        return new String[]{this._ctx.getProcess()};
    }

    protected String[] getExchangeTypeFilter() {
        String[] exchangeTypeFilter = this._ctx.getExchangeTypeFilter();
        Pair changeTypesOnRpt = (Pair)this._ctx.get("scopes_" + PresetConstant.CHANGETYPE_DIM);
        if (changeTypesOnRpt != null) {
            ArrayList<Object> resultChangeType = new ArrayList<Object>(10);
            resultChangeType.addAll(Arrays.asList((Object[])changeTypesOnRpt.p2));
            resultChangeType.retainAll(Arrays.asList(exchangeTypeFilter));
            if (resultChangeType.isEmpty()) {
                return new String[0];
            }
            return resultChangeType.toArray(new String[0]);
        }
        return exchangeTypeFilter;
    }

    @Override
    public Set<String> doConvert() {
        IMDResultSet rs = this.doQuery();
        if (rs.getFetchSize() > 0) {
            this._metadata = rs.getMetaData();
            this.collect2Cache(rs);
            if (!this.willGoBizConvertLogic()) {
                this.normalBizCvtLogic(rs);
            } else {
                this.doSpecialBizCvtLogic(rs);
            }
        }
        return this.errorMsgs;
    }

    private void doSpecialBizCvtLogic(IMDResultSet rs) {
        this.prepareHandleSpecialBizCvtLogic(rs);
        this.execSpecialBizCvtLogic();
    }

    protected boolean isGenerateLogic() {
        return false;
    }

    private void normalBizCvtLogic(IMDResultSet rs) {
        String srcCurr = this._ctx.getSrcCurrencyVo().number;
        String measureField = this.getMeasureField();
        Object originalVal = null;
        BigDecimal cvtVal = null;
        HashSet cvt2Currency = Sets.newHashSet((Object[])new String[]{this._ctx.getCvtCurrencyVo().number});
        rs.beforeFirst();
        int processIndex = this._metadata.getColIndex(DimTypesEnum.PROCESS.getNumber());
        int auditIndex = this._metadata.getColIndex(DimTypesEnum.AUDITTRIAL.getNumber());
        ArrayList<String> removeDims = new ArrayList<String>(Arrays.asList(this._ctx.getFixDims()));
        removeDims.add(this.getMeasureField());
        List<Integer> removeIndex = removeDims.stream().map(s -> this._metadata.getColIndex((String)s)).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        String orgNum = this._ctx.getRealOrgNum();
        while (rs.next()) {
            Row row = rs.getRow();
            originalVal = row.getOriginalValue(measureField) instanceof Number ? row.getBigDecimal(measureField) : row.getOriginalValue(measureField);
            for (String cvtCurr : cvt2Currency) {
                String currentCurrency;
                if (cvtCurr.equals(currentCurrency = row.getString(PresetConstant.CURRENCY_DIM))) continue;
                if (originalVal == null) {
                    this._ctx.addSaveValPair((Pair<String[], Object>)Pair.onePair((Object)this.getFilterFieldVals(processIndex, auditIndex, removeIndex, row.getStrValues()), null));
                    continue;
                }
                if (originalVal instanceof BigDecimal) {
                    cvtVal = this.isNoneOfChangeWay(row.getString(PresetConstant.CHANGETYPE_DIM)) ? (BigDecimal)originalVal : this.convertValue(this._ctx.getBaseData(), orgNum, srcCurr, cvtCurr, row.getString(PresetConstant.ACCOUNT_DIM), rs.getString(PresetConstant.CHANGETYPE_DIM), (BigDecimal)originalVal);
                    this._ctx.addSaveValPair((Pair<String[], Object>)Pair.onePair((Object)this.getFilterFieldVals(processIndex, auditIndex, removeIndex, row.getStrValues()), (Object)cvtVal));
                    continue;
                }
                this._ctx.addSaveValPair((Pair<String[], Object>)Pair.onePair((Object)this.getFilterFieldVals(processIndex, auditIndex, removeIndex, row.getStrValues()), (Object)originalVal));
            }
        }
    }

    protected BigDecimal convertValue(BaseData baseData, String orgNum, String srcCurr, String cvtCurrency, String accNum, String ctNum, BigDecimal originalVal) {
        ExchangeEnum exc = this._ctx.getCvtExchangeOfAccount(accNum);
        ChangewayEnum ct = this._ctx.getChangeWayOfChangeType(ctNum);
        return ConvertUtil.convert(baseData, orgNum, srcCurr, cvtCurrency, accNum, ctNum, exc, ct, originalVal);
    }

    protected boolean isNoneOfChangeWay(String changeType) {
        ChangewayEnum cw = this._ctx.getChangeWayOfChangeType(changeType);
        return ChangewayEnum.NONE == cw && !"BOP".equals(changeType);
    }

    @Override
    public Set<String> afterConvert() {
        return this.errorMsgs;
    }

    protected void execSpecialBizCvtLogic() {
        if (this.equations.isEmpty()) {
            return;
        }
        HashMultimap<Integer, String> filters = this.collectQueryFilter();
        Map<String, Object> kvMap = new HashMap<String, Object>(16);
        if (!filters.isEmpty()) {
            SQLBuilder sql = new SQLBuilder(this._ctx.getModelVo().number);
            sql.addSelectField(this._ctx.getSelectDimKes());
            sql.addMeasures(this._ctx.getMeasures());
            filters.asMap().forEach((key, value) -> sql.addFilter(this.getDimKey((int)key), value.toArray(new String[0])));
            MDResultSet rs = OlapServiceHelper.queryData(sql);
            this.collect2Cache(rs);
            kvMap = this.kvSnapshot(rs);
        }
        this.calculateEquation(kvMap);
    }

    protected void calculateEquation(Map<String, Object> kvMap) {
        Recorder crrFormula = new Recorder(null);
        boolean isFalse = false;
        Recorder notNull = new Recorder((Object)isFalse);
        CalculateEngineProxy engine = this.getCalculateEngine(kvMap, (Recorder<CvtFactorExpress>)crrFormula, (Recorder<Boolean>)notNull);
        if (engine == null) {
            return;
        }
        int processIndex = this._metadata.getColIndex(DimTypesEnum.PROCESS.getNumber());
        ArrayList<String> removeDims = new ArrayList<String>(Arrays.asList(this.getFixDims()));
        List removeFixIndex = removeDims.stream().map(s -> this._metadata.getColIndex((String)s)).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        this.equations.forEach(f -> {
            CvtFactorExpress express = f.getRightEquation();
            BigDecimal val = null;
            notNull.setRecord((Object)isFalse);
            try {
                if (express != null) {
                    crrFormula.setRecord((Object)express);
                    val = (BigDecimal)engine.calculate(express.getFormula());
                    if (val instanceof Exception) {
                        val = BigDecimal.ZERO;
                    }
                } else {
                    val = null;
                }
                this.addSaveValPair((Pair<String[], Object>)Pair.onePair((Object)this.getFilterFieldVals(processIndex, -1, removeFixIndex, Arrays.asList(f.getLeftEquation().getParams())), (Object)val));
            }
            catch (Exception e) {
                this.errorMsgs.add(e.getMessage());
            }
        });
    }

    protected CalculateEngineProxy getCalculateEngine(Map<String, Object> kvMap, Recorder<CvtFactorExpress> crrFormula, Recorder<Boolean> recorder) {
        boolean isTrue = true;
        if (kvMap.isEmpty()) {
            return null;
        }
        final CalculateEngine engine = CalculateEngine.engine(name -> {
            if (CvtFactorEnum.Rate.name().equals(name) || CvtFactorEnum.PreRate.name().equals(name)) {
                String[] params = ((CvtFactorExpress)crrFormula.getRecord()).getFactors().get(name).getParams();
                String accNum = params[this._metadata.getColIndex(PresetConstant.ACCOUNT_DIM)];
                String orgNum = params[this._metadata.getColIndex(PresetConstant.ENTITY_DIM)];
                String changeType = params[this._metadata.getColIndex(PresetConstant.CHANGETYPE_DIM)];
                String currency = this._ctx.getCvtCurrencyVo().number;
                String srcNum = this._ctx.getSrcCurrencyVo().number;
                RateModel Rate = ConvertUtil.getExchangeRateDetail(this._ctx.getBaseData(), orgNum, srcNum, currency);
                if (CvtFactorEnum.PreRate.name().equals(name)) {
                    BaseData preBaseData = this._ctx.getBaseData().getPreBaseData();
                    Rate = ConvertUtil.getExchangeRateDetail(preBaseData, orgNum, srcNum, currency);
                }
                return ConvertUtil.getRate(accNum, changeType, this._ctx.getCvtExchangeOfAccount(accNum), this._ctx.getChangeWayOfChangeType(changeType), Rate);
            }
            Object object = kvMap.get(String.join((CharSequence)"|", ((CvtFactorExpress)crrFormula.getRecord()).getFactors().get(name).getParams()));
            if (object != null) {
                recorder.setRecord((Object)isTrue);
            }
            return object == null ? BigDecimal.ZERO : (object instanceof BigDecimal ? (BigDecimal)object : object);
        });
        return new CalculateEngineProxy(engine){

            public Object calculate(String express) {
                return engine.calculate(express);
            }
        };
    }

    protected void addSaveValPair(Pair<String[], Object> p) {
        this._ctx.addSaveValPair(p);
    }

    protected String[] getFixDims() {
        return this._ctx.getFixDims();
    }

    private void parseEquationFactor(List<CvtEquation> equations) {
        equations.forEach(e -> {
            CvtFactorParser.parseParamsByFactor(e.getLeftEquation(), this._metadata, this._ctx);
            CvtFactorExpress express = e.getRightEquation();
            if (express != null) {
                express.getFactors().values().forEach(f -> this.parseParamsByFactor((CvtFactor)f));
            }
        });
    }

    protected void parseParamsByFactor(CvtFactor f) {
        CvtFactorParser.parseParamsByFactor(f, this._metadata, this._ctx);
    }

    private String getDimKey(int index) {
        return this._metadata.getColName(index);
    }

    private Map<String, Object> kvSnapshot(IMDResultSet rs) {
        rs.beforeFirst();
        HashMap<String, Object> kvMap = new HashMap<String, Object>(rs.getFetchSize());
        int measureIndex = this._metadata.getColIndex(this.getMeasureField());
        while (rs.next()) {
            Row row = rs.getRow();
            if (!(rs.getOriginalValue(this.getMeasureField()) instanceof Number)) continue;
            ArrayList<String> data = new ArrayList<String>(row.getStrValues());
            data.remove(measureIndex);
            kvMap.put(Joiner.on((char)'|').join(data), row.getBigDecimal(this.getMeasureField()));
        }
        return kvMap;
    }

    private HashMultimap<Integer, String> collectQueryFilter() {
        HashMultimap filters = HashMultimap.create();
        this.equations.iterator().forEachRemaining(cs -> {
            CvtFactorExpress express = cs.getRightEquation();
            if (express != null) {
                express.getFactors().values().forEach(e -> {
                    String[] params = e.getParams();
                    int i = 0;
                    for (String p : params) {
                        filters.put((Object)i++, (Object)p);
                    }
                });
            }
        });
        return filters;
    }

    protected void prepareHandleSpecialBizCvtLogic(IMDResultSet rs) {
        rs.beforeFirst();
        List<CvtEquation> equations = null;
        BigDecimal originalVal = null;
        HashSet cvt2Currency = Sets.newHashSet((Object[])new String[]{this._ctx.getCvtCurrencyVo().number});
        SimpleVo immutableCvtCurrencyVo = this._ctx.getCvtCurrencyVo();
        int processIndex = this._metadata.getColIndex(DimTypesEnum.PROCESS.getNumber());
        int auditIndex = this._metadata.getColIndex(DimTypesEnum.AUDITTRIAL.getNumber());
        ArrayList<String> removeDims = new ArrayList<String>();
        removeDims.addAll(Arrays.asList(this._ctx.getFixDims()));
        removeDims.add(this.getMeasureField());
        List<Integer> removeFixIndex = removeDims.stream().map(s -> this._metadata.getColIndex((String)s)).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        while (rs.next()) {
            Row row = rs.getRow();
            for (String cvtCurr : cvt2Currency) {
                this._ctx.switchCvtCurrencyVo(SimpleVo.newOne(cvtCurr, null));
                if (this.isNoneOfChangeWay(row.getString(PresetConstant.CHANGETYPE_DIM))) {
                    originalVal = rs.getBigDecimal(this.getMeasureField());
                    this._ctx.addSaveValPair((Pair<String[], Object>)Pair.onePair((Object)this.getFilterFieldVals(processIndex, auditIndex, removeFixIndex, row.getStrValues()), (Object)originalVal));
                    continue;
                }
                String[] params = this.getDimParams(row);
                try {
                    equations = this.genEquations(params);
                    if (equations == null) continue;
                    this.parseEquationFactor(equations);
                    this.equations.addAll(equations);
                }
                catch (CvtExchangeException e) {
                    this.errorMsgs.add(e.getMessage());
                }
            }
        }
        this._ctx.switchCvtCurrencyVo(immutableCvtCurrencyVo);
    }

    protected boolean willGoBizConvertLogic() {
        return false;
    }

    protected List<CvtEquation> genEquations(String[] params) {
        ArrayList<CvtEquation> equations = new ArrayList<CvtEquation>(1);
        CvtEquation equation = this.genEquation(params);
        if (equation != null) {
            equations.add(equation);
        }
        return equations;
    }

    protected CvtEquation genEquation(String[] params) {
        return null;
    }

    protected String[] getDimParams(Row row) {
        int mesureIndex = row.getColIndex(this.getMeasureField());
        ArrayList<String> data = new ArrayList<String>(row.getStrValues());
        data.remove(mesureIndex);
        return data.toArray(new String[0]);
    }

    private String[] getFilterFieldVals(int processIndex, int auditIndex, List<Integer> remodeFixDims, Collection<String> row) {
        ArrayList<String> rowData = new ArrayList<String>(row);
        if (!this._ctx.parallelConvert()) {
            String process = (String)rowData.get(processIndex);
            if (processIndex != -1 && "Rpt".equals(process)) {
                rowData.set(processIndex, "IRpt");
            }
            if (auditIndex != -1 && this._ctx.getConvertAudittrial() != null) {
                rowData.set(auditIndex, this._ctx.getConvertAudittrial());
            }
        }
        remodeFixDims.stream().forEach(s -> {
            String cfr_ignored_0 = (String)rowData.remove((int)s);
        });
        return rowData.toArray(new String[0]);
    }

    private void collect2Cache(IMDResultSet rs) {
        if (this.isGenerateLogic()) {
            return;
        }
        HashSet<String> acctNums = new HashSet<String>(rs.getFetchSize());
        HashSet<String> changeTypeNums = new HashSet<String>(rs.getFetchSize());
        rs.beforeFirst();
        while (rs.next()) {
            acctNums.add(rs.getString(DimTypesEnum.ACCOUNT.getNumber()));
            if (!MemberReader.isExistChangeTypeDimension((String)this._ctx.getModelVo().number)) continue;
            changeTypeNums.add(rs.getString(DimTypesEnum.CHANGETYPE.getNumber()));
        }
        this._ctx.removeHasQueryAccountCvtExchange(acctNums);
        this._ctx.removeHasQueryChangeTypeChangeWay(changeTypeNums);
        if (!acctNums.isEmpty()) {
            HashMap<String, ExchangeEnum> acctExchangeMap = new HashMap<String, ExchangeEnum>(16);
            this.executeQuery("bcm_accountmembertree", "number,exchange", acctNums::toArray, e -> acctExchangeMap.put(e.getString("number"), ExchangeEnum.getExchangeEnumByIndex((String)e.getString("exchange"))));
            this._ctx.add2cacheAccountCvtExchange(acctExchangeMap);
        }
        if (!changeTypeNums.isEmpty()) {
            HashMap<String, ChangewayEnum> changeTypeMap = new HashMap<String, ChangewayEnum>(16);
            this.executeQuery("bcm_changetypemembertree", "number,changeway", changeTypeNums::toArray, e -> changeTypeMap.put(e.getString("number"), ChangewayEnum.getChangewayEnumByIndex((String)e.getString("changeway"))));
            this._ctx.add2CacheChangeTypeChangeWay(changeTypeMap);
        }
    }

    private void executeQuery(String entity, String fields, Supplier<Object[]> filterVals, Consumer<DynamicObject> cs) {
        Collection coll = BusinessDataServiceHelper.loadFromCache((String)entity, (String)fields, (QFilter[])new QFBuilder().add("model", "=", (Object)this._ctx.getModelVo().id).add("number", "in", (Object)filterVals.get()).toArray()).values();
        coll.forEach(e -> cs.accept((DynamicObject)e));
    }

    protected List<String> getFilterFields() {
        String[] allDimKeys = this._ctx.getSelectDimKes();
        ArrayList<String> filterDimKeys = new ArrayList<String>(Arrays.asList(allDimKeys));
        filterDimKeys.removeAll(Arrays.asList(this._ctx.getFixDims()));
        return filterDimKeys;
    }

    private String getMeasureField() {
        return this._ctx.getMeasures()[0];
    }

    protected String[] handleAuditTrailFilter() {
        return new String[]{"ATTotal"};
    }

    protected String[] handleAcctFilter(String ... membs) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this._ctx.getModelVo().id);
        if (membs != null && membs.length > 0) {
            qf.add("number", "in", (Object)membs);
        }
        if (this.getAccountTypeEnumFilterVals() != null) {
            qf.add("accounttype", "in", (Object)this.getAccountTypeEnumFilterVals());
        }
        if (!this.isGenerateLogic()) {
            qf.add("isleaf", "=", (Object)"1");
            qf.add("exchange", "!=", (Object)ExchangeEnum.NONE.index);
        }
        this.userdefinedAcctFilter(qf);
        qf.add("storagetype", "in", (Object)new String[]{StorageTypeEnum.STORAGE.getOIndex(), StorageTypeEnum.DEFAULT.getOIndex(), StorageTypeEnum.UNSHARE.getOIndex()});
        String md5Key = StringUtils.stringToMD5((String)qf.toString());
        String[] accounts = (String[])GlobalCacheServiceHelper.getOrLoadNode((String)md5Key, () -> {
            DataSet coll = QueryServiceHelper.queryDataSet((String)"convertor", (String)"bcm_accountmembertree", (String)"number", (QFilter[])qf.toArray(), null);
            ArrayList numbers = new ArrayList(32);
            coll.forEach(e -> numbers.add(e.getString("number")));
            return numbers.toArray(new String[0]);
        });
        this.hasExistFilterAccts = accounts.length > 0;
        return accounts;
    }

    protected void userdefinedAcctFilter(QFBuilder qf) {
    }

    protected List<Object> getCvtAcctDataType() {
        ArrayList<Object> list = new ArrayList<Object>(10);
        for (DataTypeEnum dt : DataTypeEnum.values()) {
            if (DataTypeEnum.DEFAULT != dt && DataTypeEnum.CURRENCY != dt && DataTypeEnum.UNCURRENCY != dt) continue;
            list.add(dt.getOIndex());
        }
        return list;
    }

    protected abstract String[] getAccountTypeEnumFilterVals();

    protected void saveCvtValues2CubeDb(List<Pair<String[], Object>> cvtValues, OlapSourceEnum sourceEnum) {
        if (cvtValues.isEmpty()) {
            return;
        }
        OlapSaveBuilder save = new OlapSaveBuilder(this._ctx.getModelVo().number);
        save.setSourceEnum(sourceEnum);
        save.setNeedMonitorDataStatus(this._ctx.isNeedMonitorDataStatus());
        save.setCrossDimensions(this.getCrossDimensions());
        save.setMeasures(this._ctx.getMeasures());
        this.addfixedDimension(save);
        save.setCellSet(cvtValues);
        save.doSave();
    }

    private String[] getCrossDimensions() {
        String[] allDimKeys = this._ctx.getSelectDimKes();
        ArrayList<String> filterDimKeys = new ArrayList<String>(Arrays.asList(allDimKeys));
        filterDimKeys.removeAll(Arrays.asList(this.getFixDims()));
        return filterDimKeys.toArray(new String[0]);
    }

    private void addfixedDimension(OlapSaveBuilder save) {
        this.addFixedDimensionNew(save);
    }

    protected void addFixedDimensionNew(OlapSaveBuilder save) {
        this._ctx.getFixDim2MembNumber().forEach(save::addFixedDimension);
    }
}

