/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.convertor;

import kd.fi.bcm.business.convert.convertor.AbstractConvertor;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;

public abstract class AbstractLossOrCashFlowAcctConvertor
extends AbstractConvertor {
    public AbstractLossOrCashFlowAcctConvertor(ICvtContext ctx) {
        super(ctx);
    }

    @Override
    protected String[] getAccountTypeEnumFilterVals() {
        return new String[]{AccountTypeEnum.LOSS.index, AccountTypeEnum.CASHFLOW.index};
    }

    protected void resetGenData2Null(boolean isGenYDT, boolean isForCVTGen) {
        String[] filters;
        if (!this.hasExistFilterAccts) {
            return;
        }
        boolean hasConvertAuditTrial = this._ctx.getConvertAudittrial() != null;
        RunScriptBuilder rs = new RunScriptBuilder(this._ctx.getModelVo().number);
        rs.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)(isGenYDT ? "YTD" : "CurrentPeriod")));
        rs.appendEqualSign();
        rs.appendStr("null");
        rs.endRunExpress();
        Recorder hasAcctFilter = new Recorder((Object)Boolean.FALSE);
        this._ctx.getScopes().iterator().forEachRemaining(e -> {
            if (((String)e.p1).equals(PresetConstant.AUDITTRIAL_DIM)) {
                if (!hasConvertAuditTrial) {
                    rs.addDimensionScope((String)e.p1, (String[])e.p2);
                }
            } else if (!((String)e.p1).equals(PresetConstant.PROCESS_DIM)) {
                if (((String)e.p1).equals(PresetConstant.ACCOUNT_DIM)) {
                    rs.addDimensionScope((String)e.p1, this.handleAcctFilter((String[])e.p2));
                    hasAcctFilter.setRecord((Object)Boolean.TRUE);
                } else if (((String)e.p1).equals(PresetConstant.CURRENCY_DIM)) {
                    if (isForCVTGen) {
                        rs.addDimensionScope((String)e.p1, this._ctx.getCvtCurrencyVo().number);
                    } else {
                        rs.addDimensionScope((String)e.p1, (String[])e.p2);
                    }
                } else {
                    rs.addDimensionScope((String)e.p1, (String[])e.p2);
                }
            }
        });
        String[] auditTrailFilters = this.handleAuditTrailFilter();
        if (hasConvertAuditTrial && auditTrailFilters != null) {
            rs.addDimensionScope(PresetConstant.AUDITTRIAL_DIM, auditTrailFilters);
        }
        if (!((Boolean)hasAcctFilter.getRecord()).booleanValue()) {
            rs.addDimensionScope(PresetConstant.ACCOUNT_DIM, this.handleAcctFilter(new String[0]));
        }
        if ((filters = this.getProcessFilters()) != null && filters.length > 0) {
            rs.addDimensionScope(PresetConstant.PROCESS_DIM, filters);
        }
        rs.setSourceEnum(OlapSourceEnum.S4);
        rs.runScript();
    }
}

