/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.convertor;

import com.google.common.collect.HashMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.check.ICheckContext;
import kd.fi.bcm.business.check.helper.EntityServiceHelper;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.sql.IMDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class CheckingDataHandler {
    private ICvtContext ctx;
    private HashMultimap<String, String> theSameParentRelaMap;
    private Map<String, Pair<String, Map<String, Pair<Long, String>>>> cvtPathMap;

    public CheckingDataHandler(ICvtContext ctx) {
        this.ctx = ctx;
        this.theSameParentRelaMap = HashMultimap.create();
        this.cvtPathMap = new HashMap<String, Pair<String, Map<String, Pair<Long, String>>>>(16);
    }

    public void initTheSameParentRelaMap(IMDResultSet rs) {
        if (rs != null && rs.getFetchSize() > 0) {
            rs.beforeFirst();
            HashSet<String> orgNums = new HashSet<String>(rs.getFetchSize() * 2);
            int mycompanyIndex = rs.getMetaData().getColIndex(DimTypesEnum.MYCOMPANY.getNumber());
            while (rs.next()) {
                String orgNum = rs.getString(DimTypesEnum.ENTITY.getNumber());
                String innerCompanyNum = rs.getString(DimTypesEnum.INTERCOMPANY.getNumber());
                if (this.theSameParentRelaMap.containsKey((Object)(orgNum + "-" + innerCompanyNum))) continue;
                orgNums.add(orgNum);
                orgNums.add(innerCompanyNum);
                if (mycompanyIndex < 0) continue;
                String myCompanyNum = rs.getString(DimTypesEnum.MYCOMPANY.getNumber());
                orgNums.add(myCompanyNum);
            }
            orgNums.add(this.ctx.getCvtOrgVo().number);
            HashMultimap<String, String> orgNumMapLongNum = CheckingDataHandler.queryEntiyLongNumber(orgNums, (ICheckContext)this.ctx.get("checking_ctx"));
            HashMultimap org2InnerCompMap = HashMultimap.create();
            HashSet currOrgLongNums = new HashSet(orgNumMapLongNum.get((Object)this.ctx.getCvtOrgVo().number));
            orgNumMapLongNum.removeAll((Object)this.ctx.getCvtOrgVo().number);
            currOrgLongNums.forEach(currOrgLongNum -> orgNumMapLongNum.entries().forEach(innerComp -> {
                String parentLongNum = CheckingDataHandler.getTheSameParentLongNum(currOrgLongNum, (String)innerComp.getValue());
                if (!"Entity".equals(parentLongNum)) {
                    org2InnerCompMap.put((Object)(this.ctx.getCvtOrgVo().number + "-" + (String)innerComp.getKey()), (Object)Pair.onePair((Object)parentLongNum, (Object)currOrgLongNum));
                }
            }));
            Map<String, String> orgCurrMap = CheckingDataHandler.queryEntityCurrencyByLongNum(new HashSet<String>(org2InnerCompMap.values().stream().map(p -> (String)p.p1).collect(Collectors.toList())), this.ctx.getModelVo().id, this.ctx.getCvtYearVo().id, this.ctx.getCvtPeriodVo().id);
            org2InnerCompMap.entries().forEach(e -> {
                String pc = (String)orgCurrMap.get(((Pair)e.getValue()).p1);
                this.theSameParentRelaMap.put(e.getKey(), (Object)pc);
                this.cvtPathMap.put((String)e.getKey() + "-" + pc, (Pair<String, Map<String, Pair<Long, String>>>)Pair.onePair((Object)CheckingDataHandler.trans2CvtPath((String)((Pair)e.getValue()).p1, (String)((Pair)e.getValue()).p2), CheckingDataHandler.queryOrgInfo((String)((Pair)e.getValue()).p1, (String)((Pair)e.getValue()).p2, this.ctx.getCvtYearVo().id, this.ctx.getCvtPeriodVo().id, this.ctx.getModelVo().id)));
            });
        }
    }

    public static Map<String, String> queryEntityCurrencyByLongNum(Collection<String> longNums, long modelid, Long yearId, Long periodId) {
        HashMap<String, String> orgCurrMap = new HashMap<String, String>(16);
        QFilter longNumQf = new QFilter("longnumber", "in", longNums);
        QFilter modelQf = new QFilter("model", "=", (Object)modelid);
        DynamicObjectCollection orgCurrencys = OrgCurrencyServiceHelper.getOrgsCurrency(new QFilter[]{longNumQf, modelQf}, yearId, periodId);
        orgCurrencys.forEach(c -> orgCurrMap.put(c.getString("longnumber"), c.getString("currency.number")));
        return orgCurrMap;
    }

    public static HashMultimap<String, String> queryEntiyLongNumber(Collection<String> entityNums, ICheckContext checkCtx) {
        HashMultimap orgNumMapLongNum = HashMultimap.create();
        QFBuilder qf = new QFBuilder();
        qf.add("number", "in", entityNums);
        qf.add("model", "=", checkCtx.getModel().p1);
        qf.add("longnumber", "like", (Object)((checkCtx.isCompany() ? EntityServiceHelper.getSecondLongNumber((String)checkCtx.getEntity().p3) : (String)checkCtx.getEntity().p3) + "!%"));
        BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"number,longnumber", (QFilter[])qf.toArray()).values().forEach(c -> orgNumMapLongNum.put((Object)c.getString("number"), (Object)c.getString("longnumber")));
        return orgNumMapLongNum;
    }

    public static Map<String, Pair<Long, String>> queryOrgInfo(String parentLongNum, String cvtPathLongNum, Long yearId, Long periodId, long modelId) {
        QFBuilder qf = new QFBuilder();
        qf.add("number", "in", (Object)cvtPathLongNum.split("!"));
        qf.and("longnumber", "like", (Object)(parentLongNum + "!%"));
        qf.or("longnumber", "=", (Object)parentLongNum);
        qf.and("model.id", "=", (Object)modelId);
        HashMap<String, Pair<Long, String>> map = new HashMap<String, Pair<Long, String>>(16);
        OrgCurrencyServiceHelper.getOrgsCurrency(qf.toArray(), yearId, periodId).forEach(e -> map.put(e.getString("number"), Pair.onePair((Object)e.getLong("id"), (Object)e.getString("currency.number"))));
        return map;
    }

    public static String trans2CvtPath(String parentLongNum, String orgLongNum) {
        int lastIndex = parentLongNum.lastIndexOf(33);
        String cvtPath = "";
        if (orgLongNum.length() > lastIndex) {
            cvtPath = orgLongNum.substring(lastIndex == -1 ? 0 : lastIndex + 1);
        }
        return cvtPath;
    }

    public static String getTheSameParentLongNum(String longNum1, String longNum2) {
        String split = String.valueOf('!');
        String[] split1 = longNum1.split(split);
        String[] split2 = longNum2.split(split);
        int min = Math.min(split1.length, split2.length);
        int index = 0;
        int i = 0;
        while (i < min && split1[i].equals(split2[i])) {
            index = i++;
        }
        if (index == min - 1 && min > 1) {
            --index;
        }
        return String.join((CharSequence)split, Arrays.copyOf(split1, index + 1));
    }

    public Set<String> getCvtCurrency(Row row) {
        String key = this.ctx.getCvtOrgVo().number + "-" + row.getString(DimTypesEnum.INTERCOMPANY.getNumber());
        return this.theSameParentRelaMap.get((Object)key);
    }

    public Pair<String, Map<String, Pair<Long, String>>> getCvtEntityPath(Row row, String currency) {
        String key = this.ctx.getCvtOrgVo().number + "-" + row.getString(DimTypesEnum.INTERCOMPANY.getNumber()) + "-" + currency;
        return this.cvtPathMap.get(key);
    }

    public Set<String> getAllCvtCurrency() {
        return new HashSet<String>(this.theSameParentRelaMap.values());
    }
}

