/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.convertor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.service.BizRuleExecuteService;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.convert.convertor.AbstractConvertor;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.business.convert.factor.CvtDiffModel;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.ModelRate;
import kd.fi.bcm.business.convert.query.RateSchema;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VDmFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.olap.OlapSaveBuilder;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.compress.utils.Sets;

public class ConvertDifferenceHandle
extends AbstractConvertor {
    private Map<Object, DynamicObject> allMembers = new HashMap<Object, DynamicObject>(16);
    private static String[] fixDim = new String[]{PresetConstant.ENTITY_DIM, PresetConstant.SCENE_DIM, PresetConstant.CURRENCY_DIM};
    private Map<String, Integer> dimOrderMap = new HashMap<String, Integer>(16);
    private Map<String, String> dimNumber2ShortNumMap = new HashMap<String, String>(16);
    private Map<String, String> dimShortNum2NumberMap = new HashMap<String, String>(16);
    private BizRuleExecuteService bizRuleSrv;
    private Set<String> acctNums = new HashSet<String>(16);

    public ConvertDifferenceHandle(ICvtContext ctx) {
        super(ctx);
        this.initDimInfoMap();
    }

    private void initDimInfoMap() {
        String dimOrderMapKey = "dimOrderMap|" + this._ctx.getModelVo().id;
        Map temp = (Map)GlobalCacheServiceHelper.getOrLoadNode((String)dimOrderMapKey, () -> {
            HashMap dimOrderMap = new HashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number, shortnumber, dseq", (QFilter[])new QFBuilder("model", "=", (Object)this._ctx.getModelVo().id).toArray()).values().forEach(e -> dimOrderMap.put(e.getString("shortnumber") + "|" + e.getString("number"), e.getInt("dseq")));
            return dimOrderMap;
        });
        temp.forEach((key, value) -> {
            String[] split = key.split("\\|");
            this.dimOrderMap.put(split[0], (Integer)value);
            this.dimNumber2ShortNumMap.put(split[1], split[0]);
            this.dimShortNum2NumberMap.put(split[0], split[1]);
        });
    }

    private Map<Integer, List<DynamicObject>> getCvtDiffsGroup() {
        QFBuilder qf = new QFBuilder("model", "=", (Object)this._ctx.getModelVo().id);
        qf.add("scenario", "=", (Object)this._ctx.getScenarioVo().id);
        if (this._ctx.getTemplateId() != null) {
            DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)this._ctx.getTemplateId(), (String)"bcm_templateentity", (String)"number");
            qf.add("multitemplate.fbasedataid.number", "=", (Object)template.getString("number"));
        }
        qf.add("status", "=", (Object)"1");
        Set<Long> ids = CheckUtil.getApplySceneTmpls(this._ctx.getModelVo().id, this._ctx.getScenarioVo().id, "bcm_convertdiffentity");
        QFBuilder cvtqf = new QFBuilder("id", "in", ids);
        cvtqf.add("status", "=", (Object)"1");
        Collection<DynamicObject> cvtDiffs = BusinessDataServiceHelper.loadFromCache((String)"bcm_convertdiffentity", (QFilter[])cvtqf.toArray()).values();
        if (cvtDiffs.isEmpty()) {
            return null;
        }
        if (this._ctx.getTemplateId() != null) {
            this.allMembers = this.getMembers(cvtDiffs);
        } else {
            String cvtDiffMembsKey = "cvtDiffMembs|" + this._ctx.getModelVo().id + "|" + this._ctx.getScenarioVo().id;
            this.allMembers = (Map)GlobalCacheServiceHelper.getOrLoadNode((String)cvtDiffMembsKey, () -> this.getMembers(cvtDiffs));
        }
        TreeMap<Integer, List<DynamicObject>> seqGroup = new TreeMap<Integer, List<DynamicObject>>();
        for (DynamicObject dy : cvtDiffs) {
            Integer priority = dy.getInt("priority");
            List list = seqGroup.computeIfAbsent(priority, k -> new ArrayList(10));
            list.add(dy);
        }
        return seqGroup;
    }

    private Map<Object, DynamicObject> getMembers(Collection<DynamicObject> cvtDiffs) {
        HashMap<String, Set> batchQueryMembMap = new HashMap<String, Set>(16);
        cvtDiffs.forEach(c -> c.getDynamicObjectCollection("entryentity").forEach(e -> {
            String membermodel = e.getString("dimension.membermodel");
            Set set = batchQueryMembMap.computeIfAbsent(membermodel, k -> new HashSet(16));
            set.add(e.getLong("memberid"));
        }));
        HashMap<Object, DynamicObject> allMembers = new HashMap<Object, DynamicObject>(16);
        batchQueryMembMap.forEach((membermodel, idSet) -> {
            Map map = BusinessDataServiceHelper.loadFromCache((String)membermodel, (String)"id, number, longnumber", (QFilter[])new QFBuilder("id", "in", idSet).toArray());
            allMembers.putAll(map);
        });
        return allMembers;
    }

    private List<String> getConvertDifferenceSuitMember(DynamicObject cvtDiff, Set<String> suitDimShortNum) {
        ArrayList<String> dataList = new ArrayList<String>(10);
        DynamicObjectCollection doc = cvtDiff.getDynamicObjectCollection("entryentity");
        if (doc.isEmpty()) {
            return dataList;
        }
        HashMap<String, Set> olapSelectMap = new HashMap<String, Set>(16);
        for (DynamicObject e : doc) {
            boolean isCustom;
            String dimNum2 = e.getString("dimension.number");
            if (DimTypesEnum.ENTITY.getNumber().equals(dimNum2) || DimTypesEnum.YEAR.getNumber().equals(dimNum2) || DimTypesEnum.PERIOD.getNumber().equals(dimNum2)) continue;
            suitDimShortNum.add(this.dimNumber2ShortNumMap.get(dimNum2));
            Set membSet = olapSelectMap.computeIfAbsent(dimNum2, k -> new HashSet(16));
            DynamicObject member = this.allMembers.get(e.getLong("memberid"));
            if (member == null) continue;
            boolean bl = isCustom = e.get("propertyid_id") != null && e.getLong("propertyid_id") != 0L;
            if (!isCustom && e.getInt("membbound") == 10) {
                membSet.add(member.getString("number"));
                continue;
            }
            String membRangeKey = "cvtDiffMembs|" + e.getLong("memberid") + "|" + e.getInt("membbound");
            Set membRangeSet = (Set)GlobalCacheServiceHelper.getOrLoadNode((String)membRangeKey, () -> {
                HashSet tempSet = new HashSet(16);
                if (isCustom) {
                    new MembRangeItem(e.getString("dimension.membermodel"), (Long)e.getLong("memberid"), null, RangeEnum.getRangeByVal((int)e.getInt("membbound")), true, (Object)this._ctx.getModelVo().id).matchItems(m -> tempSet.add(m.number));
                } else {
                    new MembRangeItem(e.getString("dimension.membermodel"), (Long)member.getLong("id"), member.getString("longnumber"), member.getString("number"), RangeEnum.getRangeByVal((int)e.getInt("membbound")), false, (Object)this._ctx.getModelVo().id).matchItems(m -> tempSet.add(m.number));
                }
                return tempSet;
            });
            membSet.addAll(membRangeSet);
        }
        if (suitDimShortNum.isEmpty()) {
            return dataList;
        }
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        String rightFormula = cvtDiff.getString("rightformula");
        List<String> vList = ChkFormulaServiceHelper.getVList(rightFormula);
        ArrayList formulas = new ArrayList(10);
        try {
            for (String v : vList) {
                formulas.addAll((Collection)parser.parse((String)v, (EncoderService)coder).p2);
            }
        }
        catch (Exception e) {
            this.errorMsgs.add(String.format(ResManager.loadKDString((String)"\u6298\u7b97\u5dee\uff1a%1$s %2$s\u516c\u5f0f\u89e3\u6790\u9519\u8bef\u3002", (String)"ConvertDifferenceHandle_0", (String)"fi-bcm-business", (Object[])new Object[0]), cvtDiff.getString("number"), cvtDiff.getString("name")));
            return null;
        }
        for (IFormula f : formulas) {
            String year = f.getParamList().stream().map(s -> {
                String[] split = VDmFormula.splitDimAndMemb(s.toString());
                if (Objects.equals(split[0], SysDimensionEnum.Year.getNumber())) {
                    return split[1];
                }
                return "";
            }).collect(Collectors.joining());
            String changedYear = "";
            for (int i = 0; i < f.getParamList().size(); ++i) {
                ParamItem pi = (ParamItem)f.getParamList().get(i);
                String[] split = pi.toString().split("\\.");
                String dimNum3 = this.dimShortNum2NumberMap.get(split[0]);
                String memberNum = split[1];
                if (dimNum3.equals(SysDimensionEnum.Currency.getNumber())) {
                    memberNum = "CvtBefore".equals(memberNum) ? this._ctx.getSrcCurrencyVo().number : this._ctx.getCvtCurrencyVo().number;
                } else if (dimNum3.equals(DimTypesEnum.PERIOD.getNumber())) {
                    if ("CurrentPeriod".equals(memberNum)) {
                        memberNum = this._ctx.getCvtPeriodVo().number;
                    } else if ("LastPeriod".equals(memberNum)) {
                        String[] a = PeriodUtils.getLastPeriodIncludeYear((String)this._ctx.getModelVo().number, (String)(StringUtils.isNotEmpty((String)year) ? year : this._ctx.getCvtYearVo().number), (String)this._ctx.getCvtPeriodVo().number, (boolean)true);
                        memberNum = a[1];
                        changedYear = a[0];
                    }
                } else if (dimNum3.equals(DimTypesEnum.ACCOUNT.getNumber()) && StringUtils.isNotEmpty((String)memberNum)) {
                    this.acctNums.add(memberNum);
                }
                Set membSet = olapSelectMap.computeIfAbsent(dimNum3, k -> new HashSet(16));
                membSet.add(memberNum);
            }
            if (Objects.equals(year, changedYear)) continue;
            if (olapSelectMap.containsKey(DimTypesEnum.YEAR.getNumber())) {
                Set years = (Set)olapSelectMap.get(DimTypesEnum.YEAR.getNumber());
                years.add(changedYear);
                olapSelectMap.put(DimTypesEnum.YEAR.getNumber(), years);
                continue;
            }
            HashSet<String> years = new HashSet<String>(4);
            years.add(changedYear);
            olapSelectMap.put(DimTypesEnum.YEAR.getNumber(), years);
        }
        SQLBuilder sql = new SQLBuilder(this._ctx.getModelVo().number);
        sql.addSelectField(this.dimNumber2ShortNumMap.keySet().toArray(new String[0]));
        sql.addMeasures(this._ctx.getMeasures());
        sql.addFilter(DimTypesEnum.ENTITY.getNumber(), this._ctx.getCvtOrgVo().number);
        sql.addFilter(DimTypesEnum.SCENARIO.getNumber(), this._ctx.getScenarioVo().number);
        sql.addFilter(DimTypesEnum.YEAR.getNumber(), this._ctx.getCvtYearVo().number);
        sql.addFilter(DimTypesEnum.PERIOD.getNumber(), this._ctx.getCvtPeriodVo().number);
        if (!olapSelectMap.containsKey(DimTypesEnum.PROCESS.getNumber()) || ((Set)olapSelectMap.get(DimTypesEnum.PROCESS.getNumber())).isEmpty()) {
            sql.addFilter(DimTypesEnum.PROCESS.getNumber(), Objects.equals(this._ctx.getProcess(), "Rpt") ? "IRpt" : this._ctx.getProcess());
        }
        olapSelectMap.forEach((dimKey, values) -> {
            if (!values.isEmpty()) {
                if (dimKey.equals(DimTypesEnum.YEAR.getNumber())) {
                    values.add(this._ctx.getCvtYearVo().number);
                } else if (dimKey.equals(DimTypesEnum.PERIOD.getNumber())) {
                    values.add(this._ctx.getCvtPeriodVo().number);
                } else if (dimKey.equals(DimTypesEnum.PROCESS.getNumber())) {
                    values.add(Objects.equals(this._ctx.getProcess(), "Rpt") ? "IRpt" : this._ctx.getProcess());
                }
                sql.replaceOrAddFilter((String)dimKey, values.toArray(new String[0]));
            }
        });
        MDResultSet rs = OlapServiceHelper.queryData(sql);
        while (rs.next()) {
            StringBuilder bf = new StringBuilder();
            suitDimShortNum.forEach(dimNum -> bf.append((String)dimNum).append('.').append(rs.getString(this.dimShortNum2NumberMap.get(dimNum))).append(','));
            bf.deleteCharAt(bf.length() - 1);
            if (dataList.contains(bf.toString())) continue;
            dataList.add(bf.toString());
        }
        return dataList;
    }

    public void generate() {
        if (this._ctx.getCvtDiffAudittrial() == null) {
            return;
        }
        this.executeCvtDiff();
        this.agg2EntityInputTraDif();
    }

    private void executeCvtDiff() {
        boolean isTrue = true;
        Map<Integer, List<DynamicObject>> seqGroup = this.getCvtDiffsGroup();
        this.initBizRuleExecuteCtx();
        if (seqGroup == null) {
            return;
        }
        CalContext ctx = new CalContext(this._ctx.getModelVo().number, this._ctx.getCvtOrgVo().number, this._ctx.getCvtYearVo().number, this._ctx.getCvtPeriodVo().number, this._ctx.getScenarioVo().number, this._ctx.getCvtCurrencyVo().number);
        ctx.setProperty("isCvtDiff", isTrue);
        ctx.setProperty(DimTypesEnum.PROCESS.getShortNumber(), Objects.equals(this._ctx.getProcess(), "Rpt") ? "IRpt" : this._ctx.getProcess());
        ctx.setProperty("srcCurrency", this._ctx.getSrcCurrencyVo().number);
        ctx.setProperty("process", this._ctx.getProcess());
        ModelRate modelRate = ExchangeQueryHelper.getModeRate(this._ctx.getBaseData());
        RateSchema rateSchema = modelRate.getRateSchemaByOrgNum(this._ctx.getRealOrgNum());
        ctx.setProperty("exchangeRate", rateSchema.getRateSchemaNumber());
        seqGroup.forEach((priority, list) -> this.executeByGroup(ctx, (Integer)priority, (List<DynamicObject>)list));
    }

    private void executeByGroup(ICalContext ctx, Integer priority, List<DynamicObject> cvtDiffs) {
        HashSet templateIds = new HashSet(16);
        boolean existNotAssociatedTpl = false;
        for (DynamicObject cd : cvtDiffs) {
            if (!cd.getBoolean("unbizrule")) continue;
            DynamicObjectCollection doc = cd.getDynamicObjectCollection("multitemplate");
            doc.forEach(dy -> templateIds.add(dy.getLong("fbasedataid.id")));
            if (!doc.isEmpty()) continue;
            existNotAssociatedTpl = true;
        }
        ArrayList<Long> list = new ArrayList<Long>(10);
        if (this._ctx.getTemplateId() != null) {
            list.add((Long)this._ctx.getTemplateId());
            this.setBizRuleExecuteParams(list, true);
        } else if (existNotAssociatedTpl) {
            this.setBizRuleExecuteParams(list, false);
        } else {
            list.addAll(templateIds);
            this.setBizRuleExecuteParams(list, true);
        }
        if (this._ctx.getTemplateId() != null || existNotAssociatedTpl || !list.isEmpty()) {
            String processNum;
            String string = processNum = Objects.equals(ctx.getProcess(), "Rpt") ? "IRpt" : ctx.getProcess();
            if ("Rpt".equals(ctx.getProcess())) {
                this.bizRuleSrv.executeRule(Collections.singletonList("IRpt"), this._ctx.getCvtCurrencyVo().number, BizRuleExecuteTypeEnum.ALL);
                this.bizRuleSrv.executeRuleMultiRuleExecuteType(Collections.singletonList("RAdj"), this._ctx.getCvtCurrencyVo().number, Sets.newHashSet((Object[])new BizRuleExecuteTypeEnum[]{BizRuleExecuteTypeEnum.ALL, BizRuleExecuteTypeEnum.EXTCONV_ONLY}));
                this.log.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u5b8c\u6210\u3002", (String)"AbstractConvertService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getCvtCurrencyVo().number));
            } else {
                this.bizRuleSrv.executeRule(Collections.singletonList(processNum), this._ctx.getCvtCurrencyVo().number, BizRuleExecuteTypeEnum.ADJEJE_ONLY);
                this.log.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u5b8c\u6210\u3002", (String)"AbstractConvertService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getCvtCurrencyVo().number));
            }
        }
        CalculateService service = new CalculateService(ctx);
        ArrayList<CvtDiffModel> result = new ArrayList<CvtDiffModel>(10);
        Set<String> accountNums = new HashSet<String>(16);
        List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(this._ctx.getModelVo().id);
        for (DynamicObject cd : cvtDiffs) {
            HashSet<String> suitDimShortNum;
            List<String> suitMember;
            boolean isEffective = ConvertDifferenceHandle.isApply(this._ctx.getCvtYearVo().id, this._ctx.getCvtPeriodVo().id, cd.getDynamicObjectCollection("effective"), yearIdsList);
            if (!isEffective || !this.checkEntity(cd) || (suitMember = this.getConvertDifferenceSuitMember(cd, suitDimShortNum = new HashSet<String>(16))) == null || !suitDimShortNum.isEmpty() && suitMember.isEmpty()) continue;
            List<String> lefts = this.getRunnableFormula(ctx, cd.getString("leftformula"), suitDimShortNum, suitMember);
            String right = cd.getString("rightformula");
            right = right.replace("\"C.CvtBefore\"", "\"C." + this._ctx.getSrcCurrencyVo().number + "\"");
            if (ChkCheckServiceHelper.isSpecialFormula(right = right.replace("\"C.CvtAfter\"", "\"C." + this._ctx.getCvtCurrencyVo().number + "\""))) {
                int i;
                String newFormula = "" + right;
                List<String> vList = ChkFormulaServiceHelper.getVList(right);
                ArrayList<String> changeVList = new ArrayList<String>(10);
                boolean isCountMatch = false;
                for (i = 0; i < vList.size(); ++i) {
                    String v = vList.get(i);
                    newFormula = newFormula.replace(v, "{" + i + "}");
                    List<String> newVList = this.getRunnableFormula(ctx, v, suitDimShortNum, suitMember);
                    if (newVList == null || lefts.size() != newVList.size()) {
                        isCountMatch = false;
                        this.errorMsgs.add(String.format(ResManager.loadKDString((String)"\u6298\u7b97\u5dee\uff1a%1$s %2$s\u516c\u5f0f\u89e3\u6790\u9519\u8bef\u3002", (String)"ConvertDifferenceHandle_0", (String)"fi-bcm-business", (Object[])new Object[0]), cd.getString("number"), cd.getString("name")));
                        break;
                    }
                    changeVList.addAll(newVList);
                    isCountMatch = true;
                }
                if (!isCountMatch) continue;
                for (i = 0; i < lefts.size(); ++i) {
                    String fullFormula = "" + newFormula;
                    for (int j = 0; j < vList.size(); ++j) {
                        fullFormula = fullFormula.replace("{" + j + "}", (CharSequence)changeVList.get(j * lefts.size() + i));
                    }
                    ExpressStatus rstatus = service.addCalculateExpress(ChkCheckServiceHelper.changePercentToDec(fullFormula));
                    CvtDiffModel resultModel = new CvtDiffModel(lefts.get(i), rstatus, this._ctx, this.dimOrderMap);
                    accountNums.add(resultModel.getLeftAccountNumber());
                    result.add(resultModel);
                }
                continue;
            }
            List<String> rights = this.getRunnableFormula(ctx, right, suitDimShortNum, suitMember);
            if (rights == null || lefts.size() != rights.size()) {
                this.errorMsgs.add(String.format(ResManager.loadKDString((String)"\u6298\u7b97\u5dee\uff1a%1$s %2$s\u516c\u5f0f\u89e3\u6790\u9519\u8bef\u3002", (String)"ConvertDifferenceHandle_0", (String)"fi-bcm-business", (Object[])new Object[0]), cd.getString("number"), cd.getString("name")));
                continue;
            }
            for (int i = 0; i < rights.size(); ++i) {
                ExpressStatus rstatus = service.addCalculateExpress(ChkCheckServiceHelper.changePercentToDec(rights.get(i)));
                CvtDiffModel resultModel = new CvtDiffModel(lefts.get(i), rstatus, this._ctx, this.dimOrderMap);
                accountNums.add(resultModel.getLeftAccountNumber());
                result.add(resultModel);
            }
        }
        if ((accountNums = this.handleAcctFilter(accountNums)).isEmpty()) {
            return;
        }
        service.batchCalculate();
        this._ctx.getSaveValPairs().clear();
        for (CvtDiffModel r : result) {
            if (!accountNums.contains(r.getLeftAccountNumber())) continue;
            r.setRightresult(service);
            if (BigDecimal.ZERO.compareTo(r.getRightresult()) == 0) continue;
            this._ctx.addSaveValPair((Pair<String[], Object>)Pair.onePair((Object)r.getLeftParams(), (Object)r.getRightresult()));
        }
        List<Pair<String[], Object>> saveValPairs = this._ctx.getSaveValPairs();
        OlapSaveBuilder save = new OlapSaveBuilder(this._ctx.getModelVo().number);
        save.setSourceEnum(OlapSourceEnum.T3);
        save.setNeedMonitorDataStatus(this._ctx.isNeedMonitorDataStatus());
        save.setCrossDimensions(this.getFilterFields().toArray(new String[0]));
        save.setMeasures(this._ctx.getMeasures());
        this.addfixedDimension(save);
        save.setCellSet(saveValPairs);
        save.doSave();
    }

    private List<String> getRunnableFormula(ICalContext ctx, String formula, Set<String> suitDimShortNum, List<String> suitMember) {
        List<String> formulas = new ArrayList<String>(10);
        formulas.add(formula);
        if (!suitMember.isEmpty()) {
            formula = ConvertDifferenceHandle.removeDimFromFermula(formula, suitDimShortNum);
            formulas = ConvertDifferenceHandle.cartesianFormula(suitMember, formula);
        }
        formulas = ChkCheckServiceHelper.fixDefaultDim(ctx, formulas, this._ctx.getCvtYearVo().number, this._ctx.getCvtPeriodVo().number);
        return formulas;
    }

    private static String removeDimFromFermula(String formula, Set<String> dimkey) {
        Expression exp = null;
        try {
            exp = ExcelFormulaPaserHelper.parse((String)formula);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u53bb\u9664\u901a\u914d\u7b26\u89e3\u6790Excel\u516c\u5f0f\u5f02\u5e38\uff0c\u516c\u5f0f\uff1a%s\u3002", (String)"ChkCheckServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), formula)), new Object[0]);
        }
        ExcelFormulaPaserHelper.walk((Expression)exp, expr -> {
            if (expr instanceof FunctionExpr && ((FunctionExpr)expr).getFuncionName().equalsIgnoreCase("V")) {
                FunctionExpr fun = (FunctionExpr)expr;
                for (int i = 0; i < fun.getParameters().size(); ++i) {
                    StringExpr pi = (StringExpr)fun.getParameters().get(i);
                    String sn = pi.getValue().split("\\.")[0];
                    if (!dimkey.contains(sn)) continue;
                    fun.getParameters().remove(i);
                    --i;
                }
            }
        });
        return exp.toString();
    }

    private static List<String> cartesianFormula(List<String> dimcarte, String formula) {
        ArrayList<String> list = new ArrayList<String>(dimcarte.size());
        try {
            for (String s : dimcarte) {
                String[] ss;
                Expression exp = ExcelFormulaPaserHelper.parse((String)formula);
                for (String str : ss = s.split(",")) {
                    ExcelFormulaPaserHelper.walk((Expression)exp, expr -> {
                        if (expr instanceof FunctionExpr && ((FunctionExpr)expr).getFuncionName().equalsIgnoreCase("V")) {
                            FunctionExpr fun = (FunctionExpr)expr;
                            StringExpr s1 = new StringExpr(str.trim());
                            fun.getParameters().add(s1);
                        }
                    });
                }
                list.add(exp.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private Set<String> handleAcctFilter(Set<String> membs) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this._ctx.getModelVo().id);
        qf.add("datatype", "in", this.getCvtAcctDataType());
        qf.add("number", "in", membs);
        qf.add("isleaf", "=", (Object)"1");
        Map coll = BusinessDataServiceHelper.loadFromCache((String)"bcm_accountmembertree", (String)"number", (QFilter[])qf.toArray());
        HashSet<String> numbers = new HashSet<String>(16);
        coll.values().forEach(e -> numbers.add(e.getString("number")));
        return numbers;
    }

    private boolean checkEntity(DynamicObject cvtDiff) {
        DynamicObjectCollection doc = cvtDiff.getDynamicObjectCollection("entryentity");
        if (doc.isEmpty()) {
            return true;
        }
        HashSet<String> entitys = new HashSet<String>(16);
        for (DynamicObject e : doc) {
            boolean isCustom;
            if (!DimTypesEnum.ENTITY.getNumber().equals(e.getString("dimension.number"))) continue;
            DynamicObject member = this.allMembers.get(e.getLong("memberid"));
            boolean bl = isCustom = e.get("propertyid_id") != null && e.getLong("propertyid_id") != 0L;
            if (!isCustom && e.getInt("membbound") == 10 && member != null) {
                entitys.add(member.getString("number"));
                continue;
            }
            String membRangeKey = "cvtDiffMembs|" + e.getLong("memberid") + "|" + e.getInt("membbound");
            Set membRangeSet = (Set)GlobalCacheServiceHelper.getOrLoadNode((String)membRangeKey, () -> {
                HashSet tempSet = new HashSet(16);
                if (isCustom) {
                    new MembRangeItem(e.getString("dimension.membermodel"), (Long)e.getLong("memberid"), null, RangeEnum.getRangeByVal((int)e.getInt("membbound")), true, (Object)this._ctx.getModelVo().id).matchItems(m -> tempSet.add(m.number));
                } else if (member != null) {
                    new MembRangeItem(e.getString("dimension.membermodel"), (Long)member.getLong("id"), member.getString("longnumber"), member.getString("number"), RangeEnum.getRangeByVal((int)e.getInt("membbound")), false, (Object)this._ctx.getModelVo().id).matchItems(m -> tempSet.add(m.number));
                }
                return tempSet;
            });
            if (membRangeSet.isEmpty()) continue;
            entitys.addAll(membRangeSet);
        }
        if (!entitys.isEmpty()) {
            return entitys.contains(this._ctx.getRealOrgNum());
        }
        return true;
    }

    private void agg2EntityInputTraDif() {
        if (this._ctx.getEntityInputTraDif() != null) {
            if (this._ctx.getEntityInputTraDif().getStorageType() == StorageTypeEnum.DYNAMIC) {
                return;
            }
        } else {
            return;
        }
        RunScriptBuilder run = new RunScriptBuilder(this._ctx.getModelVo().number);
        run.setSourceEnum(OlapSourceEnum.T3);
        run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.AUDITTRIAL_DIM, (Object)"EntityInputTraDif"));
        run.appendEqualSign();
        run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.AUDITTRIAL_DIM, (Object)"EntityInput"));
        run.addV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.AUDITTRIAL_DIM, (Object)"TraDif"));
        run.endRunExpress();
        run.addDimensionScope(PresetConstant.ENTITY_DIM, this._ctx.getCvtOrgVo().number);
        run.addDimensionScope(PresetConstant.FY_DIM, this._ctx.getCvtYearVo().number);
        run.addDimensionScope(PresetConstant.PERIOD_DIM, this._ctx.getCvtPeriodVo().number);
        run.addDimensionScope(PresetConstant.SCENE_DIM, this._ctx.getScenarioVo().number);
        run.addDimensionScope(PresetConstant.CURRENCY_DIM, this._ctx.getCvtCurrencyVo().number);
        run.addDimensionScope(PresetConstant.PROCESS_DIM, Objects.equals(this._ctx.getProcess(), "Rpt") ? "IRpt" : this._ctx.getProcess());
        Optional<Pair> accout = this._ctx.getScopes().stream().filter(p -> PresetConstant.ACCOUNT_DIM.equals(p.p1)).findFirst();
        if (accout.isPresent()) {
            this.acctNums.addAll(Arrays.asList((Object[])accout.get().p2));
        } else {
            this.acctNums.clear();
        }
        if (!this.acctNums.isEmpty()) {
            run.addDimensionScope(PresetConstant.ACCOUNT_DIM, this.acctNums.toArray(new String[0]));
        }
        run.runScript();
    }

    @Override
    protected List<String> getFilterFields() {
        String[] allDimKeys = this._ctx.getSelectDimKes();
        ArrayList<String> filterDimKeys = new ArrayList<String>(allDimKeys.length);
        filterDimKeys.addAll(Arrays.asList(allDimKeys));
        filterDimKeys.removeAll(Arrays.asList(fixDim));
        return filterDimKeys;
    }

    private void addfixedDimension(OlapSaveBuilder save) {
        save.addFixedDimension(PresetConstant.ENTITY_DIM, this._ctx.getCvtOrgVo().number);
        save.addFixedDimension(PresetConstant.SCENE_DIM, this._ctx.getScenarioVo().number);
        save.addFixedDimension(PresetConstant.CURRENCY_DIM, this._ctx.getCvtCurrencyVo().number);
    }

    @Override
    protected String[] getAccountTypeEnumFilterVals() {
        return null;
    }

    private void setBizRuleExecuteParams(List<Long> templateIds, boolean isFromRpt) {
        this.bizRuleSrv.setTemplateIds(templateIds);
        this.bizRuleSrv.setFromRpt(isFromRpt);
    }

    private void initBizRuleExecuteCtx() {
        ExecuteContext exeCtx = new ExecuteContext(SimpleItem.newOne(this._ctx.getModelVo().id, this._ctx.getModelVo().number), SimpleItem.newOne(this._ctx.getCvtOrgVo().id, this._ctx.getCvtOrgVo().number), SimpleItem.newOne(this._ctx.getCvtYearVo().id, this._ctx.getCvtYearVo().number), SimpleItem.newOne(this._ctx.getCvtPeriodVo().id, this._ctx.getCvtPeriodVo().number), SimpleItem.newOne(this._ctx.getScenarioVo().id, this._ctx.getScenarioVo().number), false);
        this.bizRuleSrv = new BizRuleExecuteService(exeCtx);
    }

    public static boolean isApply(Long curyearid, Long curperiodid, DynamicObjectCollection effectives, List<Long> yearIdsList) {
        if (effectives.isEmpty() || curyearid == null || curperiodid == null || curyearid == 0L || curperiodid == 0L) {
            return true;
        }
        HashMap<Long, Set> yes = new HashMap<Long, Set>(16);
        HashMap<Long, Set> no = new HashMap<Long, Set>(16);
        for (DynamicObject edy : effectives) {
            Set periodIds;
            Object periodIds2;
            String applytype = edy.getString("applytype");
            String yearscope = edy.getString("yearscope");
            Set<Long> years = edy.get("effectiveyear") == null ? null : ConvertDifferenceHandle.getEffectiveYears(edy.getLong("effectiveyear.id"), yearscope, yearIdsList);
            Long tmpPeriodId = edy.get("effectiveperiod") == null ? curperiodid.longValue() : edy.getLong("effectiveperiod.id");
            if ("1".equals(applytype)) {
                if (years == null) {
                    periodIds2 = yes.computeIfAbsent(curyearid, k -> new HashSet(16));
                    periodIds2.add(tmpPeriodId);
                    continue;
                }
                for (Long y : years) {
                    periodIds = yes.computeIfAbsent(y, k -> new HashSet(16));
                    periodIds.add(tmpPeriodId);
                }
                continue;
            }
            if (years == null) {
                periodIds2 = no.computeIfAbsent(curyearid, k -> new HashSet(16));
                periodIds2.add(tmpPeriodId);
                continue;
            }
            for (Long y : years) {
                periodIds = no.computeIfAbsent(y, k -> new HashSet(16));
                periodIds.add(tmpPeriodId);
            }
        }
        return (yes.isEmpty() || yes.get(curyearid) != null && ((Set)yes.get(curyearid)).contains(curperiodid)) && (no.isEmpty() || no.get(curyearid) == null || !((Set)no.get(curyearid)).contains(curperiodid));
    }

    public static Set<Long> getEffectiveYears(long effectiveYearId, String yearscope, List<Long> yearIdsList) {
        HashSet<Long> yearIds = new HashSet<Long>(16);
        block5 : switch (yearscope) {
            case "2": {
                yearIds.add(effectiveYearId);
                break;
            }
            case "3": {
                for (Long year : yearIdsList) {
                    yearIds.add(year);
                    if (year != effectiveYearId) continue;
                    break block5;
                }
                break;
            }
            case "4": {
                boolean startInsert = false;
                for (Long year : yearIdsList) {
                    if (year == effectiveYearId) {
                        startInsert = true;
                    }
                    if (!startInsert) continue;
                    yearIds.add(year);
                }
                break;
            }
            default: {
                yearIds.add(effectiveYearId);
            }
        }
        return yearIds;
    }
}

