/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.convert.convertor;

import java.util.ArrayList;
import java.util.List;
import kd.fi.bcm.business.convert.convertor.AssetOrDebtAcctConvertor;
import kd.fi.bcm.business.convert.convertor.CvtInfluenceConvertor;
import kd.fi.bcm.business.convert.convertor.IConvertor;
import kd.fi.bcm.business.convert.convertor.InterestsAcctConvertor;
import kd.fi.bcm.business.convert.convertor.LossOrCashFlowAcctConvertor4CurrPeriod;
import kd.fi.bcm.business.convert.convertor.LossOrCashFlowAcctConvertor4YDT;
import kd.fi.bcm.business.convert.convertor.LossOrCashFlowCurrPeriodGenYDT;
import kd.fi.bcm.business.convert.convertor.LossOrCashFlowYDTGenCurrPeriod;
import kd.fi.bcm.business.convert.convertor.NotFiOrOtherAcctConvert;
import kd.fi.bcm.business.convert.convertor.UserDefinedFormulaConvertor;
import kd.fi.bcm.business.convert.ctx.ICvtContext;
import kd.fi.bcm.common.enums.DChangeTypeEnum;

public class ConvertorFactory {
    public static List<IConvertor> genConvertorChain(ICvtContext ctx) {
        ArrayList<IConvertor> chain = new ArrayList<IConvertor>(10);
        chain.add(new AssetOrDebtAcctConvertor(ctx));
        chain.add(new InterestsAcctConvertor(ctx));
        chain.add(new NotFiOrOtherAcctConvert(ctx));
        chain.add(new CvtInfluenceConvertor(ctx, true));
        if (DChangeTypeEnum.All == ctx.getScenarioInputChangType()) {
            chain.add(new LossOrCashFlowAcctConvertor4YDT(ctx));
            chain.add(new LossOrCashFlowAcctConvertor4CurrPeriod(ctx));
        } else if (DChangeTypeEnum.YTD == ctx.getScenarioInputChangType()) {
            chain.add(new LossOrCashFlowAcctConvertor4YDT(ctx));
            chain.add(new LossOrCashFlowYDTGenCurrPeriod(ctx, 3));
        } else if (DChangeTypeEnum.CurrentPeriods == ctx.getScenarioInputChangType()) {
            chain.add(new LossOrCashFlowAcctConvertor4CurrPeriod(ctx));
            chain.add(new LossOrCashFlowCurrPeriodGenYDT(ctx, 3));
        }
        chain.add(new UserDefinedFormulaConvertor(ctx));
        return chain;
    }
}

